﻿/// <reference path="../references.js" />

rwthapp.templateRenderer = (function () {
    var fetch = function (templateName, context) {
        templateName += ".tpl"; // TODO .tpl due to ending, so far no good way found to remove double file extension
        var template = rwthapp.util.getPropertyByString(rwthapp.handlebars.templates, templateName);

        if (template) {
            return template(context);
        } else {
            return "";
        }
    };

    var render = function (selector, templateName, context) {
        rwthapp.util.unsafeFunction(function () {
            $(selector).html(fetch(templateName, context));

            // Perform postprocessing (fixing icons, removing waves effect) if necessary
            performPostprocessing();
        });
    };

    var performPostprocessing = function () {
        // Fix icons if necessary
        rwthapp.iconFixer.fixIcons();

        // Remove waves-effect if disabled
        if (!rwthapp.options.wavesEffect.isEnabled()) {
            $(".waves-effect").removeClass("waves-effect").addClass("waves-alternative");
        }
    };

    return {
        fetch: fetch,
        render: render,
        performPostprocessing: performPostprocessing,
    };
})();