/* 
 * Funcions principals de la app Sant Cugat Comerç
 * Carrega d'informació, actualització de llistes
 */

//Url base del servidor

var base_url = "http://www.santcugatcomerc.cat/";

/* Estils dels mapes */

var styles = [ {
    "featureType": "landscape.natural", 
    "stylers": [ {
        "visibility": "off"
    } ]
},{
    "featureType": "road.highway", 
    "elementType": "geometry.stroke", 
    "stylers": [ {
        "visibility": "off"
    } ]
},{
    "featureType": "transit.line", 
    "stylers": [ {
        "visibility": "off"
    } ]
},{
    "featureType": "water", 
    "elementType": "labels", 
    "stylers": [ {
        "visibility": "off"
    } ]
},{
    "featureType": "poi.park", 
    "stylers": [ {
        "visibility": "off"
    } ]
},{
    "featureType": "road.highway"
},{
    "featureType": "landscape.man_made", 
    "elementType": "geometry", 
    "stylers": [ {
        "visibility": "off"
    } ]
} ];

//Deshabilitem les transicions

$(document).on("mobileinit", function(){
    defaultPageTransition: none;               
});

//Inicialitzem l'idioma per defecte

$(document).ready(function() {
    estableixIdiomaInicial('ca-ES');    
    carregaSegueixnos();
});

//Centrem la caratula de càrrega

$( '#pagina_caratula' ).live( 'pageshow',function(){
    $('#wrapper').css('height', window.innerHeight);
    $('#cell').css('height', window.innerHeight);                  
    
});

$( '#pagina_sobre_nosaltres' ).live( 'pageshow',function(){
    
    carregaSobreNosaltres();    
    
});

$( '#pagina_agenda_cultural' ).live( 'pageshow',function(){
    
    $.mobile.showPageLoadingMsg();
    
    agendaCultural();
    
});

$('#pagina_llista_rutes').live( 'pageshow',function(){
    
    $.mobile.showPageLoadingMsg();
    
    llistaRutes('getRutesTurisme');
    
});

$('#home_page').live( 'pagebeforeshow',function(){
    
    canviaImatge('ofertes_base');
    //$(document).bind('touchmove', false);
    
});

//Obrir el calendari d'una botiga

function obreCalendariHoraris() {
    $("#horari_botigues").data("datebox").options.useLang = llengua_activa;
    $('#horari_botigues').datebox('open');
}

window.onload = function() {
    
    $.mobile.changePage('#home_page');
    
    if (navigator.userAgent.indexOf('MSIE') == -1) {
    
        factor_correccio = $("#header_home").height() + $("#footer_home").height();
             
        altura_corregida = window.innerHeight - factor_correccio;
             
        ratio = (window.innerHeight - factor_correccio) / window.innerWidth;
                
        if (ratio >= 1.25) {
        
            $('#home_page_content').css('width', window.innerWidth + "px");
            $('#home_page_image img').css('width', window.innerWidth + "px");
            $('#home_page_content').css('height', window.innerWidth*1.25 + "px");
            $('#home_page_image').css('margin-top',(((altura_corregida - (window.innerWidth*1.25))/2)) + "px");
        
        } else {
                    
            $('#home_page_content').css('height', altura_corregida + "px");
            $('#home_page_content').css('width', altura_corregida/1.25 + "px");
            $('#home_page_image').css('width', altura_corregida/1.25 + "px");
            $('#home_page_image img').css('height', altura_corregida + "px");
                                        
        }
                
    } else {
        
        factor_correccio = $("#header_home").height() + $("#footer_home").height();
             
        altura_corregida = document.body.clientHeight - factor_correccio;
             
        ratio = (document.body.clientHeight - factor_correccio) / document.body.clientWidth;
                
        if (ratio >= 1.25) {
        
            $('#home_page_content').css('width', document.body.clientWidth + "px");
            $('#home_page_image img').css('width', document.body.clientWidth + "px");
            $('#home_page_content').css('height', document.body.clientWidth*1.25 + "px");
            $('#home_page_image').css('margin-top',(((altura_corregida - (document.body.clientWidth*1.25))/2)) + "px");
        
        } else {
                    
            $('#home_page_content').css('height', altura_corregida + "px");
            $('#home_page_content').css('width', altura_corregida/1.25 + "px");
            $('#home_page_image').css('width', altura_corregida/1.25 + "px");
            $('#home_page_image img').css('height', altura_corregida + "px");
                                        
        }
    }
                        
    //Carreguem el llistat de categories a l'iniciar l'aplicació                    
                        
    $('#llistat_ofertes_categories').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatCategoriesOfertes/');    
    $('#llistat_botigues_alfabetic_categories').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatCategories/');
}

//Carreguem la llista de botigues aleatòries de la home

$(document).delegate("#pagina_llistat_botigues", "pageinit", function(event) {
    $(".iscroll-wrapper", this).bind( { 
        "iscroll_onpulldown" : carregaAnterior,    
        "iscroll_onpullup"   : carregaSeguent        
    });
});

$(document).delegate("#pagina_llistat_ofertes", "pageinit", function(event) {
    $(".iscroll-wrapper", this).bind( { 
        "iscroll_onpulldown" : carregaAnteriorOfertes,    
        "iscroll_onpullup"   : carregaSeguentOfertes        
    });
});

var coordenades_actives; //Coordenades del lloc que estem visualitzant
var botiga_activa; //Botiga que estem visualitzant
var lloc_actiu; //Lloc que estem visualitzant
var promo_activa; //Promoció que estem visualitzant
var ruta_activa; //Ruta en la que estem actualment
var tipus_ruta_activa; //Tipus de ruta que estem mostrant (turística o comercial)
var num_lletra_actual = 0; //Lletra en la que ens trobem en la llista de botigues

//Canviem les imatges de la home en funció de l'idioma

function canviaImatge(div_imatge) {
    
    $('#ofertes_base_ca').css('display','none');
    $('#mostraPromos_ca').css('display','none');
    $('#llistaBotiguesAlfabetic_ca').css('display','none');
    $('#carregaPaginaArribar_ca').css('display','none');
    $('#llistaPoiTurisme_ca').css('display','none');
    $('#llistaNoticiesSCC_ca').css('display','none');
                
    $('#ofertes_base_es').css('display','none');
    $('#mostraPromos_es').css('display','none');
    $('#llistaBotiguesAlfabetic_es').css('display','none');
    $('#carregaPaginaArribar_es').css('display','none');
    $('#llistaPoiTurisme_es').css('display','none');
    $('#llistaNoticiesSCC_es').css('display','none');
                
    $('#'+div_imatge + '_' + llengua_activa_abr).css('display','block');
                                
}

//Veure informació d'una botiga

function infoBotiga(id_botiga) {
    
    $.mobile.showPageLoadingMsg();
    
    botiga_activa = id_botiga;
    
    $('#map_canvas').empty();
    $('#descripcio_botiga_text_container').empty();
    $('#caroussel_fotos').hide();
    
    $('#map_canvas_wrapper').hide();
    $('#descripcio_botiga_text').show();
    $('#desc_b_txt').hide();
    $('#desc_b_cte').hide();     
    $('#promos_botiga').hide();
    
    $('#descripcio_botiga_text_container').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/descripcioBotiga/'+id_botiga, function() {
  
        $.mobile.changePage('#descripcio_botiga');    
        $('#desc_b_cte a').buttonMarkup();        
        $('#botiga_compartir').popup();        
        $('#botiga_compartir a').buttonMarkup();        
        $('.botons_horaris').buttonMarkup();        
        
        $.getJSON((base_url+'SCC/ca/web_mobil/festiusBotiga/'+id_botiga), function(data) {
            
            $("#horari_botigues").data("datebox").options.highDates = data;                

        })
        .complete(function(data) {
            
            $('#horaris_contingut').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/consultaHorarisObertura/'+id_botiga, function() {
        
                $('#button_caroussel').buttonMarkup();
                $.mobile.hidePageLoadingMsg();
        
            });
        });
        
    });
    
}

//Dibuixem el mapa de com arribar al comerç des d'on som

function comArribar() {
    
    desti_lloc = $('#dir_com').html();
    
    $('#map_canvas_wrapper').show();
    $('#map_canvas').show();
    $('#desc_b_txt').hide();
    $('#desc_b_cte').hide();
    $('#caroussel_fotos').hide();
    $('#promos_botiga').hide();
    
    if ($('#map_canvas').html() == "") {
        
        $.mobile.showPageLoadingMsg();
        
        geo('map_canvas', 'botiga_mapa_popup', 'desc_b_txt', 'dir_com');    
        
    }
    
}

//Mostrem la pestanya d'informació de contacte d'una botiga

function infoContacte() {
    
    $('#map_canvas_wrapper').hide();
    $('#caroussel_fotos').hide();
    $('#descripcio_botiga_text').show();
    $('#desc_b_txt').hide();
    $('#desc_b_cte').show();
    $('#promos_botiga').hide();
    
}

//Mostrem la pestanya "compartir"

function botigaCompartir() {
    
    $('#botiga_compartir').popup('open');        
    
}


//Carreguem el caroussel de fotos d'una botiga

function carregaCaroussel() {
    
    $('#map_canvas').hide();
    $('#descripcio_botiga_text').hide();    
    $('#promos_botiga').hide();
    
    $('#caroussel_fotos').empty();
    $('#poi_caroussel_fotos').empty();    
    $('#caroussel_fotos').show();    
    $('#popupCaroussel').width(window.innerWidth - 50);
    
    $('#caroussel_fotos').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getCarousselBotiga/'+botiga_activa, function() {
          
        var altura_popup = (window.innerWidth-50) *0.67;
          
        $("#c_bot").carousel();        
        $( "#c_bot" ).css( "height", altura_popup + "px" );
        $( "#c_bot_cont" ).css( "height", altura_popup + "px" );
        $( "#c_bot_cont div" ).css( "height", altura_popup + "px" );
        $( "#popupCaroussel" ).css( "max-height", altura_popup + "px" );
        $( "#popupCaroussel" ).popup("open");        
                    
    });
}

//Mostrem la llista d'ofertes de la botiga

function mostraPromosBotiga() {
      
    $.mobile.showPageLoadingMsg();
  
    $('#llista_map_canvas_oferta').hide();
    $('#llista_map_canvas_oferta').empty();    
    $('#llista_promos_botiga').empty();

    $('#llista_promos_botiga').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatPromosBotiga/'+botiga_activa, function() {
        
        $.mobile.changePage('#llistat_ofertes');
        $('#llista_promos_botiga').listview('refresh');
        $('#llista_promos_botiga').show();
        $('#oferta_compartir_popup').popup();
        $.mobile.hidePageLoadingMsg();        
        
    });
    
}

//Mostrem les promos d'una botiga des del mapa

function mostraPromosBotigaMapa(id_botiga) {
    
    botiga_activa = id_botiga;
    mostraPromosBotiga();
    
}

//Mostrem l'informació de la promoció seleccionada

function promoBotiga(id_promo, id_botiga) {
    
    $.mobile.showPageLoadingMsg();
    
    promo_activa = id_promo;
    botiga_activa = id_botiga;
    
    $('#map_canvas_oferta_wrapper').hide();    
    $('#descripcio_oferta_text').empty();
    $('#descripcio_oferta_text').show();

    $('#descripcio_oferta_text').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/infoPromoBotiga/'+id_promo, function() {
        
        $.mobile.changePage('#descripcio_ofertes');        
        $('#desc_o_txt a').buttonMarkup();
        $.mobile.hidePageLoadingMsg();
          
    });
    
}

function mostraInfoPromo() {
    
    $('#map_canvas_oferta_wrapper').hide();    
    $('#descripcio_oferta_text').show();
    
}

//Dibuixem el mapa de com arribar al comerç des d'on som

function comArribarOferta() {
    
    desti_lloc = $('#dir_com_oferta').html();
    
    $('#promos_botiga').hide();        
    $('#map_canvas_oferta_ruta').hide();            
    $('#map_canvas_oferta_wrapper').show();
    $('#descripcio_oferta_text').hide();
    
    if ($('#map_canvas_oferta').html() == "") {
        
        $.mobile.showPageLoadingMsg();
        
        geo('map_canvas_oferta','oferta_mapa_popup', 'desc_o_txt', 'dir_com_oferta');    
        
    }
    
}

//Mostrem la llista d'ofertes de la botiga
//parametre: null si no hem de carregar la llista en una nova pàgina, 1 si hem de canviar de pàgina

function mostraPromos(parametre) {
    
    canviaImatge('mostraPromos');
  
    $.mobile.showPageLoadingMsg();
  
    $('#llista_map_canvas_oferta').hide();    
    $('#llista_map_canvas_oferta').empty();    
    $('#llista_promos_botiga').empty();

    $('#llista_promos_botiga').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatPromos', function() {
        
        if (parametre == 1) {
            
            $.mobile.changePage('#llistat_ofertes');
            
        }
                
        $('#llista_promos_botiga').listview('refresh');
        $('#llista_promos_botiga').show();
        $.mobile.hidePageLoadingMsg();
        
        //$(document).unbind('touchmove', false);

    });
    
}



var objecte_boto;

function estatActiu(objecte) {    
    objecte_boto = objecte;    
}

var num_elements_llista = 0; //Nombre d'elements que té la llista
var num_element_actual = 0; //Numero de l'últim element mostrat
var scroll_lista = true; //Indiquem si s'han de carregar més elements mitjançant l'scroll o no
var scroll_lletra = true; //Indiquem si es tracta de carregar la llista de categories
var func_cerca = 'llistatBotiguesNom';
var key_word = 'nom';

//Carreguem el llistat inicial de botigues

function llistaBotiguesAlfabetic() {
    
    scroll_llista = true;
    scroll_lletra = true;
    num_elements_llista = 0;
    func_cerca = 'llistatBotiguesNom';
    key_word = 'nom';
    
    canviaImatge('llistaBotiguesAlfabetic');
    
    $('#llistat_botigues_alfabetic_contingut_categories').hide();        
    $('#llistat_botigues_alfabetic_contingut').show();        
        
    $('#alfabet_lateral').show();
    $.mobile.showPageLoadingMsg();
        
    $('#alfabet_lateral ul').css('font-size', (window.innerHeight-150)/33 + "px");
    
    $('#llistat_botigues_alfabetic').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatBotigues/html', function() {
  
        //Resaltem la lletra actual en l'alfabet lateral
            
        $('#alfabet_lateral ul li').css('background','none');
        $('#alfabet_lateral ul li:nth-child(1)').css('background', 'gray');
        
        //Quan introduïm text en el buscador de botigues, cridem la consulta de mostrar botigues amb el text introduït.
          
        $('#searchTextFieldBotigues').attr('onkeypress', 'return llistaBotiguesKeywordKey(event)');          
        $('#searchButtonBotigues').attr('href', 'javascript:llistaBotiguesKeyword()');
        
        $.mobile.changePage('#pagina_llistat_botigues');
        
        mostraPaginaLlistatBotigues();
        
        $('#llistat_botigues_alfabetic').listview('refresh');
                
        $.mobile.hidePageLoadingMsg();
        
        //$(document).unbind('touchmove', false);
                
    });
    
}

//Listener funció per buscar botigues segons paraules contingues en el seu nom

function llistaBotiguesKeywordKey(event) {
        
    $('#alfabet_lateral ul li').css('background','none');
    
    if (event.which == 13) {
        
        llistaBotiguesKeyword();
        
    }

}

//Funció per buscar botigues segons paraules contingues en el seu nom

function llistaBotiguesKeyword() {
    
    $.mobile.showPageLoadingMsg();
                
    func_cerca = 'llistatBotiguesNom';                
    text_buscar = $('#searchTextFieldBotigues').val();
    scroll_lletra = false;
                
    if (text_buscar != "") {
                
        $.getJSON(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatBotiguesNom/'+text_buscar+'/nom/0/10', function(data) {
          
            num_elements_llista = parseInt(data.num_elements);
            num_element_actual = 10;
            $('#llistat_botigues_alfabetic').empty();
            $('#llistat_botigues_alfabetic').append(data.llista);
            $('#llistat_botigues_alfabetic').listview('refresh');
            $.mobile.hidePageLoadingMsg();

        });
                
    } else {
                
        $('#llistat_botigues_alfabetic').empty();
        $.mobile.hidePageLoadingMsg();
    }
    
}

//Listener de la funció per buscar botigues segons paraules contingues en la seva categoria

function llistaBotiguesCategoriaKey(event) {
        
    $('#alfabet_lateral ul li').css('background','none');

    if (event.which == 13) {
            
        llistaBotiguesCategoria();
            
    }

}

//Funció per buscar botigues segons paraules contingues en la seva categoria

function llistaBotiguesCategoria() {
    
    $.mobile.showPageLoadingMsg();
        
    $('#llistat_botigues_alfabetic_contingut_categories').hide();    
    $('#llistat_botigues_alfabetic_contingut').show();    
    
    categories_llista = true;
    scroll_llista = true;
    key_word = 'key';    
    func_cerca = 'comercCategoria';
    num_lletra_actual = 0;
    num_elements_llista = 0;        
                
    text_buscar = $('#searchTextFieldBotigues').val();
            
    if (text_buscar != "") {
                
        $.getJSON(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/'+func_cerca+'/'+text_buscar+'/key/0/10', function(data) {
          
            num_elements_llista = parseInt(data.num_elements);
            num_element_actual = 10;          
            $('#llistat_botigues_alfabetic').empty();
            $('#llistat_botigues_alfabetic').append(data.llista);
            $('#llistat_botigues_alfabetic').listview('refresh');
            $.mobile.hidePageLoadingMsg();

        });
                
    } else {
                
        $('#llistat_botigues_alfabetic').empty();
        $.mobile.hidePageLoadingMsg();
    }
    
}

//Carreguem els comerços de la lletra anterior

function carregaAnterior(event, data) {
    
    if (num_lletra_actual > 0 && scroll_llista == true && scroll_lletra == true) { //Lletra anterior
                
        $.mobile.showPageLoadingMsg();
            
        num_lletra_actual = num_lletra_actual-1;
        lletra_anterior = $('#alfabet_lateral ul li').get(num_lletra_actual).innerHTML;
                                    
        //Resaltem la lletra actual en l'alfabet lateral
            
        $('#alfabet_lateral ul li').css('background','none');
        $('#alfabet_lateral ul li:nth-child('+(num_lletra_actual+1)+')').css('background', 'gray');
            
        $('#llistat_botigues_alfabetic').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/'+func_cerca+'/'+lletra_anterior+'/inicial', function() {
          
            $('#llistat_botigues_alfabetic').listview('refresh');
            $.mobile.hidePageLoadingMsg();

        });
        
        data.iscrollview.refresh();
            
    } else if (scroll_llista == true) { //10 elements següents (cerca per keyword o nom)
                
        var num_element_anterior = num_element_actual-20;
        
        if (num_element_anterior < 0) {
            
            num_element_anterior = 0;            
            
        } else {
        
            num_element_actual = num_element_actual - 10;
                
            $.getJSON(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/'+func_cerca+'/'+text_buscar+'/'+key_word+'/'+num_element_anterior+'/10', function(data) {
          
                num_elements_llista = data.num_elements;                    
                $('#llistat_botigues_alfabetic').empty();
                $('#llistat_botigues_alfabetic').append(data.llista);
                $('#llistat_botigues_alfabetic').listview('refresh');
                $.mobile.hidePageLoadingMsg();

            });
        
        }
        
        data.iscrollview.refresh();
                
    }    
}

//Carreguem els comerços de la lletra següent

function carregaSeguent(event, data) {
            
    if (num_lletra_actual < 25 && num_elements_llista == 0 && scroll_llista == true) { //Avancem a la següent lletra
        
        $.mobile.showPageLoadingMsg();
            
        num_lletra_actual = num_lletra_actual+1;
        lletra_anterior = $('#alfabet_lateral ul li').get(num_lletra_actual).innerHTML;
                                    
        //Resaltem la lletra actual en l'alfabet lateral
            
        $('#alfabet_lateral ul li').css('background','none');
        $('#alfabet_lateral ul li:nth-child('+(num_lletra_actual+1)+')').css('background', 'gray');
            
        $('#llistat_botigues_alfabetic').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/'+func_cerca+'/'+lletra_anterior+'/inicial', function() {
          
            $('#llistat_botigues_alfabetic').listview('refresh');
            $.mobile.hidePageLoadingMsg();                                        
                    
        });
        
        data.iscrollview.refresh();
            
    } else if (scroll_llista == true) { //Funció d'avançament per mostrar es següents x elements d'una llista (consultes per nom o per keyword)
        
        var num_element_actual_guardat = num_element_actual; //Guardem el valor de l'element actual
        
        //Incrementem els valors
        
        var num_element_anterior = num_element_actual;
                
        //Si encara no hem mostrat tots els elements de la llista, mostrem els següents. En cas contrari
        //restablim el valor del número d'element actual sense incrementar.
        
        if (num_elements_llista > num_element_actual) {
            
            num_element_actual = num_element_actual + 10;

            $.getJSON(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/'+func_cerca+'/'+text_buscar+'/'+key_word+'/'+num_element_anterior+'/10', function(data) {
          
                num_elements_llista = data.num_elements;                    
                $('#llistat_botigues_alfabetic').empty();
                $('#llistat_botigues_alfabetic').append(data.llista);
                $('#llistat_botigues_alfabetic').listview('refresh');
                $.mobile.hidePageLoadingMsg();

            });
            
        } else {
            
            num_element_actual = num_element_actual_guardat;
            
        }
        
        data.iscrollview.refresh();
                
    }
    
}

//Mostrem els comerços que comencen per una determinada lletra (alfabet lateral)

function mostraPaginaLlistatBotigues(){
    
    $("#alfabet_lateral ul li").click(function () {
    
        num_lletra_actual = 0;
        num_elements_llista = 0;
        scroll_lletra = true;
                
        $('#alfabet_lateral ul li').css('background','none');
        $(this).css('background','gray');        
        
        $.mobile.showPageLoadingMsg();
        
        num_lletra_actual = $(this).index();
        
        $('#llistat_botigues_alfabetic').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatBotiguesNom/'+$(this).html()+'/inicial', function() {
          
            $('#llistat_botigues_alfabetic').listview('refresh');
            
            $.mobile.hidePageLoadingMsg();            
            
        });
        
    });    
    
}

/* Cercador per categories */

function llistatCategories() {
    
    scroll_llista = true;
        
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_botigues_alfabetic_contingut').hide();    
    $('#llistat_botigues_alfabetic_contingut_categories').show();        
    
    $('#alfabet_lateral').hide();
    
    $('#llistat_botigues_alfabetic').empty();
        
    $('#searchTextFieldBotigues').attr('onkeypress', 'return llistaBotiguesCategoriaKey(event)');
    
    $('#llistat_botigues_alfabetic_categories').listview('refresh');            
    $('#searchButtonBotigues').attr('href', 'javascript:llistaBotiguesCategoria()');                 
    $.mobile.changePage('#pagina_llistat_botigues');                        
    $.mobile.hidePageLoadingMsg();        
                
    
}

/* Mostrem els comerços d'una categoria determinada */

function comercCategoria(id_categoria) {
    
    categories_llista = true;
    scroll_llista = true;
    key_word = 'num';    
    func_cerca = 'comercCategoria';
    num_lletra_actual = 0;
    num_elements_llista = 0;     
    text_buscar = id_categoria;
    
    $('#llistat_botigues_alfabetic_contingut_categories').hide();    
    $('#llistat_botigues_alfabetic_contingut').show();    
        
    $('#llistat_botigues_alfabetic').empty();
    
    $.getJSON(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/comercCategoria/'+id_categoria+'/num/0/10', function(data) {
        
        num_elements_llista = parseInt(data.num_elements);
        num_element_actual = 10;          
        
        $.mobile.changePage('#pagina_llistat_botigues');
        $('#llistat_botigues_alfabetic').append(data.llista);        
        $('#llistat_botigues_alfabetic').listview('refresh');
        $.mobile.hidePageLoadingMsg();

    });
    
    
}

/* Mostrem els comerços segons keyword */

function comercCategoriaKeyword(id_categoria) {
        
    $('#llistat_botigues_alfabetic_contingut').hide();    
    $('#llistat_botigues_alfabetic_contingut_categories').show();    
    
    $('#llistat_botigues_alfabetic').empty();
    
    $('#llistat_botigues_alfabetic').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/comercCategoria/'+id_categoria+'/key', function() {
          
        $('#llistat_botigues_alfabetic').listview('refresh');
        $.mobile.hidePageLoadingMsg();

    });
    
    
}


/* BLOC LLISTAT OFERTES  */

//Llistat inicial d'ofertes

function llistaOfertesAlfabetic() {
    
    scroll_llista = true;
    scroll_lletra = true;
    num_elements_llista = 0;
    func_cerca = 'llistaPromosOrdenat';
    key_word = '-';
    num_element_actual = 10;
    
    $.mobile.showPageLoadingMsg();
    
    canviaImatge('mostraPromos');
 
    $('#alfabet_lateral_ofertes').show();        
    $('#llistat_ofertes_alfabetic_contingut').show();    
    $('#llistat_ofertes_categories_alfabetic_contingut').hide();        
    
    carregaDadesLlista('llistaPromosOrdenat', key_word, 0, carregaLlistaOfertes);
    
    
}

//Listener de la funció per buscar ofertes segons paraules contingues en el títol de l'oferta

function llistaOfertesKey(event) {
    
    if (event.which == 13) {
            
        llistaOfertesKeyword();
            
    }

}

//Carreguem les següents ofertes

function carregaAnteriorOfertes(event, data) {
    
    $.mobile.showPageLoadingMsg();
    
    if (scroll_llista == true) { //10 elements següents (cerca per keyword o nom)
        
        var num_element_anterior = num_element_actual-20;
        
        if (num_element_anterior < 0) {
            
            num_element_anterior = 0;            
            
            $.mobile.hidePageLoadingMsg();        
            
        } else {
            
            num_element_actual = num_element_actual - 10;
                
            carregaDadesLlista(func_cerca, key_word, num_element_anterior, refrescaLlistaOfertes);
        
        }
        
        data.iscrollview.refresh();
                
    }    
}

//Carreguem les anteriors ofertes

function carregaSeguentOfertes(event, data) {
            
    $.mobile.showPageLoadingMsg();            
            
    if (scroll_llista == true) { //Funció d'avançament per mostrar es següents x elements d'una llista (consultes per nom o per keyword)
        
        var num_element_actual_guardat = num_element_actual; //Guardem el valor de l'element actual
        
        //Incrementem els valors
        
        var num_element_anterior = num_element_actual;
                
        //Si encara no hem mostrat tots els elements de la llista, mostrem els següents. En cas contrari
        //restablim el valor del número d'element actual sense incrementar.
        
        if (num_elements_llista > num_element_actual) {
            
            num_element_actual = num_element_actual + 10;

            carregaDadesLlista(func_cerca, key_word, num_element_anterior, refrescaLlistaOfertes);
            
        } else {
            
            num_element_actual = num_element_actual_guardat;
            
            $.mobile.hidePageLoadingMsg();        
            
        }
        
        data.iscrollview.refresh();
                
    }
    
}

//Carreguem les dades d'una llista amb iscroll

function carregaDadesLlista(funcio_cerca, part_nom, num_element_anterior, callback) {
    
    $('#llistat_ofertes_alfabetic').empty();
    
    $.getJSON(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/' + funcio_cerca + '/'+ part_nom + '/'+num_element_anterior+'/10', function(data) {
          
        num_elements_llista = data.data[0].num_elements;                            
        $('#llistat_ofertes_alfabetic').append(data.data[0].html);                
                
    }).done(callback);
    
}

//Callback cridat quan creem per primer cop la llista d'ofertes amb iscroll

var carregaLlistaOfertes = function () {
    
    //$('#searchButtonOfertes').attr('href', 'javascript:llistaOfertesKeyword();');        
    $.mobile.changePage('#pagina_llistat_ofertes');        
    $('#llistat_ofertes_alfabetic').listview('refresh');                
    $.mobile.hidePageLoadingMsg();        
    //$(document).unbind('touchmove', false);
    
};

//Callback cridat quan creem per primer cop la llista d'ofertes amb iscroll

var refrescaLlistaOfertes = function () {
    
    $('#llistat_ofertes_alfabetic').listview('refresh');                
    $.mobile.hidePageLoadingMsg();        
        
};

//Funció per buscar ofertes segons paraules contingues en el seu nom llistatPromosNom

function llistaOfertesKeyword() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_ofertes_categories_alfabetic_contingut').hide();        
    $('#llistat_ofertes_alfabetic_contingut').show();    
                    
    func_cerca = 'llistatPromosNom';                
    text_buscar = $('#searchTextFieldOfertes').val();
    scroll_lletra = false;
    key_word = text_buscar;
                
    if (text_buscar != "") {
        
        carregaDadesLlista(func_cerca, text_buscar, 0, refrescaLlistaOfertes);
        num_element_actual = 10;
                
    } else {
                
        $('#llistat_ofertes_alfabetic').empty();
        $.mobile.hidePageLoadingMsg();
    }
    
}

/* Cercador d'ofertes per categories */

function llistatOfertesCategories() {
    
    scroll_llista = true;
        
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_ofertes_alfabetic').empty();
    
    $('#llistat_ofertes_alfabetic_contingut').hide();    
    $('#llistat_ofertes_categories_alfabetic_contingut').show();        
    
    $.mobile.changePage('#pagina_llistat_ofertes');                        
    $('#llistat_ofertes_categories').listview('refresh');    
    $.mobile.hidePageLoadingMsg();  
    
}
    

/* Obté les ofertes d'una categoria */

function ofertaCategoria(id_oferta) {
    
    scroll_llista = true;
    scroll_lletra = true;
    num_elements_llista = 0;
    func_cerca = 'ofertaCategoria';
    key_word = id_oferta;
    num_element_actual = 10;
    
    $.mobile.changePage('#pagina_llistat_ofertes');
    
    $('#alfabet_lateral_ofertes').show();
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_ofertes_alfabetic_contingut').show();    
    $('#llistat_ofertes_categories_alfabetic_contingut').hide();        
    
    carregaDadesLlista('ofertaCategoria', id_oferta, 0, carregaOfertesCategories);
    
}

//Callback cridat quan cridem cop la llista d'ofertes per categories amb iscroll

var carregaOfertesCategories = function () {
         
    $('#llistat_ofertes_alfabetic').listview('refresh');                
    $.mobile.hidePageLoadingMsg();        
    //$(document).unbind('touchmove', false);
    
};

//Mostrem les ofertes d'una botiga

function mostraPromosBotigaOrdenat() {
    
    scroll_llista = true;
    scroll_lletra = true;
    num_elements_llista = 0;
    func_cerca = 'llistatPromosBotigaOrdenat';
    key_word = 'nom';
    num_element_actual = 10;
        
    $.mobile.showPageLoadingMsg();
  
    $.mobile.changePage('#pagina_llistat_ofertes');     
  
    $('#llistat_ofertes_alfabetic_contingut').show();    
    $('#llistat_ofertes_categories_alfabetic_contingut').hide();        
  
    carregaDadesLlista('llistatPromosBotigaOrdenat', botiga_activa, 0,carregaOfertesCategories);
    
}

/* FINAL BLOC LLISTAT OFERTES */
 
//Carreguem el llistat de POI's

function llistaPoiTurisme() {
    
    canviaImatge('llistaPoiTurisme');
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_poi_turisme').empty();
    $('#llistat_poi_turisme').show();    
    
    $('#llistat_poi_turisme').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/llistatPoiTurisme', function() {
  
        $.mobile.changePage('#pagina_propostes');
        $('#llistat_poi_turisme').listview('refresh');
        $.mobile.hidePageLoadingMsg();         
       // $(document).unbind('touchmove', false);
    });
    
}

function carregaCarousselPoi() {
    
    $('#caroussel_fotos').empty();
    $('#poi_caroussel_fotos').empty();    
    $('#poi_caroussel_fotos').show();    
    $('#popupCarousselPoi').width(window.innerWidth - 50);    
    
    $('#poi_caroussel_fotos').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getCarousselPoi/'+lloc_actiu, function() {
        
        var altura_popup = (window.innerWidth-50) *0.67;
          
        $("#c_bot_poi").carousel();        
        $( "#c_bot_poi" ).css( "height", altura_popup + "px" );
        $( "#c_bot_poi_cont" ).css( "height", altura_popup + "px" );
        $( "#c_bot_poi_cont div" ).css( "height", altura_popup + "px" );
        $( "#popupCarousselPoi" ).css( "max-height", altura_popup + "px" );
        $( "#popupCarousselPoi" ).popup("open");      
                    
    });
}


//Carreguem l'agenda cultural

function agendaCultural() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_agenda_cultural').empty();
    $('#llistat_agenda_cultural_categoria').empty();
        
    $('#llistat_agenda_cultural').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getAgendaCultural', function() {
  
        $.mobile.hidePageLoadingMsg();               
        $('#llistat_agenda_cultural').listview('refresh');        
        
    });
    
}

//Carreguem els esdeveniments d'una categoria

function getCategoriaAgendaCultural(tipus_activitat) {
    
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_agenda_cultural').empty();
    $('#llistat_agenda_cultural_categoria').empty();
                    
    $('#llistat_agenda_cultural_categoria').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getCategoriaAgendaCultural/', {
        tipus_activitat: tipus_activitat
    } , function() {
  
        $.mobile.hidePageLoadingMsg();       
        $('.rss_popup').popup();
        $('.rss_popup a').buttonMarkup();
        $('#llistat_agenda_cultural_categoria').listview('refresh');        
        
    });
    
}

function getNoticies() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_agenda_cultural').empty();
    $('#llistat_agenda_cultural_categoria').empty();
            
    $('#llistat_agenda_cultural').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getNoticies', function() {
  
        $.mobile.hidePageLoadingMsg();                  
        $('#llistat_agenda_cultural').listview('refresh');        
        
    });
    
}

function getNoticiesCategoria(tipus_activitat) {
    
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_agenda_cultural').empty();
    $('#llistat_agenda_cultural_categoria').empty();
                
    $('#llistat_agenda_cultural').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getNoticiesCategoria/', {
        tipus_activitat: tipus_activitat
    } , function() {
  
        $.mobile.hidePageLoadingMsg();       
        $('.rss_popup_noticies').popup();
        $('.rss_popup_noticies a').buttonMarkup();
        $('#llistat_agenda_cultural').listview('refresh');        
        
    });
    
}

//RSS: Esdeveniments del dia d'avui

function getEsdevenimentsAvui() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_agenda_cultural').empty();
    $('#llistat_agenda_cultural_categoria').empty();
            
    $('#llistat_agenda_cultural_categoria').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getEsdevenimentsAvui' , function() {
  
        $.mobile.hidePageLoadingMsg();       
        $('.rss_popup').popup();
        $('.rss_popup a').buttonMarkup();
        $('#llistat_agenda_cultural_categoria').listview('refresh');        
        
    });
    
}

//RSS: Cugat.cat

function getNoticiesCugat() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#llistat_agenda_cultural').empty();
    $('#llistat_agenda_cultural_categoria').empty();
                
    $('#llistat_agenda_cultural').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getNoticiesCugat/', function() {
  
        $.mobile.hidePageLoadingMsg();       
        $('.rss_popup_noticies').popup();
        $('.rss_popup_noticies a').buttonMarkup();
        $('#llistat_agenda_cultural').listview('refresh');        
        
    });
    
}

//Obtenim la descripció d'un punt d'interès

function infoPoi(id_lloc) {
    
    $.mobile.showPageLoadingMsg();
    
    lloc_actiu = id_lloc;
    
    $('#poi_map_canvas').empty();
    $('#descripcio_propostes_text_container').empty();
    $('#descripcio_propostes_text_container').show();
    $('#poi_caroussel_fotos').hide();
    
    $('#poi_map_canvas_wrapper').hide();
    $('#descripcio_poi_text').show();
    $('#desc_c_txt').hide();
    $('#desc_c_cte').hide();
    
    $('#descripcio_propostes_text_container').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getDescripcioPoi/'+id_lloc, function() {
  
        $.mobile.changePage('#pagina_descripcio_propostes');
        $('#poi_compartir').popup();
        $('#poi_compartir a').buttonMarkup();    
        $('#button_caroussel_poi').buttonMarkup();
        $.mobile.hidePageLoadingMsg();
          
    });
    
}

//Mostrem la pestanya "compartir" del poi

function poiCompartir() {
    
    $('#poi_compartir').popup('open');
}

//Dibuixem el mapa de com arribar al poi des d'on som

function comArribarPoi() {
    
    desti_lloc = $('#dir_poi').html();
    
    $('#poi_map_canvas_ruta').hide();
    $('#poi_map_canvas_wrapper').show();
    $('#descripcio_propostes_text_container').hide();
    
    if ($('#poi_map_canvas').html() == "") {
        
        $.mobile.showPageLoadingMsg();
        
        geo('poi_map_canvas','propostes_mapa_popup', 'desc_c_txt', 'dir_poi');    
        
    }
    
}

//Mostrem la info d'un poi

function mostraInfoPoi() {
    
    $('#descripcio_propostes_text_container').show();
    $('#descripcio_poi_text').show();
    $('#poi_map_canvas_wrapper').hide();
    $('#poi_caroussel_fotos').hide();    
    $('#desc_c_txt').show();
    $('#desc_c_cte').hide();
    
}

//Carreguem el llistat de POI's

function llistaRutes(tipus) {
  
    tipus_ruta_activa = tipus;
  
    $('#llistat_rutes').empty();    
    $('#llistat_rutes').show();    
    
    $('#llistat_rutes').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/'+tipus, function() {
  
        $('#llistat_rutes').listview('refresh');
        $.mobile.hidePageLoadingMsg();
                
    });
    
}

//Informació sobre una ruta de turisme o comercial

function infoRutaTurisme(id_ruta, tipus_ruta) {
    
    $.mobile.showPageLoadingMsg();
    
    ruta_activa = id_ruta;
    tipus_ruta_activa = tipus_ruta;
    
    $('#rutes_turistiques_map_canvas').empty();
    $('#rutes_turistiques_text_container').empty();
    $('#rutes_turistiques_text_container').show();
        
    $('#rutes_turistiques_map_canvas').hide();
    $('#rutes_turistiques_text').show();
    $('#descripcio_poi_text').hide();
    
    $('#rutes_turistiques_text_container').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/'+tipus_ruta+'/'+id_ruta, function() {
  
        $.mobile.changePage('#pagina_descripcio_rutes_turistiques');            
        $('#turisme_compartir').popup();
        $('#turisme_compartir a').buttonMarkup();    
        
        $.mobile.hidePageLoadingMsg();
          
    });
        
}

//Mostrem la pestanya "compartir" de la ruta

function rutaTurismeCompartir() {
    
    $('#turisme_compartir').popup('open');
    
}

//Mostrem la info d'un poi

function mostraInfoRutaTurisme() {
    
    $('#rutes_turistiques_text_container').show();   
    $('#rutes_turistiques_map_canvas').hide();
    $('#descripcio_poi_text').show();
    
}

/* Horaris de transport públic */

function horaris_fgc() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#transport_public_horaris').load(base_url+'SCC/'+llengua_activa_abr+'/trens/horarisFerrocarrils', function() {
  
        $.mobile.changePage('#pagina_transport_public');
        
        $('#web_fgc_button').buttonMarkup();
        
        $.mobile.hidePageLoadingMsg();
          
    });
    
}

function horaris_renfe(){
    
    $.mobile.showPageLoadingMsg();
                
    $('#transport_public_horaris').load(base_url+'SCC/'+llengua_activa_abr+'/trens/horarisFerrocarrilsTornada', function() {
  
        $.mobile.changePage('#pagina_transport_public');
        
        $('#web_fgc_button').buttonMarkup();
        
        $.mobile.hidePageLoadingMsg();
        
    });
    
}

function getInfoInteres() {
    
    $('#info_interes_contingut').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/getInfoInteres', function() {
  
        $.mobile.changePage('#pagina_info_interes');
        
        $('#info_interes_contingut a').buttonMarkup();
        
        $.mobile.hidePageLoadingMsg();
        
    });
    
}

/* Noticies SCC */

function llistaNoticiesSCC() {
    
    canviaImatge('llistaNoticiesSCC');
    
    $.mobile.showPageLoadingMsg();
    
    $('#llista_noticies_stc').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/obteNoticies', function() {
  
        $.mobile.changePage('#pagina_llista_stc');
        
        $('#llista_noticies_stc').listview('refresh');
        
        $.mobile.hidePageLoadingMsg();
        
        //$(document).unbind('touchmove', false);
          
    });
    
}

/* Noticies SCC */

function obteNoticia(id_noticia) {
    
    $.mobile.showPageLoadingMsg();
    
    $('#descripcio_noticies_stc').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/obteNoticia/'+id_noticia, function() {
  
        $.mobile.changePage('#pagina_descripcio_noticies_stc');
        
        $('#noticia_compartir').popup();        
        $('#noticia_compartir a').buttonMarkup();
        
        $.mobile.hidePageLoadingMsg();
          
    });
    
}

//Pagina com arribar

function carregaPaginaArribar() {
    
    canviaImatge('carregaPaginaArribar');
    
    $.mobile.showPageLoadingMsg();
    $.mobile.changePage('#pagina_com_arribar');
    
    $('#searchTextField').click(function(){
        $('#searchTextField').val('');
    });
    
    geo_arribar();
    
    //$(document).unbind('touchmove', false);
    
}

//Sobre nosaltres

function carregaSobreNosaltres() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#descripcio_sobre_nosaltres').empty();
    
    $('#descripcio_sobre_nosaltres').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/carregaSobreNosaltres', function() {
                
        $.mobile.hidePageLoadingMsg();
          
    });
    
}

//Contacte

function carregaContacte() {
    
    $.mobile.showPageLoadingMsg();
    
    $('#descripcio_sobre_nosaltres').empty();
    
    $('#descripcio_sobre_nosaltres').load(base_url+'SCC/'+llengua_activa_abr+'/web_mobil/carregaContacte', function() {
                
        $.mobile.hidePageLoadingMsg();
        $('#descripcio_sobre_nosaltres a').buttonMarkup();
          
    });
    
}

//Botons segueix-nos

function carregaSegueixnos() {
    
    var data_segueixnos;
    
    $.getJSON((base_url+'SCC/ca/web_mobil/carregaSegueixnos'), function(data) {                       
        data_segueixnos = data;
    })
    .complete(function() {        
        $('#fb').attr('href', data_segueixnos.fb);
        $('#twitter').attr('href', data_segueixnos.tw);            
    });
    
}