/* Script per mostrar els POI del meu voltant */

var botiguesConfig;

//Mostrem un mapa amb una ruta turistica

function mostraRuta() {
    
    if (tipus_ruta_activa == "getRutaComercial") {

        botiguesConfig = {
            map_canvas : "rutes_turistiques_map_canvas",    
            popup: "rutes_turistiques_mapa_popup",
            funcio: 'infoBotiga',
            canvi_pag: 0,
            consultaRuta: "getComercosRutaComercial"
        }
        
    } else {
        
        botiguesConfig = {
            map_canvas : "rutes_turistiques_map_canvas",    
            popup: "rutes_turistiques_mapa_popup",
            funcio: 'infoPoi',
            canvi_pag: 0,
            consultaRuta: "getPOIRutaTurisme"
        
        }
        
    }
    
    if (geoPosition.init() !==null) {                
        geoPosition.getCurrentPosition(getRuta, error);        
    } else {
        
        msg.code = 1;
        
        error(msg);        
    }	
    
}

//var waypts = [];

function getRuta(position) {
    
    $('#rutes_turistiques_text_container').hide();
    $.mobile.showPageLoadingMsg();
    
    var rendererOptions = {
        suppressMarkers : true
    }
    
    var posicio_llocs;
    var markersArray = new Array();
    var bounds = new google.maps.LatLngBounds();
    var waypts = [];
    var directionsDisplay = new google.maps.DirectionsRenderer(rendererOptions);
    var directionsService = new google.maps.DirectionsService();
        
    //Agafem els punts d'interès d'una ruta determinada
    
    $.getJSON((base_url+'SCC/ca/web_mobil/'+botiguesConfig.consultaRuta+'/' + ruta_activa ),function(data) {
        
        posicio_llocs = data;
        
    })
    .complete(function() { 
        
        origen = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
       
        myOptions = {            
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            center: origen,
            mapTypeControl: false,  
            streetViewControl: false
        }
	
        map_botigues = new google.maps.Map(document.getElementById(botiguesConfig.map_canvas), myOptions);
        directionsDisplay.setMap(map_botigues);
    
        map_botigues.setOptions({
            styles: styles
        });
        
        //Afegim el waypoint de lloc on som
        
        waypts.push({
            location:origen
        });
    
        //Posem el marker de la nostra posició    
        
        var marker = new google.maps.Marker({
            map: map_botigues,
            position: origen,
            icon: icona_botiga[16],
            optimized: false,
            zIndex: google.maps.Marker.MAX_ZINDEX + 1
        });
        markersArray.push(marker);
        bounds.extend(marker.position);
        
        //Afegim el popup del lloc on ens trobem
        
        socAquiPopup(origen, marker);
        
        //Iterem els POI obtinguts i creem el seu marcador
    
        $.each(posicio_llocs, function(key, val) {            
        
            //Si es tracta d'una ruta turistica, l'icona serà igual per a tots els poi. En cas de 
            //ser una ruta comercial, cada poi tindrà l'icona corresponent a la categoria del comerç.
        
            var iconaPoi = icona_botiga[17];
                            
            if (botiguesConfig.consultaRuta == "getComercosRutaComercial") {
                
                if (val.categoria == null) {
                    iconaPoi = icona_botiga[0];                    
                } else {
                    iconaPoi = icona_botiga[val.categoria];                                    
                }
                
            }
        
            var marker = new google.maps.Marker({
                map: map_botigues,
                position: new google.maps.LatLng(val.latitude, val.longitude),
                icon: iconaPoi,
                optimized: false
            });
            
            //Afegim els waypoints de cada POI
            
            waypts.push({
                location: new google.maps.LatLng(val.latitude, val.longitude),
                stopover: true
            });
            
            
            markersArray.push(marker);            
            bounds.extend(marker.position);
            
            //Afegim el listener per al popup depenent del tipus de ruta que es tracti
            
            google.maps.event.addListener(marker, 'click', function() {
        
                $('#'+botiguesConfig.popup+'_text').empty();
        
                if (botiguesConfig.consultaRuta == "getPOIRutaTurisme") {
        
                    $('#'+botiguesConfig.popup+'_text').append("<p>" + val.nom_lloc + "</p><p>" + val.direccio_lloc + "</p>");
                    $('#'+botiguesConfig.popup+' a').attr('href', "javascript:" + botiguesConfig.funcio + "(" + val.id_lloc + ")")                
                                        
                } else {
                                        
                    $('#'+botiguesConfig.popup+'_text').append("<p>" + val.nombre_comercio + "</p><p>" + val.direccion_comercio + "</p>");
                    $('#'+botiguesConfig.popup+' a').attr('href', "javascript:" + botiguesConfig.funcio + "(" + val.id_comercio + ")")                
                                        
                }
                
                $('#'+botiguesConfig.popup).popup('open');
        
            });  
        });
        
        var request = {
            origin: origen,
            destination: waypts[1].location,
            waypoints: waypts,
            optimizeWaypoints: false,
            travelMode: google.maps.TravelMode.WALKING
        };
        directionsService.route(request, function(response, status) {
            if (status == google.maps.DirectionsStatus.OK) {
                directionsDisplay.setDirections(response);                      
            }
        });
        
        $('#'+botiguesConfig.map_canvas).show();                
    
        //Un cop el mapa està carregat del tot:
    
        google.maps.event.addListenerOnce(map_botigues, 'idle', function(){
            //Fer un resize del mapa un cop carregat per tal que la API reconegui les dimensions del contenidor. D'aquesta forma //s'evita que només mostri una part del mapa.
        
            google.maps.event.trigger(map_botigues,'resize'); 
            
            map_botigues.fitBounds(bounds);
        
            $('#'+botiguesConfig.map_canvas).css('visibility','visible');
        
            $.mobile.hidePageLoadingMsg();    
        
        });	
       
    });
}

//Obtenim l'adreça d'un objecte latLng i creem el popup corresponent

function socAquiPopup(origen, marker) {

    geocoder.geocode( {
        'latLng': origen
    }, function(results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
            
            google.maps.event.addListener(marker, 'click', function() {				  			  			  

                $('#'+botiguesConfig.popup+'_aqui_text').empty();
                $('#'+botiguesConfig.popup+'_aqui_text').append('<p>'+idiomes[llengua_activa]['lang_voste_aqui']+'</p><p>' + results[0].formatted_address + '</p>');
                $('#'+botiguesConfig.popup+'_aqui').popup('open');

            });
            return true;
            
        } else {
            return false;
        }
    });
    
}