//Mostrem un mapa amb les botigues que tenim al nostre voltant

var botiguesConfig;

function botiguesVoltant() {
    
    if (geoPosition.init()) {
        
        /* Script per mostrar els POI del meu voltant */

        botiguesConfig = {
            map_canvas : "map_canvas_botigues",
            funcio_consulta : "botiguesVoltant",
            popup: "botigues_mapa_popup",
            funcio: 'infoBotiga',
            canvi_pag: 0,
            distancia: 0.1

        }
        
        $.mobile.showPageLoadingMsg();
          
        $.mobile.changePage('#pagina_mapa_botigues_voltant');
                        
        geoPosition.getCurrentPosition(getBotiguesVoltant, error);						
    } else {
        msg.code = 1;        
        error(msg);      
    }	
}

//Mostrem un mapa amb les botigues amb ofertes que tenim al nostre voltant

function botiguesOfertesVoltant(canviPag) {
    
    if (geoPosition.init()) {
        
        //Inicialitzem els paràmetres per a botiguesOfertes
        
        botiguesConfig = {
            map_canvas : "llista_map_canvas_oferta",
            funcio_consulta : "ofertesVoltant",    
            popup: "ofertes_voltant_map",
            funcio: 'mostraPromosBotigaMapa',
            canvi_pag: canviPag,
            distancia: 0.1
        }
        
        $.mobile.showPageLoadingMsg();
        
        $.mobile.changePage('#llistat_ofertes');
        
        $('#llista_promos_botiga').hide();
          
        geoPosition.getCurrentPosition(getBotiguesVoltant, error);						
    } else {
        msg.code = 1;        
        error(msg); 
    }
    
}

function getBotiguesVoltant(position) {
    
    var posicio_llocs;
    var markersArray = new Array();    
    
    var bounds = new google.maps.LatLngBounds();
    
    //Mirem quins llocs estan en un radi de x quilòmetres des del punt on em trobo jo
    
    $.getJSON((base_url+'SCC/ca/web_mobil/' + botiguesConfig.funcio_consulta + '/' + position.coords.latitude + '/' + position.coords.longitude + '/' + botiguesConfig.distancia),function(data) {
        
        posicio_llocs = data;
        
    })
    .complete(function() { 
        
        origen = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
       
        myOptions = {            
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            center: origen,
            mapTypeControl: false,  
            streetViewControl: false
        }
	
        map_botigues = new google.maps.Map(document.getElementById(botiguesConfig.map_canvas), myOptions);
    
        map_botigues.setOptions({
            styles: styles
        });
    
        //Posem el marker de la nostra posició    
        
        var marker = new google.maps.Marker({
            map: map_botigues,
            position: origen,
            icon: icona_botiga[16],
            optimized: false,
            zIndex: google.maps.Marker.MAX_ZINDEX + 1
        });
        markersArray.push(marker);
        bounds.extend(marker.position);
        
        //Afegim el popup del lloc on ens trobem
        
        socAquiPopup(origen, marker);
        
        //Iterem els POI obtinguts i creem el seu marcador
    
        $.each(posicio_llocs, function(key, val) {            
        
            var current_icon;
        
            if (val.categoria != null) {
                
                current_icon = icona_botiga[val.categoria];
                
            } else {
                
                current_icon = icona_botiga[0];
                
            }
        
            var marker = new google.maps.Marker({
                map: map_botigues,
                position: new google.maps.LatLng(val.latitude, val.longitude),
                icon: current_icon,
                optimized: false
            });
            markersArray.push(marker);            
            bounds.extend(marker.position);
            
            //Afegim el listener per al popup
            
            google.maps.event.addListener(marker, 'click', function() {				  			  			  
        
                $('#'+botiguesConfig.popup+'_text').empty();
                $('#'+botiguesConfig.popup+'_text').append("<p>" + val.nombre_comercio + "</p><p>" + val.direccion_comercio + "</p>");
                $('#'+botiguesConfig.popup+' a').attr('href', "javascript:" + botiguesConfig.funcio + "(" + val.id_comercio + ")")                
                $('#'+botiguesConfig.popup).popup('open');
        
            });
        
        });
    
        $('#'+botiguesConfig.map_canvas).show();
    
        //Un cop el mapa està carregat del tot:
    
        google.maps.event.addListenerOnce(map_botigues, 'idle', function(){
            //Fer un resize del mapa un cop carregat per tal que la API reconegui les dimensions del contenidor. D'aquesta forma //s'evita que només mostri una part del mapa.
        
            google.maps.event.trigger(map_botigues,'resize'); 
            
            map_botigues.fitBounds(bounds);
        
            $('#'+botiguesConfig.map_canvas).css('visibility','visible');
        
            $.mobile.hidePageLoadingMsg();    
        
            $('#llistat_ofertes [data-role=header] [data-role=navbar] ul li:nth-child(3) a').toggleClass('ui-btn-active');
        
        });	
       
    });
}

//Obtenim l'adreça d'un objecte latLng i creem el popup corresponent

function socAquiPopup(origen, marker) {

    geocoder.geocode( {
        'latLng': origen
    }, function(results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
            
            google.maps.event.addListener(marker, 'click', function() {				  			  			  

                $('#'+botiguesConfig.popup+'_aqui_text').empty();
                $('#'+botiguesConfig.popup+'_aqui_text').append('<p>'+idiomes[llengua_activa]['lang_voste_aqui']+'</p><p>' + results[0].formatted_address + '</p>');
                $('#'+botiguesConfig.popup+'_aqui').popup('open');

            });
            return true;
            
        } else {
            return false;
        }
    });
    
}