﻿var GameWorld =
{
    world:				null,
    coorBullet:			[],
    body_x:				0,
    body_y:				0,
    collisionCoor:		[],
    collisionFlag:		false,
	wall_density:		10,
    wall_restitution:	0.7,
    wall_friction:		1,
	widthSidePanel:		38,
	heightTopPanel:		25,
	sideShiftWall:		202,
    topShiftWallX:      118,
    topShiftWallY:      141,


    createWorld: function()
    {
        GameWorld.world = box2d.createWorld(new b2Vec2(0, 0), false);

        box2d.setContactsListener(
                GameWorld.world,
                {
                    beginContact: function(contact)
                    {
                        //console.log('contact.m_fixtureA.GetBody() = ', contact.m_fixtureA.GetBody());
                        //console.log('contact.m_fixtureB.GetBody() = ', contact.m_fixtureB.GetBody());
                        //console.log('contact.IsTouching() = ', contact.IsTouching());
                        //debugger;

                        Bullet.checkContactList(contact.m_fixtureA.GetBody(), contact.m_fixtureB.GetBody());
                    }
                });

        GameWorld.createWalls(GameWorld.world);
        box2d.setDebugDraw(GameWorld.world, document.getElementById('screen'));
    },

    createWalls: function(world)
    {
		var body = null;
		//left
        body = box2d.createPoly(world, {
                    x:              getStageWidthCenter() - GameWorld.sideShiftWall,
                    y:              getStageHeightCenter(),
                    points:         [[[8, -94], [-1, -77], [-38, -77], [-38, -94]], [[-1, -77], [-1, 160], [-38, 160], [-38, -77]]],
                    rotation:       0,
                    bodyType:       box2d.bodyType.static,
                    density:        GameWorld.wall_density,
                    restitution:    GameWorld.wall_restitution,
                    friction:       GameWorld.wall_friction});
        body.WALL = true;
        body.ID_WALL = 1;

		//rigth
        body = box2d.createPoly(world, {
                    x:              getStageWidthCenter() + GameWorld.sideShiftWall,
                    y:              getStageHeightCenter(),
                    points:         [[[38, -94], [38, -77], [1, -77], [-8, -94]], [[38, -77], [38, 160], [1, 160], [1, -77]]],
                    rotation:       0,
                    bodyType:       box2d.bodyType.static,
                    density:        GameWorld.wall_density,
                    restitution:    GameWorld.wall_restitution,
                    friction:       GameWorld.wall_friction});
        body.WALL = true;
        body.ID_WALL = 2;

		//top
        body = box2d.createCircle(world, {
                    x:              getStageWidthCenter() - 207,
                    y:              getStageHeightCenter() - 127,
                    radius:         35,
                    rotation:       0,
                    bodyType:       box2d.bodyType.static,
                    density:        GameWorld.wall_density,
                    restitution:    GameWorld.wall_restitution,
                    friction:       GameWorld.wall_friction});
        body.WALL = true;
        body.ID_WALL = 3;

        body = box2d.createCircle(world, {
                    x:              getStageWidthCenter() + 207,
                    y:              getStageHeightCenter() - 127,
                    radius:         35,
                    rotation:       0,
                    bodyType:       box2d.bodyType.static,
                    density:        GameWorld.wall_density,
                    restitution:    GameWorld.wall_restitution,
                    friction:       GameWorld.wall_friction});
        body.WALL = true;
        body.ID_WALL = 4;

        // top left
        body = box2d.createPoly(world, {
                    x:              getStageWidthCenter() - GameWorld.topShiftWallX,
                    y:              getStageHeightCenter() - GameWorld.topShiftWallY,
                    points:         [[[55, -19], [50, -1], [39, 12], [24, 19], [-55, 19], [-55, -19]]],
                    rotation:       0,
                    bodyType:       box2d.bodyType.static,
                    density:        GameWorld.wall_density,
                    restitution:    GameWorld.wall_restitution,
                    friction:       GameWorld.wall_friction});
        body.WALL = true;
        body.ID_WALL = 5;

        //top right
        body = box2d.createPoly(world, {
                    x:              getStageWidthCenter() + GameWorld.topShiftWallX,
                    y:              getStageHeightCenter() - GameWorld.topShiftWallY,
                    points:         [[[55, -19], [55, 19], [-24, 19], [-39, 12], [-50, -1], [-55, -19]]],
                    rotation:       0,
                    bodyType:       box2d.bodyType.static,
                    density:        GameWorld.wall_density,
                    restitution:    GameWorld.wall_restitution,
                    friction:       GameWorld.wall_friction});
        body.WALL = true;
        body.ID_WALL = 6;
    },

    getBodyByPoint: function(point, presentBody)
    {
        var body = GameWorld.world.GetGroundBody();

        if (point)
        {
            stack = stage.getObjectsStackByCoord(point.x, point.y, false);

            if (stack.length > 0)
            {
                for (var i = stack.length - 1; i >= 0; i--)
                {
                    if (stack[i].box2dBody && stack[i].box2dBody != presentBody)
                    {
                        body = stack[i].box2dBody;
                    }
                }
            }
        }

        return body;
    },

    createObject: function(lo, ob)
    {
        console.log('======createObject');
        var body, density, restitution, friction, fixed, x, y, width, height;

        var mc = library.getSprite(ob.name);
        mc.x = getStageWidthCenter() - (240 - lo.x);
        mc.y = lo.y;
		mc.NAME = ob.name;
        mc.rotation = lo.rotation;
        stage.addChild(mc);

//		if (ob.type == WARP)
//		{
//			Warp.addSprite(mc);
//		}

		if (ob.type == CIRCLE_PLATFORM || ob.type == PLATFORM)
		{
			mc.PLATFORM = true;
		}

        if (ob.bodyType != NONE && ob.type != WARP)
		{
            fixed = (typeof (lo.fixed) != "undefined") ? lo.fixed : ob.fixed;
            density = (typeof (lo.density) != "undefined") ? lo.density : ob.density;
            restitution = (typeof (lo.restitution) != "undefined") ? lo.restitution : ob.restitution;
            friction = (typeof (lo.friction) != "undefined") ? lo.friction : ob.friction;

            if (density <= 0)
            {
                fixed = true;
            }

            width = ob.bodyWidth ? ob.bodyWidth : ob.width;
            height = ob.bodyHeight ? ob.bodyHeight : ob.height;
            x = getStageWidthCenter() - (240 - lo.x);
            y = lo.y;

            if (ob.bodyPosCorrect)
            {
                x += ob.bodyPosCorrect.x;
                y += ob.bodyPosCorrect.y;
                mc.syncX = ob.bodyPosCorrect.x;
                mc.syncY = ob.bodyPosCorrect.y;
                mc.onbox2dsync = spritesSync;
            }

            if (ob.bodyType == BOX)
            {
                body = box2d.createBox(GameWorld.world, {
                    x: x,
                    y: y,
                    width: width,
                    height: height,
                    rotation: lo.rotation,
                    bodyType: fixed ? box2d.bodyType.static : box2d.bodyType.dynamic,
                    density: density,
                    restitution: restitution,
                    friction: friction
                });
            }

            if (ob.bodyType == CIRCLE)
            {
                body = box2d.createCircle(GameWorld.world, {
                    x: x,
                    y: y,
                    radius: width / 2,
                    rotation: lo.rotation,
                    bodyType: fixed ? box2d.bodyType.static : box2d.bodyType.dynamic,
                    density: density,
                    restitution: restitution,
                    friction: friction,
                    //filter: {groupIndex: -1}
                });
            }

            if (ob.bodyType == POLY)
            {
                body = box2d.createPoly(GameWorld.world, {
                    x: x,
                    y: y,
                    points: ob.points,
                    rotation: lo.rotation,
                    bodyType: fixed ? box2d.bodyType.static : box2d.bodyType.dynamic,
                    density: density,
                    restitution: restitution,
                    friction: friction
                });
            }

			if (ob.color)
			{
				body.color = ob.color;
			}

			body.NAME = ob.name;
            body.sprite = mc;
			body.type = ob.type;
			body.width = ob.bodyWidth;
            mc.box2dBody = body;

            if (ob.type == CRYSTAL || ob.type == ASTEROID || ob.type == STONE)
            {
                body.ELEMENT = true;
                body.typeName = ob.typeName;
                Elements.addBody(body);
            }

            if (ob.type == CIRCLE_PLATFORM || ob.type == PLATFORM)
            {
                body.PLATFORM = true;
                Platforms.addBody(body);
            }
        }

		if (GET["debug"] != 1 && (fixed && ob.type != ELEMENT))
		{
			mc.static = true;
        }

		//mc.static = true;

        mc.obType = ob.type;
        mc.bodyWidth = ob.bodyWidth;
        mc.bodyHeight = ob.bodyHeight;

        mc.gotoAndStop(0);

        return mc;
    },

    findObject: function(name)
    {
        for (var i = 0; i < objects.length; i++)
        {
            if (objects[i].name == name)
            {
                return objects[i];
            }
        }

        return false;
    },

    convertMetersToBox2d: function(val)
    {
        return val / box2d.SCALE;
    },

    convertBox2dToMeters: function(val)
    {
        return val * box2d.SCALE;
    },

    deleteObject: function(body)
    {
        if (body)
        {
            if (body.sprite)
            {
                body.sprite.visible = false;
                body.sprite.destroy = true;

                buildBackground();
            }

            GameWorld.world.DestroyBody(body);
        }
    },

    actionBeforeCalcWorld: function()
    {
        //destroy
        var b = GameWorld.world.GetBodyList();

        while (b)
        {
            if (b.NEED_DESTROY)
            {
                GameWorld.deleteObject(b);
            }

            b = b.GetNext();
        }

        //create
        if (need_create_flag)
        {
            Bullet.createBody();
            Bullet.move(true);

            need_create_flag = false;
        }
    },

    showScaleScore: function(id)
    {
        //console.log('2) Elements.body[' + id + '] = ', Elements.body[id]);
        if (Elements.body[id].type !== ASTEROID)
        {
            return;
        }

        if (tmpScoreMultiplier !== scoreMultiplier)
        {
            for (var i = 0; i < stage.objects.length; i++)
            {
                if (stage.objects[i].SCALE_SCORE)
                {
                    stage.objects[i].gotoAndStop(2);
                }
            }

            tmpScoreMultiplier = scoreMultiplier;
        }

        if (scoreMultiplier !== multiplierValue[multiplierValue.length - 1])
        {
            var spr = GameBase.createSprite('scale', getStageWidthCenter() + 219, getStageHeightCenter() + yScaleScore[Elements.allTouches], 100);

            spr.SCALE_SCORE = true;
            spr.SCALE_ID = Elements.allTouches;
            spr.gotoAndStop(1);
        }

        //console.log('spr = ', spr);
    }

};


var Cannon =
{
	sprite:			null,
	spriteAim:		null,
	body:			null,
	startRotation:	false,
	radius:			50,
	shooterShift:	16,
	aimShift:		13,
	cannonShift:	10,
	shiftElements:	36,

	init: function()
	{
		//console.log('===================Cannon.init()');
		if (!Cannon.sprite)
		{
			Cannon.sprite = GameBase.createSprite("cannon", getStageWidthCenter(), 0);
			Cannon.sprite.CANNON = true;

			Cannon.body = box2d.createCircle(GameWorld.world, {
                    x: Cannon.sprite.x,
                    y: Cannon.sprite.y,
                    radius: Cannon.radius,
                    rotation: 0,
                    bodyType: box2d.bodyType.static,
                    density: ball_density,
                    restitution: ball_restitution,
                    friction: ball_friction
                });
            Cannon.body.CANNON = true;

			Cannon.spriteAim = GameBase.createSprite("aim_1", getStageWidthCenter(), 0, null, false, 1, 0.7);
			Cannon.spriteAim.CANNON = true;
			Cannon.spriteAim.anchor = {x: 0, y: -(106 + Cannon.aimShift + Cannon.shiftElements / 0.7)};
			Cannon.spriteAim.setZIndex(0);
		}
	},

	rotate: function(e)
	{
		//console.log('===================Cannon.rotate()');
		if (Cannon.startRotation)
		{
			var rotation = Math.PI/2 + Math.atan2(getStageHeightCenter() + e.y - Cannon.sprite.y,
												  getStageWidthCenter() + e.x - Cannon.sprite.x);

			if (rotation > 4.25)
			{
				rotation = 4.25;
			}

			if (rotation < 2.05)
			{
				rotation = 2.05;
			}

            Cannon.sprite.rotation = Cannon.spriteAim.rotation = Math.PI + rotation;
		}
	},

	clear: function()
	{
		Cannon.sprite = null;
		Cannon.body = null;
	}
};


var Bullet =
{
    BIMBA:          1,
    ROKETA:         2,
    MULTIBULLET:    3,
    ADDBULLET:      4,

	sprite:			[],
	body:			[],
	radius:			7,
	impulse:		6,
	onFieldFlag:    0,
	onTouchFlag:	false,
	zIndex:			0,
	pearlShift:		-11,
	startTime:		0,
	startHlTime:	0,
	finishTime:		0,
	contactFlag:	0,
	index:			0,
	bonusType:		-1,
    bimbaRadius:    70,
    vector:         null,
    stackBonus:     [],
    isBodySensor:   false,

	init: function(noResetBonusType)
	{
		console.log('===================Bullet.init()');
		var sprite_name;
		var sprite_angle = 0;

        Bullet.vector = null;
        Bullet.bonusType = -1;
        Bullet.isBodySensor = false;
        //console.log('Bullet.stackBonus = ', Bullet.stackBonus);

        if (Bullet.stackBonus.length)
        {
            Bullet.bonusType = Bullet.stackBonus.shift();
        }

        GameWorld.world.SetGravity(new b2Vec2(0, 10));

		switch (Bullet.bonusType)
		{
			case Bullet.BIMBA: {
                    sprite_name = 'bullet_4';
                    break;
                }
			case Bullet.ROKETA: {
                    sprite_name = 'bullet_3';
                    sprite_angle = Math.PI + Cannon.spriteAim.rotation;
                    GameWorld.world.SetGravity(new b2Vec2(0, 0));
                    Bullet.isBodySensor = true;
                    break;
                }
			default: {
                    sprite_name = 'bullet_1';
                    break;
                }
		}

        if (Bullet.index >= 1 && !Bullet.body[Bullet.index])
        {
            Bullet.index = Bullet.index - 1 < 0 ? 0 : Bullet.index - 1;
        }

        if (Bullet.index < 0)
        {
            Bullet.index = 0;
        }

		if (!Bullet.sprite[Bullet.index])
		{
			Bullet.sprite[Bullet.index] = GameBase.createSprite(
                    sprite_name,
					getStageWidthCenter() - Math.round(Math.sin(Cannon.spriteAim.rotation) * (Cannon.radius + Bullet.pearlShift)),
					Math.abs(Math.round(Math.cos(Cannon.spriteAim.rotation) * (Cannon.radius + Bullet.pearlShift))),
                    1);
			Bullet.sprite[Bullet.index].rotation = sprite_angle;
			Bullet.sprite[Bullet.index].BULLET = true;
            Bullet.sprite[Bullet.index].BULLET_ID = Bullet.index;
			Bullet.sprite[Bullet.index].bonusType = Bullet.bonusType;

			if (!Bullet.zIndex)
			{
				Bullet.zIndex = Bullet.sprite[0].zIndex;
			}
			else
			{
				Bullet.sprite[Bullet.index].setZIndex(Bullet.zIndex);
			}

            Cannon.spriteAim.bitmap = library.getBitmap('aim_' + sprite_name.substr(sprite_name.length - 1, 1));

			Bullet.index++;
            Bullet.bonusType = -1;
            Bullet.onFieldFlag = 0;
		}
	},

	reset: function(index)
	{
		//console.log('===================Bullet.reset()');
		Bullet.sprite[index].visible = false;
		Bullet.sprite[index].destroy = true;

		if (Bullet.body[index])
		{
			Bullet.body[index].NEED_DESTROY = true;
		}

		buildBackground();

		Bullet.sprite.splice(index, 1);
		Bullet.body.splice(index, 1);
		Bullet.index--;

        if (Bullet.index < 0)
        {
            Bullet.index = 0;
        }
	},

	takeAim: function()
	{
		//console.log('===================Bullet.takeAim()');
		Bullet.sprite[0].x = getStageWidthCenter() - Math.round(Math.sin(Cannon.spriteAim.rotation) * (Cannon.radius + Bullet.pearlShift));
		Bullet.sprite[0].y = Math.abs(Math.round(Math.cos(Cannon.spriteAim.rotation) * (Cannon.radius + Bullet.pearlShift)));

		if (Bullet.sprite[0].bonusType == 1 || Bullet.sprite[0].bonusType == 2)
		{
			Bullet.sprite[0].rotation = Math.PI + Cannon.spriteAim.rotation;
		}
	},

	createBody: function(index)
	{
        console.log('===================Bullet.createBody()');
		index = (typeof(index) !== 'undefined' ? index : Bullet.index - 1);

        //console.log('Bullet.index = ' + Bullet.index);
        //console.log('index = ' + index);

		Bullet.onFieldFlag++;
		Bullet.body[index] = box2d.createCircle(GameWorld.world, {
                    x: Bullet.sprite[index].x,
                    y: Bullet.sprite[index].y,
                    radius: Bullet.radius,
                    rotation: 0,
                    bodyType: box2d.bodyType.dynamic,
                    density: ball_density,
                    restitution: ball_restitution,
                    friction: ball_friction,
                    //isSensor: Bullet.isBodySensor
                    filter: {groupIndex: -1}
                });
        Bullet.body[index].BULLET = true;
        Bullet.body[index].BULLET_ID = index;
		Bullet.body[index].sprite = Bullet.sprite[index];
		Bullet.sprite[index].box2dBody = Bullet.body[index];
		Bullet.sprite[index].onbox2dsync = spritesSync;

        Bullet.body[index].SetBullet(true);

        //console.log('Bullet.onFieldFlag = ' + Bullet.onFieldFlag);
	},

	move: function(randomAngleFlag, index)
	{
		var angle = randomAngleFlag ? (Math.random() * Math.PI * 2) : (Math.PI/2 + Cannon.spriteAim.rotation + 0.001);

		index = (typeof(index) !== 'undefined' ? index : Bullet.index - 1);

		if (Bullet.sprite[index].bonusType == 1 || Bullet.sprite[index].bonusType == 2)
		{
			Bullet.body[index].SetAngle(Bullet.sprite[index].rotation);
		}

		Bullet.body[index].ApplyImpulse(new b2Vec2(Math.cos(angle) * Bullet.impulse,
                                                Math.sin(angle) * Bullet.impulse),
									    new b2Vec2(Bullet.body[index].GetPosition().x,
                                                Bullet.body[index].GetPosition().y));

        if (Bullet.bonusType != 1 && Bullet.bonusType != 2 && !randomAngleFlag)
        {
            Shots.removeShot();
        }

        Bullet.startTime = Bullet.startHlTime = new Date();

        playSound('shot');
	},

	checkCoor: function(index)
	{
		//console.log('===================Bullet.checkCoor()');
		if (!Bullet.body[index])
		{
			return;
		}

		// попали в краба
		if (Bullet.sprite[index].y >= (Crab.topSprite.y - Crab.topSprite.height / 4)
			&& ((Bullet.sprite[index].x >= Crab.sprite.x - 20) && (Bullet.sprite[index].x <= Crab.sprite.x + 20))
			&& !Crab.lightFlag)
		{
            console.log('Bullet.sprite[index].y = ' + Bullet.sprite[index].y);
            console.log('Crab.topSprite.y = ' + Crab.topSprite.y);

			Crab.showLight();
			Shots.addShot();
            GameWorld.world.SetGravity(new b2Vec2(0, 10));
		}

        // упали ниже экрана
		if (Bullet.sprite[index].y > getStageHeight()/* && Bullet.onFieldFlag*/)
		{
            //console.log('tut');
            GameWorld.world.SetGravity(new b2Vec2(0, 10));
            var bonus_type = Bullet.sprite[index].bonusType;

			Bullet.reset(index);
			Bullet.finishTime = new Date();

			if (!Crab.lightFlag
                && !Bullet.onTouchFlag
                && (Bullet.finishTime - Bullet.startTime < secondChanceTime)
				&& bonus_type != 0
                && bonus_type != 1
                && bonus_type != 2)
			{
				Shots.addShot();
				moveInfoText('megabonus', getStageWidthCenter(), getStageHeightCenter(), getStageHeightCenter() - 20);
			}

			var t = setInterval(function()
			{
				if (!Crab.lightFlag)
				{
					clearInterval(t);
					Bullet.flagAddShot = false;
					Bullet.onFieldFlag--;
					Bullet.onTouchFlag = false;
					Elements.explosionElements();

					if (!Bullet.index)
					{
						Bullet.init();
					}
				}
			}, 20);
		}
		else
		{
			var finish_time = new Date();

			if (finish_time - Bullet.startHlTime > explosionHLElementsTime)
			{
				Elements.explosionElements(true);
				Bullet.startHlTime = new Date();
			}
		}
	},

    setBonusElement: function(body)
    {
        console.log('==========Bullet.setBonusElement()');
        if (body.WAS_TOUCH)
        {
            return;
        }

        body.WAS_TOUCH = true;

        var bonus = -1;

        switch (body.color)
        {
            case RED: {
                    moveInfoText(
                            'fireball',
                            GameWorld.convertBox2dToMeters(body.GetPosition().x),
                            GameWorld.convertBox2dToMeters(body.GetPosition().y),
                            GameWorld.convertBox2dToMeters(body.GetPosition().y) - 20);
                    //Bullet.bonusType = Bullet.BIMBA; // бимба
                    Bullet.stackBonus.push(Bullet.BIMBA);
                    bonus = Bullet.BIMBA;
                    break;
            }
            case VIOLET: {
                    moveInfoText(
                            'rocketball',
                            GameWorld.convertBox2dToMeters(body.GetPosition().x),
                            GameWorld.convertBox2dToMeters(body.GetPosition().y),
                            GameWorld.convertBox2dToMeters(body.GetPosition().y) - 20);
                    //Bullet.bonusType = Bullet.ROKETA; // ракета
                    Bullet.stackBonus.push(Bullet.ROKETA);
                    bonus = Bullet.ROKETA;
                    break;
            }
            case BLUE: {
                    Bullet.launchMultibullet(body); // мультибол
                    bonus = Bullet.MULTIBULLET;
                    break;
            }
            case GREEN: {
                    Shots.addShot();
                    bonus = Bullet.ADDBULLET;
                    break;
            }
        }

        return bonus;
    },

    setBulletVectorForRocket: function()
    {
        if (!Bullet.body[0])
        {
            return;
        }

        for (var i = 0; i < Bullet.body.length; i++)
        {
            if (Bullet.body[i].sprite.bonusType == Bullet.ROKETA)
            {
                if (!Bullet.vector)
                {
                    Bullet.vector = Bullet.body[i].GetLinearVelocity();
                }

                Bullet.body[i].SetLinearVelocity(Bullet.vector);

                if (Bullet.body[i].sleep_body)
                {

                    Bullet.body[i].ApplyImpulse(new b2Vec2(Math.cos(Math.PI/2 + Cannon.spriteAim.rotation) * Bullet.impulse,
                                                                        Math.sin(Math.PI/2 + Cannon.spriteAim.rotation) * Bullet.impulse),
                                                            new b2Vec2(Bullet.body[i].GetPosition().x,
                                                                       Bullet.body[i].GetPosition().y));
                    Bullet.body[i].SetAwake(true);
                    Bullet.body[i].sleep_body = false;
                }

                break;
            }

        }
    },

	checkContactList: function(bodyA, bodyB)
	{
        //console.log('===================Bullet.checkContactList()');
		if (!bodyA || !bodyB)
		{
			return;
		}

        var bodyBullet = bodyA;
        var bodyContact = bodyB;

        if (!bodyA.BULLET)
        {
            bodyBullet = bodyB;
            bodyContact = bodyA;
        }

        var index = bodyBullet.BULLET_ID;

		//var b = Bullet.body[index].GetContactList();
        //var ios = (navigator.userAgent.toLowerCase().indexOf("mac") != -1);
        //var chrome_ios = (navigator.userAgent.toLowerCase().indexOf("crios") != -1)

//            if (!bodyContact.IsTouching()/* && bodyBullet.SENSOR/* && !(ios && chrome_ios)*/)
//            {
//                return;
//            }

        var angle = Math.atan2(bodyContact.GetPosition().y - bodyBullet.GetPosition().y, bodyContact.GetPosition().x - bodyBullet.GetPosition().x) - Math.PI;

        if (bodyContact.ELEMENT || bodyContact.PLATFORM)
        {
            switch (bodyBullet.sprite.bonusType)
            {
                case Bullet.BIMBA:
                    {
                        bodyBullet.SetAwake(false);
                        Bullet.onFieldFlag--;
                        showExplosion(
                                GameWorld.convertBox2dToMeters(bodyBullet.GetPosition().x),
                                GameWorld.convertBox2dToMeters(bodyBullet.GetPosition().y));

                        Bullet.reset(index);

                        var multi_flag = false;

                        for (var e = 0; e < Elements.body.length; e++)
                        {
                            if (Elements.body[e])
                            {
                                var s = Math.sqrt(Math.pow((Elements.body[e].GetPosition().x - bodyBullet.GetPosition().x), 2)
                                                  + Math.pow((Elements.body[e].GetPosition().y - bodyBullet.GetPosition().y), 2));

                                if (GameWorld.convertBox2dToMeters(s) <= Bullet.bimbaRadius)
                                {
                                    var pr = 0;

                                    for (var p = 0; p < prize[Elements.body[e].typeName].length; p++)
                                    {
                                        pr += prize[Elements.body[e].typeName][p];
                                    }

                                    GameBase.elementScore[Elements.body[e].typeName] += pr;
                                    curLevelScore += pr;

                                    moveTextHitScore(
                                            pr,
                                            GameWorld.convertBox2dToMeters(Elements.body[e].GetPosition().x),
                                            GameWorld.convertBox2dToMeters(Elements.body[e].GetPosition().y) - 10,
                                            GameWorld.convertBox2dToMeters(Elements.body[e].GetPosition().y) - 40,
                                            0.5);

                                    if (Elements.body[e].type && Elements.body[e].type == CRYSTAL)
                                    {
                                        var bonus = Bullet.setBonusElement(Elements.body[e]);

                                        if (bonus == Bullet.MULTIBULLET)
                                        {
                                            multi_flag = true;
                                        }
                                    }

                                    Elements.remove(e);
                                }
                            }
                        }

                        for (var e = 0; e < Platforms.body.length; e++)
                        {
                            if (Platforms.body[e])
                            {
                                var s = Math.sqrt(Math.pow((Platforms.body[e].GetPosition().x - bodyBullet.GetPosition().x), 2)
                                                  + Math.pow((Platforms.body[e].GetPosition().y - bodyBullet.GetPosition().y), 2));

                                if (GameWorld.convertBox2dToMeters(s) <= Bullet.bimbaRadius)
                                {
                                    Platforms.remove(e);
                                }
                            }
                        }

                        if (!multi_flag)
                        {
                            Bullet.init();
                        }

                        break;
                    }
                case Bullet.ROKETA:
                    {
                        var pr = 0;
                        var x = GameWorld.convertBox2dToMeters(bodyContact.GetPosition().x);
                        var y = GameWorld.convertBox2dToMeters(bodyContact.GetPosition().y);

                        if (bodyContact.PLATFORM)
                        {
                            Platforms.remove(bodyContact.PLATFORM_ID);
                        }
                        else
                        {
                            pr = 0;
                            x = GameWorld.convertBox2dToMeters(bodyContact.GetPosition().x);
                            y = GameWorld.convertBox2dToMeters(bodyContact.GetPosition().y);

                            for (var p = 0; p < prize[bodyContact.typeName].length; p++)
                            {
                                pr += prize[bodyContact.typeName][p];
                            }

                            if (bodyContact.typeName)
                            {
                                GameBase.elementScore[bodyContact.typeName] += pr;
                            }

                            curLevelScore += pr;

                            moveTextHitScore(
                                pr,
                                x,
                                y - 10,
                                y - 40,
                                0.5);

                            if (bodyContact.type && bodyContact.type == CRYSTAL)
                            {
                                Bullet.setBonusElement(bodyContact);
                            }

                            Elements.remove(bodyContact.ELEMENT_ID);
                        }

                        bodyBullet.SetAwake(false);
                        bodyBullet.sleep_body = true;

                        break;
                    }
                case -1:
                default:
                    {
                        if (bodyContact.PLATFORM)
                        {
                            Bullet.push(-angle, index);
                            return;
                        }

                        Bullet.onTouchFlag = true;
                        Bullet.contactFlag++;

                        Elements.countTouch(bodyContact.ELEMENT_ID);
                        Bullet.push(angle, index);

                        var tc = setTimeout(function()
                        {
                            clearTimeout(tc);
                            Bullet.contactFlag--;
                        }, 200);

                        break;
                    }
            }

            return;
        }
        else if ((bodyBullet.sprite.bonusType === Bullet.ROKETA) && (!bodyContact.CANNON))
        {
            console.log('BOOOOM!');

            GameWorld.world.SetGravity(new b2Vec2(0, 10));

            bodyBullet.NEED_DESTROY = true;
            Bullet.onFieldFlag--;
            showExplosion(Bullet.sprite[index].x, Bullet.sprite[index].y);
            Bullet.reset(index);
            Bullet.init();

            return;
        }

        Bullet.setBulletVectorForRocket();
	},

    launchMultibullet: function(body)
    {
        Elements.remove(body.ELEMENT_ID);

        //debugger;

        showExplosion(body.sprite.x, body.sprite.y, body.sprite.NAME);
        moveInfoText('multiball', body.sprite.x, body.sprite.y, body.sprite.y - 20);

        Bullet.sprite[Bullet.index] = GameBase.createSprite("bullet_2",
                                                            body.sprite.x,
                                                            body.sprite.y);
        Bullet.sprite[Bullet.index].BULLET = true;

        if (!Bullet.zIndex)
        {
            Bullet.zIndex = Bullet.sprite[0].zIndex;
        }
        else
        {
            Bullet.sprite[Bullet.index].setZIndex(Bullet.zIndex);
        }

        Bullet.index++;

        need_create_flag = true;
    },

	push: function(angle, index)
	{
        //console.log('push');
        if (!Bullet.body[index])
        {
            return false;
        }

		Bullet.body[index].ApplyImpulse(new b2Vec2(Math.cos(angle) * (Bullet.impulse / 6),
												  Math.sin(angle) * (Bullet.impulse / 6)),
									   new b2Vec2(Bullet.body[index].GetPosition().x,
												  Bullet.body[index].GetPosition().y));
	},

	clear: function()
	{
		Bullet.sprite = [];
		Bullet.body = [];
		Bullet.index = 0;
		Bullet.zIndex = 0;
		Bullet.onFieldFlag = 0;
		Bullet.startTime = 0;
		Bullet.startHlTime = 0;
		Bullet.finishTime = 0;
		Bullet.contactFlag = 0;
		Bullet.bonusType = -1;
        Bullet.vector = null;
        Bullet.stackBonus = [];
	}

};


var Crab =
{
	sprite:			null,
    topSprite:      null,
	body:			null,
	spriteLight:	null,
	lightFlag:		false,
	moveLimit:		0,
	leftLimit:		-200,
	rigthLimit:		200,
    crabStepWidth:  3,
    crabDirectLeft: false,
    animationFlag:  false,
    firstMove:      true,

	init: function()
	{
		console.log('===================Crab.init()');
		if (Crab.sprite) {
			return;
		}

		Crab.sprite = GameBase.createSprite("bottom", getStageWidthCenter(), getStageHeight() - 12, 0);
		Crab.sprite.CRAB = true;
        Crab.topSprite = GameBase.createSprite("bottom_top", Crab.sprite.x, Crab.sprite.y, 5);
		Crab.topSprite.CRAB = true;

		var points = [
            [[-17, -20], [-17, 25], [-52, 25], [-52, -7], [-48, -14], [-36, -18]],
            [[17, -20], [36, -18], [48, -14], [52, -7], [52, 25], [17, 25]]
        ];

		Crab.body = box2d.createPoly(GameWorld.world, {
                    x: getStageWidthCenter(),
                    y: getStageHeight() - Crab.sprite.height / 5,
                    points: points,
                    rotation: 0,
                    bodyType: box2d.bodyType.static,
                    density: GameWorld.wall_density,
                    restitution: GameWorld.wall_restitution,
                    friction: GameWorld.wall_friction
                });

		Crab.body.sprite = Crab.sprite;
		Crab.sprite.box2dBody = Crab.body;

		Crab.leftLimit = getStageWidthCenter() - GameWorld.sideShiftWall + Crab.sprite.width / 2;
		Crab.rightLimit = getStageWidthCenter() + GameWorld.sideShiftWall - Crab.sprite.width / 2;
	},

	reset: function()
	{
		Crab.sprite.visible = false;
		Crab.sprite.destroy = true;
		Crab.body.NEED_DESTROY;
	},

	move: function()
	{
        var pos = Crab.body.GetPosition();

        pos.x = Crab.crabDirectLeft
                        ? GameWorld.convertBox2dToMeters(pos.x) + Crab.crabStepWidth
                        : GameWorld.convertBox2dToMeters(pos.x) - Crab.crabStepWidth;

        if ((pos.x < Crab.leftLimit) || (pos.x > Crab.rightLimit))
        {
			Crab.crabDirectLeft = !Crab.crabDirectLeft;
		}

        Crab.body.SetPosition(new b2Vec2(GameWorld.convertMetersToBox2d(pos.x), pos.y));

        Crab.sprite.x = Crab.topSprite.x = GameWorld.convertBox2dToMeters(pos.x);
        Crab.sprite.y = Crab.topSprite.y = GameWorld.convertBox2dToMeters(pos.y);
	},

	showLight: function()
	{
		if (Crab.spriteLight)
		{
			return;
		}

		Crab.lightFlag = true;
		Crab.spriteLight = library.getSprite('light');
		Crab.spriteLight.x = Crab.sprite.x;
		Crab.spriteLight.y = getStageHeight() - (Crab.spriteLight.height / 2 + Crab.sprite.height / 2) + 10;
        Crab.spriteLight.animDelay = 2;
        Crab.spriteLight.onrender = function(e)
        {
            e.target.x = Crab.sprite.x;

            if ((e.target.currentFrame == e.target.totalFrames - 1) && (e.target.animStep == e.target.animDelay - 1))
            {
                if (e.target.currentLayer !== e.target.totalLayers - 1)
                {
                    e.target.currentLayer++;
                }
                else
                {
                    e.target.destroy = true;
                    e.target.stop();
                }
            }
        };
        stage.addChild(Crab.spriteLight);

		moveInfoText('plusball', Crab.sprite.x, Crab.spriteLight.y, Crab.spriteLight.y - 40);
        playSound('plus1');

		var t = setTimeout(function()
		{
			clearTimeout(t);
			Crab.spriteLight.visible = false;
			Crab.spriteLight.destroy = true;
			buildBackground();
			Crab.spriteLight = null;
			Crab.lightFlag = false;
		}, 300);
	},

	clear: function()
	{
		Crab.sprite = null;
		Crab.body = null;
	}
};


var Elements =
{
	sprite:			[],
	body:			[],
	counterTouch:	[],
	count:			0,
    allCount:       0,
    allTouches:     0,
    elementTouches: 0,

	init: function()
	{
		Elements.sprite = [];
		Elements.body = [];
		Elements.countTouch = [];
	},

	addBody: function(body, i)
	{
		if (typeof(i) !== 'undefined')
		{
			body.ELEMENT_ID = i;
			Elements.body[i] = body;
            Elements.sprite[i] = body.sprite;
		}
		else
		{
			body.ELEMENT_ID = Elements.body.length;
			Elements.body.push(body);
			Elements.sprite[Elements.body.length - 1] = body.sprite;
		}

        body.sprite.touchesInOneShot = 0;
        body.ELEMENT = true;
        body.START_POINT = {
            x: body.sprite.x,
            y: body.sprite.y
        };

        if (body.type !== STONE)
        {
            Elements.count++;
        }

        if (body.type == ASTEROID)
        {
            Elements.elementTouches++;
        }

        Elements.allCount++;

		return Elements.body.length - 1;
	},

	countTouch: function(id)
	{
		//console.log('===================Elements.countTouch()');
        if (!Elements.body[id])
        {
            return;
        }

        if (Elements.body[id].type == ASTEROID)
        {
            Elements.allTouches++;

            GameBase.calculateMultiplierScore();
            GameWorld.showScaleScore(id);
        }

		if (!Elements.counterTouch[id])
		{
			Elements.counterTouch[id] = 1;
		}
		else
		{
			Elements.counterTouch[id]++;
		}

        Elements.sprite[id].touchesInOneShot++;

		if (Elements.counterTouch[id] > 2)
		{
			Elements.counterTouch[id] = 3;
		}

        if (Elements.sprite[id].touchesInOneShot > 2)
		{
			Elements.sprite[id].touchesInOneShot = 3;
		}

        //playSound('asteroid_ball');

		if (Elements.sprite[id])
		{
			if (Elements.counterTouch[id] > 0)
			{
                Elements.sprite[id].gotoAndStop(1);
			}

			if (Elements.counterTouch[id] < 3)
			{
                if (prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1])
                {
                    curLevelScore += prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1] * scoreMultiplier;
                }

                if (!GameBase.elementScore[Elements.sprite[id].box2dBody.typeName])
                {
                    GameBase.elementScore[Elements.sprite[id].box2dBody.typeName] = 0;
                }

//                console.log('Elements.sprite[id].box2dBody.typeName = ', Elements.sprite[id].box2dBody.typeName);
//                console.log('Elements.counterTouch[' + id + '] = ', Elements.counterTouch[id]);
//                console.log('prize[' + Elements.sprite[id].box2dBody.typeName + '][' + (Elements.counterTouch[id] - 1) + '] = ', prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1]);
//                console.log('scoreMultiplier = ', scoreMultiplier);
//                console.log('prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1] * scoreMultiplier = ', (prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1] * scoreMultiplier));

                if (prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1])
                {
                    GameBase.elementScore[Elements.sprite[id].box2dBody.typeName] += prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1] * scoreMultiplier;
                }

				moveTextHitScore(
                        prize[Elements.sprite[id].box2dBody.typeName][Elements.counterTouch[id] - 1] * scoreMultiplier,
                        Elements.sprite[id].x,
                        Elements.sprite[id].y - 10,
                        Elements.sprite[id].y - 40,
                        0.5);
			}

            if (Elements.sprite[id].touchesInOneShot >= 1 && Elements.sprite[id].box2dBody.type == CRYSTAL)
            {
                Bullet.setBonusElement(Elements.sprite[id].box2dBody);
            }
		}

        buildBackground();
	},

	remove: function(id)
	{
        console.log('===================Elements.remove()');
        //debugger;

        if (!Elements.body[id] || Elements.body[id].NEED_DESTROY)
        {
            return;
        }

		Elements.sprite[id].visible = false;
		Elements.sprite[id].destroy = true;
		Elements.counterTouch[Elements.body[id].ELEMENT_ID] = null;

        //console.log('Elements.body[id] = ', Elements.body[id]);

		if (Elements.body[id])
		{
            Elements.body[id].NEED_DESTROY = true;
		}

		showExplosion(Elements.sprite[id].x, Elements.sprite[id].y, Elements.sprite[id].NAME);
		buildBackground();

        if (Elements.body[id].type !== STONE)
        {
            Elements.count--;
        }

		delete Elements.sprite[id];
		delete Elements.body[id];
	},

	explosionElements: function(inGameFlag)
	{
		//console.log('===================Elements.explosionElements()');
		var count_touches = (typeof(inGameFlag) !== 'undefined' ? 2: 1);

		for (var i = 0; i < Elements.body.length; i++)
		{
			if (Elements.body[i] && (Elements.counterTouch[Elements.body[i].ELEMENT_ID] >= count_touches))
			{
				Elements.remove(i);
			}
		}
	},

	clear: function()
	{
		Elements.sprite = [];
		Elements.body = [];
		Elements.counterTouch = [];
		Elements.count = 0;
        Elements.allCount = 0;
        Elements.allTouches = 0;
	}
};


var Platforms =
{
    sprite:			[],
	body:			[],
	count:			0,

	init: function()
	{
		Platforms.sprite = [];
		Platforms.body = [];
	},

	addBody: function(body, i)
	{
		if (typeof(i) !== 'undefined')
		{
			body.PLATFORM_ID = i;
			Platforms.body[i] = body;
            Platforms.sprite[i] = body.sprite;

		}
		else
		{
			body.PLATFORM_ID = Platforms.body.length;
			Platforms.body.push(body);
			Platforms.sprite[Platforms.body.length - 1] = body.sprite;
		}

        body.PLATFORM = true;
        body.sprite.touchesInOneShot = 0;

        if (body.type !== STONE)
        {
            Platforms.count++;
        }

		return Platforms.body.length - 1;
	},

    remove: function(id)
	{
        if (Platforms.sprite[id].NEED_DESTROY)
        {
            return;
        }

		Platforms.sprite[id].visible = false;
		Platforms.sprite[id].destroy = true;

		if (Platforms.body[id])
		{
			Platforms.body[id].NEED_DESTROY = true;
		}

		showExplosion(Platforms.sprite[id].x, Platforms.sprite[id].y);
		buildBackground();

        if (Platforms.body[id].type !== STONE)
        {
            Platforms.count--;
        }

		delete Platforms.sprite[id];
		delete Platforms.body[id];
	},

	clear: function()
	{
		Platforms.sprite = [];
		Platforms.body = [];
		Platforms.count = 0;
	}
};


var Shots =
{
	sprite:				[],
	spriteGlass:		null,
	count:				0,
	visibleShotsLimit:	10,
    maxCount:           0,

	init: function()
	{
        //console.log('===================Shots.init()');
		Shots.count = startCountShots[curLevel];

		for (var i = 0; i < (Shots.count > Shots.visibleShotsLimit ? Shots.visibleShotsLimit : Shots.count); i++)
		{
			var spr = library.getSprite('bullet_1');
			spr.x = getStageWidthCenter() + startBulletsListCoor.x;
			spr.y = getStageHeightCenter() + startBulletsListCoor.y - startBulletsListCoor.step[i];
			spr.scaleX = 0;
			spr.scaleY = 0;
			spr.SHOT = true;
			stage.addChild(spr);

			Shots.sprite.push(spr);
		}

        Shots.maxCount = Shots.sprite.length;
	},

	show: function()
	{
		for (var i = 0; i < Shots.sprite.length; i++)
		{
			Shots.sprite[i].scaleTo(1, fps / 4);
		}
	},

	addShot: function()
	{
		//console.log('===================Shots.addShot()');
		Shots.count++;

        if (Shots.count > Shots.maxCount)
        {
            Shots.maxCount = Shots.count;
        }

		if (Shots.count > Shots.visibleShotsLimit)
		{
			return;
		}

		var spr = library.getSprite('bullet_1');
		spr.x = getStageWidthCenter() + startBulletsListCoor.x;
		spr.y = getStageHeightCenter() + startBulletsListCoor.y - startBulletsListCoor.step[Shots.count - 1];
		spr.scaleX = 0;
		spr.scaleY = 0;
		spr.SHOT = true;
		stage.addChild(spr);

		Shots.sprite.push(spr);

		spr.scaleTo(1, fps / 4);
	},

	removeShot: function()
	{
		//console.log('===================Shots.removeShot()');
		if (Shots.count - 1 < 0)
		{
			return;
		}

		if (Shots.count > 10)
		{
			Shots.count--;
			return;
		}

		buildBackground();

		Shots.sprite[Shots.count - 1].scaleTo(0,
											  fps / 4,
											  null,
											  function(e)
											  {
												  e.target.obj.destroy = true;
											  });

        Shots.sprite.pop();
        Shots.count--;
	},

	clear: function()
	{
		Shots.sprite = [];
		Shots.spriteGlass = null;
		Shots.count = 0;
	}
};


var GameBase =
{
    elementScore: {},

	createSprite: function(spriteName, x, y, zIndex, staticFlag, scaleX, scaleY)
	{
		//console.log('===================GameBase.createSprite(' + spriteName + ',' + x + ',' + y + ',' + zIndex + ',' + staticFlag + ')');
		staticFlag = (typeof(staticFlag) == 'undefined' || staticFlag == null) ? false : staticFlag;
        var scale_x = (typeof(scaleX) == 'undefined' || scaleX == null) ? 1 : scaleX;
        var scale_y = (typeof(scaleY) == 'undefined' || scaleY == null) ? scale_x : scaleY;

		var sprite = library.getSprite(spriteName);
        sprite.x = x;
        sprite.y = y;
		sprite.onbox2dsync = spritesSync;
        sprite.syncX = 0;
        sprite.syncY = 0;
		sprite.static = staticFlag;
        sprite.scaleX = scale_x;
        sprite.scaleY = scale_y;
        stage.addChild(sprite);

		if (typeof(zIndex) !== 'undefined' || zIndex !== null)
		{
			sprite.setZIndex(zIndex);
		}

		return sprite;
	},

    calculateMultiplierScore: function()
    {
        var count_points = 0;
        var tmp_multiplier = scoreMultiplier;

        for (var i = 0; i <= scaleScoreMultiplier.length; i++)
        {
            if (scaleScoreMultiplier[i])
            {
                //console.log('(count_points + scaleScoreMultiplier[i] >= Elements.allTouches)  || ' + (count_points + scaleScoreMultiplier[i] >= Elements.allTouches));
                if (count_points + scaleScoreMultiplier[i] > Elements.allTouches)
                {
                    scoreMultiplier = multiplierValue[i];
                    break;
                }

                count_points += scaleScoreMultiplier[i];
            }
            else
            {
                scoreMultiplier = multiplierValue[i];
                //moveInfoText('x2points', getStageWidthCenter(), getStageHeightCenter(), getStageHeightCenter() - 20);
            }
        }

        if (tmp_multiplier != scoreMultiplier)
        {
            moveInfoText('x' + scoreMultiplier, getStageWidthCenter(), getStageHeightCenter(), getStageHeightCenter() - 20);
            playSound('scale');
        }

        //console.log('scoreMultiplier = ' + scoreMultiplier);
    },

    getPlayerScore: function()
    {
		//console.log('===================GameBase.getPlayerScore()');
		maxScore = parseInt(Utils.getCookie(GAME_ID + "maxScore") == null ? 0 : Utils.getCookie(GAME_ID + "maxScore"));
		gameScore = parseInt(Utils.getCookie(GAME_ID + "gameScore") == null ? 0 : Utils.getCookie(GAME_ID + "gameScore"));
        bestLevelStars = (Utils.getCookie(GAME_ID + "bestLevelStars") == null ? [] : Utils.getCookie(GAME_ID + "bestLevelStars").split(','));
        openLevel = parseInt(Utils.getCookie(GAME_ID + "openLevel") == null ? 0 : Utils.getCookie(GAME_ID + "openLevel"));
		maxLevel = parseInt(Utils.getCookie(GAME_ID + "maxLevel") == null ? 0 : Utils.getCookie(GAME_ID + "maxLevel"));

        if (isNaN(gameScore))
        {
            gameScore = 0;
        }

        if (isNaN(maxScore))
        {
            maxScore = 0;
        }

        for (var i = 0; i <= countLevels; i++)
        {
            if (typeof(bestLevelStars[i]) === 'undefined')
            {
                bestLevelStars[i] = 0;
            }

			levelStars[i] = bestLevelStars[i] * 1;
            levelScore[i] = 0;
        }
    },

    setPlayerScore: function()
    {
		//console.log('===================GameBase.setPlayerScore()');
        for (var i = 0; i < levelStars.length; i++) {
            if (!bestLevelStars[i] || levelStars[i] > bestLevelStars[i]) {
                bestLevelStars[i] = levelStars[i];
            }
        }

        console.log('levelStars = ', levelStars);

        maxScore = (maxScore >= gameScore ? maxScore : gameScore);

		Utils.setCookie(GAME_ID + "maxScore", (maxScore >= gameScore ? maxScore : gameScore));
		Utils.setCookie(GAME_ID + "gameScore", gameScore);
        Utils.setCookie(GAME_ID + "bestLevelStars", bestLevelStars.join(','));

		openLevel = (openLevel >= countLevels ? countLevels : openLevel);
		openLevel = (openLevel > curLevel ? openLevel : (levelStars[curLevel] > 1 ? curLevel + 1 : openLevel));
		maxLevel = (maxLevel > curLevel ? maxLevel : curLevel + 1);

		Utils.setCookie(GAME_ID + "maxLevel", maxLevel);
        Utils.setCookie(GAME_ID + "openLevel", openLevel);
    },

    resetGameParameters: function()
    {
		Bullet.clear();
		Cannon.clear();
		Elements.clear();
		Crab.clear();
		Shots.clear();
        //Warp.clear();

        GameWorld.world = null;

        scoreMultiplier = 1;

		starCouter = -1;
		starSprites = [];
		curLevelScore = 0;
		timeInterval = null;

		shop_flag = false;
        pause_flag = false;
        hint_flag = false;
    }

};

