/**
 * @class
 * @deprecated из-за старого бага с позиционированием, использование нежелательно. Используйте sprites_group.js
 * @description Группа спрайтов.
 * @param {Stage} stage
 */
function SpritesGroup(stage)
{
	this.stage = stage;
	
	/** x координата группы */
	this.x = 0;
	/** y координата группы */
	this.y = 0;
	/** угол поворота */
	this.rotation = 0;
	/** масштаб по x */
	this.scaleX = 1;
	/** масштаб по y */
	this.scaleY = 1;
	/** полупрозрачность */
	this.opacity = 1;
	
	/** @ignore */
	this.sprites = [];
	
	stage.addEventListener("pretick", Utils.proxy(this.update, this));
};

/**
 * Добавление спрайта в группу
 * @param {Sprite} obj спрайт
 * @param {Boolean} [addToStage] нужно ли добавлять спрайт также на сцену
 * @example
 * Для корректной работы у спрайта обязаны быть выставлены свойства, относительные группе:
 * gx - x координата
 * gy - y координата
 * gscaleX - масштаб по x
 * gscaleY - масштаб по y
 * grotation - угол поворота
 * gopacity - полупрозрачность
 */
SpritesGroup.prototype.addChild = function(obj, addToStage)
{
	if(typeof obj.gscaleX == "undefined") obj.gscaleX = 1;
	if(typeof obj.gscaleY == "undefined") obj.gscaleY = 1;
	if(typeof obj.grotation == "undefined") obj.grotation = 0;
	if(typeof obj.gopacity == "undefined") obj.gopacity = 1;
	
	this.sprites.push(obj);
	if(addToStage) this.stage.addChild(obj);
	this.update();
};

/**
 * Удаление спрайта из группы
 * @param {Sprite} obj спрайт
 * @param {Boolean} [destroy] нужно ли также уничтожить спрайт

 */
SpritesGroup.prototype.removeChild = function(obj, destroy)
{
	this.sprites = Utils.removeFromArray(this.sprites, obj);
	if(destroy) obj.destroy = true;
};

/**
 * Уничтожение всех спрайтов, принадлежащих группе
 */
SpritesGroup.prototype.remove = function()
{
	for(var i=0; i<this.sprites.length; i++)
	{
		this.sprites[i].destroy = true;
	}
	this.sprites = [];
};

/** @ignore */
SpritesGroup.prototype.update = function()
{
	var obj;
	for(var i=0; i<this.sprites.length; i++)
	{
		obj = this.sprites[i];
		
		var x = obj.gx;
		var y = obj.gy;
		
		var p = new Vector(x, y);
		p.rotate(-this.rotation);
		x += p.x;
		y += p.y;
		
		x *= this.scaleX;
		y *= this.scaleY;
		
		x += this.x;
		y += this.y;
		
		obj.x = x;
		obj.y = y;
		obj.scaleX = obj.gscaleX * this.scaleX;
		obj.scaleY = obj.gscaleY * this.scaleY;
		obj.rotation = obj.grotation + this.rotation;
		obj.opacity = obj.gopacity * this.opacity;
	}
};