// Play sound
$(document).ready(function() {

    var curPlaying;
    var audioElement = document.createElement('audio');

    $('.play').click(function() {

        // Reset all play buttons
        $('.play').css('background-image','url(img/play_snd.png)');

        if ( !audioElement.paused && curPlaying == $(this).attr("rel")) {

            // Change stop button to play button for current sound
            $(this).css('background-image','url(img/play_snd.png)');

            // Pause sound
            audioElement.pause();

        } else {

            // Change play button to stop button for current sound
            $(this).css('background-image','url(img/stop_snd.png)');

            // Set and play sound
            audioElement.setAttribute('src', 'mp3/' + $(this).attr("rel"));
            audioElement.play();

            // End event
            audioElement.addEventListener('ended', function(){
                $('.play').css('background-image','url(img/play_snd.png)');
            }, false);
        }

        // Current playing sound
        curPlaying = $(this).attr("rel");

    });
});

// Install button
(function(){
    function install(ev) {
        ev.preventDefault();
        // define the manifest URL
        var manifest_url = "/manifest.webapp";
        // install the app
        var myapp = navigator.mozApps.install(manifest_url);
        myapp.onsuccess = function(data) {
            // App is installed, remove button
            this.parentNode.removeChild(this);
        };
        myapp.onerror = function() {
            // App wasn't installed, info is in this.error.name
            console.log('Install failed, error: ' + this.error.name);
            alert('Install failed, error: ' + this.error.name);
        };
    };
    // get a reference to the button and call install() on click
    var button = document.getElementById('install-btn');
    button.addEventListener('click', install, false);
})();