
var ctx;

//0: Chrome extension
//1: Android
//2: iOS
//3: Firefox OS

var myPlatform = 3;
var isFullMode = false;
var needAd = !isFullMode;
var storagePrefix = isFullMode?"full_":"free_";

//Android
var webSiteLink = "http://www.omega.url.tw";
var moreAppsLink = "market://search?q=pub:Omega+Studio";
var fullVerLink = "market://details?id=tw.url.omega.screensizefull";
var freeVerLink = "market://details?id=tw.url.omega.screensize";
var adLink = "http://www.omega.url.tw/_adhtml/screen_size_android.html";
var rateThisAppLink;

if(myPlatform == 2){
	//iOS
	moreAppsLink = "http://appstore.com/yumaofeng";
	fullVerLink = "http://appstore.com/screensizefull";
	freeVerLink = "http://appstore.com/screensize";
	adLink = "http://www.omega.url.tw/_adhtml/screen_size_ios.html";
	
}else if(myPlatform == 3){
	//Firefox OS
	moreAppsLink = "http://www.omega.url.tw/apps/index.html";
	fullVerLink = "https://marketplace.firefox.com/app/screen-size";
	freeVerLink = "https://marketplace.firefox.com/app/screen-size";
	adLink = "http://www.omega.url.tw/_adhtml/screen_size_fxos.html";
	needAd = false;

}else if(myPlatform == 0){
	//Chrome
	needAd = false;
	moreAppsLink = "https://chrome.google.com/webstore/search/www.omega.url.tw";
	fullVerLink = "https://chrome.google.com/webstore/detail/screen-size/dibjkbohhllnokliflkbicfdeommfgpg";
	freeVerLink = "https://chrome.google.com/webstore/detail/screen-size/dibjkbohhllnokliflkbicfdeommfgpg";
	//adLink = "";
}

rateThisAppLink = freeVerLink;
if(isFullMode){
	rateThisAppLink = fullVerLink;
}

var common_size_list = [ ['CGA',320,200],
						 ['QVGA',320,240],
						 ['HVGA',480,320],
						 ['VGA',640,480],
						 ['WVGA',800,480],
						 ['SVGA',800,600],
						 ['WSVGA',1024,600],
						 ['XGA',1024,768],
						 ['XGA+',1152,864],
						 ['SXGA',1280,1024],
						 ['SXGA+',1400,1050],
						 ['WXGA',1280,800],
						 ['UXGA',1600,1200],
						 ['WUXGA',1920,1200],
						 ['QWXGA',2048,1152],
						 ['QXGA',2048,1536],
						 ['WQXGA',2560,1600],
						 ['QSXGA',2560,2048],
						 ['HD',1280,720],
						 ['FullHD',1920,1080],
						 ['WQHD',2560,1440],
						 ['PAL',768,576]
						];

var common_ratio_list = [
						["17:9", 17.0/9],
						["16:9", 16.0/9],
						["5:3", 5.0/3],
						["16:10", 16.0/10],
						["3:2", 3.0/2],
						["4:3", 4.0/3],
						["5:4", 5.0/4],
						["4:5", 4.0/5],
						["3:4", 3.0/4],
						["2:3", 2.0/3],
						["10:16", 10.0/16],
						["3:5", 3.0/5],
						["9:16", 9.0/16],
						["9:17", 9.0/17]
						];

var canvasRectRatio = 1.0;
var canvasRectRatioMax = 5.0;
var canvasRectRatioMin = 0.2;
var canvasRectRatioTarget = 1.0;
var canvasRectW = 170;
var canvasRectH = 170;
var canvasRectTargetW = 170;
var canvasRectTargetH = 170;
var needRedraw = true;

var oldWidthPx = 480;
var oldHeightPx = 320;
var oldDiagnalIn = 3.5;

var toastFrameCnt = -1;

function my_init() {
	var tCommonSize = document.getElementById('my_common_size');
	for(var i=0;i<common_size_list.length;i++){
		tCommonSize.options[i] = new Option(common_size_list[i][0],i);
	}
	tCommonSize.options[tCommonSize.length] = new Option('Custom',tCommonSize.length);
	//localStorage.clear();
	getLocalStorage();
	
	my_calc();
  //alert('hi');
  	//alert((new Date()).getDate());
  //tCommonSize.add("abc");
  //alert(tCommonSize.options[1].text);
  //alert(tCommonSize.options);
  //tCommonSize.options[2] = new Option("xxyyzz", 2);
}
function check_common_list(){
	var tWidthPx = document.getElementById('my_width_px').value;
	var tHeightPx = document.getElementById('my_height_px').value;
	var tIdx = -1;
	for(var i=0;i<common_size_list.length;i++){
		if((tWidthPx==common_size_list[i][1] && tHeightPx==common_size_list[i][2]) || (tWidthPx==common_size_list[i][2] && tHeightPx==common_size_list[i][1])){
			tIdx=i;
			break;
		}
	}
	if(tIdx>-1){
		document.getElementById('my_common_size').selectedIndex = tIdx;
	}else{
		document.getElementById('my_common_size').selectedIndex = common_size_list.length;
	}
}

function correctInputs(){
	var tWidthPx = parseInt(document.getElementById('my_width_px').value);
	if(isNaN(tWidthPx)){
		tWidthPx = oldWidthPx;
	}
	document.getElementById('my_width_px').value = Math.min(99999, Math.max(1, tWidthPx));

	var tHeightPx = parseInt(document.getElementById('my_height_px').value);
	if(isNaN(tHeightPx)){
		tHeightPx = oldHeightPx;
	}
	document.getElementById('my_height_px').value = Math.min(99999, Math.max(1, tHeightPx));

	var tDiagnalIn = parseFloat(document.getElementById('my_diagonal_in').value);
	if(isNaN(tDiagnalIn)){
		tDiagnalIn = oldDiagnalIn;
	}
	document.getElementById('my_diagonal_in').value = Math.min(99999, Math.max(0.01, tDiagnalIn));

	//alert(isNaN(parseFloat(tWidthPx)));
}

function my_calc() {

	correctInputs();

	//oldWidthPx = document.getElementById('my_width_px').value;
	//oldHeightPx = document.getElementById('my_height_px').value;
	//oldDiagnalIn = document.getElementById('my_diagonal_in').value;

	check_common_list();

	var tWidthPx = document.getElementById('my_width_px').value;
	var tHeightPx = document.getElementById('my_height_px').value;
	var tDiagnalIn = document.getElementById('my_diagonal_in').value;
	var tRatio = tWidthPx/tHeightPx;
	var tHeightIn = tDiagnalIn*Math.sqrt(1/(tRatio*tRatio+1));
	var tWidthIn = tHeightIn*tRatio;
	var tWidthCm = tWidthIn*2.54;
	var tHeightCm = tHeightIn*2.54;
	var tResolution = tWidthPx/tWidthIn;
	
	var tResult = document.getElementById('my_result');
	
	var size_name = '';
	var tIdx = document.getElementById('my_common_size').selectedIndex;
	if(tIdx<common_size_list.length){
		size_name = common_size_list[tIdx][0]+' ';
	}

	var tRatioStr = "";
	if(isFullMode){
		//tRatioStr = " " + my_round_2(tRatio);
		//var tIdx = -1;
		for(var i=0;i<common_ratio_list.length;i++){
			if(Math.abs(common_ratio_list[i][1] - tRatio) < 0.01){
				//tIdx=i;
				tRatioStr = common_ratio_list[i][0] + " ";
				break;
			}
		}
	}

	tResult.innerHTML = my_round_2(tDiagnalIn) + '\" ' + size_name + tRatioStr + '(' + my_round_2(tWidthPx) + ' x ' + my_round_2(tHeightPx) + ')' + '<br />' +
						my_round_2(tWidthIn) + ' x ' + my_round_2(tHeightIn) + ' inch<br />' +
						my_round_2(tWidthCm) + ' x ' + my_round_2(tHeightCm) + ' cm<br />' +
						my_round_2(tResolution) + ' ppi';
	
	/*
	document.getElementById('div01').innerHTML = my_round_2(tWidthPx) + ' px';
	document.getElementById('div02').innerHTML = my_round_2(tHeightPx) + ' px';
	document.getElementById('div03').innerHTML = my_round_2(tDiagnalIn) + '\"';
	
	if(parseFloat(tWidthPx)>parseFloat(tHeightPx)){
		document.getElementById('my_img').src = 'rect_l.gif';
	}else{
		document.getElementById('my_img').src = 'rect_p.gif';
	}
	*/
	//redrawCanvas(parseFloat(tWidthPx), parseFloat(tHeightPx));
	if(parseFloat(tWidthPx)>0 && parseFloat(tHeightPx)>0){
		var tRatio = parseFloat(tHeightPx)/parseFloat(tWidthPx);
		tRatio = Math.min( Math.max(tRatio, canvasRectRatioMin), canvasRectRatioMax);
		if(tRatio<1){
			canvasRectTargetW = 170;
			canvasRectTargetH = canvasRectTargetW * tRatio;
		}else{
			canvasRectTargetH = 170;
			canvasRectTargetW = canvasRectTargetH / tRatio;
		}

		needRedraw = true;
	}

	setLocalStorage();
}
function my_round_2(num){
	return Math.round(num*100)/100;
}
function my_select_common_size(idx){
	//alert('hi' + document.getElementById('my_common_size').selectedIndex);
	if(idx<common_size_list.length){
		document.getElementById('my_width_px').value = common_size_list[idx][1];
		document.getElementById('my_height_px').value = common_size_list[idx][2];
	}
	my_calc();
}

//--localStorage--//

function getLocalStorage(){
	
	var tIdx = localStorage.getItem(storagePrefix+'idx');
	var tWidthPx = localStorage.getItem(storagePrefix+'w');
	var tHeightPx = localStorage.getItem(storagePrefix+'h');
	var tDiagnalIn = localStorage.getItem(storagePrefix+'d');
	
	if(tIdx!=null){
		document.getElementById('my_common_size').value = unescape(tIdx);
	}
	if(tWidthPx!=null){
		document.getElementById('my_width_px').value = unescape(tWidthPx);
	}
	if(tHeightPx!=null){
		document.getElementById('my_height_px').value = unescape(tHeightPx);
	}
	if(tDiagnalIn!=null){
		document.getElementById('my_diagonal_in').value = unescape(tDiagnalIn);
	}
}
function setLocalStorage(){
	var tIdx = document.getElementById('my_common_size').selectedIndex;
	var tWidthPx = document.getElementById('my_width_px').value;
	var tHeightPx = document.getElementById('my_height_px').value;
	var tDiagnalIn = document.getElementById('my_diagonal_in').value;
	
	localStorage.setItem(storagePrefix+'idx', escape(tIdx));
	localStorage.setItem(storagePrefix+'w', escape(tWidthPx));
	localStorage.setItem(storagePrefix+'h', escape(tHeightPx));
	localStorage.setItem(storagePrefix+'d', escape(tDiagnalIn));
}

function copyToClipboard( text ){
                var copyDiv = document.createElement('div');
                copyDiv.contentEditable = true;
                document.body.appendChild(copyDiv);
                copyDiv.innerHTML = text;
                copyDiv.unselectable = "off";
                copyDiv.focus();
                document.execCommand('SelectAll');
                document.execCommand("Copy", false, null);
                document.body.removeChild(copyDiv);
}

function showHideToast(aFlag){
	if(aFlag){
		document.getElementById('divToast').style.display = "block";
		document.getElementById('divToast').style.opacity = 1.0;
		toastFrameCnt=30;
	}else{
		document.getElementById('divToast').style.display = "none";
		//document.getElementById('divToast').style.opacity = 0.5;
	}
	
}

//0: Chrome extension
//1: Android
//2: iOS
function onClickCopy(){
	//alert("copy");
	if(myPlatform!=3){
		showHideToast(true);
	}

	if(myPlatform ==0){
		copyToClipboard(document.getElementById('my_result').innerHTML) ;
	}else if(myPlatform==1){
		window.myJSinterface.mydata(document.getElementById('my_result').innerHTML);
	}else if(myPlatform==3){
	    var newMail = new MozActivity({
			name: "view",
			data: {
				type: "url", 
				url: "mailto:%20?subject=Screen%20Size%20results&body=" + document.getElementById('my_result').innerHTML.replace(/<br>/g,"%0D")
			}
		});
	}else{
		window.location = "omega://func=mycopy&str="+escape(document.getElementById('my_result').innerHTML);
		//YOUR_SCHEMA://a=11111&b=22222&c=33333
	}
}

function onClickAbout(){
	//if(myPlatform ==0){
		document.getElementById('divAbout').style.display='block';
		document.getElementById('divMain').style.display='none';
	//}else if(myPlatform==1){
		//window.myJSinterface.myabout();
	//}else{
		//window.location = "omega://func=myabout";
	//}
}

function onClickClose(){
	document.getElementById('divAbout').style.display='none';
	document.getElementById('divMain').style.display='block';
}

function onChangeCommonSize(){
	my_select_common_size(document.getElementById('my_common_size').selectedIndex);
}

function onClickWebSiteLink () {
    var openURL = new MozActivity({
		name: "view",
		data: {
			type: "url", 
			url: webSiteLink
		}
	});
	//if(myPlatform == 0){
	//chrome.tabs.create({url:webSiteLink});
	//}else{
	//	window.location.href = webSiteLink;
	//}
}

function onClickMoreAppsLink () {
    var openURL = new MozActivity({
		name: "view",
		data: {
			type: "url", 
			url: moreAppsLink
		}
	});
	//if(myPlatform == 0){
	//chrome.tabs.create({url:moreAppsLink});
	//}else{
	//	window.location.href = moreAppsLink;
	//}
}

function onClickRateThisAppLink () {
    var openURL = new MozActivity({
		name: "view",
		data: {
			type: "url", 
			url: rateThisAppLink
		}
	});
	//if(myPlatform == 0){
	//chrome.tabs.create({url:rateThisAppLink});
	//}else{
	//	window.location.href = rateThisAppLink;
	//}
}

function onClickFullVerLink () {
    var openURL = new MozActivity({
		name: "view",
		data: {
			type: "url", 
			url: fullVerLink
		}
	});
	//window.location.href = fullVerLink;
}

function androidClickBack(){
	if(document.getElementById('divAbout').style.display=='block'){
		onClickClose();
	}else{
		window.myJSinterface.webviewWantToQuit();
	}
}

function onFocusInput(){
	//this.blur();
	//alert(this.value);
	/*
	if(this.value!=""){
		this.value = parseFloat(this.value);//this.value.replace(/,/gi,"");
	}
	*/
	//my_calc();
	oldWidthPx = document.getElementById('my_width_px').value;
	oldHeightPx = document.getElementById('my_height_px').value;
	oldDiagnalIn = document.getElementById('my_diagonal_in').value;

}

function redrawCanvas(){
	/*
	var tW = 200;
	var tH = 200;
	if(canvasRectRatio<1){
		tH = tW * canvasRectRatio;
	}else{
		tW = tH / canvasRectRatio;
	}
	*/
	ctx.clearRect(0,0,200,200);


	ctx.strokeStyle= "rgba(255, 255, 255, 1)";
	ctx.lineWidth = 2;
	ctx.strokeRect(5, 200-5-canvasRectH, canvasRectW,canvasRectH);
	///
	ctx.strokeStyle= "rgba(255, 255, 255, 0.5)";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(5,5);
	ctx.lineTo(5, 200-5-canvasRectH-5);
	ctx.stroke();
	ctx.beginPath();
	ctx.moveTo(5+canvasRectW,5);
	ctx.lineTo(5+canvasRectW, 200-5-canvasRectH-5);
	ctx.stroke();
	ctx.beginPath();
	ctx.moveTo(5,5+7);
	ctx.lineTo(5+canvasRectW, 5+7);
	ctx.stroke();
	///
	ctx.beginPath();
	ctx.moveTo(200-5, 200-5-canvasRectH);
	ctx.lineTo(canvasRectW+5+5, 200-5-canvasRectH);
	ctx.stroke();
	ctx.beginPath();
	ctx.moveTo(200-5, 200-5);
	ctx.lineTo(canvasRectW+5+5, 200-5);
	ctx.stroke();
	ctx.beginPath();
	ctx.moveTo(200-5-7,200-5-canvasRectH);
	ctx.lineTo(200-5-7, 200-5);
	ctx.stroke();
	///
	ctx.beginPath();
	ctx.moveTo(5,200-5);
	ctx.lineTo(canvasRectW+5, 200-5-canvasRectH);
	ctx.stroke();
	//
	ctx.fillText("W", 5+(canvasRectW-14)/2, 14+5+7-14/2);
	ctx.fillText("H", 200-5-7-14/2+2, 200-5-canvasRectH/2+14/2);
	ctx.fillText("D", 5+(canvasRectW-14)/2, 200-5-canvasRectH/2+14/2);
	//ctx.strokeRect(5, 200-5-canvasRectH, canvasRectW,canvasRectH);


}


// Add event listeners once the DOM has fully loaded by listening for the
// DOMContentLoaded event on the document, and adding your listeners to
// specific elements when it triggers.
document.addEventListener('DOMContentLoaded', function () {
	my_init();
	
	if(myPlatform==0){
		document.getElementById('my_width_px').type = "text";
		document.getElementById('my_width_px').maxLength=5;
		document.getElementById('my_height_px').type = "text";
		document.getElementById('my_height_px').maxLength=5;
		document.getElementById('my_diagonal_in').type = "text";
		document.getElementById('my_diagonal_in').maxLength=5;
	}
	
	//document.getElementById('mybody').addEventListener('load', my_init);
	
	document.getElementById('btnClose').addEventListener('click', onClickClose);
	document.getElementById('btnAbout').addEventListener('click', onClickAbout);

	document.getElementById('form1').addEventListener('action', my_calc);

	document.getElementById('my_width_px').addEventListener('change', my_calc);
	document.getElementById('my_height_px').addEventListener('change', my_calc);
	document.getElementById('my_diagonal_in').addEventListener('change', my_calc);

	document.getElementById('my_width_px').addEventListener('focus', onFocusInput);
	document.getElementById('my_height_px').addEventListener('focus', onFocusInput);
	document.getElementById('my_diagonal_in').addEventListener('focus', onFocusInput);

	document.getElementById('my_common_size').addEventListener('change', onChangeCommonSize);

	document.getElementById('btnCopy').addEventListener('click', onClickCopy);
	
	if(myPlatform == 3){
		document.getElementById('btnCopy').src = "email.png";
	}

	document.getElementById('webSiteLinkLabel').href = webSiteLink;
	document.getElementById('moreAppsLinkLabel').href = moreAppsLink;
	document.getElementById('rateThisAppLinkLabel').href = rateThisAppLink;
	document.getElementById('fullVerLinkLabel').href = fullVerLink;
	if(myPlatform==0){
		document.getElementById('webSiteLinkLabel').target = "_blank";
		document.getElementById('moreAppsLinkLabel').target = "_blank";
		document.getElementById('rateThisAppLinkLabel').target = "_blank";
		document.getElementById('fullVerLinkLabel').target = "_blank";
	}
	if(myPlatform==3){
		document.getElementById('webSiteLinkLabel').href = null;
		document.getElementById('moreAppsLinkLabel').href = null;
		document.getElementById('rateThisAppLinkLabel').href = null;
		document.getElementById('fullVerLinkLabel').href = null;
		document.getElementById('webSiteLinkLabel').addEventListener('click', onClickWebSiteLink);
		document.getElementById('moreAppsLinkLabel').addEventListener('click', onClickMoreAppsLink);
		document.getElementById('rateThisAppLinkLabel').addEventListener('click', onClickRateThisAppLink);
		document.getElementById('fullVerLinkLabel').addEventListener('click', onClickFullVerLink);
	}
	/*
	if(myPlatform==0){
		document.getElementById('webSiteLinkLabel').addEventListener('click', onClickWebSiteLink);
		document.getElementById('moreAppsLinkLabel').addEventListener('click', onClickMoreAppsLink);
		document.getElementById('rateThisAppLinkLabel').addEventListener('click', onClickRateThisAppLink);
		document.getElementById('fullVerLinkLabel').addEventListener('click', onClickFullVerLink);
	}else{
		document.getElementById('webSiteLinkLabel').href = webSiteLink;
		document.getElementById('moreAppsLinkLabel').href = moreAppsLink;
		document.getElementById('rateThisAppLinkLabel').href = rateThisAppLink;
		document.getElementById('fullVerLinkLabel').href = fullVerLink;
	}
	*/


	var c=document.getElementById("myCanvas");
	ctx=c.getContext("2d");
	ctx.fillStyle="rgba(255, 255, 255, 1)";
	ctx.font = "14px Helvetica, Arial, sans-serif";

	var myFrameTimer=setInterval(myTimer,30);
	function myTimer(){
		if(needRedraw){
			canvasRectW += (canvasRectTargetW-canvasRectW) * 0.2;
			canvasRectH += (canvasRectTargetH-canvasRectH) * 0.2;
			redrawCanvas();
			if(Math.abs(canvasRectTargetW-canvasRectW)<1 && Math.abs(canvasRectTargetH-canvasRectH)<1){
				canvasRectW = canvasRectTargetW;
				canvasRectH = canvasRectTargetH;
				redrawCanvas();
				needRedraw = false;
			}
		}

		//Toast
		if(toastFrameCnt>0){
			toastFrameCnt--;
		}else if(toastFrameCnt==0){
			document.getElementById('divToast').style.opacity -= 0.1;
			if(document.getElementById('divToast').style.opacity<0.2){
				showHideToast(false);
				toastFrameCnt=-1;
			}
		}

	}

	
	function loadAd(){
		if(document.activeElement==document.getElementById('my_width_px') ||
			document.activeElement==document.getElementById('my_height_px') ||
			document.activeElement==document.getElementById('my_diagonal_in') ||
			document.activeElement==document.getElementById('my_common_size')){
			//alert("NO ads");
		}else{
			//alert("REFRESH ads");
			document.getElementById("adframe").src = adLink;
		}
	}

	if(isFullMode){
		document.getElementById("aboutTitle").innerHTML="Screen Size Full";
		document.getElementById('fullVerLinkLabel').style.display='none';
	}
	if(myPlatform == 0){
		document.getElementById('fullVerLinkLabel').style.display='none';
	}
	if(myPlatform == 3){
		document.getElementById('fullVerLinkLabel').style.display='none';
	}
	if(needAd){
		document.getElementById("btnAbout").style.bottom="50px";
		document.getElementById("btnClose").style.bottom="50px";
		document.getElementById("divAds").style.display="block";

		loadAd();
		var myRefreshAdTimer=setInterval(loadAd,60000);
	}

});






