'use strict';

function onDeviceReady() {

    var game = new Phaser.Game(window.innerWidth, window.innerHeight, Phaser.AUTO, '');

    var sound_active = true;
    var bg_sound = null;
    var bg_height = 600;
    var velocity_ground = -200;
    var height_ground = 32;
    var pipes_to_win = 20;
    var num_pipes = 5;
    var num_bonus = 4;
    var platform = null;

    function loadMedia(file, name) {
        if (sound_active) {
            try {
                if (!platform) {
                    platform = device.platform.toLowerCase();
                }

                if (platform === "android") {
                    return new Media("/android_asset/www/assets/" + file);
                }
                else if (platform === "ios") {
                    return new Media("assets/" + file);
                }
                else if (platform === "win32nt") {
                    return new Media("www/assets/" + file);
                }
            } catch (e) {
                game.load.audio(name, 'assets/' + file);
                return game.add.audio(name);
            }
        }
    }
    
    function goToScube() {
        window.open("http://www.scubeworld.com", "_system");
    }
    
    function downloadApp() {
        if (platform === "android") {
            window.open("https://play.google.com/store/apps/details?id=com.delonia.Scubeworld", "_system");
        }
        else if (platform === "ios") {
            window.open("itms://itunes.apple.com/es/app/scubeworld/id890539554", "_system");
        }
        else if (platform === "win32nt") {
            window.open("http://www.windowsphone.com/es-es/store/app/scubeworld/1b7ffe0f-3113-4bd8-a19e-a63c21e9fcca", "_system");
        }
        
        
    }

    var Preload = function () {
        this.ready = false;
    };

    Preload.prototype = {
        preload: function () {
            this.stage.backgroundColor = '#ffffff';
            this.load.image('title', 'assets/title.png');
            this.load.image('motorbike', 'assets/motorbike.png');
            this.load.image('b_easy', 'assets/b_easy.png');
            this.load.image('b_medium', 'assets/b_medium.png');
            this.load.image('b_hard', 'assets/b_hard.png');
            this.load.image('b_goto', 'assets/b_goto.png');
            this.load.image('b_download', 'assets/b_download.png');
            this.load.image('b_play', 'assets/b_play.png');
            this.load.image('b_menu', 'assets/b_menu.png');
            this.load.spritesheet('pipe', 'assets/cars.png', 54, 120, num_pipes);
            this.load.image('background', 'assets/background.jpg');
            this.load.image('ground', 'assets/ground.png');
            this.load.image('hand', 'assets/hand.png');
            this.load.spritesheet('bonus', 'assets/bonus.png', 50, 50, num_bonus);
        },
        create: function () {

        },
        update: function () {
            if (this.ready) {
                this.game.state.start('menu');
            }
        },
        render: function () {
            this.ready = true;
        }
    };


    var Menu = function () {

    };

    Menu.prototype = {
        preload: function () {

        },
        create: function () {
            // add the background sprite
            this.background = this.game.add.sprite(0, this.game.height - bg_height, 'background');

            bg_sound = loadMedia("bg_sound.mp3", "bg_sound");
            if (sound_active && bg_sound) {
                bg_sound.play();
            }

            /** STEP 1 **/
            // create a group to put the title assets in 
            // so they can be manipulated as a whole
            this.titleGroup = this.game.add.group();

            /** STEP 2 **/
            // create the title sprite
            // and add it to the group
            this.title = this.add.sprite(this.game.width / 2, 0, 'title');
            this.title.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.title);

            /** STEP 3 **/
            // create the motorbike sprite 
            // and add it to the title group
            this.motorbike = this.add.sprite(this.game.width / 2, 55, 'motorbike');
            this.motorbike.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.motorbike);

            /** STEP 4 **/
            // add an animation to the motorbike
            // and begin the animation
            this.motorbike.animations.add('flap');
            this.motorbike.animations.play('flap', 12, true);

            /** STEP 5 **/
            // Set the originating location of the group
            this.titleGroup.x = 0;
            this.titleGroup.y = 100;

            /** STEP 6 **/
            //  create an oscillating animation tween for the group
            this.game.add.tween(this.titleGroup).to({ y: 115 }, 350, Phaser.Easing.Linear.NONE, true, 0, 1000, true);

            // add our start button with a callback
            this.easyButton = this.game.add.button(this.game.width / 2, 250, 'b_easy', this.easyGame, this);
            this.easyButton.anchor.setTo(0.5, 0.5);
            this.mediumButton = this.game.add.button(this.game.width / 2, 310, 'b_medium', this.mediumGame, this);
            this.mediumButton.anchor.setTo(0.5, 0.5);
            this.hardButton = this.game.add.button(this.game.width / 2, 370, 'b_hard', this.hardGame, this);
            this.hardButton.anchor.setTo(0.5, 0.5);
            
            this.gotoButton = this.game.add.button(this.game.width / 4, 450, 'b_goto', goToScube, this);
            this.gotoButton.anchor.setTo(0.5, 0.5);
            this.downloadButton = this.game.add.button((this.game.width / 4) * 3, 450, 'b_download', downloadApp, this);
            this.downloadButton.anchor.setTo(0.5, 0.5);
        },
        easyGame: function () {
            this.game.level_gravity = 700;
            this.game.level_jump = -250;
            this.game.velocity_objects = -100;
            this.game.time_to_pipe = 4000;
            this.startGame();
        },
        mediumGame: function () {
            this.game.level_gravity = 1000;
            this.game.level_jump = -350;
            this.game.velocity_objects = -200;
            this.game.time_to_pipe = 2000;
            this.startGame();
        },
        hardGame: function () {
            this.game.level_gravity = 1200;
            this.game.level_jump = -450;
            this.game.velocity_objects = -200;
            this.game.time_to_pipe = 2000;
            this.startGame();
        },
        startGame: function () {
            // start the 'play' state
            this.game.state.start('play');
        }
    };


    var Play = function () {
        this.timer;
        this.timer_bonus;
        this.score;
        this.velocity_bg = -50;
        this.height_obstacule = 120;
    };
    Play.prototype = {
        create: function () {
            game.physics.startSystem(Phaser.Physics.ARCADE);

            game.input.onTap.add(this.init_play, this);
            game.input.onTap.add(this.jump, this);

            this.hole_positions = Math.floor(game.height / this.height_obstacule);

            this.pipes_to_win = pipes_to_win;

            this.bg = game.add.tileSprite(0, this.game.height - bg_height, 2000, bg_height, 'background');
            this.bg.autoScroll(this.velocity_bg, 0);
            this.ground = game.add.tileSprite(0, this.game.height - height_ground, 2000, height_ground, 'ground');
            this.ground.autoScroll(velocity_ground, 0);
            game.physics.enable(this.ground, Phaser.Physics.ARCADE);
            this.ground.body.immovable = true;

            this.motorbike = game.add.sprite(70, 245, 'motorbike');
            game.physics.enable(this.motorbike, Phaser.Physics.ARCADE);
            //this.motorbike.body.gravity.y = 1000;
            // Change the anchor point of the motorbike
            this.motorbike.anchor.setTo(-0.2, 0.5);
            this.motorbike.inGround = false;

            this.hand = game.add.sprite(this.game.width / 2, 330, 'hand');
            game.physics.enable(this.hand, Phaser.Physics.ARCADE);
            this.hand.anchor.setTo(0.5, 0.5);
            this.game.add.tween(this.hand).to({ height: 70, width: 70 }, 350, Phaser.Easing.Linear.NONE, true, 0, 1000, true);

            if (sound_active && bg_sound) {
                try {
                    if (platform === "win32nt") {
                        bg_sound.play();
                    }
                    bg_sound.seekTo(30000);
                } catch (e) {}
            }

            // Add sounds to the game
            this.jump_sound = loadMedia("jump.mp3", "jump");
            this.hit_sound = loadMedia("hit.mp3", "hit");
            this.bonus_sound = loadMedia("bonus.mp3", "bonus");

            this.pipe_index = 0;
            this.bonus_index = 0;
        },
        update: function () {
            if (this.motorbike.inWorld === false || this.motorbike.inGround === true) {
                this.restart_game();
            }

            // Make the motorbike slowly rotate downward
            if (this.motorbike.angle < 10)
                this.motorbike.angle += 1;

            game.physics.arcade.collide(this.motorbike, this.ground, this.hit_ground, null, this);

            if (this.pipes) {
                this.checkScore(this.pipes.getFirstAlive());

                game.physics.arcade.overlap(this.motorbike, this.pipes, this.hit_pipe, null, this);
                game.physics.arcade.overlap(this.motorbike, this.bonus, this.hit_bonus, null, this);
            }
        },
        init_play: function () {
            game.input.onTap.remove(this.init_play, this);

            this.hand.kill();

            this.pipes = game.add.group();
            this.pipes.enableBody = true;
            this.pipes.physicsBodyType = Phaser.Physics.ARCADE;
            this.pipes.createMultiple(20, 'pipe');
            this.timer = game.time.events.loop(this.game.time_to_pipe, this.add_row_of_pipes, this);

            this.bonus = game.add.group();
            this.bonus.enableBody = true;
            this.bonus.physicsBodyType = Phaser.Physics.ARCADE;
            this.bonus.createMultiple(20, 'bonus');
            game.time.events.add(this.game.time_to_pipe / 2, this.add_bonus, this);

            this.motorbike.body.gravity.y = this.game.level_gravity;

            this.score = 0;
            var style = { font: "30px Arial", fill: "#FFFFFF", stroke: "#000000", strokeThickness: 7 };
            this.label_score = game.add.text(this.game.width / 2, 20, "" + this.score, style);
        },
        jump: function () {
            // if the motorbike hit a pipe, no jump
            if (this.motorbike.alive === false)
                return;

            this.motorbike.body.velocity.y = this.game.level_jump;

            // Animation to rotate the motorbike
            game.add.tween(this.motorbike).to({ angle: -20 }, 100).start();

            // Play a jump sound
            try {
                if (sound_active) {
                    this.jump_sound.play();
                }
            } catch (e) { }
        },
        hit_ground: function () {
            this.motorbike.body.velocity.x = 0;
            this.motorbike.inGround = true;
            if (this.motorbike.alive === true) {
                this.hit_pipe();
            }
        },
        // Dead animation when the motorbike hit a pipe
        hit_pipe: function () {
            // If the motorbike has already hit a pipe, we have nothing to do
            if (this.motorbike.alive === false)
                return;

            try {
                if (sound_active) {
                    this.hit_sound.play();
                }
            } catch (e) { }

            // Set the alive flag to false
            this.motorbike.alive = false;

            // Prevent new pipes from apearing
            game.time.events.removeAll();

            // Go trough all the pipes, and stop their movement
            this.pipes.forEachAlive(function (p) {
                game.physics.enable(p, Phaser.Physics.ARCADE);
                p.body.velocity.x = 0;
            }, this);

            this.bonus.forEachAlive(function (b) {
                game.physics.enable(b, Phaser.Physics.ARCADE);
                b.body.velocity.x = 0;
            }, this);

            this.bg.autoScroll(0, 0);
            this.ground.autoScroll(0, 0);
        },
        restart_game: function () {
            game.time.events.removeAll();

            this.pipes.forEachAlive(function (p) {
                p.kill();
            }, this);
            this.bonus.forEachAlive(function (b) {
                b.kill();
            }, this);
            this.motorbike.kill();
            this.game.score = this.score;
            this.game.state.start('gameover');
        },
        checkScore: function (pipe) {
            if (pipe) {
                if (!pipe.hasScored && pipe.alive && pipe.world.x <= this.motorbike.world.x) {
                    pipe.alive = false;
                    pipe.hasScored = true;
                    this.score += 1;
                    this.label_score.text = this.score;
                    if (--this.pipes_to_win <= 0) {
                        this.game.score = this.score;
                        this.game.state.start('gamewin');
                    }
                }
                else if (pipe.hasScored) {
                    pipe.alive = false;
                }
            }
        },
        add_one_pipe: function (x, y, scored) {
            var pipe = this.pipes.next();
            pipe.reset(x, y);
            pipe.frame = this.pipe_index;
            this.pipe_index = ++this.pipe_index % num_pipes;
            pipe.hasScored = scored;
            game.physics.enable(pipe, Phaser.Physics.ARCADE);
            pipe.body.velocity.x = this.game.velocity_objects;
            pipe.outOfBoundsKill = true;
        },
        add_row_of_pipes: function () {
            var hole = ((Math.round(Math.random() * 100) / 100) * this.hole_positions);
            if (hole < 1) {
                hole = 1;
            }
            else if (100 + hole * 120 > game.height) {
                hole -= 0.5;
            }

            var scored = false;
            for (var i = hole - 1; i >= 0; i--) {
                this.add_one_pipe(game.width, -100 + i * 120, scored);
                if (!scored) {
                    scored = true;
                }
            }
            for (var i = hole; i * 120 < game.height; i++) {
                this.add_one_pipe(game.width, 100 + i * 120, scored);
            }
        },
        add_bonus: function () {
            this.timer_bonus = game.time.events.loop(this.game.time_to_pipe * 2, this.add_bonus_item, this);
        },
        add_bonus_item: function () {
            var bonus_item = this.bonus.next();
            bonus_item.anchor.setTo(0.5, 0.5);
            bonus_item.frame = this.bonus_index;
            this.bonus_index = ++this.bonus_index % num_bonus;
            bonus_item.reset(game.width, game.height / 2);
            game.physics.enable(bonus_item, Phaser.Physics.ARCADE);
            bonus_item.body.velocity.x = this.game.velocity_objects;
            bonus_item.outOfBoundsKill = true;
            this.game.add.tween(bonus_item).to({ height: 60, width: 60 }, 350, Phaser.Easing.Linear.NONE, true, 0, 1000, true);
        },
        hit_bonus: function (motorbike, bonus_item) {
            bonus_item.kill();
            try {
                if (sound_active) {
                    this.bonus_sound.play();
                }
            } catch (e) { }
            this.score += 5;
            this.label_score.text = this.score;
        }
    };


    var GameWin = function () {

    };

    GameWin.prototype = {
        preload: function () {
            this.load.image('title_gamewin', 'assets/title_gamewin.png');
            this.load.image('bg_gameover', 'assets/bg_gameover.png');
            this.load.image('img_gamewin', 'assets/game_win.png');

            this.gw_sound = loadMedia("win.mp3");
        },
        create: function () {
            // add the background sprite
            this.background = this.game.add.sprite(0, this.game.height - bg_height, 'background');
            this.ground = game.add.tileSprite(0, this.game.height - height_ground, 2000, height_ground, 'ground');

            try {
                if (sound_active) {
                    this.gw_sound.play();
                }
            } catch (e) { }

            /** STEP 1 **/
            // create a group to put the title assets in 
            // so they can be manipulated as a whole
            this.titleGroup = this.game.add.group();
            this.bg_title = this.add.sprite(this.game.width / 2, 30, 'bg_gameover');
            this.bg_title.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.bg_title);

            /** STEP 2 **/
            // create the title sprite
            // and add it to the group
            this.title = this.add.sprite(this.game.width / 2, 0, 'title_gamewin');
            this.title.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.title);

            /** STEP 3 **/
            // create the motorbike sprite 
            // and add it to the title group
            var style = { font: "30px Arial", fill: "#FFFFFF", stroke: "#000000", strokeThickness: 5 };
            this.label = game.add.text(this.game.width / 2, 55, "Score: " + this.game.score, style);
            this.label.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.label);

            this.titleGroup.x = 0;
            this.titleGroup.y = 70;

            // add our start button with a callback
            this.startButton = this.game.add.button(this.game.width / 2, 210, 'b_play', this.startClick, this);
            this.startButton.anchor.setTo(0.5, 0.5);
            this.menuButton = this.game.add.button(this.game.width / 2, 270, 'b_menu', this.menuClick, this);
            this.menuButton.anchor.setTo(0.5, 0.5);

            this.imgGO = this.add.sprite(this.game.width / 2, this.game.height - 110, 'img_gamewin');
            this.imgGO.anchor.setTo(0.5, 0.5);
            
            this.gotoButton = this.game.add.button(70, 350, 'b_goto', goToScube, this);
            this.gotoButton.anchor.setTo(0.5, 0.5);
            this.downloadButton = this.game.add.button(this.game.width - 70, 350, 'b_download', downloadApp, this);
            this.downloadButton.anchor.setTo(0.5, 0.5);
        },
        startClick: function () {
            // start button click handler
            // start the 'play' state
            this.game.state.start('play');
        },
        menuClick: function () {
            this.game.state.start('menu');
        }
    };


    var GameOver = function () {

    };

    GameOver.prototype = {
        preload: function () {
            this.load.image('title_gameover', 'assets/title_gameover.png');
            this.load.image('bg_gameover', 'assets/bg_gameover.png');
            this.load.image('img_gameover', 'assets/game_over.png');

            this.go_sound = loadMedia("game_over.mp3");
        },
        create: function () {
            // add the background sprite
            this.background = this.game.add.sprite(0, this.game.height - bg_height, 'background');
            this.ground = game.add.tileSprite(0, this.game.height - height_ground, 2000, height_ground, 'ground');

            try {
                if (sound_active) {
                    this.go_sound.play();
                }
            } catch (e) { }

            /** STEP 1 **/
            // create a group to put the title assets in 
            // so they can be manipulated as a whole
            this.titleGroup = this.game.add.group();
            this.bg_title = this.add.sprite(this.game.width / 2, 30, 'bg_gameover');
            this.bg_title.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.bg_title);

            /** STEP 2 **/
            // create the title sprite
            // and add it to the group
            this.title = this.add.sprite(this.game.width / 2, 0, 'title_gameover');
            this.title.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.title);

            /** STEP 3 **/
            // create the motorbike sprite 
            // and add it to the title group
            var style = { font: "30px Arial", fill: "#FFFFFF", stroke: "#000000", strokeThickness: 5 };
            this.label = game.add.text(this.game.width / 2, 55, "Score: " + this.game.score, style);
            this.label.anchor.setTo(0.5, 0.5);
            this.titleGroup.add(this.label);

            this.titleGroup.x = 0;
            this.titleGroup.y = 70;

            // add our start button with a callback
            this.startButton = this.game.add.button(this.game.width / 2, 210, 'b_play', this.startClick, this);
            this.startButton.anchor.setTo(0.5, 0.5);
            this.menuButton = this.game.add.button(this.game.width / 2, 270, 'b_menu', this.menuClick, this);
            this.menuButton.anchor.setTo(0.5, 0.5);

            this.imgGO = this.add.sprite(this.game.width / 2, this.game.height - 110, 'img_gameover');
            this.imgGO.anchor.setTo(0.5, 0.5);
            
            this.gotoButton = this.game.add.button(70, 350, 'b_goto', goToScube, this);
            this.gotoButton.anchor.setTo(0.5, 0.5);
            this.downloadButton = this.game.add.button(this.game.width - 70, 350, 'b_download', downloadApp, this);
            this.downloadButton.anchor.setTo(0.5, 0.5);
        },
        startClick: function () {
            // start button click handler
            // start the 'play' state
            this.game.state.start('play');
        },
        menuClick: function () {
            this.game.state.start('menu');
        }
    };

    game.state.add('menu', Menu);
    game.state.add('play', Play);
    game.state.add('preload', Preload);
    game.state.add('gamewin', GameWin);
    game.state.add('gameover', GameOver);

    game.state.start('preload');

}