function BattleShip(_par, _notify)
{
	var th = this
//--------------------------------//
	//
	var dimension = _par.getDimension()
	// Для первого шага
	var allTime = __config.time_for_first_step
	var num_deck1 = typeof(__config.size_field[dimension].num_deck_1) == "number" ? __config.size_field[dimension].num_deck_1 : 0
	var num_deck2 = typeof(__config.size_field[dimension].num_deck_2) == "number" ? __config.size_field[dimension].num_deck_2 : 0
	var num_deck3 = typeof(__config.size_field[dimension].num_deck_3) == "number" ? __config.size_field[dimension].num_deck_3 : 0
	var num_mine = typeof(__config.size_field[dimension].num_mine) == "number" ? __config.size_field[dimension].num_mine : 0
	var num_chests = typeof(__config.size_field[dimension].num_chests) == "number" ? __config.size_field[dimension].num_chests : 0
	//
	var num_chest = typeof(__config.size_field[dimension].num_chest) == "number" ? __config.size_field[dimension].num_chest : 0
	//--//
	var all_shots_user = 0
	var all_shots_bot = 0
	var ship_shots_user = 0
	var ship_shots_bot = 0
	var num_chests_user = 0
	var num_chests_bot = 0
	var num_money = 0
	var num_bot_money = st_getMoney()
	//--//
	var multibomb_num_user = typeof(__config.size_field[dimension].multibomb) == "number" ? __config.size_field[dimension].multibomb : __config.multibomb
	var dinamite_num_user = typeof(__config.size_field[dimension].dinamite) == "number" ? __config.size_field[dimension].dinamite : __config.dinamite
	var periskope_num_user = typeof(__config.size_field[dimension].periskope) == "number" ? __config.size_field[dimension].periskope : __config.periskope
	var torpedo_num_user = typeof(__config.size_field[dimension].torpedo) == "number" ? __config.size_field[dimension].torpedo : __config.torpedo
	var multibomb_num_bot = multibomb_num_user
	var dinamite_num_bot = dinamite_num_user
	var periskope_num_bot = periskope_num_user
	var torpedo_num_bot = torpedo_num_user
	//-----//
	var num_deck1_bot = num_deck1
	var num_deck2_bot = num_deck2
	var num_deck3_bot = num_deck3
	var num_mine_bot = num_mine
	var num_chests_bot = num_mine

	var flying_money = false
	/////
	var time = -1
//////////////////////////////////
	var timer
	var rocks = new Array()
	var ships_user = new Array()
	var ships_bot = new Array()
	var mines_user = new Array()
	var chest_user = new Array()
	var mines_bot = new Array()
	var chest_bot = new Array()
	var chests = new Array()
	var field = new Array()
	var made_moves_bot = new Array()
	var made_moves_user = new Array()
	var used_move_user = new Array()
	var used_move_bot = new Array()
	var used_objects = new Array()
	var periscopes = new Array()
	for(var a=0; a < dimension; a++)
		field[a] = new Array()


	this.getData = function(){
		var p = {
			num_deck1: num_deck1,
			num_deck2: num_deck2,
			num_deck3: num_deck3,
			num_mine: num_mine,
			num_chests: num_chests,

			ships_user: ships_user,
			ships_bot: ships_bot,
			mines_user: mines_user,
			chest_user: chest_user,
			mines_bot: mines_bot,
			chest_bot: chest_bot,
			chests: chests,
			rocks: rocks,
			made_moves_user: made_moves_user,
			made_moves_bot: made_moves_bot,
			used_move_user: used_move_user,
			used_move_bot: used_move_bot,

			all_shots_user: all_shots_user,
			all_shots_bot: all_shots_bot,
			ship_shots_user: ship_shots_user,
			ship_shots_bot: ship_shots_bot,
			num_chests_user: num_chests_user,
			num_chests_bot: num_chests_bot,

			periscopes: periscopes,
			// time: time

			num_attack: 0
		}		
		// Количество доступных бонусов
		p.multibomb_num_user = multibomb_num_user
		p.dinamite_num_user = dinamite_num_user
		p.periskope_num_user = periskope_num_user
		p.torpedo_num_user = torpedo_num_user
		p.multibomb_num_bot = multibomb_num_bot
		p.dinamite_num_bot = dinamite_num_bot
		p.periskope_num_bot = periskope_num_bot
		p.torpedo_num_bot = torpedo_num_bot
		p.used_objects = used_objects
		p.flying_money = flying_money
		p.num_money = num_money
		p.num_bot_money = num_bot_money

		return p
	}
// Создание корабля в центре поля
	this.createShip = function(deck, direct, player, rand){
		// console.log(num_deck1, num_deck2, num_deck3)
		switch (deck){
			case 1:
				if(player == "user")
					num_deck1--
				else
					num_deck1_bot--
				break
			case 2:
				if(player == "user")
					num_deck2--
				else
					num_deck2_bot--
				break
			case 3:
				if(player == "user")
					num_deck3--
				else
					num_deck3_bot--
				break
		}
		var _ship = new SeaObjects("ship", deck, "goriz")
		if(player == "user")
			ships_user.push(_ship)
		if(player == "bot")
			ships_bot.push(_ship)
		var ii = Math.floor(dimension/2)-1
		var jj = Math.floor(dimension/2)-1
		if(rand){
			ii = Math.round(Math.random() * (dimension - 1))
			jj = Math.round(Math.random() * (dimension - 1))
		}
		set_ship_in_cell(ii, jj, _ship, player)
		if(num_mine == 0 && num_deck1 == 0 && num_deck2 == 0 && num_deck3 == 0 && 
			num_mine_bot == 0 && num_deck1_bot == 0 && num_deck2_bot == 0 && num_deck3_bot == 0){
			this.randomPlacing()
		}

		return _ship
	}

// Изменение положения корабля на поле
	this.changeShipLoc = function(o, i, j, player){
		set_ship_in_cell(i, j, o, player)
	}
// Поворот корабля 
	this.rotateShip = function(o, player){
		var i = o.getTakes()[0].i
		var j = o.getTakes()[0].j
		set_ship_in_cell(i, j, o, player)
	}
// Создание мины
	this.createMine = function(player, rand){
		if(player == "user")
			num_mine --
		else
			num_mine_bot -- 
		var _mine = new SeaObjects("mine", 1, "goriz")
		if(player == "user")
			mines_user.push(_mine)
		if(player == "bot")
			mines_bot.push(_mine)
		var ii = Math.floor(dimension/2)-1
		var jj = Math.floor(dimension/2)-1
		if(rand){
			ii = Math.round(Math.random() * (dimension - 1))
			jj = Math.round(Math.random() * (dimension - 1))
		}
		set_ship_in_cell(ii, jj, _mine, "user")
		if(num_mine == 0 && num_deck1 == 0 && num_deck2 == 0 && num_deck3 == 0 && 
			num_mine_bot == 0 && num_deck1_bot == 0 && num_deck2_bot == 0 && num_deck3_bot == 0){
			this.randomPlacing()
		}
	}
// Создание сундука
	this.createChest = function(player){
		var _mine = new SeaObjects("chest", 1, "goriz")
		if(player == "user"){
			num_chests -- 
			chest_user.push(_mine)
		}else if (player == "bot"){
			num_chests_bot --
			chest_bot.push(_mine)			
		}
		// chests.push(_mine)
		var ii = Math.round(Math.random() * (dimension - 1))
		var jj = Math.round(Math.random() * (dimension - 1))
		set_ship_in_cell(ii, jj, _mine, player)
	}
// Рандомное размещение объектов на поле
	this.randomPlacing = function(player, end){
		if(player == "user"){
			// num_mine = __config.num_mine
			// num_deck1 = __config.num_deck_1
			// num_deck2 = __config.num_deck_2
			// num_deck3 = __config.num_deck_3

			if(num_mine == 0 && num_deck1 == 0 && num_deck2 == 0 && num_deck3 == 0 && !end){
				num_deck1 = typeof(__config.size_field[dimension].num_deck_1) == "number" ? __config.size_field[dimension].num_deck_1 : 0
				num_deck2 = typeof(__config.size_field[dimension].num_deck_2) == "number" ? __config.size_field[dimension].num_deck_2 : 0
				num_deck3 = typeof(__config.size_field[dimension].num_deck_3) == "number" ? __config.size_field[dimension].num_deck_3 : 0
				num_mine = typeof(__config.size_field[dimension].num_mine) == "number" ? __config.size_field[dimension].num_mine : 0

				// console.log(num_deck1, num_deck2, num_deck3, num_mine)
				ships_user = new Array()
				mines_user = new Array()
				// return
			}

			var rotate = new Array()
			while(num_mine>0)
				this.createMine(player, true)
			while(num_deck1>0)
				rotate.push(this.createShip(1, "goriz", player, true))
			while(num_deck2>0)
				rotate.push(this.createShip(2, "goriz", player, true))
			while(num_deck3>0)
				rotate.push(this.createShip(3, "goriz", player, true))
			for(var a=0; a<rotate.length; a++){
				var r = Math.round(Math.random())
				if(r == 1){
					rotate[a].changeDir()
					this.rotateShip(rotate[a], player)
				}
			}
			while(num_chests>0){
				this.createChest("user")
			}
		}else if(player == "bot"){
			if(num_mine_bot == 0 && num_deck1_bot == 0 && num_deck2_bot == 0 && num_deck3_bot == 0)
				return
			while(num_mine_bot>0)
				this.createMine(player, true)
			while(num_deck1_bot>0)
				this.createShip(1, "goriz", player, true)
			while(num_deck2_bot>0)
				this.createShip(2, "goriz", player, true)
			while(num_deck3_bot>0)
				this.createShip(3, "goriz", player, true)
			for(var a=0; a<ships_bot.length; a++) {
				var r = Math.round(Math.random())
				if(r == 1) {
					ships_bot[a].changeDir()
					this.rotateShip(ships_bot[a], player)
				}

			while(num_chests_bot>0)
				this.createChest("bot")
			}
		}else{
			// while(num_chest>0)
			// 	this.createChest()
			// console.log("CHESTS")
			 th.randomPlacing("user", true)
			_par.activeReady()
		}
	}

	this.getAllTime = function(){
		return allTime
	}

	var aftertime = false
	var num_call_after_time = 0
	this.after_time = function(){
		if(aftertime && num_call_after_time != 1)
			return
		if(num_call_after_time == 0){
			_par.startTimer(__config.time_for_after_first_step)
			_par.setModal("text_items_placed")
			th.randomPlacing("user", true)
			aftertime = true
			num_call_after_time++
		}else if(num_call_after_time == 1){
			_par.nextStep()
		}
	}
	this.randomPlacing("bot")

	this.createRocks = function(){
		_par.setModal("text_setup_battlefield")
		for(var a=1; a<=4; a++){
			var o = new SeaObjects("rock", 1, "goriz", a)
			var rand_i = Math.round(Math.random() * (dimension - 1))
			var rand_j = Math.round(Math.random() * (dimension - 1))
			rocks.push(o)
			set_ship_in_cell(rand_i, rand_j, o)
		}
	}

	this.setAlphaObjects = function(v){
		var change = new Array()
		change = change.concat(ships_user)
		for(var a=0; a< change.length; a++)
			change[a].setAlpha(v)		
	}

// PRIVATE //
// Установка объекта в ячейку

	function set_ship_in_cell(i, j, ship, player){
		ship.setTakes(-1)
		var coor = searchSpace(i, j, ship, player)
		ship.setTakes(coor.i, coor.j)
		_notify()
	}

// Проверка ячейки на занятость
	function checkCell(i, j, player) {
		if(i<0 || i>=dimension || j<0 || j>=dimension)
			return true
		var check = rocks
		check = check.concat(chests)
		check = player == "user" ? check.concat(ships_user) : check.concat(ships_bot)
		check = player == "user" ? check.concat(mines_user) : check.concat(mines_bot)
		check = player == "user" ? check.concat(chest_user) : check.concat(chest_bot)
		if(!player){
			check = rocks
			check = check.concat(ships_user)
			check = check.concat(mines_user)
			check = check.concat(ships_bot)
			check = check.concat(mines_bot)
		}

		for (var a = 0; a < check.length; a++) {
			var mas = check[a].getTakes()
			for (var b = 0; b < mas.length; b++) {
				if(mas[b].i == i && mas[b].j == j)
					return true
			}
		}
	}

// Поиск свободного места
	function searchSpace(i, j, ship, player) {
		var deaks = ship.getNumDecks()
		var dir = ship.getDirection()

		if(!checkLoc(i, j, dir, deaks, player))
			return {i:i, j: j}

		for(var b = 1; b < dimension; b++){
			var search_mas = buildMasIndex(-1 * b, -1 * b, Math.abs((-1 * b)*2) + 1)
			for(var a=0; a<search_mas.length; a++){
				if(!checkLoc(i + search_mas[a][0], j + search_mas[a][1], dir, deaks, player))
					return {i:i + search_mas[a][0], j: j + search_mas[a][1]}
			}
		}
	}

	// Проверка ячейки для корабля с определенными габаритами
	function checkLoc(i, j, dir, deaks, player){
		var num = deaks;
		for(var a = 0; a<deaks; a++){
			if(dir == "goriz"){
				if(!checkCell(i, j+a, player))
					num--;
			}
			if(dir == "vert"){
				if(!checkCell(i+a, j, player))
					num--;
			}
		}
		if(num == 0)
			return false
		else
			return true
	}

	// Построение массива индекса проверяемых элементов (начиная с элемента i, j квадратная область размером num)
	function buildMasIndex(i, j, num){
		var mas = new Array()
		for(var a=0; a<num; a++)
			for(var b=0; b<num; b++){
				var p = [i + a, j + b]
				mas.push(p)
			}
		return mas
	}
}