function ViewModelGame(_logic)
{	
//--------------------------------//
	var _obs = new Array()
	var _model = _logic

	var p = _model.getData()

	_model.registerObservers(this)	

// Регистрация наблюдателей за изменениями
	this.registerObservers = function(v){
		_obs.push(v)
	}
	var _visual = new VisualGame(this, _model.getDimension())
// Обновление модели
	this.notify = function() {
		p = _model.getData()
		changeVisual()
		// console.log(p)
	}

// События от визуальных объектов
	this.setToCell = function(o, i, j){
		_model.changeShipLoc(o, i, j)
	}
	
	this.rotateShip = function(o, rot){
		_model.rotateShip(o, rot)
	}

	this.shot = function(i, j, player, num){
		_model.shot(i, j, player, num)
	}

	this.changeCurrentPlayer = function(){
		_model.changeCurrentPlayer()
	}

	this.nextStep = function(){
		_model.nextStep()
	}

// Getters //
	this.getVisual = function(){
		return _visual
	}

	this.getData = function(){
		return p
	}

	this.getDimension = function(){
		return _model.getDimension() 
	}
// PRIVATE //
	function changeVisual(){
		for(var a=0; a<_obs.length; a++)
			if(_obs[a].updateField)
				_obs[a].updateField(p.cur_step)
	}
};