/**
 * Listens for the app launching then creates the window
 *
 * @see http://developer.chrome.com/apps/app.runtime.html
 * @see http://developer.chrome.com/apps/app.window.html
 */
var chromeWindow;

chrome.app.runtime.onLaunched.addListener(createVisibleWindow);

function createVisibleWindow(appRenderedCallback) {
    console.log('createVisibleWindow', arguments);
    var width = Math.min(screen.availWidth, 640);
    var height = screen.availHeight;

    chrome.app.window.create('index.html', {
        id: "SereneNotesId",
        outerBounds: {
            width: width,
            height: height,
            left: 0,
            top: 0
        }
    }, function (createdWindow) {
        console.log('window creation callback', createdWindow);
        chromeWindow = createdWindow;
        if (typeof appRenderedCallback === 'function') {
            chromeWindow.contentWindow.appRenderedCallback = appRenderedCallback;
        }

        chromeWindow.onClosed.addListener(function () {
            console.log('chrome window closed');
            chromeWindow = null;
        });
    });
}


chrome.alarms.onAlarm.addListener(function (alarm) {
    console.log("System delivered alarm:", alarm, chromeWindow);
    if (chromeWindow && chromeWindow.contentWindow) {
         postMessageFromBackground();
    } else {
        createVisibleWindow(postMessageFromBackground);
    }

    function postMessageFromBackground () {
        var msg = {action: alarm.name};
        console.log("posting message", msg);
        chromeWindow.contentWindow.postMessage(msg, '*');
    }
});
