// Jasmine 2.2 specs for AlarmService in Serene Notes
// Copyright © 2015-2016 Hominid Software
// Since alarms are scheduled by the system, this doesn't test the happy path of AlarmService.
// It chiefly tests that errors are handled.

describe("AlarmService", function () {
    var alarmService;
    beforeEach(function () {
        alarmService = new AlarmService();
    });
    afterEach(function () {
        alarmService.destroy();
    });

    if ('mozSetMessageHandler' in navigator && 'mozAlarms' in navigator ||   // FxOS
        'chrome' in window && 'alarms' in chrome) {   // Chrome app
        it("should fulfill a Promise when scheduling nightly backup", function (done) {
            alarmService.scheduleNightlyBackup()
                .then(function (date) {
                    expect(date).toEqual(jasmine.any(Date));
                    expect(date.getHours()).toBe(4);
                    expect(date.getMinutes()).toBe(30);
                    done();
                })
                .catch(function (err) {
                    fail(err);
                    done();
                });
        });
    } else {
        it("should reject a Promise on platforms w/o alarms", function (done) {
            alarmService.scheduleNightlyBackup()
                .then(function (date) {
                    fail(new Error("Should have rejected Promise"));
                    done();
                })
                .catch(function (err) {
                    expect(err.message).toEqual($L("Switch to the Chrome app or Firefox OS to schedule backups."));
                    done();
                });
        });
    }

    it("can clear on any platform (though it may be a NOP)", function () {
        expect(enyo.bind(alarmService, 'clear')).not.toThrow();
    });
});
