/* unit and functional tests for Banner (FFOS-style status line) */
/*jsl:import ../source/Banner.js */

describe('Banner', function () {
	var timerCallback, div;

	beforeEach( function () {
		timerCallback = jasmine.createSpy("timerCallback");
		jasmine.clock().install();

		div = document.createElement("div");
		document.body.appendChild(div);
	});
	
	afterEach(function () {
		document.body.removeChild(div);

		jasmine.clock().uninstall();
	});
	
	it('should pop up at bottom of viewport', function () {
		var banner = new Banner();
		expect(banner).toBeTruthy();

		banner.renderInto(div);
		// Popups are instantiated lazily
		expect(banner.hasNode()).toEqual(false);

		banner.show();
		expect(banner.hasNode()).not.toEqual(false);
		expect(banner.hasNode().tagName).toEqual('SECTION');
		expect(banner.getAttribute('role')).toEqual('status');
//		expect(banner.getComputedStyleValue('text-align')).toEqual('center');
		var bounds = banner.getBounds();
		expect(bounds.top).toEqual(jasmine.any(Number));   // value depends on banner contents
//		expect(bounds.left).toEqual(0);
		// There might be a scroll bar
		expect(bounds.width).not.toBeGreaterThan(window.innerWidth || document.documentElement.offsetWidth);
//		expect(bounds.height).to.be.greaterThan(0);

		banner.destroy();
	});

	it('should pop up when the text is set, then automatically close', function () {
		var banner = new Banner();
		banner.renderInto(div);
		expect(banner.hasNode()).toEqual(false);
		expect(banner.get('showing')).toEqual(false);

		banner.showMessage('Able was I ere I saw <strong>Elba</strong>.');
		expect(banner.hasNode()).not.toEqual(false);
		expect(banner.get('showing')).toEqual(true);
		expect(banner.$.paragraph.getContent()).toEqual('Able was I ere I saw <strong>Elba</strong>.');

		jasmine.clock().tick(banner.timeout-1);
		expect(banner.get('showing')).toEqual(true);

		jasmine.clock().tick(2);
		expect(banner.get('showing')).toEqual(false);

		banner.destroy();
	});
	
	it('should queue messages sent quickly', function () {
		var banner = new Banner();
		banner.renderInto(div);
		expect(banner.get('showing')).toEqual(false);

		banner.showMessage('Able was I ere I saw <strong>Elba</strong>.');
		expect(banner.get('showing')).toEqual(true);
		expect(banner.$.paragraph.getContent()).toEqual('Able was I ere I saw <strong>Elba</strong>.');

		jasmine.clock().tick(100);
		expect(banner.get('showing')).toEqual(true);

		banner.showMessage('The rain in Spain stays mainly in the plain.');
		expect(banner.get('showing')).toEqual(true);
		expect(banner.$.paragraph.get('content')).toEqual('Able was I ere I saw <strong>Elba</strong>.');

		banner.showMessage('Four score and seven years ago');
		expect(banner.get('showing')).toEqual(true);
		expect(banner.$.paragraph.get('content')).toEqual('Able was I ere I saw <strong>Elba</strong>.');

		jasmine.clock().tick(banner.timeout);
		expect(banner.get('showing')).toEqual(true);
		expect(banner.$.paragraph.get('content')).toEqual('The rain in Spain stays mainly in the plain.');

		jasmine.clock().tick(banner.timeout);
		expect(banner.get('showing')).toEqual(true);
		expect(banner.$.paragraph.get('content')).toEqual('Four score and seven years ago');

		jasmine.clock().tick(banner.timeout);
		expect(banner.get('showing')).toEqual(false);

		banner.destroy();
	});
});

