/* unit and functional tests for DetailPanel.js for Serene Notes */
/* Copyright © 2015 Hominid Software */
/*jsl:import ../source/DetailPanel.js */

var PanelTestJig = enyo.kind({
	name: "PanelTestJig",
	panelUpdateItemResponse: null,
	panelHideDetailsResponse: null,
	components: [
		{	kind: "DetailPanel", 
			onUpdateItem: "panelUpdateItem", 
			onHideDetails: "panelHideDetails"
		}
	],
	panelUpdateItem: function (inSender, inResponse) {
		this.log(inResponse);
		this.panelUpdateItemResponse = inResponse;
	},
	panelHideDetails: function (inSender, inResponse) {
		this.log(inResponse);
		this.panelHideDetailsResponse = inResponse;
	}
});


describe('DetailPanel', function () {
	var div, panelTestJig;
	beforeEach( function () {
		div = document.createElement("div");
		document.body.appendChild(div);
		panelTestJig = new PanelTestJig();
		panelTestJig.renderInto(div);
	});
	
	afterEach(function () {
		panelTestJig.destroy();
		document.body.removeChild(div);
	});
		
	
	/* This does not catch the setValue bug introduced in Enyo 2.4 */
	it('should update subject field & date picker when setItem is called',function () {
		var item = {key: 21, sortKey: 21, subject: 'test of setItem'};
		panelTestJig.$.detailPanel.setItem(item, false);
		expect(panelTestJig.$.detailPanel.$.subjectFld.value).toEqual('test of setItem');
		expect(panelTestJig.$.detailPanel.$.subjectFld.hasNode().innerHTML).toEqual('test of setItem');
		expect(panelTestJig.$.detailPanel.$.datePicker.get('value')).toEqual(new Date(-21));

		item = {key: 22, sortKey: 22, subject: ''};
		panelTestJig.$.detailPanel.setItem(item, true);
		expect(panelTestJig.$.detailPanel.$.subjectFld.value).toEqual('');
		expect(panelTestJig.$.detailPanel.$.subjectFld.hasNode().innerHTML).toEqual('');
		expect(panelTestJig.$.detailPanel.$.datePicker.get('value')).toEqual(new Date(-22));
	});		

	it('should fire updateItem on subject field input event', function () {
		var item = {key: 24, subject: 'original subject'};		
		panelTestJig.$.detailPanel.setItem(item);
		expect(panelTestJig.$.detailPanel.$.subjectFld.value).toEqual('original subject');
		
		panelTestJig.$.detailPanel.$.subjectFld.bubble('oninput');
		expect(panelTestJig.panelUpdateItemResponse.key).toEqual(24);
		expect(panelTestJig.panelUpdateItemResponse.oldProps).toEqual({subject: 'original subject'});
	});
		
	it('should fire updateItem on date picker change & use noon on selected day', function () {
		var item = {key: 30, sortKey: -100, subject: 'some subject'};		
		panelTestJig.$.detailPanel.setItem(item);
		expect(panelTestJig.$.detailPanel.$.datePicker.value.valueOf()).toEqual(100);
		
		panelTestJig.$.detailPanel.$.datePicker.bubble('onSelect', {value: new Date(2009,5,6,9)});
		expect(panelTestJig.panelUpdateItemResponse.key).toEqual(30);
		expect(panelTestJig.panelUpdateItemResponse.oldProps).toEqual({sortKey: -100});
		expect(new Date(-panelTestJig.panelUpdateItemResponse.item.sortKey)).toEqual(new Date(2009,5,6,12));
	});	
});

