/* unit and functional tests for ListPane.js for Serene Notes */
/*jsl:import ../source/ListPane.js */

describe('ListPane', function () {
	var div, listPane;
	beforeEach( function () {
		div = document.createElement("div");
		document.body.appendChild(div);
		listPane = new ListPane();
	});
	
	afterEach(function () {
		listPane.destroy();
		document.body.removeChild(div);
	});
	
	it('should be instantiable', function () {
		expect(listPane).toBeTruthy();

		listPane.renderInto(div);
		var listPaneNode = div.firstChild;
        expect(listPane.hasNode()).toEqual(listPaneNode);
		 
        expect(listPane.$.fittableColumns.hasNode()).toEqual(listPaneNode.firstChild);
 
        expect(listPane.$.prefToast.hasNode()).toEqual(listPaneNode.lastChild);
	});
	
	it('should allow inserting a note', function () {
		listPane.renderInto(div);
		expect(listPane.items.length).toEqual(0);
		expect(listPane.$.list.getCount()).toEqual(0);
		
		listPane.populate({items: [{subject: 'AAA'}, {subject: 'BBB'}], isSearch: false});
		expect(listPane.items.length).toEqual(2);
		expect(listPane.$.list.getCount()).toEqual(2);
		
		listPane.insert({subject: 'inserted note'});
		expect(listPane.$.list.getCount()).toEqual(3);
		expect(listPane.items[0].subject).toEqual('inserted note');
	});
	
	it('should allow fading out search text & count', function () {
		listPane.renderInto(div);
		// can't reliably test color of input text
//		expect(listPane.$.input.getComputedStyleValue('color')).toEqual('rgb(255, 255, 255)');
		expect(listPane.$.searchCount.getComputedStyleValue('color')).toEqual('rgb(0, 0, 0)');

		listPane.fadeSearchText(true);
//		expect(listPane.$.input.getComputedStyleValue('color')).toEqual('rgba(255, 255, 255, 0.5)');
		expect(listPane.$.searchCount.getComputedStyleValue('color')).toMatch(/transparent|rgba\(0, 0, 0, 0(.0)?\)|rgb\(0, 0, 0\)/);

		listPane.fadeSearchText(false);
//		expect(listPane.$.input.getComputedStyleValue('color')).toEqual('rgb(255, 255, 255)');
		expect(listPane.$.searchCount.getComputedStyleValue('color')).toEqual('rgb(0, 0, 0)');
	});

	it("should allow selection by key", function (done) {
		listPane.renderInto(div);
		spyOn(listPane.$.list, 'select');
		spyOn(listPane.$.list, 'scrollToRow');
		spyOn(listPane, 'doSetDetailsItem');
		listPane.scrollToKeyWhenDisplayed([99, 223, 127]);
		listPane.populate({items: [
			{key:22, sortKey:22, subject:"foo"},
			{key:48, sortKey:48, subject:"bar"},
			{key:127, sortKey:127, subject:"spam"},
			{key:223, sortKey:223, subject:"frotz"},
			{key:409, sortKey:409, subject:"baz"}
		]});
		setTimeout(function () {
			expect(listPane.$.list.select.calls.count()).toEqual(1);
			expect(listPane.$.list.select.calls.argsFor(0)).toEqual([2]);
			expect(listPane.$.list.scrollToRow.calls.count()).toBe(1);
			expect(listPane.$.list.scrollToRow.calls.argsFor(0)).toEqual([2]);
			expect(listPane.doSetDetailsItem.calls.count()).toEqual(1);
			expect(listPane.doSetDetailsItem.calls.argsFor(0)).toEqual([{item: {key:127, sortKey:127, subject:"spam"}}]);
			done();
		}, 0);
	});
	
	it('should display prefToast with passed question & set passed pref', function () {
		listPane.renderInto(div);
		expect(listPane.$.prefToast.showing).toEqual(false);
		
		listPane.showPrefToast('foo', 'Enable foo?');
		expect(listPane.$.prefToast.showing).toEqual(true);
		expect(listPane.$.prefToastQuestion.content).toEqual('Enable foo?');
		
		var prefChangeSpy = spyOn(listPane, 'doPrefChange');
		listPane.$.prefToastYesBtn.bubble('ontap');
		expect(prefChangeSpy).toHaveBeenCalled();
		expect(prefChangeSpy).toHaveBeenCalledWith({key: "foo", value: true});
	});
});
