/* unit & functional tests for PrefHelpPanel.js (Serene Notes) 
 * Copyright © 2015 Hominid Software */
/*jsl:import ../source/PrefHelpPanel.js */

var PrefHelpPanelTestJig = enyo.kind({
	name: "PrefHelpPanelTestJig",
	panelPrefChangeResponse: null,
	components: [
		{	kind: "PrefHelpPanel", 
			onPrefChange: "panelPrefChange"
		}
	],
	panelPrefChange: function (inSender, inResponse) {
		this.log(inResponse);
		this.panelPrefChangeResponse = inResponse;
	}
});


describe('Preferences & Help Panel', function () {
	var div, prefHelpJig;
		
	beforeEach( function () {
	    div = document.createElement("div");
		document.body.appendChild(div);
		prefHelpJig = new PrefHelpPanelTestJig();
		prefHelpJig.renderInto(div);
	});
	
	afterEach(function () {
		prefHelpJig.destroy();
		document.body.removeChild(div);
	});
		
	it('allows setting all pref UI', function () {
		expect(prefHelpJig.$.prefHelpPanel.$.geotagOnCreateTgl.getValue()).toEqual(false);
		expect(prefHelpJig.$.prefHelpPanel.$.backupNightlyTgl.getValue()).toEqual(false);
		prefHelpJig.$.prefHelpPanel.setAllPrefs(null, {geotagOnCreate: true, backupNightly: true});
		expect(prefHelpJig.$.prefHelpPanel.$.geotagOnCreateTgl.getValue()).toEqual(true);
		expect(prefHelpJig.$.prefHelpPanel.$.backupNightlyTgl.getValue()).toEqual(true);
	});
		
	it('displays undefined prefs as falsy', function () {
		prefHelpJig.$.prefHelpPanel.setAllPrefs(null, {geotagOnCreate: true, backupNightly: true});
		expect(prefHelpJig.$.prefHelpPanel.$.geotagOnCreateTgl.getValue()).toEqual(true);
		expect(prefHelpJig.$.prefHelpPanel.$.backupNightlyTgl.getValue()).toEqual(true);
		prefHelpJig.$.prefHelpPanel.setAllPrefs(null, {});
		expect(prefHelpJig.$.prefHelpPanel.$.geotagOnCreateTgl.getValue()).toEqual(false);
		expect(prefHelpJig.$.prefHelpPanel.$.backupNightlyTgl.getValue()).toEqual(false);
	});

	it('should send prefChanged when geotagOnCreate UI toggled', function () {
		prefHelpJig.$.prefHelpPanel.$.geotagOnCreateTgl.bubble('onChange', {value: false});
		expect(prefHelpJig.panelPrefChangeResponse.key).toEqual('geotagOnCreate');
		expect(prefHelpJig.panelPrefChangeResponse.value).toEqual(false);		
	});

	it('should send prefChanged when backupNightly UI toggled', function () {
		prefHelpJig.$.prefHelpPanel.$.backupNightlyTgl.bubble('onChange', {value: 42});
		expect(prefHelpJig.panelPrefChangeResponse.key).toEqual('backupNightly');
		expect(prefHelpJig.panelPrefChangeResponse.value).toEqual(42);		
	});	
});

