// Jasmine 2.2 unit tests for Serene Notes item
// Copyright © 2015 Hominid Software
/*jsl:import ../source/item.js */

describe('item functions', function () {
	var item;
	beforeEach( function () {
		item = {
			subject: 'ballistic phonon transport',
			sortKey: -1300000000000
		};
	});


	it('should be modifiable', function () {
		modifyItem(item, {subject: 'semiregular tesselation'});
		expect(item).toEqual(jasmine.objectContaining({subject: 'semiregular tesselation'}));
	});


	it('should move an item after another', function () {
		var afterThisItem = {
			subject: 'Nearer my God to thee',
			sortKey: -1200000000000
		};
		var changeDescriptor = moveAfter(item, afterThisItem);
		expect(item.sortKey).toEqual(-1199999999990);
		expect(changeDescriptor.item).toEqual(item);
		expect(changeDescriptor.oldProps).toEqual({sortKey: -1300000000000});
	});
	
	
	it('should move an item before another', function () {
		var beforeThisItem = {
			subject: 'What hath God wrought?',
			sortKey: -1200000000000
		};
		var changeDescriptor = moveBefore(item, beforeThisItem);
		expect(item.sortKey).toEqual(-1200000000010);
		expect(changeDescriptor.item).toEqual(item);
		expect(changeDescriptor.oldProps).toEqual({sortKey: -1300000000000});
	});

	
	it('should move an item between two others far apart', function () {
		var afterThisItem = {
			subject: 'Nearer my God to thee',
			sortKey: -1200000000000
		};
		var beforeThisItem = {
			subject: 'What hath God wrought?',
			sortKey: -1100000000000
		};
		var changeDescriptor = moveBetween(item, afterThisItem, beforeThisItem);
		expect(item.sortKey).toEqual(-1199999999990);
		expect(changeDescriptor.item).toEqual(item);
		expect(changeDescriptor.oldProps).toEqual({sortKey: -1300000000000});
	});

	
	it('should move an item between two others close', function () {
		var afterThisItem = {
			subject: 'Nearer my God to thee',
			sortKey: -1100000000010
		};
		var beforeThisItem = {
			subject: 'What hath God wrought?',
			sortKey: -1100000000000
		};
		var changeDescriptor = moveBetween(item, afterThisItem, beforeThisItem);
		expect(item.sortKey).toEqual(-1100000000005);
		expect(changeDescriptor.item).toEqual(item);
		expect(changeDescriptor.oldProps).toEqual({sortKey: -1300000000000});
	});
});
