/**
 * angular-translate - v1.1.1 - 2013-11-24
 * http://github.com/PascalPrecht/angular-translate
 * Copyright (c) 2013 ; Licensed
 */
angular.module('pascalprecht.translate', ['ng']).run([
    '$translate',
    function ($translate) {
        var key = $translate.storageKey(), storage = $translate.storage();
        if (storage) {
            if (!storage.get(key)) {
                if (angular.isString($translate.preferredLanguage())) {
                    $translate.uses($translate.preferredLanguage());
                } else {
                    storage.set(key, $translate.uses());
                }
            } else {
                $translate.uses(storage.get(key));
            }
        } else if (angular.isString($translate.preferredLanguage())) {
            $translate.uses($translate.preferredLanguage());
        }
    }
]);
angular.module('pascalprecht.translate').provider('$translate', [
    '$STORAGE_KEY',
    function ($STORAGE_KEY) {
        var $translationTable = {}, $preferredLanguage, $fallbackLanguage, $uses, $nextLang, $storageFactory, $storageKey = $STORAGE_KEY, $storagePrefix, $missingTranslationHandlerFactory, $interpolationFactory, $interpolatorFactories = [], $loaderFactory, $loaderOptions, $notFoundIndicatorLeft, $notFoundIndicatorRight, NESTED_OBJECT_DELIMITER = '.';
        var translations = function (langKey, translationTable) {
            if (!langKey && !translationTable) {
                return $translationTable;
            }
            if (langKey && !translationTable) {
                if (angular.isString(langKey)) {
                    return $translationTable[langKey];
                } else {
                    angular.extend($translationTable, flatObject(langKey));
                }
            } else {
                if (!angular.isObject($translationTable[langKey])) {
                    $translationTable[langKey] = {};
                }
                angular.extend($translationTable[langKey], flatObject(translationTable));
            }
            return this;
        };
        var flatObject = function (data, path, result, prevKey) {
            var key, keyWithPath, val;
            if (!path) {
                path = [];
            }
            if (!result) {
                result = {};
            }
            for (key in data) {
                if (!data.hasOwnProperty(key))
                    continue;
                val = data[key];
                if (angular.isObject(val)) {
                    flatObject(val, path.concat(key), result, key);
                } else {
                    keyWithPath = path.length ? '' + path.join(NESTED_OBJECT_DELIMITER) + NESTED_OBJECT_DELIMITER + key : key;
                    if (path.length && key === prevKey) {
                        keyWithShortPath = '' + path.join(NESTED_OBJECT_DELIMITER);
                        result[keyWithShortPath] = '@:' + keyWithPath;
                    }
                    result[keyWithPath] = val;
                }
            }
            return result;
        };
        this.translations = translations;
        this.addInterpolation = function (factory) {
            $interpolatorFactories.push(factory);
            return this;
        };
        this.useMessageFormatInterpolation = function () {
            return this.useInterpolation('$translateMessageFormatInterpolation');
        };
        this.useInterpolation = function (factory) {
            $interpolationFactory = factory;
            return this;
        };
        this.preferredLanguage = function (langKey) {
            if (langKey) {
                $preferredLanguage = langKey;
                return this;
            } else {
                return $preferredLanguage;
            }
        };
        this.translationNotFoundIndicator = function (indicator) {
            this.translationNotFoundIndicatorLeft(indicator);
            this.translationNotFoundIndicatorRight(indicator);
            return this;
        };
        this.translationNotFoundIndicatorLeft = function (indicator) {
            if (!indicator) {
                return $notFoundIndicatorLeft;
            }
            $notFoundIndicatorLeft = indicator;
            return this;
        };
        this.translationNotFoundIndicatorRight = function (indicator) {
            if (!indicator) {
                return $notFoundIndicatorRight;
            }
            $notFoundIndicatorRight = indicator;
            return this;
        };
        this.fallbackLanguage = function (langKey) {
            if (langKey) {
                if (typeof langKey === 'string' || angular.isArray(langKey)) {
                    $fallbackLanguage = langKey;
                } else {
                }
                return this;
            } else {
                return $fallbackLanguage;
            }
        };
        this.uses = function (langKey) {
            if (langKey) {
                if (!$translationTable[langKey] && !$loaderFactory) {
                    throw new Error('$translateProvider couldn\'t find translationTable for langKey: \'' + langKey + '\'');
                }
                $uses = langKey;
                return this;
            } else {
                return $uses;
            }
        };
        var storageKey = function (key) {
            if (!key) {
                if ($storagePrefix) {
                    return $storagePrefix + $storageKey;
                }
                return $storageKey;
            }
            $storageKey = key;
        };
        this.storageKey = storageKey;
        this.useUrlLoader = function (url) {
            return this.useLoader('$translateUrlLoader', { url: url });
        };
        this.useStaticFilesLoader = function (options) {
            return this.useLoader('$translateStaticFilesLoader', options);
        };
        this.useLoader = function (loaderFactory, options) {
            $loaderFactory = loaderFactory;
            $loaderOptions = options || {};
            return this;
        };
        this.useLocalStorage = function () {
            return this.useStorage('$translateLocalStorage');
        };
        this.useCookieStorage = function () {
            return this.useStorage('$translateCookieStorage');
        };
        this.useStorage = function (storageFactory) {
            $storageFactory = storageFactory;
            return this;
        };
        this.storagePrefix = function (prefix) {
            if (!prefix) {
                return prefix;
            }
            $storagePrefix = prefix;
            return this;
        };
        this.useMissingTranslationHandlerLog = function () {
            return this.useMissingTranslationHandler('$translateMissingTranslationHandlerLog');
        };
        this.useMissingTranslationHandler = function (factory) {
            $missingTranslationHandlerFactory = factory;
            return this;
        };
        this.$get = [
            '$log',
            '$injector',
            '$rootScope',
            '$q',
            function ($log, $injector, $rootScope, $q) {
                var Storage, defaultInterpolator = $injector.get($interpolationFactory || '$translateDefaultInterpolation'), pendingLoader = false, interpolatorHashMap = {};
                var loadAsync = function (key) {
                    if (!key) {
                        throw 'No language key specified for loading.';
                    }
                    var deferred = $q.defer();
                    $rootScope.$broadcast('$translateLoadingStart');
                    pendingLoader = true;
                    $injector.get($loaderFactory)(angular.extend($loaderOptions, { key: key })).then(function (data) {
                        $rootScope.$broadcast('$translateLoadingSuccess');
                        var translationTable = {};
                        if (angular.isArray(data)) {
                            angular.forEach(data, function (table) {
                                angular.extend(translationTable, table);
                            });
                        } else {
                            angular.extend(translationTable, data);
                        }
                        pendingLoader = false;
                        deferred.resolve({
                            key: key,
                            table: translationTable
                        });
                        $rootScope.$broadcast('$translateLoadingEnd');
                    }, function (key) {
                        $rootScope.$broadcast('$translateLoadingError');
                        deferred.reject(key);
                        $rootScope.$broadcast('$translateLoadingEnd');
                    });
                    return deferred.promise;
                };
                if ($storageFactory) {
                    Storage = $injector.get($storageFactory);
                    if (!Storage.get || !Storage.set) {
                        throw new Error('Couldn\'t use storage \'' + $storageFactory + '\', missing get() or set() method!');
                    }
                }
                if ($interpolatorFactories.length > 0) {
                    angular.forEach($interpolatorFactories, function (interpolatorFactory) {
                        var interpolator = $injector.get(interpolatorFactory);
                        interpolator.setLocale($preferredLanguage || $uses);
                        interpolatorHashMap[interpolator.getInterpolationIdentifier()] = interpolator;
                    });
                }
                var checkValidFallback = function (usesLang) {
                    if (usesLang && $fallbackLanguage) {
                        if (angular.isArray($fallbackLanguage)) {
                            var fallbackLanguagesSize = $fallbackLanguage.length;
                            for (var current = 0; current < fallbackLanguagesSize; current++) {
                                if ($uses === $translationTable[$fallbackLanguage[current]]) {
                                    return false;
                                }
                            }
                            return true;
                        } else {
                            return usesLang !== $fallbackLanguage;
                        }
                    } else {
                        return false;
                    }
                    return false;
                };
                var $translate = function (translationId, interpolateParams, interpolationId) {
                    var table = $uses ? $translationTable[$uses] : $translationTable, Interpolator = interpolationId ? interpolatorHashMap[interpolationId] : defaultInterpolator;
                    if (table && table.hasOwnProperty(translationId)) {
                        if (angular.isString(table[translationId]) && table[translationId].substr(0, 2) === '@:') {
                            return $translate(table[translationId].substr(2), interpolateParams, interpolationId);
                        }
                        return Interpolator.interpolate(table[translationId], interpolateParams);
                    }
                    if ($missingTranslationHandlerFactory && !pendingLoader) {
                        $injector.get($missingTranslationHandlerFactory)(translationId, $uses);
                    }
                    var normatedLanguages;
                    if ($uses && $fallbackLanguage && checkValidFallback($uses)) {
                        if (typeof $fallbackLanguage === 'string') {
                            normatedLanguages = [];
                            normatedLanguages.push($fallbackLanguage);
                        } else {
                            normatedLanguages = $fallbackLanguage;
                        }
                        var fallbackLanguagesSize = normatedLanguages.length;
                        for (var current = 0; current < fallbackLanguagesSize; current++) {
                            if ($uses !== $translationTable[normatedLanguages[current]]) {
                                var translationFromList = $translationTable[normatedLanguages[current]][translationId];
                                if (translationFromList) {
                                    var returnValFromList;
                                    Interpolator.setLocale(normatedLanguages[current]);
                                    returnValFromList = Interpolator.interpolate(translationFromList, interpolateParams);
                                    Interpolator.setLocale($uses);
                                    return returnValFromList;
                                }
                            }
                        }
                    }
                    if ($notFoundIndicatorLeft) {
                        translationId = [
                            $notFoundIndicatorLeft,
                            translationId
                        ].join(' ');
                    }
                    if ($notFoundIndicatorRight) {
                        translationId = [
                            translationId,
                            $notFoundIndicatorRight
                        ].join(' ');
                    }
                    return translationId;
                };
                $translate.preferredLanguage = function () {
                    return $preferredLanguage;
                };
                $translate.fallbackLanguage = function () {
                    return $fallbackLanguage;
                };
                $translate.proposedLanguage = function () {
                    return $nextLang;
                };
                $translate.storage = function () {
                    return Storage;
                };
                $translate.uses = function (key) {
                    if (!key) {
                        return $uses;
                    }
                    var deferred = $q.defer();
                    $rootScope.$broadcast('$translateChangeStart');
                    function useLanguage(key) {
                        $uses = key;
                        $rootScope.$broadcast('$translateChangeSuccess');
                        if ($storageFactory) {
                            Storage.set($translate.storageKey(), $uses);
                        }
                        defaultInterpolator.setLocale($uses);
                        angular.forEach(interpolatorHashMap, function (interpolator, id) {
                            interpolatorHashMap[id].setLocale($uses);
                        });
                        deferred.resolve(key);
                        $rootScope.$broadcast('$translateChangeEnd');
                    }

                    if (!$translationTable[key] && $loaderFactory) {
                        $nextLang = key;
                        loadAsync(key).then(function (translation) {
                            $nextLang = undefined;
                            translations(translation.key, translation.table);
                            useLanguage(translation.key);
                        }, function (key) {
                            $nextLang = undefined;
                            $rootScope.$broadcast('$translateChangeError');
                            deferred.reject(key);
                            $rootScope.$broadcast('$translateChangeEnd');
                        });
                    } else {
                        useLanguage(key);
                    }
                    return deferred.promise;
                };
                $translate.storageKey = function () {
                    return storageKey();
                };
                $translate.refresh = function (langKey) {
                    if (!$loaderFactory) {
                        throw new Error('Couldn\'t refresh translation table, no loader registered!');
                    }
                    var deferred = $q.defer();

                    function onLoadSuccess() {
                        deferred.resolve();
                        $rootScope.$broadcast('$translateRefreshEnd');
                    }

                    function onLoadFailure() {
                        deferred.reject();
                        $rootScope.$broadcast('$translateRefreshEnd');
                    }

                    if (!langKey) {
                        $rootScope.$broadcast('$translateRefreshStart');
                        var loaders = [];
                        if ($fallbackLanguage) {
                            if (typeof $fallbackLanguage === 'string') {
                                loaders.push(loadAsync($fallbackLanguage));
                            } else {
                                var fallbackLanguagesSize = $fallbackLanguage.length;
                                for (var current = 0; current < fallbackLanguagesSize; current++) {
                                    loaders.push(loadAsync($fallbackLanguage[current]));
                                }
                            }
                        }
                        if ($uses) {
                            loaders.push(loadAsync($uses));
                        }
                        if (loaders.length > 0) {
                            $q.all(loaders).then(function (newTranslations) {
                                for (var lang in $translationTable) {
                                    if ($translationTable.hasOwnProperty(lang)) {
                                        delete $translationTable[lang];
                                    }
                                }
                                for (var i = 0, len = newTranslations.length; i < len; i++) {
                                    translations(newTranslations[i].key, newTranslations[i].table);
                                }
                                if ($uses) {
                                    $translate.uses($uses);
                                }
                                onLoadSuccess();
                            }, function (key) {
                                if (key === $uses) {
                                    $rootScope.$broadcast('$translateChangeError');
                                }
                                onLoadFailure();
                            });
                        } else
                            onLoadSuccess();
                    } else if ($translationTable.hasOwnProperty(langKey)) {
                        $rootScope.$broadcast('$translateRefreshStart');
                        var loader = loadAsync(langKey);
                        if (langKey === $uses) {
                            loader.then(function (newTranslation) {
                                $translationTable[langKey] = newTranslation.table;
                                $translate.uses($uses);
                                onLoadSuccess();
                            }, function () {
                                $rootScope.$broadcast('$translateChangeError');
                                onLoadFailure();
                            });
                        } else {
                            loader.then(function (newTranslation) {
                                $translationTable[langKey] = newTranslation.table;
                                onLoadSuccess();
                            }, onLoadFailure);
                        }
                    } else
                        deferred.reject();
                    return deferred.promise;
                };
                if ($loaderFactory) {
                    if (angular.equals($translationTable, {})) {
                        $translate.uses($translate.uses());
                    }
                    if ($fallbackLanguage) {
                        if (typeof $fallbackLanguage === 'string' && !$translationTable[$fallbackLanguage]) {
                            loadAsync($fallbackLanguage);
                        } else {
                            var fallbackLanguagesSize = $fallbackLanguage.length;
                            for (var current = 0; current < fallbackLanguagesSize; current++) {
                                if (!$translationTable[$fallbackLanguage[current]]) {
                                    loadAsync($fallbackLanguage[current]);
                                }
                            }
                        }
                    }
                }
                return $translate;
            }
        ];
    }
]);
angular.module('pascalprecht.translate').factory('$translateDefaultInterpolation', [
    '$interpolate',
    function ($interpolate) {
        var $translateInterpolator = {}, $locale, $identifier = 'default';
        $translateInterpolator.setLocale = function (locale) {
            $locale = locale;
        };
        $translateInterpolator.getInterpolationIdentifier = function () {
            return $identifier;
        };
        $translateInterpolator.interpolate = function (string, interpolateParams) {
            return $interpolate(string)(interpolateParams);
        };
        return $translateInterpolator;
    }
]);
angular.module('pascalprecht.translate').constant('$STORAGE_KEY', 'NG_TRANSLATE_LANG_KEY');
angular.module('pascalprecht.translate').directive('translate', [
    '$filter',
    '$interpolate',
    '$parse',
    function ($filter, $interpolate, $parse) {
        var translate = $filter('translate');
        return {
            restrict: 'AE',
            scope: true,
            link: function linkFn(scope, element, attr) {
                if (attr.translateInterpolation) {
                    scope.interpolation = attr.translateInterpolation;
                }
                attr.$observe('translate', function (translationId) {
                    if (angular.equals(translationId, '') || translationId === undefined) {
                        scope.translationId = $interpolate(element.text().replace(/^\s+|\s+$/g, ''))(scope.$parent);
                    } else {
                        scope.translationId = translationId;
                    }
                });
                attr.$observe('translateValues', function (interpolateParams) {
                    if (interpolateParams)
                        scope.$parent.$watch(function () {
                            scope.interpolateParams = $parse(interpolateParams)(scope.$parent);
                        });
                });
                scope.$on('$translateChangeSuccess', function () {
                    element.html(translate(scope.translationId, scope.interpolateParams, scope.interpolation));
                });
                scope.$watch('[translationId, interpolateParams]', function (nValue) {
                    if (scope.translationId) {
                        element.html(translate(scope.translationId, scope.interpolateParams, scope.interpolation));
                    }
                }, true);
            }
        };
    }
]);
angular.module('pascalprecht.translate').filter('translate', [
    '$parse',
    '$translate',
    function ($parse, $translate) {
        return function (translationId, interpolateParams, interpolation) {
            if (!angular.isObject(interpolateParams)) {
                interpolateParams = $parse(interpolateParams)();
            }
            return $translate(translationId, interpolateParams, interpolation);
        };
    }
]);