'use strict';
var lenguaje = window.navigator.userLanguage || window.navigator.language;
angular.module('seetiesApp', [
    'ionic',
    'ngCookies',
    'ngResource',
    'ngSanitize',
    'ngRoute',
    'ngTouch',
    'ngAnimate',
    'geolocation',
    'pascalprecht.translate',
    'jmdobry.angular-cache'
]).config([
    '$angularCacheFactoryProvider',
    function ($angularCacheFactoryProvider) {
        $angularCacheFactoryProvider.setCacheDefaults({
            capacity: 10000,
            maxAge: 86400000,
            deleteOnExpire: 'aggressive',
            recycleFreq: 900000,
            cacheFlushInterval: 129600000,
            storageMode: 'localStorage',
            verifyIntegrity: true,
            onExpire: function (key, value) {
                $http.get(key).success(function (data) {
                    cache.put(key, data);
                });
            }
        });
    }
]).config([
    '$httpProvider',
    function ($httpProvider) {
        $httpProvider.defaults.cache = true;
        delete $httpProvider.defaults.headers.common['X-Requested-With'];
    }
]).run([
    '$angularCacheFactory',
    '$http',
    function ($angularCacheFactory, $http) {
        var cache = $angularCacheFactory('apiCache');
        $http.defaults.cache = $angularCacheFactory.get('apiCache');
    }
])/*.config([
    '$routeProvider',
    function ($routeProvider) {
        $routeProvider.when('/', {
            templateUrl: 'views/main.html',
            controller: 'MainCtrl'
        }).when('/s', {
            templateUrl: 'views/busqueda.html',
            controller: 'BusquedaCtrl'
        }).when('/s/:q', {
            templateUrl: 'views/busqueda.html',
            controller: 'BusquedaCtrl'
        }).when('/user', {
            templateUrl: 'views/user.html',
            controller: 'UserCtrl'
        }).when('/user/:id', {
            templateUrl: 'views/user.html',
            controller: 'UserCtrl'
        }).when('/plat', {
            templateUrl: 'views/plat.html',
            controller: 'PlatCtrl'
        }).when('/about', {
            templateUrl: 'views/about.html',
            controller: 'AboutCtrl'
        }).when('/fav', {
            templateUrl: 'views/fav.html',
            controller: 'FavCtrl'
        }).when('/hist', {
            templateUrl: 'views/hist.html',
            controller: 'HistCtrl'
        }).when('/legal', {
            templateUrl: 'views/legal.html',
            controller: 'LegalCtrl'
        }).otherwise({ redirectTo: '/' });
    }
])*/.config(function($stateProvider, $urlRouterProvider){
    $stateProvider
        .state('main', {
            url: "/",
            templateUrl: 'views/main.html',
            controller: 'MainCtrl'
        })
        .state('busqueda', {
            url: "/s",
            templateUrl: 'views/busqueda.html',
            controller: 'BusquedaCtrl'
        })
        .state('busquedaparam', {
            url: "/s/:q",
            templateUrl: 'views/busqueda.html',
            controller: 'BusquedaCtrl'
        })
        .state('user', {
            url: "/user",
            templateUrl: 'views/user.html',
            controller: 'UserCtrl'
        })
        .state('about', {
            url: "/about",
            templateUrl: 'views/about.html',
            controller: 'AboutCtrl'
        })
        .state('fav', {
            url: "/fav",
            templateUrl: 'views/fav.html',
            controller: 'FavCtrl'
        })
        .state('hist', {
            url: "/hist",
            templateUrl: 'views/hist.html',
            controller: 'HistCtrl'
        })
        .state('legal', {
            url: "/legal",
            templateUrl: 'views/legal.html',
            controller: 'LegalCtrl'
        });

    $urlRouterProvider.otherwise('/');
}).config([
    '$compileProvider',
    function ($compileProvider) {
        $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|chrome-extension|app):/);
    }
]).config([
    '$translateProvider',
    function ($translateProvider) {
        $translateProvider.translations('es', traduccion_es);
        $translateProvider.translations('en', traduccion_en);
        $translateProvider.preferredLanguage(lenguaje.substr(0, 2));
        $translateProvider.fallbackLanguage('es');
    }
]).controller('indexCtrl', function ($scope, geolocation, $location, PoiModal, $ionicModal, apiconnect, $ionicSideMenuDelegate, lugarModal, $ionicScrollDelegate) {
    var mijson;
    $scope.iconURI = "data:image/png;base64,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"
    $scope.headerTitle = '<img height="35px" ng-click="sideMenuController.toggleLeft()" src="' + $scope.iconURI + '"/><em>Seeties</em> - Descubre tu mundo';

    $scope.scrollToTop = function() {
        $ionicScrollDelegate.$getByHandle('articulo').scrollTop(true);
    };

    apiconnect.data.locationlist(null, function (data) {
        $scope.ciudades = data;
    });

    $scope.sideMenuController = $ionicSideMenuDelegate;

    $ionicModal.fromTemplateUrl('imagengrande.html', {
        scope: $scope,
        animation: ''
    }).then(function(modal){
        $scope.imagenGrande = modal;
    });

    $scope.abrirImagenGrande = function(img) {
        $scope.imagenMostradaEnGrande = img;
        $scope.imagenGrande.show();
    };

    $scope.cerrarImagenGrande = function() {
        $scope.imagenGrande.hide();
    };

    $scope.abrirEnlaceExterno = function(enlace){
        window.open(enlace, '_blank');
    };

    $scope.url = function(enlace){
        window.open(enlace, '_blank');
    };

    $scope.appStarted = window.localStorage['didTutorial'] == 'true';
    $scope.isAppStarted = function () {
        return $scope.appStarted;
    };
    $scope.closeModalPoi = function () {
        PoiModal.closeModalPoi();
    };
    $scope.closeModalLugar = function (ciudad) {
        if (ciudad) {
            geolocation.ciudad = ciudad['id-location'];
            geolocation.nombreCiudad = ciudad.name;
        }
        lugarModal.closeModalLugar();
    };
    $scope.isRuta = function (ruta) {
        return $location.path() == ruta;
    };
    $scope.toggleFavorito = function () {
        if ($scope.favorito) {
            mijson = JSON.parse(localStorage.favoritos);
            mijson[PoiModal.id] = false;
            localStorage.favoritos = JSON.stringify(mijson);
        } else {
            mijson = JSON.parse(localStorage.favoritos);
            mijson[PoiModal.id] = true;
            localStorage.favoritos = JSON.stringify(mijson);
        }
        $scope.favorito = !$scope.favorito;
    };
    $scope.generarEstiloImagen = function (link) {
        return { background: 'url(' + link + ') 50% 50% no-repeat', 'margin-right': '3px' };
    };
    $ionicModal.fromTemplateUrl('poi.html', function (modal) {
        $scope.modalPoi = modal;
    }, {
        scope: $scope,
        animation: 'slide-in-up'
    });
    PoiModal.openModalPoi = function () {
        $ionicScrollDelegate.scrollTop(false);
        $scope.articulo = undefined;
        apiconnect.data.article([
            PoiModal.id,
            PoiModal.lang
        ], function (data) {
            $scope.articulo = data;
            $scope.articulo.imgmapaurl = 'http://www.mapquestapi.com/staticmap/v4/getmap?key=Fmjtd%7Cluur296rnq%2Can%3Do5-90rsq0&center=' + $scope.articulo.latitude + ',' + $scope.articulo.longitude + '&zoom=15&size=150,170&type=map&imagetype=jpeg&scalebar=false&pois=x,' + $scope.articulo.latitude + ',' + $scope.articulo.longitude;
            $scope.articulo.estilomapa = {
                background: 'url(' + $scope.articulo.imgmapaurl + ') 50% 50% no-repeat',
                'min-height': '170px'
            };
            var saddr = 'saddr=' + geolocation.getLocation[0] + ',' + geolocation.getLocation[1] + '&';
            var daddr = 'daddr=' + data.latitude + ',' + data.longitude;
            $scope.articulo.linkmapa = 'http://maps.google.com/?' + daddr;
        });
        $scope.modalPoi.show();
        if (localStorage.favoritos && JSON.parse(localStorage.favoritos)[PoiModal.id]) {
            $scope.favorito = true;
        } else {
            $scope.favorito = false;
            if (!localStorage.favoritos) {
                mijson = { id: false };
                localStorage.favoritos = JSON.stringify(mijson);
            }
        }
    };
    $ionicModal.fromTemplateUrl('lugares.html', function (modal) {
        $scope.modalLugar = modal;
    }, {
        scope: $scope,
        animation: 'slide-in-up'
    });
    lugarModal.openModalLugar = function () {
        $scope.modalLugar.show();
    };
    PoiModal.closeModalPoi = function () {
        $scope.modalPoi.hide();
    };
    lugarModal.closeModalLugar = function () {
        $scope.modalLugar.hide();
    };
    $scope.navegarIzda = function (destino) {
        $location.path(destino);
        $scope.sideMenuController.toggleLeft();
    };
    $scope.leftButtonTap = function () {
       $scope.sideMenuController.toggleLeft();
    };
}).controller('introCtrl', function ($scope) {
    var startApp = function () {
        window.localStorage['didTutorial'] = true;
        $scope.didTutorial = true;
    };
    $scope.login = function () {
        //navigator.id.request();
        //if(!PersonaBeacon.nologueado) window.localStorage['didTutorial'] = true;
        startApp();
    };
    if (window.localStorage['didTutorial'] === 'true') {
        startApp();
        return;
    }
    startApp();
    // Esto hace que no aparezcan las diapositivas. Quitar cuando quieran ponerse.
    $scope.next = function () {
        $scope.$broadcast('slideBox.nextSlide');
    };
    var rightButtons = [
        {
            content: 'Siguiente',
            type: 'button-positive button-clear',
            tap: function (e) {
                $scope.next();
            }
        }
    ];
    var leftButtons = [
        {
            content: 'Saltar',
            type: 'button-positive button-clear',
            tap: function (e) {
                startApp();
            }
        }
    ];
    $scope.leftButtons = leftButtons;
    $scope.rightButtons = rightButtons;
    $scope.slideChanged = function (index) {
        if (index > 0) {
            $scope.leftButtons = [
                {
                    content: 'Atr\xe1s',
                    type: 'button-positive button-clear',
                    tap: function (e) {
                        $scope.$broadcast('slideBox.prevSlide');
                    }
                }
            ];
        } else {
            $scope.leftButtons = leftButtons;
        }
        if (index == 2) {
            $scope.rightButtons = [
                {
                    content: 'Comienza a usar Seeties',
                    type: 'button-positive button-clear',
                    tap: function (e) {
                        startApp();
                    }
                }
            ];
        } else {
            $scope.rightButtons = rightButtons;
        }
    };
})
.directive('dynamic', function($compile){
        return {
            restrict: 'A',
            replace: true,
            link: function (scope, ele, attrs) {
                scope.$watch(attrs.dynamic, function(html) {
                    ele.html(html);
                    $compile(ele.contents())(scope);
                });
            }
        };
    })
.run(function($ionicPlatform) {
        $ionicPlatform.ready(function () {
            setTimeout(function () {
                navigator.splashscreen.hide();
            }, 1000);
        })
    });
