'use strict';

angular.module('seetiesApp')
    .controller('MainCtrl', function ($scope, SearchQuery, geolocation, apiconnect, PoiModal, lugarModal, $rootScope) {
        $scope.data = SearchQuery;
        $scope.geolocation = geolocation;

        Number.prototype.toRad = function () {
            return this * Math.PI / 180;
        };

        $scope.abrirArticulo = function (resultado) {
            var id = resultado['id-article'];
            var lang = resultado.language;
            PoiModal.id = id;
            PoiModal.lang = lang;
            PoiModal.openModalPoi();
        };

        function distancia(coordinates0, coordinates1) {
            var R = 6371; // Radius of the earth in km
            var dLat = (coordinates1[1] - coordinates0[1]).toRad(); // Javascript functions in radians
            var dLon = (coordinates1[0] - coordinates0[0]).toRad();
            var a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.cos(coordinates0[1].toRad()) * Math.cos(coordinates1[1].toRad()) * Math.sin(dLon / 2) * Math.sin(dLon / 2);
            return R * 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a)) * 1000; // Distance in meters
        }

        var tratarResultados = function (data, scope, result) {
            var resultados = [];
            var yaFiltrado = [];

            angular.forEach(data, function (arrayvalue, key) {
                if (yaFiltrado.indexOf(key) <= -1) {
                    for (var i = 0; i < 4; i++) {
                        for (var j = 0; j < arrayvalue.length; j++) {
                            if (yaFiltrado.indexOf(key) <= -1) {
                                if (arrayvalue[j].language == SearchQuery.lang[i]) {
                                    arrayvalue[j]['id-article'] = key;
                                    this.push(arrayvalue[j]);
                                    yaFiltrado.push(key);
                                }
                            }
                        }
                    }
                }

                if (yaFiltrado.indexOf(key) <= -1) {
                    this.push(arrayvalue[0]);
                }
            }, resultados);

            geolocation.getLocation().then(function (pos) {
                var localizacion = [pos.coords.latitude, pos.coords.longitude];
                angular.forEach(resultados, function (value, key) {
                    if (value.latitude && value.longitude) {
                        value.distancia = distancia(localizacion, [value.latitude, value.longitude]);
                    }
                });
            }, function (reason) {
                console.log(reason)
            });

            angular.forEach(resultados, function(value, key){
                apiconnect.data.article([value['id-article'], 'es'], function(art){
                    value.images = art.images;
                })
            });

            scope[result] = resultados;

            scope.predicate = 'distancia';
            scope.reverse = false;
        };

        var peticionList = function (idciudad) {
            apiconnect.data.list([idciudad], function (data) {
                if (data) {
                    tratarResultados(data, $scope, 'monumentos');
                } else {
                    $scope.resultados = [];
                }
            });
        };

        function geolocalizaCiudad() {
            geolocation.getLocation().then(function (position) {
                apiconnect.data.location([position.coords.latitude, position.coords.longitude], function (data) {
                    geolocation.ciudad = data.id;
                    geolocation.nombreCiudad = data.name;
                });
            }, function (reason) {
                console.log(reason);
                if(!geolocation.ciudad) {
                    lugarModal.openModalLugar();
                }
            });
        }

        $scope.$watch(function () {
            return geolocation.ciudad
        }, function () {
            if(geolocation.ciudad){
                peticionList(geolocation.ciudad);
            } else {
                geolocalizaCiudad();
            }
        });

/*        $scope.$watch(function () {
            return geolocation.ciudad;
        }, function () {
            if(geolocation.ciudad) {
                apiconnect.data.list([geolocation.ciudad], function (lista) {
                    var monumentos = [];
                    angular.forEach(lista, function (val, key) {
                        var articulo;
                        var esto = this;
                        apiconnect.data.article([key, 'es'], function (art) {
                            articulo = art;
                            esto.push(articulo);
                            $scope.monumentos = monumentos;
                        })
                    }, monumentos);
                })
            }
        });*/


        $scope.tieneImagen = function (item){
            return !!item.images[0];
        };

        if(!geolocation.ciudad) {
            geolocalizaCiudad();
        }

        var calcularDistancias = function(){
            geolocation.getLocation().then(function (pos) {
                var localizacion = [pos.coords.latitude, pos.coords.longitude];
                angular.forEach($scope.resultados, function (value, key) {
                    if (value.latitude && value.longitude) {
                        value.distancia = distancia(localizacion, [value.latitude, value.longitude]);
                    }
                });
            }, function (reason) {
                console.log(reason)
            });
        }

        var temporizador = setInterval(calcularDistancias, 5000);

        $rootScope.$on('$stateChangeStart',
            function(event, toState, toParams, fromState, fromParams){
                window.clearInterval(temporizador);
            }
        );


        /*var container = document.querySelector('#supergrid');
        var msnry = new Masonry(container, {
            "itemSelector": ".gridimg"
        })*/
    });
