'use strict';

/*
 Servicio apiconnect.


 Configurar las variables del servicio de acuerdo con la configuración
 del servidor.

 Devuelve un objeto con funciones, una por cada método de la API.

 Todas las funciones reciben como primer argumento un array de parámetros
 y como segundo argumento, la función de callback.

 Los parámetros se pasan en plano y la conversión se hace en el sevicio.

 La llamada sería, tras inyectar el servicio:

 apiconnect.seccion.metodo_elegido(params, function(data){
 return do_something_with(data);
 });

 */


angular.module('seetiesApp')
    .factory('apiconnect', function ($http) {
        var baseURL = "http://gcdc2013-seeties.appspot.com/api/";

        return {
            data: {
                location: function (params, callback) {
                    var direccion = baseURL + "data/" + "location/" + window.btoa(params[0]) + "/" + window.btoa(params[1]);
                    $http.get(direccion)
                        .success(function (data) {
                            callback(data);
                        });
                },

                list: function (params, callback) {
                    var direccion = baseURL + "data/" + "list/" + parseInt(params[0]).toString(36);
                    $http.get(direccion)
                        .success(function (data, code) {
                            if (code != 204) {
                                callback(data);
                            } else {
                                callback(false);
                            }
                        });
                },

                article: function (params, callback) {
                    var direccion = baseURL + "data/" + "article/" + parseInt(params[0]).toString(36) + "/" + params[1];
                    $http.get(direccion)
                        .success(function (data) {
                            callback(data);
                        });
                },

                search: function (params, callback) {
                    var b64string = window.btoa(unescape(encodeURIComponent(params[0])));
                    var direccion = baseURL + "data/" + "search/" + b64string;
                    // b64->utf8 : decodeURIComponent(escape(window.atob( str )));
                    $http.get(direccion)
                        .success(function (data) {
                            callback(data);
                        });
                },

                locationlist: function (params, callback) {
                    var direccion = baseURL + "data/" + "locationlist/";
                    $http.get(direccion)
                        .success(function (data) {
                            callback(data);
                        });
                }
            },

            platform: {
                articlelist: function (params, callback) {
                    $http.get(baseURL + "platform/" + "articlelist/")
                        .success(function (data) {
                            callback(data);
                        });
                },

                userlist: function (params, callback) {
                    $http.get(baseURL + "platform/" + "userlist/")
                        .success(function (data) {
                            callback(data);
                        });
                },

                contact: function (params, callback) {
                    $http.get(baseURL + "platform/" + "contact/")
                        .success(function (data) {
                            callback(data);
                        });
                },

                deassignuser: function (params, callback) {
                    var xsrf = $.param({"id-article": params[0]});
                    var xsrf2 = $.param({ "id-article": params[0], "state": 0 });

                    $http({
                        method: 'POST',
                        url: baseURL + "platform/" + "deassignuser",
                        data: xsrf,
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'}
                    })
                        .success(function () {
                            $http({
                                method: 'POST',
                                url: baseURL + "platform/" + "changestate",
                                data: xsrf2,
                                headers: {'Content-Type': 'application/x-www-form-urlencoded'}
                            });
                            callback();
                        });
                },

                assignuser: function (params, callback) {
                    var xsrf = $.param({"id-user": params[0], "id-article": params[1]});
                    var xsrf2 = $.param({ "id-article": params[1], "state": 1 });

                    $http({
                        method: 'POST',
                        url: baseURL + "platform/" + "assignuser",
                        data: xsrf,
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'}
                    })
                        .success(function () {
                            $http({
                                method: 'POST',
                                url: baseURL + "platform/" + "changestate",
                                data: xsrf2,
                                headers: {'Content-Type': 'application/x-www-form-urlencoded'}
                            });
                            callback();
                        });
                },

                user: function (params, callback) {
                    $http.get(baseURL + "platform/" + "user")
                        .success(function (data) {
                            callback(data);
                        });
                }
            }
        }
    });
