'use strict';

/*
 Servicio geolocalizacion.
 */

angular.module('geolocation', [])
    .factory('geolocation', ['$q', function ($q) {
        return {
            getLocation: function () {
                var deferred = $q.defer();
                window.navigator.geolocation.getCurrentPosition(function (position) {
                    deferred.resolve(position);
                }, function (error) {
                    deferred.reject("No se puede conseguir la localización: " + error);
                }, {enableHighAccuracy: false, timeout: 10000, maximumAge: 0});
                return deferred.promise;
            },
            ciudad: null,
            nombreCiudad: null
        };
    }]);