var AppRouter = Backbone.Router.extend({
	routes: {
	    ""                  : "intro",
	    "regole"            : "regole",
	    "carte"             : "list",
	    "carte/page/:page"  : "list",
	    "culture"           : "culture",
	    "culture/:cultura"  : "culture",
	    "turchi"            : "turchi"
	},

  initialize: function () {
    this.headerView = new HeaderView();
    $('#header').html(this.headerView.el);

    //track every route change as a page view in google analytics
    if (typeof ga !== 'undefined') this.bind('route', this.trackPageview);
  },

	trackPageview: function () {
    var url = Backbone.history.getFragment();
    //prepend slash
    if (!/^\//.test(url) && url != "") { url = "/" + url; }
    ga('send', 'pageview', url);
	},

	list: function(page) {
        var p = page ? parseInt(page, 10) : 1;
        var cardList = new CardCollection();
        cardList.fetch({success: function(){
            $("#content").html(new CardListView({model: cardList, page: p}).el);
        }});
        this.headerView.selectMenuItem('carte');
    },
	turchi: function(page) {
        var cardTurchiList = new CardTurchiCollection();
        cardTurchiList.fetch({success: function(){
            $("#content").html(new CardTurchiListView({model: cardTurchiList}).el);
        }});
        this.headerView.selectMenuItem('expansioni');
    },

	culture: function(cultura) {
        var c = cultura ? cultura : "";
        var cardList = new CardCollection();
        cardList.fetch({success: function(){
            $("#content").html(new CultureListView({model: cardList, cultura: c}).el);
        }});
        this.headerView.selectMenuItem('culture');
    },

    intro: function () {
        if (!this.introView) { this.introView = new IntroView(); }
        $('#content').html(this.introView.el);
        this.headerView.selectMenuItem('intro');
    },

    regole: function () {
        if (!this.regoleView) { this.regoleView = new RegoleView(); }
        $('#content').html(this.regoleView.el);
        this.headerView.selectMenuItem('regole');
    }
});


function startEverything () {
  Backbone.$.ajaxSettings.xhr = function () {
    return new window.XMLHttpRequest({mozSystem: true})
  };
  
  // FIREFOX OS CROSS-DOMAIN AJAX SUPPORT
  //$.ajaxSetup({  xhr: function() {return new window.XMLHttpRequest({mozSystem: true});} })
  $.ajaxSetup({  xhrFields: { mozSystem: true } });
  
  utils.loadTemplate(['HeaderView', 'CardListItemView', 'RegoleView', 'IntroView'], function() {
    app = new AppRouter();
    Backbone.history.start();
  });

/*
  // FACEBOOK
  (function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = "//connect.facebook.net/it_IT/all.js#xfbml=1&appId=168869753144600";
    fjs.parentNode.insertBefore(js, fjs);
  }(document, "script", "facebook-jssdk"));

  // TWITTER
  !function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="https://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");
*/
  // SUL DB IL TESTO DELLE CARTE CARICATO IN AJAX E' IN ISO-8859-1
  $(function() {
  	$.ajaxSetup({
  	    'beforeSend' : function(xhr) {
  	        xhr.overrideMimeType('text/html; charset=ISO-8859-1');
  	    }
  	});
  });
}

function init() {
  document.addEventListener("deviceready", startEverything, false); 
  //$(function() { startEverything(); });
}

window.onload = init;