window.CardListView = Backbone.View.extend({
    initialize: function (options) {
        this.options = options || {};
        this.render();
    },
    render: function () {
        var cards = this.model.models;
        var len = cards.length;
        var startPos = (this.options.page - 1) * 10;
        var endPos = Math.min(startPos + 10, len);

        $(this.el).html('<h1>Elenco delle Carte</h1>\
Clicca sul nome della carta per visualizzarla. <a href="http://seicento.info/stampatutti.php" target="_blank">Clicca qui per stamparle tutte</a>.<br />\
<span class="label label-warning">Nota</span> Per stampare anche il retro delle carte, trovi <a href="http://seicento.info/stampatutti_retro.php" target="_blank"> qui una pagina con nove pezzi</a> pronti da tagliare!<br /><br />\
<table id="elenco_carte" class="table table-striped table-bordered"></table>');

        //$('#elenco_carte', this.el).append('<tr><th>Tipo e Cultura</th><th>Carta</th></tr>');

        for (var i = startPos; i < endPos; i++) {
		// FORMATTAZIONE NUMERO COPIE CARTA
		cards[i].attributes.ncopie_mostrato = (cards[i].attributes.ncopie>1) ? '('+cards[i].attributes.ncopie+' copie nel mazzo)' : '';
		cards[i].attributes.nome_lower = (cards[i].attributes.nome + '').toLowerCase().replace(/[\u00e0]/, "a");
		 
           var item = new CardListItemView({model: cards[i]});
			//console.log(item);
			$('#elenco_carte', this.el).append(item.render().el);
        }
        $(this.el).append(new Paginator({model: this.model, page: this.options.page}).render().el);
        return this;
    }
});

window.CardListItemView = Backbone.View.extend({
    tagName: "tr",
    initialize: function () {
        this.model.bind("change", this.render, this);
        this.model.bind("destroy", this.close, this);
    },
    render: function () {
        $(this.el).html(this.template(this.model.toJSON()));
        return this;
    }
});

window.CultureListView = Backbone.View.extend({
    initialize: function (options) {
        this.options = options || {};
        this.render();
    },
    render: function () {
        var cards = this.model.models;

	$(this.el).html('<h1 style="text-transform:capitalize;">Cultura '+this.options.cultura+'</h1>\
		<table id="elenco_carte_'+this.options.cultura+'" class="table table-striped table-bordered tabella_cultura"></table>');
	//$('#elenco_carte_'+this.options.cultura, this.el).append('<tr><th>Tipo</a></th><th class="colonna_cultura">Cultura</th><th>Carta</th></tr>');
        
	for (var i = 0; i < cards.length; i++) {
		//console.log(cards[i].attributes.famiglia+' '+this.options.cultura);
		if (cards[i].attributes.famiglia == this.options.cultura || this.options.cultura=="") {
			// FORMATTAZIONE NUMERO COPIE CARTA
			cards[i].attributes.ncopie_mostrato = (cards[i].attributes.ncopie>1) ? '('+cards[i].attributes.ncopie+' copie nel mazzo)' : '';
			cards[i].attributes.nome_lower = (cards[i].attributes.nome + '').toLowerCase().replace(/[\u00e0]/, "a");

	       		var item = new CardListItemView({model: cards[i]});
			//console.log(item);
			$('#elenco_carte_'+this.options.cultura, this.el).append(item.render().el);
        	}
	}
        return this;
    }
});


/* CARDTURCHILIST.JS */
window.CardTurchiListView = Backbone.View.extend({
    initialize: function () {
        this.render();
    },
    render: function () {
        var cards = this.model.models;

        $(this.el).html('<h1>Espansione: Turchi</h1>\
<strong>Turchi</strong> &egrave; la prima espansione di <strong>600 <small>il Secolo di Ferro</small></strong>, composta di 21 carte.<br /><br />\
Viene introdotta la Cultura Turca. Lo scopo del gioco rimane la costruzione di una Citt&agrave; Multiculturale con 5 Culture diverse, a scelta tra le 6 ora disponibili.<br /><br />\
Clicca sul nome della carta per visualizzarla. <a href="http://seicento.info/stampatutti_turchi.php" target="_blank">Clicca qui per stamparle tutte</a>.<br /><br/>\
<table id="elenco_carte" class="table table-striped table-bordered"></table>');

        //$('#elenco_carte', this.el).append('<tr><th>Tipo</a></th><th>Cultura</th><th>Carta</th></tr>');

        for (var i = 0; i < cards.length; i++) {
		// FORMATTAZIONE NUMERO COPIE CARTA
		cards[i].attributes.ncopie_mostrato = (cards[i].attributes.ncopie>1) ? '('+cards[i].attributes.ncopie+' copie nel mazzo)' : '';
		cards[i].attributes.nome_lower = (cards[i].attributes.nome + '').toLowerCase().replace(/[\u00e0]/, "a");
           var item = new CardListItemView({model: cards[i]});
			//console.log(item);
			$('#elenco_carte', this.el).append(item.render().el);
        }
        return this;
    }
});


