window.Paginator = Backbone.View.extend({
    initialize:function (options) {
        this.options = options || {};
        this.model.bind("reset", this.render, this);
        this.render();
    },
    render:function () {
        var items = this.model.models;
        var len = items.length;
        var pageCount = Math.ceil(len / 10);
        $(this.el).html('<ul class="pagination"></ul>');
        for (var i=0; i < pageCount; i++) {
            $('ul', this.el).append("<li" + ((i + 1) === this.options.page ? " class='active'" : "") + "><a href='#carte/page/"+(i+1)+"'>" + (i+1) + "</a></li>");
        }
        return this;
    }
});