var vid = document.getElementById('videoel');
var overlay = document.getElementById('overlay');
var overlayCC = overlay.getContext('2d');
var save = document.getElementById("save")
var player = document.getElementById('play');
var audio = document.getElementById('cam_audio');

n = parseInt(localStorage.getItem("cheese")) || 0;

save.onmousedown = function(){n++;}

player.addEventListener('click', function(){
  if(vid.paused){
    vid.play();
    save.classList.add("disabled");
    setTimeout(function(){
      thr = true;
    },500)
  }else {
    vid.pause();
    save.classList.add("disabled");
  }
});

var timer = null;
vid.addEventListener('play', function() {
   // Every 33 milliseconds copy the video image to the canvas
   w=overlay.width;
   h=overlay.height;
   setInterval(function() {
      if (vid.paused || vid.ended){
        clearInterval(timer);
        return;
      };
      overlayCC.fillRect(0, 0, w, h);
      overlayCC.drawImage(vid, 0, 0, w, h);
   }, 33);
}, false);

/********** check and set up video/webcam **********/

function enablestart() {
  var startbutton = document.getElementById('startbutton');
  startbutton.value = "start";
  startbutton.className = 'btn'
  startbutton.disabled = false;
}

navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia;
window.URL = window.URL || window.webkitURL || window.msURL || window.mozURL;

// check for camerasupport
if (navigator.getUserMedia) {
  // set up stream

  var videoSelector = {video : true};
  if (window.navigator.appVersion.match(/Chrome\/(.*?) /)) {
    var chromeVersion = parseInt(window.navigator.appVersion.match(/Chrome\/(\d+)\./)[1], 10);
    if (chromeVersion < 20) {
      videoSelector = "video";
    }
  };

  navigator.getUserMedia(videoSelector, function( stream ) {
    if (vid.mozCaptureStream) {
      vid.mozSrcObject = stream;
    } else {
      vid.src = (window.URL && window.URL.createObjectURL(stream)) || stream;
    }
    vid.play();
  }, function() {
    //insertAltVideo(vid);
    alert("There was some problem trying to fetch video from your webcam. If you have a webcam, please make sure to accept when the browser asks for access to your webcam.");
  });
} else {
  //insertAltVideo(vid);
  alert("This demo depends on getUserMedia, which your browser does not seem to support. :(");
}

vid.addEventListener('canplay', enablestart, false);

/*********** setup of emotion detection *************/

var ctrack = new clm.tracker({useWebGL : true});
ctrack.init(pModel);

function startVideo() {
  var wrap = document.getElementById('teaser');
  wrap.className = "up";
  // start video
  vid.play();
  // start tracking
  ctrack.start(vid);
  // start loop to draw face
  drawLoop();
}
thr = true;

function drawLoop() {
  var cp = ctrack.getCurrentParameters();
  var er = ec.meanPredict(cp);
  if(er[3] && er[3].value > 0.7  && !vid.paused && thr){
    audio.play();
    vid.pause()
    save.classList.remove("disabled")
    save.href= overlay.toDataURL("image/png");
    var filename = "cheese-camera"+n+".png";
    localStorage.setItem("cheese", n);
    save.download = filename;
    thr = false;
  }
  requestAnimFrame(drawLoop);
}

var ec = new emotionClassifier();
ec.init(emotionModel);
var emotionData = ec.getBlank();

function printImage(){
   window.location = overlay.toDataURL("image/png");
}
