!function() {
	function Calculator() {
		this.buttons = n.one('#buttons')
		
		this.problem = n.one('#main .problem')
		this.answer = n.one('#main .answer')

		this.viewHistory = n.one('#view-history')

		this.setDefaultCurrentEquation();

		this.buttons.on('click', this.handleButton.bind(this))
		this.viewHistory.on('click', this.toggleHistory.bind(this))
		n.one('#history .content').on('click', this.goToHistoryItem.bind(this))
	}

	Calculator.prototype = {

		get formattedEquation() {
			// Make entities
			var formatted = (this.currentEquation + '')
				.replace(/\*/g, '&times;')
				.replace(/\//g, '&divide;')
				.replace(/\-/g, '&minus;')

			return formatted
		},

		set currentEquation(value) {

			// Strip leading zeros
			if (/^0[0-9]{1}/.test(value)) {
				value = value.substring(1)
			}

			this._currentEquation = value
			this.answer.setHtml(this.formattedEquation)
			this.answer._node.scrollLeft = this.answer._node.scrollWidth

		},

		get currentEquation() {
			return this._currentEquation
		},

		setDefaultCurrentEquation: function() {
			this.currentEquation = '0'
		},

		backspace: function() {
			return String(this.currentEquation).substring(0, String(this.currentEquation).length-1)
		},

		clear: function() {
			return '0'
		},

		evaluate: function() {
			var answer

			try {
				answer = eval(this.currentEquation)
			} catch(e) {
				// Invalid answer, give the text a red flast for a second
				this.answer.addClass('error')
				setTimeout(function() {
					this.answer.removeClass('error')
				}.bind(this), 1000)
				return this.currentEquation
			}

			var last = this.formattedEquation
			this.problem.setHtml(last)

			// Append the history item
			n.one('#history .content').prepend(
				n.node.create('<div><p class="equation">' +
					'<span class="problem">' + last + '</span>' + 
					'<span class="answer">' + answer + '</span>' +
				'</p></div>')
			)

			return answer
		},

		plusminus: function() {
			if (this.currentEquation[0] === '-') {
				return this.currentEquation.substring(1)
			} else {
				return '-' + this.currentEquation
			}
		},

		handleButton: function(e) {
			e.target.addClass('active')
			setTimeout(function() {
				e.target.removeClass('active')	
			}, 200)

			if (e.target.data('handler')) {
				this.currentEquation = this[e.target.data('handler')]()
			} else {
				var character

				if (e.target.data('character')) {
					character = e.target.data('character')
				} else {

					// If we do *not* have a character, but the last action was to evaluate
					// clear the input and just start typing again.
					// Normally we would just append operations to the result of the previous answer.
					if (this.lastButtonContent === '=') {
						this.setDefaultCurrentEquation()
					}

					character = e.target.getHtml()
				}

				this.currentEquation = this.currentEquation + character
			}

			// Update the last button content
			this.lastButtonContent = e.target._node.textContent
		},

		toggleHistory: function() {
			var body = n.one('body')
			if (body.hasClass('history-view')) {
				body.removeClass('history-view')
			} else {
				body.addClass('history-view')
			}
		},

		/**
		 * Called when the user taps on a history item.
		 * Loads the result of that item as the current equation
		 */
		goToHistoryItem: function(e) {
			this.currentEquation = e.target.one('.answer').getHtml()
			this.lastButtonContent = this._currentEquation[this._currentEquation.length - 1]
			this.toggleHistory()
		}
	}

	window.addEventListener('load', function() {
		window.Calculator = new Calculator()
	})
}()