
var lang = {
  'ca': {
    name: 'Català',
    how: ['fort', 'suau', 'rapid', 'lent'],
    actions: ['mossegar', 'xuclar', 'petons', 'apretar', 'pessigar', 'massatge'],
    places: ['pits', 'genitals', 'mugrons', 'coll', 'llavis', 'orella', 'cli/gland', 'cul'],
    strings: {
      firstplayer: 'Primer Jugador',
      secondplayer: 'Segon Jugador',
      actions: 'Accions',
      places: 'Llocs',
      configure: 'Configurar',
      start: 'Començar',
      idioma: 'Idioma',
      duration: 'Duració de les accions (en segons)',
      audio: 'Senyalitzacions',
      silence: 'Silenci',
      withsound: 'So Habilitat',
      reset: 'Esborrar-ho Tot',
      resetconfirm: 'Esborrar totes les dades?',
      save: 'Desar',
      canvi: 'Canvi!',
      jugar: 'A Jugar!',
      jugar_next: 'Següent jugador!',
      jugar_shuffle: 'Repetir',
      bubble: 'Prem aquí per canviar',
      bubble2: 'Clicka aqui per començar',
      vibrate: 'Vibrar',
      novibrate: 'No vibrar',
      err_noteq: 'No es poden dir igual',
      err_data: 'Falten dades'
    }
  },
  'en': {
    name: 'English',
    how: ['hard', 'soft', 'quick', 'slow'],
    actions: ['bite', 'suck', 'kiss', 'tighten', 'pinch', 'massage'],
    places: ['tits', 'genitals', 'nipples', 'neck', 'lips', 'ear', 'cli/gland', 'ass'],
    strings: {
      firstplayer: 'First Player',
      secondplayer: 'Second Player',
      actions: 'Actions',
      places: 'Places',
      configure: 'Options',
      start: 'Start!',
      idioma: 'Language',
      duration: 'Duration of actions (in seconds)',
      audio: 'Audio Ding',
      silence: 'Silence',
      withsound: 'Sound Enabled',
      reset: 'Reset',
      resetconfirm: 'Confirm Reset?',
      save: 'Save',
      canvi: 'Change',
      jugar: 'Play!',
      jugar_next: 'Next player!',
      jugar_shuffle: 'Shuffle',
      bubble: 'Tap name to change player',
      bubble2: 'Tap here to start',
      vibrate: 'Vibrate',
      novibrate: 'Do not vibrate',
      err_noteq: 'Cant have the same name',
      err_data: 'Missing actions'
    }
  },
  'eo': {
    name: 'Esperanto',
    how: ['maldolĉe', 'dolĉe', 'rapide', 'malrapide'],
    actions: ['mordi la', 'suĉi la', 'kisi la', 'stringi la', 'pinĉi la', 'masaĝi la'],
    places: ['mamon', 'testikon', 'cicon', 'kolon', 'lipon', 'orelon', 'clitoron/glanon', 'pugon'],
    strings: {
      firstplayer: 'Unua ludanto',
      secondplayer: 'Dua ludanto',
      actions: 'Agoj',
      places: 'Lokoj',
      configure: 'Opcioj',
      start: 'Ek!',
      idioma: 'Lingvoj',
      duration: 'Daŭro de agoj (sekundojn)',
      audio: 'Sonorilo',
      silence: 'Silentigi',
      withsound: 'Sonoj enŝaltitaj',
      reset: 'Rekomencigi',
      resetconfirm: 'Ĉu vi konfirmas rekomencigon?',
      save: 'Konservi',
      canvi: 'Ŝanĝi',
      jugar: 'Ludi!',
      jugar_next: 'Proksima ludanto!',
      jugar_shuffle: 'Miksi!',
      bubble: 'Frapetu tie ŝanĝi',
      bubble2: 'Frapetu tie komenci',
      vibrate: 'Vibras',
      novibrate: 'Ne vibras',
      err_noteq: 'ne povas havi la saman nomon',
      err_data: 'neniu agoj difinita'
    }
  },
  'es': {
    name: 'Español',
    how: ['fuerte', 'suave', 'rápido', 'lento'],
    actions: ['morder', 'chupar', 'besos', 'apretar', 'pellizcar', 'masaje'],
    places: ['pechos', 'genitales', 'pezones', 'cuello', 'labios', 'oreja', 'cli/glande', 'culo'],
    strings: {
      firstplayer: 'Primer Jugador',
      secondplayer: 'Segundo Jugador',
      actions: 'Acciones',
      places: 'Sitios',
      configure: 'Configurar',
      start: 'Empezar',
      idioma: 'Idioma',
      duration: 'Duración de las acciones (en segundos)',
      audio: 'Señales',
      silence: 'Silencio',
      withsound: 'Sonido Habilitado',
      reset: 'Eliminar Datos',
      resetconfirm: 'Eliminar Datos?',
      save: 'Grabar',
      canvi: 'Cambio!',
      jugar: 'A Jugar!',
      jugar_next: 'Siguiente!',
      jugar_shuffle: 'Repetir',
      bubble: 'Presiona el nombre para cambiar',
      bubble2: 'Haz click aqui para empezar',
      vibrate: 'Vibrar',
      novibrate: 'No vibrar',
      err_noteq: 'No pueden llamarse igual',
      err_data: 'Faltan datos'
    }
  },
  'it': {
    name: 'Italiano',
    how: ['forte', 'dolcemente', 'velocemente', 'lentamente'],
    actions: ['mordi', 'succhia', 'bacia', 'premi', 'pizzica', 'massaggia'],
    places: ['le tette', 'i genitali', 'i capezzoli', 'il collo', 'le labbra', 'l\'orecchio', 'il cli./glande', 'il culo'],
    strings: {
      firstplayer: 'Primo giocatore',
      secondplayer: 'Secondo giocatore',
      actions: 'Azioni',
      places: 'Luoghi',
      configure: 'Opzioni',
      start: 'Incomincia!',
      idioma: 'Lingua',
      duration: 'Durata delle azioni (in secondi)',
      audio: 'Suono',
      silence: 'Muto',
      withsound: 'Suoni attivati',
      reset: 'Reset',
      resetconfirm: 'Confermi il reset?',
      save: 'Salva',
      canvi: 'Cambia',
      jugar: 'Gioca!',
      jugar_next: 'Il prossimo!',
      jugar_shuffle: 'Mescolare',
      bubble: 'Click per cambiare giocatore',
      bubble2: 'Toccare qui per iniziare',
      vibrate: 'Vibra',
      novibrate: 'Non vibra',
      err_noteq: 'Non possono essere chiamati uguale',
      err_data: 'Dati mancanti'
    }
  },
  'tp': {
    name: 'Tokipona',
    how: ['wawa', 'wawa ala', 'wawa tawa', 'wawa tawa lili'],
    actions: ['moku', 'uta', 'pana e uta', 'o kama jo', 'pakala lili', 'pona e sijelo'],
    places: ['nena sike', 'anpa lawa', 'uta', 'kute', 'palisa/lupa', 'monsi'],
    strings: {
      firstplayer: 'jan pi nanpa wan',
      secondplayer: 'jan pi nanpa tu',
      actions: 'kama',
      places: 'wan sijelo',
      configure: 'nasin mute',
      start: 'open!',
      idioma: 'toki',
      duration: 'tenpo pi pali e kama',
      audio: 'kalama',
      silence: 'kalama ala li lon',
      withsound: 'kalama li lon',
      reset: 'weka',
      resetconfirm: 'sina wile ala wile weka e ijo?',
      save: 'awen sona',
      canvi: 'ante',
      jugar: 'open!',
      jugar_next: 'jan ante',
      jugar_shuffle: 'pali ante',
      bubble: 'jan nimi ante',
      bubble2: 'pilin tawa musi',
      vibrate: 'pilin tawa',
      novibrate: 'pilin tawa ala',
      err_noteq: 'nimi li sama',
      err_data: 'pali nimi li lon ala'
    }
  }
}

var langs = [];
for (var a in lang) {
  langs[langs.length] = a;
}

///////////////////////////////////////////////////////////////////////////////
function setCurLang(n) {
  if (lang[n]) {
    localStoraget.setItem('lang', n);
  }
}

function getCurLang() {
  var curlang = localStorage.getItem ('lang');
  if (!curlang) {
    var navlang = window.navigator.language.substring(0, 2);
    if (lang[navlang]) {
      curlang = navlang;
    } else {
      curlang = 'en';
    }
    localStorage.setItem ('lang', curlang);
  }
  return curlang;
}

function getLang() {
  var l = lang[getCurLang()];
  return l ? l : lang.en;
}

function getString(s) {
  var q = getLang().strings[s];
  return q || s;
}
