// Bubble Pop Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3.6
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Bubble Pop Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the required number of bubbles for the round have been popped and eating by the catcher.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a bubble with a target item is touched.
//         
// Round Properties
//
//     numBubbles: Maximum number of bubbles visible on the screen at once.
//     background
//         Properties:
//            filename: Filename of the background image.
//     bubbleHighlight: Displayed behind the bubble when it is highlighted.
//     bubblePopAnimation: Displayed when a bubble is touched.
//     emptyBubble
//         Properties:
//             filename: Filename of the emoty bubble image.
//     catcher: A character would catches items that fall out of bubbles which are popped.
//         Available States:
//             WAIT: Displayed when the catcher is not active.
//             WAVE: Displayed at the beginning of each round.
//             MOVE: Displayed when the catcher is moving.
//             JUMP: Displayed when a popped bubble has dropped in range of the catcher.
//     target: A random item is selected at the start of each round to be the correct item.
//         Properties:
//             unpopped
//                 Properties:
//                     filename: Filename of the image displayed if the bubble has not been touched.
//             popped
//                 Properties:
//                     filename: Filename of the image displayed after bubble has been touched.
//             label
//                 Available States:
//                     NOTFOUND: Initial state of the label.
//                     FOUND: Displayed after the item is found.
//     distractors (Array): Array of objects that will be displayed with target bubbles that just pop when touch
//         Properties:
//             filename: Filename of the distractor image.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "mozilla_thumb_256x256_ShapePop.png",
	audioEnabled: true,
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "start-bubblePop-shapes.jpg",
	audioFilename: "BP_shapes.mp3", //all audio including intro, payoff, and music is in one file found here
	audio: {
		states: [
			{
				name: "music", 
				startTime: 79,
				duration: 19,
				loop: true
			}
		]
	},
	hud: {
		sidebar: {
			type: "SIDEBAR",
			states: [
				{
					type: "Default",
					filename: "sidebar.png",
					numFrames: 12,
					autoStart: false
				}
			]
		}
	},
	rounds: [
		{
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 10,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 14,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_circle_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_circle_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "circle_purple.png"
						},{
							type: "Found",
							filename: "circle_found.png"
						}
					]
				}
			},
			distractors: [
				{
				//	filename: "Shapes_hexagon_in_bubble_150x150.png"
				//}, {
					filename: "Shapes_octagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rectangle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rhombus_in_bubble_150x150.png"
				}, {
					filename: "Shapes_square_in_bubble_150x150.png"
				}, {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 49,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 53,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_hexagon_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_hexagon_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "hexagon_purple.png"
						},{
							type: "Found",
							filename: "hexagon_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Shapes_circle_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_octagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rectangle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rhombus_in_bubble_150x150.png"
				}, {
					filename: "Shapes_square_in_bubble_150x150.png"
				}, {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 59,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 63,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_octagon_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_octagon_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "octagon_purple.png"
						},{
							type: "Found",
							filename: "octagon_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Shapes_circle_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_hexagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rectangle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rhombus_in_bubble_150x150.png"
				}, {
					filename: "Shapes_square_in_bubble_150x150.png"
				}, {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 39,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 43,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_pentagon_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "pentagon_purple.png"
						},{
							type: "Found",
							filename: "pentagon_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Shapes_circle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_hexagon_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_octagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rectangle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rhombus_in_bubble_150x150.png"
				}, {
					filename: "Shapes_square_in_bubble_150x150.png"
				}, {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 19,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 23,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_rectangle_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_rectangle_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "rectangle_purple.png"
						},{
							type: "Found",
							filename: "rectangle_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Shapes_circle_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_hexagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_octagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_rhombus_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_square_in_bubble_150x150.png"
				}, {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 29,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 33,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_rhombus_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_rhombus_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "rhombus_purple.png"
						},{
							type: "Found",
							filename: "rhombus_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Shapes_circle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_hexagon_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_octagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_rectangle_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_square_in_bubble_150x150.png"
				}, {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 4,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_square_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_square_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "square_purple.png"
						},{
							type: "Found",
							filename: "square_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Shapes_circle_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_hexagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_octagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_rectangle_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_rhombus_in_bubble_150x150.png"
				}, {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 69,
						duration: 3.6
					}, {
						name: "payoff",
						startTime: 73,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble_highlight_150x150.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "Shapes_empty_bubble_150x150.png"
			},
			target: {
				unpopped: {
					filename: "Shapes_triangle_in_bubble_150x150.png"
				},
				popped: {
					filename: "Shapes_triangle_outof_bubble_150x150.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "triangle_purple.png"
						},{
							type: "Found",
							filename: "triangle_found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Shapes_circle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_hexagon_in_bubble_150x150.png"
				//}, {
				//	filename: "Shapes_octagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_pentagon_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rectangle_in_bubble_150x150.png"
				}, {
					filename: "Shapes_rhombus_in_bubble_150x150.png"
				}, {
					filename: "Shapes_square_in_bubble_150x150.png"
				}
			]
		}
	]
};