// Path Drawing Configuration File
//iPad

// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     hotspots (Array):  Array of bounding rectangles that will act as the hotspot for the view if specified.
//         Example:
//              hotspots: [
//					{x: 38, y: 0, width: 161, height: 45},
//					{x: 9, y: 45, width: 201, height: 51}
//              ]
//     hotspotsVisible (Boolean): If true the hotspot rectangles of the view will be outlined. This is used for debug purposes only. 
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Path Drawing Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the hero reaches the goal.
//             MUSIC: Loops in the background.
//			   OBSTACLE_HIT: Plays when the path enters the hotspot of an obstacle.
//      hint
//         Properties:
//             color: The color (in hex e.g. #ff0000 for red) of the hint line.
//		       speed: The speed (in pixels per second) at which the line is drawn.
//		       width: The diameter of the line.
//		       dashWidth: The length of the dash.
//		       dashGap: The length of the gap between dashes.
//     bumpers
//         Properties:
//             top: Y location of the bumper on the top 
//             bottom: Y location of the bumper on the bottom in relation to the bottom of the screen
//             left: X location of the bumper on the left
//             right: X location of the bumper on the right in relation to the right side of the screen
//             hudWidth: Width of the rectangle in the top right hand corner of the screen.
//             hudHeight: Height of the rectangle in the top right hand corner of the screen.
//         
// Round Properties
//
//     pathColor: The color (in hex e.g. #ff0000 for red) of the path drawn.
//     background
//         Properties:
//            filename: Filename of the background image.
//     hero
//         Properties:
//             startX: Start x position of the hero.
//             startY: Start y position of the hero.
//             speed: Number of pixels the hero moves each frame when moving along the path.
//         Available States:
//             DEFAULT: Only currently supported state.
//     goal
//         Available States:
//             DEFAULT: Initial state of the goal.
//             GOAL: Displayed when the hero reaches the goal.
//     groups (Array): An array of obstacle groups. One set of obstacles will be randomly chosen each round.
//         obstacles
//             Available States:
//                 DEFAULT: Only currently supported state.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -128
		}
	},
	gameIcon: "icon_seacaptainpath.png",
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "startscreen_etm_seacaptain_ipad.jpg",
	audioEnabled: true,
	audioFilename: "audio-path-sea-captain.mp3", //all audio including intro, payoff, and music is in this one file
	audio: {
		states: [
			{
				name: "music", 
				startTime: 105,
				duration: 21.80,
				loop: true
			}
		]
	},
	bumpers: {
		top: 20,
		bottom: -20,
		left: 20,
		right: -20,
		hudWidth: 100,
		hudHeight: 90
	},
	hint: {
		color: "#ffea00",
		speed: 5,
		width: 30, //width of the line itself. Makes the dots get bigger
		dashWidth: 1, //width of the dash in pixels. Cannot go higher than 10px
		dashGap: 50 //number of pixels between each dash. Cannot go lower than 10px
	},
	rounds: [
		{ //Round 1
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 0,
						duration: 9.5
					},
					{
						name: "payoff",
						startTime: 10.5,
						duration: 6.1
					}
				]
			},
			pathColor: "#aedde9",
			background: {
				filename: "Background_ocean.png"
			},
			hero: { 
				type: "Hero",
				startX: 155,
				startY: 230,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Elmo_in_Ship.png",
						offsetX: -130,
						offsetY: -186,
						//hotspotsVisible: true,
						hotspots: [
							{ x: -130, y: -180, width: 183, height: 198 }
						]
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 600,
				startY: 370,
				states: [
					{
						type: "Default",
						filename: "Moby_Pink_All.png",
						// hotspotsVisible: false,
						hotspots: [
							{ x: 176, y: 70, width: 300, height: 210 }
						]
					},{
						type: "Goal",
						filename: "EtM_SeaCap_MobyP_Lvl1.png",
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{}]
		},{ //Round 2
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 17.5,
						duration: 11.5
					},
					{
						name: "payoff",
						startTime: 29.5,
						duration: 7.5
					}
				]
			},
			pathColor: "#aedde9",
			background: {
				filename: "Background_ocean.png"
			},
			hero: { 
				type: "Hero",
				startX: 155,
				startY: 230,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Elmo_in_Ship.png",
						offsetX: -130,
						offsetY: -186,
						//hotspotsVisible: true,
						hotspots: [
							{ x: -130, y: -180, width: 183, height: 198 }
						]
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 600,
				startY: 370,
				states: [
					{
						type: "Default",
						filename: "Moby_Pink_All.png",
						// hotspotsVisible: false,
						hotspots: [
							{ x: 176, y: 70, width: 300, height: 210 }
						]
					},{
						type: "Goal",
						filename: "EtM_SeaCap_MobyP_Lvl2.png",
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{
				obstacles: [ //randomly chooses from 1 of the 3 obstacles below
					{
						type: "Obstacle",
						startX: 409,
						startY: 235,
						states: [
							{
								type: "Default",
								filename: "Octagon.png",									
								hotspots: [
									{ x: 49, y: 0, width: 92, height: 206 },
									{ x: 0, y: 45, width: 25, height: 161 },
									{ x: 25, y: 25, width: 25, height: 182 },
									{ x: 142, y: 25, width: 25, height: 182 },
									{ x: 167, y: 45, width: 25, height: 161 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 403,
						startY: 398,
						states: [
							{
								type: "Default",
								filename: "Octagon.png",									
								hotspots: [
									{ x: 49, y: 0, width: 92, height: 206 },
									{ x: 0, y: 45, width: 25, height: 161 },
									{ x: 25, y: 25, width: 25, height: 182 },
									{ x: 142, y: 25, width: 25, height: 182 },
									{ x: 167, y: 45, width: 25, height: 161 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 275,
						startY: 285,
						states: [
							{
								type: "Default",
								filename: "Octagon.png",									
								hotspots: [
									{ x: 49, y: 0, width: 92, height: 206 },
									{ x: 0, y: 45, width: 25, height: 161 },
									{ x: 25, y: 25, width: 25, height: 182 },
									{ x: 142, y: 25, width: 25, height: 182 },
									{ x: 167, y: 45, width: 25, height: 161 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					}
				]
			}]
		},{ //Round 3
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 37.5,
						duration: 11
					},
					{
						name: "payoff",
						startTime: 49.5,
						duration: 8
					}
				]
			},
			pathColor: "#aedde9",
			background: {
				filename: "Background_ocean.png"
			},
			hero: { 
				type: "Hero",
				startX: 155,
				startY: 230,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Elmo_in_Ship.png",
						offsetX: -130,
						offsetY: -186,
						//hotspotsVisible: true,
						hotspots: [
							{ x: -130, y: -180, width: 183, height: 198 }
						]
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 600,
				startY: 370,
				states: [
					{
						type: "Default",
						filename: "Moby_Pink_All.png",
						// hotspotsVisible: false,
						hotspots: [
							{ x: 176, y: 70, width: 300, height: 210 }
						]
					},{
						type: "Goal",
						filename: "EtM_SeaCap_MobyP_Lvl3.png",
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 350,
						startY: 322,
						states: [
							{
								type: "Default",
								filename: "Hexagon_1.png",									
								hotspots: [
									{ x: 38, y: 0, width: 87, height: 170 },
									{ x: 0, y: 67, width: 13, height: 103 },
									{ x: 13, y: 50, width: 13, height: 120 },
									{ x: 26, y: 33, width: 13, height: 137 },
									{ x: 151, y: 67, width: 13, height: 103 },
									{ x: 138, y: 50, width: 13, height: 120 },
									{ x: 125, y: 33, width: 13, height: 137 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					},
					{
						type: "Obstacle",
						startX: 642,
						startY: 168,
						states: [
							{
								type: "Default",
								filename: "Hexagon_2.png",									
								hotspots: [
									{ x: 38, y: 0, width: 87, height: 170 },
									{ x: 0, y: 67, width: 13, height: 103 },
									{ x: 13, y: 50, width: 13, height: 120 },
									{ x: 26, y: 33, width: 13, height: 137 },
									{ x: 151, y: 67, width: 13, height: 103 },
									{ x: 138, y: 50, width: 13, height: 120 },
									{ x: 125, y: 33, width: 13, height: 137 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					}
				]
			},{
				obstacles: [
					{
						type: "Obstacle",
						startX: 299,
						startY: 336,
						states: [
							{
								type: "Default",
								filename: "Hexagon_1.png",									
								hotspots: [
									{ x: 38, y: 0, width: 87, height: 170 },
									{ x: 0, y: 67, width: 13, height: 103 },
									{ x: 13, y: 50, width: 13, height: 120 },
									{ x: 26, y: 33, width: 13, height: 137 },
									{ x: 151, y: 67, width: 13, height: 103 },
									{ x: 138, y: 50, width: 13, height: 120 },
									{ x: 125, y: 33, width: 13, height: 137 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					},
					{
						type: "Obstacle",
						startX: 609,
						startY: 348,
						states: [
							{
								type: "Default",
								filename: "Hexagon_2.png",									
								hotspots: [
									{ x: 38, y: 0, width: 87, height: 170 },
									{ x: 0, y: 67, width: 13, height: 103 },
									{ x: 13, y: 50, width: 13, height: 120 },
									{ x: 26, y: 33, width: 13, height: 137 },
									{ x: 151, y: 67, width: 13, height: 103 },
									{ x: 138, y: 50, width: 13, height: 120 },
									{ x: 125, y: 33, width: 13, height: 137 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					}
				]
			},{
				obstacles: [
					{
						type: "Obstacle",
						startX: 484,
						startY: 412,
						states: [
							{
								type: "Default",
								filename: "Hexagon_1.png",									
								hotspots: [
									{ x: 38, y: 0, width: 87, height: 170 },
									{ x: 0, y: 67, width: 13, height: 103 },
									{ x: 13, y: 50, width: 13, height: 120 },
									{ x: 26, y: 33, width: 13, height: 137 },
									{ x: 151, y: 67, width: 13, height: 103 },
									{ x: 138, y: 50, width: 13, height: 120 },
									{ x: 125, y: 33, width: 13, height: 137 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					},
					{
						type: "Obstacle",
						startX: 625,
						startY: 162,
						states: [
							{
								type: "Default",
								filename: "Hexagon_2.png",									
								hotspots: [
									{ x: 38, y: 0, width: 87, height: 170 },
									{ x: 0, y: 67, width: 13, height: 103 },
									{ x: 13, y: 50, width: 13, height: 120 },
									{ x: 26, y: 33, width: 13, height: 137 },
									{ x: 151, y: 67, width: 13, height: 103 },
									{ x: 138, y: 50, width: 13, height: 120 },
									{ x: 125, y: 33, width: 13, height: 137 }
								],
								// hotspotsVisible: true //for debugging. 
							}
						]
					}
				]
			}
			]
		},{ //Round 4
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 57.5,
						duration: 15.5
					},
					{
						name: "payoff",
						startTime: 73.5,
						duration: 9
					}
				]
			},			
			pathColor: "#aedde9",
			background: {
				filename: "Background_ocean.png"
			},
			hero: { 
				type: "Hero",
				startX: 155,
				startY: 230,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Elmo_in_Ship.png",
						offsetX: -130,
						offsetY: -186,
						//hotspotsVisible: true,
						hotspots: [
							{ x: -130, y: -180, width: 183, height: 198 }
						]
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 600,
				startY: 370,
				states: [
					{
						type: "Default",
						filename: "Moby_Pink_All.png",
						// hotspotsVisible: false,
						hotspots: [
							{ x: 176, y: 70, width: 300, height: 210 }
						]
					},{
						type: "Goal",
						filename: "EtM_SeaCap_MobyP_Lvl4.png",
						frameRate: 15,
						numFrames: 16,
						offsetY: -85
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 233,
						startY: 314,
						states: [
							{
								type: "Default",
								filename: "Rhombus_1.png",
								// hotspotsVisible: false, //for debugging. 
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 580,
						startY: 280,
						states: [
							{
								type: "Default",
								filename: "Rhombus_2.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 687,
						startY: 182,
						states: [
							{
								type: "Default",
								filename: "Rhombus_3.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 320,
						startY: 232,
						states: [
							{
								type: "Default",
								filename: "Rhombus_1.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 517,
						startY: 495,
						states: [
							{
								type: "Default",
								filename: "Rhombus_2.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 634,
						startY: 200,
						states: [
							{
								type: "Default",
								filename: "Rhombus_3.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 223,
						startY: 423,
						states: [
							{
								type: "Default",
								filename: "Rhombus_1.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 455,
						startY: 289,
						states: [
							{
								type: "Default",
								filename: "Rhombus_2.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					},{
						type: "Obstacle",
						startX: 755,
						startY: 142,
						states: [
							{
								type: "Default",
								filename: "Rhombus_3.png",
								// hotspotsVisible: false, //for debugging. 								
								hotspots: [
									{ x: 40, y: 0, width: 10, height: 185 },
									{ x: 0, y: 60, width: 15, height: 125 },
									{ x: 15, y: 40, width: 15, height: 145 },
									{ x: 30, y: 20, width: 15, height: 165 },
									{ x: 75, y: 60, width: 15, height: 125 },
									{ x: 60, y: 40, width: 15, height: 145 },
									{ x: 45, y: 20, width: 15, height: 165 }
								]
							}
						]
					}
				]
			}]
		},{ //Round 5
			audio: {
				states: [
					{
						name: "intro", 
						startTime: 82.5,
						duration: 12.4
					},
					{
						name: "payoff",
						startTime: 95.5,
						duration: 9.5
					}
				]
			},
			pathColor: "#aedde9",
			background: {
				filename: "Background_ocean.png"
			},
			hero: { 
				type: "Hero",
				startX: 155,
				startY: 230,
				speed: 10,
				states: [
					{
						type: "Default",
						filename: "Elmo_in_Ship.png",
						offsetX: -130,
						offsetY: -186,
						//hotspotsVisible: true,
						hotspots: [
							{ x: -130, y: -180, width: 183, height: 198 }
						]
					}
				]
			},
			goal: {
				type: "Goal",
				startX: 600,
				startY: 370,
				states: [
					{
						type: "Default",
						filename: "Moby_Pink_All.png",
						// hotspotsVisible: false,
						hotspots: [
							{ x: 176, y: 70, width: 300, height: 210 }
						]
					},{
						type: "Goal",
						filename: "EtM_SeaCap_MobyP_Lvl5.png",
						frameRate: 15,
						numFrames: 18
					}
				]
			},
			groups: [{
				obstacles: [
					{
						type: "Obstacle",
						startX: 171,
						startY: 520,
						states: [
							{
								type: "Default",
								filename: "Triangle_1.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 396,
						startY: 312,
						states: [
							{
								type: "Default",
								filename: "Triangle_2.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 618,
						startY: 152,
						states: [
							{
								type: "Default",
								filename: "Triangle_3.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 902,
						startY: 250,
						states: [
							{
								type: "Default",
								filename: "Triangle_4.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 305,
						startY: 316,
						states: [
							{
								type: "Default",
								filename: "Triangle_1.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 505,
						startY: 148,
						states: [
							{
								type: "Default",
								filename: "Triangle_2.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 456,
						startY: 570,
						states: [
							{
								type: "Default",
								filename: "Triangle_3.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 785,
						startY: 257,
						states: [
							{
								type: "Default",
								filename: "Triangle_4.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}
				]
			}, {
				obstacles: [
					{
						type: "Obstacle",
						startX: 214,
						startY: 540,
						states: [
							{
								type: "Default",
								filename: "Triangle_1.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 320,
						startY: 212,
						states: [
							{
								type: "Default",
								filename: "Triangle_2.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 483,
						startY: 416,
						states: [
							{
								type: "Default",
								filename: "Triangle_3.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}, {
						type: "Obstacle",
						startX: 749,
						startY: 216,
						states: [
							{
								type: "Default",
								filename: "Triangle_4.png",
								// hotspotsVisible: false, //for debugging. 							
								hotspots: [
									{ x: 0, y: 112, width: 14, height: 14 },
									{ x: 14, y: 84, width: 14, height: 42 },
									{ x: 28, y: 56, width: 14, height: 70 },
									{ x: 42, y: 28, width: 14, height: 98 },
									{ x: 56, y: 0, width: 14, height: 126 },
									{ x: 112, y: 112, width: 14, height: 14 },
									{ x: 98, y: 84, width: 14, height: 42 },
									{ x: 84, y: 56, width: 14, height: 70 },
									{ x: 70, y: 28, width: 14, height: 98 }
								]
							}
						]
					}
				]
			}]
		}
	]
};