    var statusElement = document.getElementById('status');
    var progressElement = document.getElementById('progress');
    var spinnerElement = document.getElementById('spinner');
    var botonDebugElement = document.getElementById('botonDebug');
    var AngelMxC_principal_logo = document.getElementById('principal_logo');
    var AngelMxC_output = document.getElementById('output');
    var canvasElement = document.getElementById('canvas');

        var Module = {
            preRun: [],
            postRun: [],
            print: (function () {
                var element = document.getElementById('output');
                if (element) element.value = ''; // clear browser cache
                return function (text) {
                    text = Array.prototype.slice.call(arguments).join(' ');
                    // These replacements are necessary if you render to raw HTML
                    //text = text.replace(/&/g, "&amp;");
                    //text = text.replace(/</g, "&lt;");
                    //text = text.replace(/>/g, "&gt;");
                    //text = text.replace('\n', '<br>', 'g');
                    console.log(text);
                    if (element) {
                        element.value += text + "\n";
                        element.scrollTop = element.scrollHeight; // focus on bottom
                    }
                };
            })(),
            printErr: function (text) {
                text = Array.prototype.slice.call(arguments).join(' ');
                if (0) { // XXX disabled for safety typeof dump == 'function') {
                    dump(text + '\n'); // fast, straight to the real console
                } else {
                    console.error(text);
                }
            },
            canvas: document.getElementById('canvas'),
            setStatus: function (text) {
                if (!Module.setStatus.last) Module.setStatus.last = { time: Date.now(), text: '' };
                if (text === Module.setStatus.text) return;
                var m = text.match(/([^(]+)\((\d+(\.\d+)?)\/(\d+)\)/);
                var now = Date.now();
                if (m && now - Date.now() < 30) return; // if this is a progress update, skip it if too soon
                if (m) {
                    text = m[1];
                    progressElement.value = parseInt(m[2]) * 100;
                    progressElement.max = parseInt(m[4]) * 100;
                    progressElement.hidden = false;
                    spinnerElement.hidden = false;
                } else {
                    progressElement.value = null;
                    progressElement.max = null;
                    progressElement.hidden = true;
                    if (!text) {
                        spinnerElement.hidden = true;
                    }
                }
                statusElement.innerHTML = text;
            },
            totalDependencies: 0,
            monitorRunDependencies: function (left) {
                this.totalDependencies = Math.max(this.totalDependencies, left);
                Module.setStatus(left ? 'Preparing... (' + (this.totalDependencies - left) + '/' + this.totalDependencies + ')' : 'Loading...');
            }
        };
        Module.setStatus('Downloading...');

       if(canvasElement){
           canvasElement.oncontextmenu = function (event) {
              event.preventDefault();
           };
       }

        //Inicialización
       if(AngelMxC_principal_logo){
           AngelMxC_principal_logo.style.display = 'block';
       }

       //DEBUG
       botonDebugElement=document.getElementById('canvas');
        if (botonDebugElement) {
            /*
            botonDebugElement.ontouch = function (evt) {
                if (evt.touches.length > 1 || (evt.type == "touchend" && evt.touches.length > 0)){
                    return;
                }
                
                var newEvt = document.createEvent("MouseEvents");
                var type = null;
                var touch = null;
                switch (event.type) {
                    case "touchstart": type = "mousedown"; touch = evt.changedTouches[0];
                    case "touchmove":  type = "mousemove"; touch = evt.changedTouches[0];
                    case "touchend":   type = "mouseup"; touch = evt.changedTouches[0];
                }
                newEvt.initMouseEvent(type, true, true, event.originalTarget.ownerDocument.defaultView, 0,
                                      touch.screenX, touch.screenY, touch.clientX, touch.clientY,
                                      evt.ctrlKey, evt.altKey, evt.shirtKey, evt.metaKey, 0, null);
                event.originalTarget.dispatchEvent(newEvt);
            };*/
            
            //Eventos ratón
            var isFFOS = (navigator.userAgent.search("Mobile") != -1);//!!"mozApps" in navigator && 
            if(isFFOS){
                //FIREFOX OS
                botonDebugElement.ontouchstart = function (event) {
                    event.preventDefault();
                    var touches = event.changedTouches;
                    for (var i=0;i<touches.length&&i<1;i++) {
                        AngelMxC_EventoRatonClick_presionado(touches[i].pageX-botonDebugElement.offsetLeft,touches[i].pageY-botonDebugElement.offsetTop); 
                    }
                    //AngelMxC_output.value+='presionado ';
                };
                botonDebugElement.ontouchend = function (event) {
                    event.preventDefault();
                    var touches = event.changedTouches;
                    for (var i=0;i<touches.length&&i<1;i++) {
                        AngelMxC_EventoRatonClick_liberado(touches[i].pageX-botonDebugElement.offsetLeft,touches[i].pageY-botonDebugElement.offsetTop); 
                    }
                };
                botonDebugElement.ontouchmove = function (event) {
                    event.preventDefault();
                    var touches = event.changedTouches;
                    for (var i=0;i<touches.length&&i<1;i++) {
                        AngelMxC_EventoRatonMovimiento(touches[i].pageX-botonDebugElement.offsetLeft,touches[i].pageY-botonDebugElement.offsetTop); 
                    }
                };
            }else{
                botonDebugElement.onmousedown = function (event) {
                    AngelMxC_EventoRatonClick_presionado(event.pageX-botonDebugElement.offsetLeft,event.pageY-botonDebugElement.offsetTop); 
                };
                botonDebugElement.onmouseup = function (event) {
                    AngelMxC_EventoRatonClick_liberado(event.pageX-botonDebugElement.offsetLeft,event.pageY-botonDebugElement.offsetTop); 
                };
                botonDebugElement.onmousemove = function (event) {
                    AngelMxC_EventoRatonMovimiento(event.pageX-botonDebugElement.offsetLeft,event.pageY-botonDebugElement.offsetTop); 
                };
            }
        }
