ig.module(
	'game.entities.button'
)
.requires(
	'impact.entity',
	'impact.animation'
)
.defines(function(){
	
EntityButton = ig.Entity.extend({
	click: new ig.Sound( 'media/sounds/click.*', true ),
	
	visible: true,
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.addAnim('idle', 1, [0]);
		this.addAnim('hover', 1, [1]);
		this.addAnim('active', 0.05, [2]);
		
		this.size.x = this.animSheet.width;
		this.size.y = this.animSheet.height;
	},
	
	alignToCenter: function() {
		this.pos.x -= Math.floor(this.size.x / 2);
		this.pos.y -= Math.floor(this.size.y / 2);
	},
	
    isMouseHover: function() {
	    return (
	        (this.pos.x <= ig.input.mouse.x && ig.input.mouse.x < this.pos.x + this.size.x) &&
	        (this.pos.y <= ig.input.mouse.y && ig.input.mouse.y < this.pos.y + this.size.y)
	    );
	},
	
	update: function() {
		if (this.currentAnim == this.anims.active) {
			if (this.currentAnim.loopCount) {
				this.currentAnim = this.anims.hover.rewind();
			}
		} else {
			this.currentAnim = this.isMouseHover() ? this.anims.hover : this.anims.idle;
		}
		
		if (ig.input.pressed('mouse1') && this.isMouseHover() && this.visible) {
			this.click.play();
			
			this.clicked();
			
			this.currentAnim = this.anims.active.rewind();
		}
		
		this.currentAnim.update();
	},
	
	draw: function() {
		if (this.visible) {
			if( this.currentAnim ) {
				this.currentAnim.draw(
					this.pos.x.round() - this.offset.x,
					this.pos.y.round() - this.offset.y
				);
			}
		}
	},
	
	clicked: function() {
		
	}
});

});

