ig.module(
	'game.entities.checkpoint'
).
requires(
	'impact.entity'
).
defines(function () {
    EntityCheckpoint = ig.Entity.extend({
        size: {
            x: 34,
            y: 32
        },
        zIndex: -1,
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.A,
        collides: ig.Entity.COLLIDES.NEVER,
        // sound: new ig.Sound('media/sounds/respawn-activate.ogg', false),
        animSheet: new ig.AnimationSheet('media/sprites/checkpoint.png', 34, 32),
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            
            this.addAnim('idle', 1, [1]);
            this.addAnim('activated', 1, [0]);
            this.addAnim('respawn', 0.3, [0]);
        },
        update: function () {
            if (this.currentAnim == this.anims.respawn && this.currentAnim.loopCount > 10) {
                this.currentAnim = this.anims.activated;
            }
            this.currentAnim.update();
        },
        getSpawnPos: function () {
            return {
                x: (this.pos.x + 11),
                y: this.pos.y
            };
        },
        activate: function () {
            //this.sound.play();
            this.active = true;
            this.currentAnim = this.anims.activated;
            ig.game.lastCheckpoint = this;
        },
        check: function (other) {
            if (!this.active) {
                this.activate();
            }
        }
    });
});