ig.module(
	'game.entities.player'
).
requires(
	'impact.entity',
	'game.entities.particle'
).
defines(function () {
    EntityPlayer = ig.Entity.extend({
        size: {
            x: 18,
            y: 22
        },
        offset: {
            x: (34 - 18) / 2,
            y: 8
        },
        maxVel: {
            x: 100,
            y: 200
        },
        friction: {
            x: 600,
            y: 0
        },
        bounciness: 0,
        type: ig.Entity.TYPE.A,
        checkAgainst: ig.Entity.TYPE.NONE,
        collides: ig.Entity.COLLIDES.PASSIVE,
        animSheet: new ig.AnimationSheet('media/sprites/sheep.png', 34, 30),
        flip: false,
        accelGround: 400,
        accelAir: 200,
        jump: 200,
        jumpSound: new ig.Sound('media/sounds/jump.*', true),
        hurtSound: new ig.Sound('media/sounds/hurt.*', true),
        dieSound: new ig.Sound('media/sounds/die.*', true),
        health: 30,
        zIndex: 1,
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            
            this.addAnim('idle1', 1, [5]);
            this.addAnim('run1', 0.05, [6, 7, 8, 0, 1, 2, 3, 4, 5]);
            this.addAnim('jump1', 1, [9]);
            this.addAnim('fall1', 1, [5]);
            
            var ao = 10;
            this.addAnim('idle2', 1, [ao + 5]);
            this.addAnim('run2', 0.05, [ao + 6, ao + 7, ao + 8, ao + 0, ao + 1, ao + 2, ao + 3, ao + 4, ao + 5]);
            this.addAnim('jump2', 1, [ao + 9]);
            this.addAnim('fall2', 1, [ao + 5]);
            
            this.anims.idle = this.anims.idle2;
            this.anims.run = this.anims.run2;
            this.anims.jump = this.anims.jump2;
            this.anims.fall = this.anims.fall2;
            
            this.addAnim('spawn', 0.05, [ao + 5, 20, ao + 5, 20, ao + 5, 20, ao + 5, 20, ao + 5, 20, ao + 5, 20]);
            this.addAnim('hurt', 0.05, [20]);
            this.addAnim('die', 0.1, [20]);
            
            if( Object.defineProperty ) { // Standard
				Object.defineProperty(this,"panic", { 
					get: this.getPanic.bind(this),
					set: this.setPanic.bind(this)
				});
			}
			else if( this.__defineGetter__ ) { // Non-standard
				this.__defineGetter__('panic', this.getPanic.bind(this));
				this.__defineSetter__('panic', this.setPanic.bind(this));
			}
        },
        update: function () {
        	if (ig.game.gameOver)
        		return;
        	
        	if (this.currentAnim == this.anims.spawn) {
                this.currentAnim.update();
                if (this.currentAnim.loopCount) {
                    this.currentAnim = this.anims.idle.rewind();
                } else {
                    return;
                }
            }
            
            if (this.currentAnim == this.anims.die) {
                this.currentAnim.update();
                if (this.currentAnim.loopCount) {
                    this.kill();
                }
                return;
            }
        	
            var accel = this.standing ? this.accelGround : this.accelAir;
            
            if (ig.input.state('left') || (ig.game.joystick && ig.game.joystick.state('left'))) {
                this.accel.x = -accel;
                this.flip = true;
            } else if (ig.input.state('right') || (ig.game.joystick && ig.game.joystick.state('right'))) {
                this.accel.x = accel;
                this.flip = false;
            } else {
                this.accel.x = 0;
            }
            
            if (this.standing && (ig.input.state('jump') || (ig.game.joystick && ig.game.joystick.state('jump')))) {
                this.vel.y = -this.jump;
                
                if (!ig.ua.mobile) 
                {
					this.jumpSound.play();
                }
            }
            
            if (this.currentAnim == this.anims.hurt) {
                if (this.currentAnim.loopCount) {
                    this.currentAnim = null;
                }
            }
            
            if (this.currentAnim != this.anims.hurt) {
	            if (this.vel.y < 0) {
	                this.currentAnim = this.anims.jump;
	            } else if (this.vel.y > 0) {
	                this.currentAnim = this.anims.fall;
	            } else if (this.vel.x != 0) {
	                this.currentAnim = this.anims.run;
	            } else {
	                this.currentAnim = this.anims.idle;
	            }
			}
            
            this.currentAnim.flip.x = this.flip;
            this.parent();
        },
        receiveDamage: function (amount, from) {
            // this.anims.hit.flip.x = this.currentAnim.flip.x;
            // this.currentAnim = this.anims.hit.rewind();
            // this.seenPlayer = true;
            //this.inJump = false;
            
            if (from.name == "saw")
            {
            	this.vel.x += 300;
			}
            else
            {
                this.vel.y = -250;
			}
            
            this.parent(amount);
            
            this.currentAnim = this.anims.hurt.rewind();
            this.panic = true;
            
            if (!ig.ua.mobile) 
            {
				this.hurtSound.play();
            }
        },
        kill: function () {
            var gibs = ig.ua.mobile ? 5 : 20;
            for (var i = 0; i < gibs; i++) {
                ig.game.spawnEntity(EntityPlayerGib, this.pos.x, this.pos.y);
            }
            this.parent();
            
            if (!ig.ua.mobile) 
            {
				this.dieSound.play();
            }
            
            ig.game.respawnDeferred(this.pos.x, this.pos.y);
        },
        setPanic: function(value) {
        	if (value)
        	{
				this.anims.idle = this.anims.idle1;
	            this.anims.run = this.anims.run1;
	            this.anims.jump = this.anims.jump1;
	            this.anims.fall = this.anims.fall1;
			}
			else
			{
				this.anims.idle = this.anims.idle2;
	            this.anims.run = this.anims.run2;
	            this.anims.jump = this.anims.jump2;
	            this.anims.fall = this.anims.fall2;
			}
        },
        getPanic: function() {
			return this.anims.idle == this.anims.idle1;
        },
        triggeredBy: function( entity, trigger ) {
        	if (trigger.name == 'trigger1')
        	{
        		this.vel.y = -90;
        		this.panic = true;
			}
			else if (trigger.name == 'finish')
        	{
        		ig.game.reachFinish();
			}
			//this.durationTimer.set( this.duration );
			//this.nextEmit.set( 0 );
		}
    });
    
    EntityPlayerGib = EntityParticle.extend({
        lifetime: 3,
        fadetime: 0.7,
        friction: {
            x: 0,
            y: 0
        },
        vel: {
            x: 120,
            y: 120
        },
        size: {
			x: 8,
			y: 8
        },
        animSheet: new ig.AnimationSheet('media/sprites/sheep-gibs.gif', 8, 8),
        init: function (x, y, settings) {
            this.addAnim('idle', 6, [
            	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11
            ]);
            this.parent(x, y, settings);
        }
    });
});