ig.module(
	'game.entities.saw'
).
requires(
	'impact.entity'
).
defines(function () {
    EntitySaw = ig.Entity.extend({
    	damage: 10,
        size: {
            x: 32,
            y: 320
        },
        zIndex: 0,
        visible: false,
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.A,
        //collides: ig.Entity.COLLIDES.NEVER,
        // sound: new ig.Sound('media/sounds/respawn-activate.ogg', false),
        animSheet: new ig.AnimationSheet('media/sprites/saw.png', 32, 320),
        init: function (x, y, settings) {
            this.parent(x, y, settings);

            this.addAnim('idle', 0.02, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]);
        },
        check: function (other) {
        	if (this.visible && !ig.game.gameOver)
        	{
				other.receiveDamage(this.damage, this);
			}
        },
        update: function () {
        	if (this.visible)
        	{
	            this.currentAnim.update();
	            
	            //this.pos.x += 5 * ig.system.tick;
	            var speed = Math.abs(ig.game.player.pos.x - this.pos.x) / 2.5;
	            
                var sw = ig.system.width / 480;

	            if (ig.game.player.pos.x - this.pos.x > 200 * sw)
            		this.pos.x += Math.max(10, speed) * ig.system.tick;
	            else
            		this.pos.x += Math.max(10, Math.sqrt(this.pos.x) / 1.3) * ig.system.tick;
            		
            	if (this.pos.x > ig.game.camera.max.x)
            		this.pos.x = ig.game.camera.max.x;
            		
	            /*var s = this.strength * Math.pow( 10, 2 );
				if( s > 0.5 ) {
					this.pos.x += Math.random().map( 0, 1, -s, s );
					this.pos.y += Math.random().map( 0, 1, -s, s );
				}
				
				this.parent();*/
			}
        },
        draw: function() {
			if (this.visible)
        	{
        		this.parent();
			}
        },
        triggeredBy: function( entity, trigger ) {
			if (trigger.name == "trigger1")
			{
				this.visible = true;
				
				ig.music.playTrack(1);
			}
		}
    });
});