ig.module(
	'game.scores'
)
.requires(
	'impact.game',
	'impact.font',
	
	// Entities
	'game.entities.button',
	'game.entities.loading'
)
.defines(function(){
	
Scores = ig.Game.extend({
	font: new ig.Font( 'media/font-calypso.png' ),
	font2: new ig.Font( 'media/font-calypso-x2.png' ),
	
	loading: null,
	
	clearColor: '#18182A',
	
	scores: null,
	error: null,
	offset: 0,
	
	init: function() {
		this.parent();
		
		if (!Scores.initialized) {

            Scores.initialized = true;
		}
		
		this.loading = this.spawnEntity( EntityLoading, ig.system.width / 2, ig.system.height / 2 );
		this.loading.text = "Loading...";
		
		this.spawnEntity( ScoresEntityButtonMenu, ig.system.width / 2, ig.system.height - 35 );
		// this.spawnEntity( ScoresEntityButtonSubmit, ig.system.width / 2 + 50, ig.system.height - 35 );
		
		var options = {
			global: true,
			highest: true,
			mode: "alltime",
			page: 1,
			perpage: 10
		};
		
		try {
			Playtomic.Leaderboards.List("HighScore", this.loadComplete.bind(this), options);
		} catch (e) {
			if (window.console && window.console.log)
				window.console.log(e);
		}

		ig.localyticsSession.tagScreen("Scores");
		
		/*this.loadComplete([
			{Name: "Test-Test-Test-Test-Test-", Points: 100000},
			{Name: "TEst2", Points: 10001},
			{Name: "TEst3", Points: 10002},
			{Name: "TEst4", Points: 10003},
			{Name: "TEst5", Points: 10004},
			{Name: "TEst6", Points: 10005},
			{Name: "TEst6", Points: 10005},
			{Name: "TEst6", Points: 10005},
			{Name: "TEst6", Points: 10005},
			{Name: "TEst6", Points: 10005}], 100, {Success: true});*/
	},
	
	hide: function() {
		this.parent();
	},
	
	update: function() {
		this.parent();
	},
	
	draw: function() {
		ig.system.clear( this.clearColor );
		
		this.font2.draw("High Scores", ig.system.width / 2, 15, ig.Font.ALIGN.CENTER);
		
		this.loading.visible = false;
		if (this.error != null)
		{
			this.font.draw(this.error, ig.system.width / 2, ig.system.height / 2 - this.font.height / 2, ig.Font.ALIGN.CENTER);
		}
		else if (this.scores != null)
		{
			this.scores.forEach(function(score, i){
				var y = 70 + i * 16;
				
				var name = score.Name;
				if (name.length > 12)
					name = name.substr(0, 12) + '...';
				
				this.font.draw(this.offset + i + 1 + ". ", ig.system.width / 2 - 107, y, ig.Font.ALIGN.RIGHT);
				this.font.draw(name, ig.system.width / 2 - 100, y, ig.Font.ALIGN.LEFT);
				
				var points = score.Points + "";
				/*while (points.length < 8)
        			points = '0' + points;*/
        			
				this.font.draw(points, ig.system.width / 2 + 107, y, ig.Font.ALIGN.RIGHT);
			}.bind(this));
		}
		else
		{
			this.loading.visible = true;
		}
		
		for( var i = 0; i < this.entities.length; i++ ) {
			this.entities[i].draw();
		}
	},
	
	/// scores, response.Data.NumScores, {Success: response.Status == 1, ErrorCode: response.ErrorCode}
	/**
	 	var score = {};
		score.Name = Playtomic.Unescape(arr[i].Name);
		score.FBUserId = arr[i].FBUserId;
		score.Points = arr[i].Points;
		score.Website = arr[i].Website;
		score.SDate = arr[i].SDate;
		score.RDate = arr[i].RDate;
		score.CustomData = {};

		for(x in arr[i].CustomData)
			score.CustomData[x] = Playtomic.Unescape(arr[i].CustomData[x]);

		scores[i] = score;
	*/
	loadComplete: function(scores, numScores, answer) {
		//window.console.log("Load complete!" + numScores);
		
		this.error = null;
		if (answer.Success)
		{
			this.scores = [];
			scores.forEach(function(score, i) {
				// window.console.log("-", score);
				this.scores.push({ Name: score.Name, Points: score.Points });
			}.bind(this));

			//window.console.log(this.scores);
			if (this.scores.length == 0)
			{
				this.scores = null;
				this.error = "No scores submitted yet. Be the first!";
			}
		}
		else
		{
			this.error = "Error occurred while loading scores.";
			
			// if (window.console)
			//	window.console.log(asnwer.ErrorCode);
		}
	}
});

ScoresEntityButtonMenu = EntityButton.extend({
	name: "menu",
	animSheet: new ig.AnimationSheet( 'media/sprites/button-menu.png', 56, 38 ),
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.alignToCenter();
	},
	
	clicked: function() {
		ig.system.switchGame(Title);
	}
});

ScoresEntityButtonSubmit = EntityButton.extend({
	name: "submit",
	animSheet: new ig.AnimationSheet( 'media/sprites/button-submit.png', 75, 38 ),
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.alignToCenter();
	},
	
	clicked: function() {
		
	}
});

});