ig.module(
	'game.title'
)
.requires(
	'impact.game',
	'impact.font',
	'impact.animation',
	
	// Entities
	'game.entities.button'
)
.defines(function(){
	
Title = ig.Game.extend({
	musicEarthquake: new ig.Sound( 'media/sounds/music-earthquake.*', false ),
	musicAmbient: new ig.Sound( 'media/sounds/music-ambient.*', false ),
	
	logo: new ig.Image( 'media/sprites/logo.png' ),
	joystick: null,
	
	clearColor: '#18182A',
	
	init: function() {
		this.parent();
		
		// this.joystick = this.spawnEntity( TitleEntitySwitchButtonJoystick, ig.system.width - 35, ig.system.height - 35 );
		
		if (!Title.initialized) {
			ig.music.loop = true;
			ig.music.add( this.musicAmbient );
			ig.music.add( this.musicEarthquake );
			
			ig.input.bind(ig.KEY.MOUSE1, 'mouse1');
			
			// this.joystick.checked = ig.ua.mobile;
			
            Title.initialized = true;
		} else {
			// this.joystick.checked = Title.joystickState;
		}
		
		ig.music.playTrack(0);
		
		// try {
		// 	if (!Playtomic)
		// 		throw("Playtomic not loaded");
			
			// this.spawnEntity( TitleEntityButtonPlay, ig.system.width / 2 - 50, ig.system.height - 35 );
			// this.spawnEntity( TitleEntityButtonScores, ig.system.width / 2 + 40, ig.system.height - 35 );
		// } catch (e) {
			this.spawnEntity( TitleEntityButtonPlay, ig.system.width / 2, ig.system.height - 35 );
		// }

		ig.localyticsSession.tagScreen("Title");
		ig.localyticsSession.upload();
	},
	
	update: function() {
		this.parent();
	},
	
	draw: function() {
		ig.system.clear( this.clearColor );
		
		this.logo.draw((ig.system.width - this.logo.width) / 2, (ig.system.height - this.logo.height) / 2 - 20);
		
		for( var i = 0; i < this.entities.length; i++ ) {
			this.entities[i].draw();
		}
	}
});

TitleEntityButtonPlay = EntityButton.extend({
	name: "play",
	animSheet: new ig.AnimationSheet( 'media/sprites/button-play.png', 56, 38 ),
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.alignToCenter();
	},
	
	clicked: function() {
		ig.system.switchGame(SheepGame);

		ig.localyticsSession.tagEvent("Title: Click Play Button");
	}
});

// TitleEntityButtonScores = EntityButton.extend({
// 	name: "scores",
// 	animSheet: new ig.AnimationSheet( 'media/sprites/button-scores.png', 75, 38 ),
	
// 	init: function( x, y, settings ) {
// 		this.parent(x, y, settings);
		
// 		this.alignToCenter();
// 	},
	
// 	clicked: function() {
// 		// ig.system.switchGame(Scores);

// 		// Check the result of the user status and display login button if necessary
// 		function checkLoginStatus(response) {
// 			if(response && response.status == 'connected') {
// 				alert('User is authorized');
// 				// document.getElementById('loginButton').style.display = 'none';
// 				console.log('Access Token: ' + response.authResponse.accessToken);
// 			} else {
// 				alert('User is not authorized');

// 				if (confirm('Authorize?')) {
// 					FB.login(checkLoginStatus, {scope:'email'});
// 				}
// 				// document.getElementById('loginButton').style.display = 'block';
// 			}
// 		}

// 		// Check if the current user is logged in and has authorized the app
// 		FB.getLoginStatus(checkLoginStatus);
// 	}
// });

/*
TitleEntitySwitchButtonJoystick = EntityButton.extend({
	name: "scores",
	animSheet: new ig.AnimationSheet( 'media/sprites/button-joystick.png', 38, 38 ),
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.anims.idle1 = this.anims.idle;
		this.anims.hover1 = this.anims.hover;
		this.addAnim('idle2', 1, [2]);
		this.addAnim('hover2', 1, [3]);
		
		this.alignToCenter();
		
		if( Object.defineProperty ) { // Standard
			Object.defineProperty(this,"checked", { 
				get: this.getChecked.bind(this),
				set: this.setChecked.bind(this)
			});
		}
		else if( this.__defineGetter__ ) { // Non-standard
			this.__defineGetter__('checked', this.getChecked.bind(this));
			this.__defineSetter__('checked', this.setChecked.bind(this));
		}
	},
	
	clicked: function() {
		this.checked = !this.checked;
	},
	
	setChecked: function(value) {
        if (value)
        {
			this.anims.idle = this.anims.idle2;
			this.anims.hover = this.anims.hover2;
		}
		else
		{
			this.anims.idle = this.anims.idle1;
			this.anims.hover = this.anims.hover1;
		}
		
		Title.joystickState = this.checked;
    },
    getChecked: function() {
		return this.anims.idle == this.anims.idle2;
    },
});*/

});