var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../Subscriber'], function (require, exports, Subscriber_1) {
    function defaultIfEmpty(defaultValue) {
        if (defaultValue === void 0) { defaultValue = null; }
        return this.lift(new DefaultIfEmptyOperator(defaultValue));
    }
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.default = defaultIfEmpty;
    var DefaultIfEmptyOperator = (function () {
        function DefaultIfEmptyOperator(defaultValue) {
            this.defaultValue = defaultValue;
        }
        DefaultIfEmptyOperator.prototype.call = function (subscriber) {
            return new DefaultIfEmptySubscriber(subscriber, this.defaultValue);
        };
        return DefaultIfEmptyOperator;
    })();
    var DefaultIfEmptySubscriber = (function (_super) {
        __extends(DefaultIfEmptySubscriber, _super);
        function DefaultIfEmptySubscriber(destination, defaultValue) {
            _super.call(this, destination);
            this.defaultValue = defaultValue;
            this.isEmpty = true;
        }
        DefaultIfEmptySubscriber.prototype._next = function (x) {
            this.isEmpty = false;
            this.destination.next(x);
        };
        DefaultIfEmptySubscriber.prototype._complete = function () {
            if (this.isEmpty) {
                this.destination.next(this.defaultValue);
            }
            this.destination.complete();
        };
        return DefaultIfEmptySubscriber;
    })(Subscriber_1.default);
});
//# sourceMappingURL=defaultIfEmpty.js.map