var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../Subscriber'], function (require, exports, Subscriber_1) {
    /**
     * Maps every value to the same value every time.
     * @param {any} value the value to map each incoming value to
     * @returns {Observable} an observable of the passed value that emits everytime the source does
     */
    function mapTo(value) {
        return this.lift(new MapToOperator(value));
    }
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.default = mapTo;
    var MapToOperator = (function () {
        function MapToOperator(value) {
            this.value = value;
        }
        MapToOperator.prototype.call = function (subscriber) {
            return new MapToSubscriber(subscriber, this.value);
        };
        return MapToOperator;
    })();
    var MapToSubscriber = (function (_super) {
        __extends(MapToSubscriber, _super);
        function MapToSubscriber(destination, value) {
            _super.call(this, destination);
            this.value = value;
        }
        MapToSubscriber.prototype._next = function (x) {
            this.destination.next(this.value);
        };
        return MapToSubscriber;
    })(Subscriber_1.default);
});
//# sourceMappingURL=mapTo.js.map