let objectTypes = {
    'boolean': false,
    'function': true,
    'object': true,
    'number': false,
    'string': false,
    'undefined': false
};
export let root = (objectTypes[typeof self] && self) || (objectTypes[typeof window] && window);
let freeExports = objectTypes[typeof exports] && exports && !exports.nodeType && exports;
let freeModule = objectTypes[typeof module] && module && !module.nodeType && module;
let freeGlobal = objectTypes[typeof global] && global;
if (freeGlobal && (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal)) {
    root = freeGlobal;
}
