var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var angular2_1 = require('angular2/angular2');
var router_1 = require('angular2/router');
var data_service_1 = require('../../services/data-service');
var storage_service_1 = require("../../services/storage-service");
var modal_service_1 = require("../../services/modal-service");
var currency_pipe_1 = require('../../pipes/currency-pipe');
var ItemsComponent = (function () {
    function ItemsComponent(storageService, modalService) {
        var _this = this;
        this.storageService = storageService;
        this.modalService = modalService;
        this.title = "Items";
        this.tax = 0.07;
        //force localStorage
        this.storageService.init();
        localforage.getItem("cost", function (err, value) {
            if (err) {
                console.log(err);
            }
            else {
                if (value === null) {
                    _this.cost = 0;
                }
                else {
                    _this.cost = value;
                }
            }
        });
        localforage.getItem("items", function (err, value) {
            if (err) {
                console.log(err);
            }
            else {
                //there were no items saved
                if (value === null) {
                    _this.items = [];
                }
                else {
                    _this.items = value;
                }
            }
        });
    }
    //open modal to add new item
    ItemsComponent.prototype.addItem = function () {
        this.modalService.open();
    };
    //add item
    ItemsComponent.prototype.add = function (name, price) {
        var newItem = new data_service_1.DataService(name, price);
        //have to convert this to a number so we can add up the total cost
        var realPrice = parseInt(newItem.price);
        //set the cost of the item
        this.cost = this.cost + realPrice + this.tax;
        this.items.push(newItem);
        this.storageService.save("items", this.items);
        this.storageService.save("cost", this.cost);
        this.modalService.close();
    };
    //user decides to not add item
    ItemsComponent.prototype.close = function () {
        this.modalService.close();
    };
    //user removes item
    ItemsComponent.prototype.removeItem = function (item) {
        this.items.splice(this.items.indexOf(item), 1);
        this.cost = this.cost - item.price - this.tax;
        this.storageService.save("cost", this.cost);
        this.storageService.save("items", this.items);
        navigator.vibrate(500);
    };
    ItemsComponent = __decorate([
        angular2_1.Component({
            selector: 'shoppingItems',
            providers: [storage_service_1.StorageService, modal_service_1.ModalService],
            templateUrl: 'app/components/items/items-component.html',
            directives: [router_1.RouterLink, angular2_1.NgFor],
            pipes: [currency_pipe_1.CurrencyPipe]
        }), 
        __metadata('design:paramtypes', [storage_service_1.StorageService, modal_service_1.ModalService])
    ], ItemsComponent);
    return ItemsComponent;
})();
exports.ItemsComponent = ItemsComponent;
//# sourceMappingURL=items-component.js.map