var Arme = Entity.extend({
	init: function(coord){
		this._super();
		this.coord = coord;

		this.level = 0;
		this.attaque = 5;
		this.attaqueBonus = 0;
		this.attaqueSup = 0;
		this.tempsRecharge = 100;
		this.tempsRechargeBonus=0;
		this.vitesseBalle=0.5;
		this.nbMunition = -1;	// -1 pour illimité
		this.timeLastShoot = 0;
	},
	
	reset: function(){
		this.level = 0;
		this.attaqueBonus = 0;
		this.attaqueSup = 0;
		this.tempsRechargeBonus=0;
		this.timeLastShoot = 0;
	},
		
	getAttaque: function(){
		return this.attaque+this.attaqueBonus+this.attaqueSup;
	},	
	
	update: function(){
		
	},
	
	draw: function(){

	},
	

	
	EvtAttaque: function(){
		
		// Plus de munition
		if (this.nbMunition==0)
			return;		
		
		var temps = this.tempsRecharge+this.tempsRechargeBonus;
		if (temps<this.tempsRecharge*0.2)
			temps=this.tempsRecharge*0.2;
			
		if (game.gameTimeElapse-this.timeLastShoot>temps){
			if (this.nbMunition>0)
				this.nbMunition--;
			this.EvtDoAttaque();
			this.timeLastShoot = game.gameTimeElapse;
			
			sonManager.play(SON_hk53);
		}
	},
	
	levelUp: function(){
		this.level++;
	
	
		if (this.level>=20){
			this.attaqueSup+=0.5;
		}		
		else if (this.level>=10){
			//this.tempsRecharge*=0.95;
			this.tempsRecharge*=0.97;
			this.vitesseBalle*=1.01;
			this.attaqueSup+=0.3;
		}
		else if (this.level>=4){
			this.tempsRecharge*=0.87;
			this.vitesseBalle*=1.05;
			this.attaqueSup+=0.2;			
		}
		
	},	
	
	
	EvtDoAttaque: function(){
	},	
});

var ArmeStandardNiv1 = Arme.extend({
	init: function(coord){
		this._super(coord);

		this.attaque = 0;
		this.tempsRecharge = 300;
	},

	EvtDoAttaque: function(){
		
		game.nbTireArme1++;
		
		if (this.level==0){
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
		}
		else if (this.level==1){
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));		
		}
		else if (this.level==2){ 
			game.tballes.push(new Balle1(new Vec(this.coord.x-8, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+93, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));			
		}
		else {
			game.tballes.push(new Balle1(new Vec(this.coord.x-28, this.coord.y-10), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x-8, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+93, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+113, this.coord.y-10), new VDep(0,this.vitesseBalle), this.getAttaque()));			
		}		
	}
});

var ArmeStandardNiv2 = ArmeStandardNiv1.extend({

	EvtDoAttaque: function(){
		game.nbTireArme1++;
		
		if (this.level==0){
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
		}
		else if (this.level==1){ 
			game.tballes.push(new Balle1(new Vec(this.coord.x-8, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+93, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));			
		}
		else if (this.level==2){ 
			game.tballes.push(new Balle1(new Vec(this.coord.x-28, this.coord.y-10), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x-8, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+93, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+113, this.coord.y-10), new VDep(0,this.vitesseBalle), this.getAttaque()));			
		}
		else {
			game.tballes.push(new Balle1(new Vec(this.coord.x-48, this.coord.y-13), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x-28, this.coord.y-10), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x-8, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-2), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+93, this.coord.y-6), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+113, this.coord.y-10), new VDep(0,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+133, this.coord.y-10), new VDep(0,this.vitesseBalle), this.getAttaque()));		
		}			
		
	}
});

var ArmeDiagNiv1 = Arme.extend({
	init: function(coord){
		this._super(coord);

		this.attaque = 0;
		this.tempsRecharge = 250;
		
		this.vitesseBalle = 0.5;
	},	

	EvtDoAttaque: function(){
		game.nbTireArme1++;		
		
		game.tballes.push(new Balle1(new Vec(this.coord.x+42, this.coord.y), new VDep(0,0.6), this.getAttaque()));
		game.tballes.push(new Balle1(new Vec(this.coord.x-8, this.coord.y-6), new VDep(-1,game.vitesse_defilement), this.getAttaque()));
		game.tballes.push(new Balle1(new Vec(this.coord.x+93, this.coord.y-6), new VDep(1,game.vitesse_defilement), this.getAttaque()));	
	
		if (this.level>=1){
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(-this.vitesseBalle/3,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(this.vitesseBalle/3,this.vitesseBalle), this.getAttaque()));		
		}
		
		if (this.level>=2){
			game.tballes.push(new Balle1(new Vec(this.coord.x+32, this.coord.y), new VDep(-this.vitesseBalle/10,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+53, this.coord.y), new VDep(this.vitesseBalle/10,this.vitesseBalle), this.getAttaque()));			
		}
	
		if (this.level>=3){
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(-this.vitesseBalle,this.vitesseBalle), this.getAttaque()));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(this.vitesseBalle,this.vitesseBalle), this.getAttaque()));		
		}			
	}
});
var ArmeDiagNiv2 = ArmeDiagNiv1.extend({
	EvtDoAttaque: function(){	
		game.nbTireArme1++;
		
		game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(-this.vitesseBalle/6,this.vitesseBalle), this.getAttaque()));
		game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(-this.vitesseBalle/60,this.vitesseBalle), this.getAttaque()));
		game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(this.vitesseBalle/6,this.vitesseBalle), this.getAttaque()));
		game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(this.vitesseBalle/60,this.vitesseBalle), this.getAttaque()));
	}
});


var ArmeBigBullet = Arme.extend({
	init: function(coord, nbMunition, lvl){
		this._super(coord);


		this.attaque = 0;
		if (lvl==1)
			this.tempsRecharge = 4000;
		else if (lvl==2)
			this.tempsRecharge = 3000;
		else if (lvl==3)
			this.tempsRecharge = 2000;
		else 
			this.tempsRecharge = 1000;
			
		this.tempsRecharge /= lvl;
		
		
		
		
		this.vitesseBalle = 1;
		this.nbMunition=nbMunition;
	},


	
	EvtDoAttaque: function(){
		game.nbTireArme2++;
		game.tballes.push(new BalleGros(new Vec(this.coord.x+42, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
		this.timeLastShoot = game.gameTimeElapse;
	}
	
});

var ArmeBigArtifice = Arme.extend({
	init: function(coord, nbMunition, lvl){
		this._super(coord);

		this.attaque = 0;
		
		if (lvl==1)
			this.tempsRecharge = 1500;
		else if (lvl==2)
			this.tempsRecharge = 1200;
		else if (lvl==3)
			this.tempsRecharge = 1000;
		else 
			this.tempsRecharge = 800;
		
		
		
		this.vitesseBalle=0.6;
		this.nbMunition=nbMunition;
	},

	EvtDoAttaque: function(){
		game.nbTireArme2++;
		game.tballes.push(new BalleBigArtifice(new Vec(this.coord.x+35, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque()));
		this.timeLastShoot = game.gameTimeElapse;
	}
	
});

var ArmeMissile = Arme.extend({
	init: function(coord, nbMunition, lvl){
		this._super(coord);

		this.lvl=lvl;
		this.attaque = 0;
		this.tempsRecharge = 2000;
		
		this.vitesseBalle=0.45;
		this.nbMunition=nbMunition;
	},

	EvtDoAttaque: function(){
		game.nbTireArme2++;
		game.tballes.push(new Missile(false, new Vec(this.coord.x+35, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque(), undefined, this.lvl));
		this.timeLastShoot = game.gameTimeElapse;
	}
	
});

var ArmeMissileRandExpl = ArmeMissile.extend({
	init: function(coord, nbMunition, lvl){
		this._super(coord, nbMunition, lvl);
	},

	EvtDoAttaque: function(){
		game.nbTireArme2++;
		game.tballes.push(new MissileRandExpl(new Vec(this.coord.x+35, this.coord.y), new VDep(0,this.vitesseBalle), this.getAttaque(), undefined, this.lvl));
		this.timeLastShoot = game.gameTimeElapse;
	}
	
});

