var Balle = Entity.extend({
	init: function(coord, direction, attaqueSup){
		this._super();
		this.toto="boulete";
		this.tile = null;
		this.attaque = 0;
		this.attaqueSup = attaqueSup;
		this.coord = coord;
		this.direction = direction;
		this.collision = new Collisionneur();
		this.del = false;
	},
	
	update: function(){
		
		this.coord.addVec(this.direction.getDeplacement());
		
		this.coord.addVec(new VDep(0,game.vitesse_defilement).getDeplacement());
		
		if (this.getScreenCoord().y<-this.tile.coordBox.height || this.getScreenCoord().y>game.height || this.getScreenCoord().x<0 || this.getScreenCoord().x>game.width)
			this.delme();
	},

	getAttaque: function(){
		return this.attaqueSup+this.attaque;
	},	
	
	EvtExplose: function(){
		this.delme();
	},	
	
	draw: function(){
		if (this.tile!=null)
		{
			this.tile.setPosition(this.getScreenCoord());
			//this.tile.setPosition(this.coord);
			this.tile.draw();
		}
	}
		
});


var Balle1 = Balle.extend({
	init: function(coord, direction,attaqueSup){
		this._super(coord, direction,attaqueSup);
		this.toto="bouleteBall1";
		this.tile = new Tile(IMAGE_explosions);
		this.tile.setSprite(846, 783, 24, 19);
		this.tile.setPosition(this.getScreenCoord());
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, 24, 19));	
		
		this.attaque = 1;
	},
	
	EvtExplose: function(){
		this.delme();
	},
	
});

var Balle1TimeLimit = Balle1.extend({
	init: function(coord, direction, attaqueSup, distance_de_vie){
		this._super(coord, direction, attaqueSup);
		this.distance_de_vie=distance_de_vie;
		this.coordStart = coord.copy();
	},
	update: function(){
		this._super();
		
		//if (game.gameTimeElapse-this.timeStart>this.duree_de_vie){
		var dist = this.coordStart.getDist(this.coord);
		
		if (dist>this.distance_de_vie){		
			this.delme();
		}
	},		
});

var BalleGros = Balle.extend({
	init: function(coord, direction, attaqueSup){
		this._super(coord, direction, attaqueSup);
		this.tile = new Tile(IMAGE_explosions);
		this.tile.setSprite(773, 656, 39, 39);
		this.tile.setPosition(this.getScreenCoord());
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, 39, 39));	
		
		this.attaque = 10;
	},
		
});

var BalleBigArtifice = Balle.extend({
	init: function(coord, direction, attaqueSup){
		this._super(coord, direction, attaqueSup);
		this.tile = new Tile(IMAGE_explosions);
		this.tile.setSprite(773, 656, 39, 39);
		this.tile.setPosition(this.getScreenCoord());
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, 39, 39));	
		
		this.attaque = 10;
		
		//this.coordStart = coord.copy();
		this.screenCoordStart = this.getScreenCoord();
		
	},
	
	update: function(){
		this._super();
		
		//var dist = this.coordStart.getDist(this.coord);

		var dist = this.screenCoordStart.getDist(this.getScreenCoord());
	
		if (dist>300){
			this.delme();
			
			for (var i=1 ; i<8 ; i++){
				var v = angleToVec(i*45)
				game.tballes.push(new Balle1TimeLimit(this.coord.copy(), new VDep(v.x, v.y), this.attaqueSup, 200));
			}

		}
	},		
});


var Missile = Balle.extend({
	init: function(enemie, coord, direction, attaqueSup, distanceExplosion, lvl){
		this._super(coord, direction, attaqueSup);
		
		this.enemie=enemie;
		if (lvl==undefined)
			this.lvl=1;
		else
			this.lvl=lvl;
		this.tile = new Tile(IMAGE_missile);
		this.tile.setPosition(this.getScreenCoord());
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(this.tile.spriteBox.copy());		
		
		
		this.angle = vecToAngle(direction);
		this.tile.setAnge(-90-this.angle);
		
		if (distanceExplosion==undefined)
			this.distanceExplosion = 450;
		else
			this.distanceExplosion = distanceExplosion;
			
		this.attaque = 5;
		//this.coordStart = coord.copy();
		this.screenCoordStart = this.getScreenCoord();
	},
	
	
	EvtExplose: function(){	
		
		if (this.enemie)
			game.tballesEnnemi.push(new ExplosionMortel(this.coord, this.attaqueSup));
		else if (this.lvl==1)
			game.tballes.push(new ExplosionMortel(this.coord, this.attaqueSup));
		else if (this.lvl==2){
			var c = this.coord.copy();
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			var c = this.coord.copy();
			c.x=this.coord.x+80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			var c = this.coord.copy();
			c.x=this.coord.x-80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			var c = this.coord.copy();
			c.y=this.coord.y+80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			var c = this.coord.copy();
			c.y=this.coord.y-80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));						
		}
		else if (this.lvl==3){

			
			var c = this.coord.copy();
			c.x=this.coord.x+80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			var c = this.coord.copy();
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));			
			
			var c = this.coord.copy();
			c.x=this.coord.x-80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			
			var c = this.coord.copy();
			c.x=this.coord.x+80;
			c.y=this.coord.y+80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			var c = this.coord.copy();
			c.y=this.coord.y+80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));			
			
			var c = this.coord.copy();
			c.x=this.coord.x-80;
			c.y=this.coord.y+80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));			
			
			
			var c = this.coord.copy();
			c.x=this.coord.x+80;
			c.y=this.coord.y-80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
			
			var c = this.coord.copy();
			c.y=this.coord.y-80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));			
			
			var c = this.coord.copy();
			c.x=this.coord.x-80;
			c.y=this.coord.y-80;
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(200)));
					
		}		
		this.delme();
	},	
	
	update: function(){
		
		this.coord.addVec(this.direction.getDeplacement());
		this.coord.addVec(new VDep(0,game.vitesse_defilement).getDeplacement());
		
		if (this.getScreenCoord().y<-this.tile.coordBox.height || this.getScreenCoord().y>game.height || this.getScreenCoord().x<0 || this.getScreenCoord().x>game.width)
			this.delme();
	
		var dist = this.screenCoordStart.getDist(this.getScreenCoord());
		if (dist>this.distanceExplosion){
			this.EvtExplose();
/*			game.tEntity.push(new ExplosionMortel(this.coord));
			this.delme();*/
		}
	},	
		
});


var MissileRandExpl = Missile.extend({
	init: function(coord, direction, attaqueSup, distanceExplosion, lvl){
		this._super(false, coord, direction, attaqueSup, distanceExplosion, lvl);
	},
	

	EvtExplose: function(){	
		
		var l = 0;
		var h = 0;
		var duree = 0;
		
		if (this.lvl==1){
			l = 300;
			h = 300;
			duree = 2000;
		}
		else if (this.lvl==2){
			l = 400;
			h = 400;
			duree = 4000;			
		}
		else if (this.lvl==3){
			l = 500;
			h = 500;
			duree = 5000;			
		}		
		else if (this.lvl==4){
			l = 600;
			h = 800;
			duree = 6000;			
		}			
		
		var nbExplosion = ((l+h)/80)*duree/300;	
		
		// Une petite explosion au centre pour symbolisé l'explosion du missile
		game.tballes.push(new ExplosionMortel(this.coord.copy(), this.attaqueSup, 0));	
		
		// Plein d'explosion de partou
		while (nbExplosion>0){
			var c = this.coord.copy();
			c.x=this.coord.x-l/2+randomInt(l);
			c.y=this.coord.y-h/2+randomInt(h);
			game.tballes.push(new ExplosionMortel(c, this.attaqueSup, randomInt(duree)));
			
			nbExplosion--;
		}
		
			
		this.delme();
	},	
		
	
});


var ExplosionMortel = Balle.extend({
	init: function(coord, attaqueSup, delai){
		this._super(coord, new Vec(0,0), attaqueSup);

		if (delai==undefined)
			delai=0;
		this.delai=delai;

		this.ctp_temps = 0;

		this.attaque = 10;
	},
	
	initCollision: function(){
		var explosion = new ExplosionBig(this.coord);
		game.tEntity.push(explosion);		
		
		this.collision.setPosition(explosion.tile.coordBox);
		this.collision.addBox(explosion.tile.spriteBox.copy());	
		
		this.duree = explosion.getDuree();
	},		
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		if (this.delai>=0 && this.ctp_temps>=this.delai){
			this.initCollision();
			this.delai=-1;
			this.ctp_temps=0;
		}
		if (this.ctp_temps>=this.duree){
			this.delme();
		}
	},	
	delme: function(){		
		this.del = true;
	},		
});
