var Bonus = Entity.extend({
	init: function(coord){
		this._super();
		this.coord = coord;
		this.collision = new Collisionneur();	
		

		
		this.effectDone=false;
	},
	
	update: function(){
		if (this.getScreenCoord().y>game.height+128)
			this.delme();		
	},
	
	draw: function(){
		if (this.tile!=null){
			this.tile.setPosition(this.getScreenCoord());
			this.tile.draw();
		}
	},


	EvtCollision: function(){
		this.bonusEffect();
		this.delme();
		game.nbBonus++;
		sonManager.play(SON_item);
	},	
	

	bonusEffect: function(){
	},	
	
});	

var GraphBonusArgent = Bonus.extend({
	init: function(coord){
		this._super(coord);
		
		this.tile = new Tile(IMAGE_pickups);
		this.tile.setSpriteItem(ITEM_pickups_coin);
		this.tile.setMode(TILE_CENTER|TILE_MIDLE);
		this.tile.setPosition(this.getScreenCoord());
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));
		
	},
	
	bonusEffect: function(){
		game.nbBonusArgent++;
		game.argent+=40;
	},	
	
});	

var GraphBonusVitesseTire = Bonus.extend({
	init: function(coord){
		this._super(coord);
		
		this.tile = new Tile(IMAGE_pickups);
		this.tile.setSpriteItem(ITEM_pickups_life_up);
		this.tile.setMode(TILE_CENTER|TILE_MIDLE);
		this.tile.setPosition(this.getScreenCoord());
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));
	},
	
	bonusEffect: function(){
		game.tBonusEffect.push(new BonusVitesseTire());
	},	
});	



var GraphBonusPuissanceTire = Bonus.extend({
	init: function(coord){
		this._super(coord);
		
		this.tile = new Tile(IMAGE_pickups);
		this.tile.setSpriteItem(ITEM_pickups_diagonal_gun);
		this.tile.setMode(TILE_CENTER|TILE_MIDLE);
		this.tile.setPosition(this.getScreenCoord());
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));
		

	},
	
	bonusEffect: function(){
		game.tBonusEffect.push(new BonusPuissanceTire());
	},	
});

var GraphBonusArmeLvlUp = Bonus.extend({
	init: function(coord){
		this._super(coord);
		
		this.tile = new Tile(IMAGE_pickups);
		this.tile.setSpriteItem(ITEM_pickups_wingman);
		this.tile.setMode(TILE_CENTER|TILE_MIDLE);
		this.tile.setPosition(this.getScreenCoord());
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));
		

	},
	
	bonusEffect: function(){
		game.vehiculeJoueur.arme1.levelUp();
	},	
});


var GraphBonusVie = Bonus.extend({
	init: function(coord, lvl){
		this._super(coord);
		this.lvl=lvl;		
		
		this.tile = new Tile(IMAGE_pickups);
		this.tile.setSpriteItem(ITEM_pickups_vie);
		this.tile.setMode(TILE_CENTER|TILE_MIDLE);
		this.tile.setPosition(this.getScreenCoord());
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));
		
	},
	
	bonusEffect: function(){
		game.vehiculeJoueur.vie+=1+(this.lvl);
		game.vehiculeJoueur.vie=clampu(game.vehiculeJoueur.vie, game.vehiculeJoueur.vieMax);	
	},	
	
});




var BonusEffect = Entity.extend({
	init: function(){
		this._super();
		
		this.timeDel = 0;
		this.bonusEffect();
	},
	
	update: function(){	
		if (this.timeDel>0){
			this.timeDel-=game.timeDelay;
			if (this.timeDel<=0){
				this.effaceBonusEffect();
				this.delme();
				return;
			}
		}
	},

	bonusEffect: function(){

	},
	
	effaceBonusEffect: function(){
	},	
});	




var BonusPuissanceTire = BonusEffect.extend({
	init: function(){
		this.attaqueSup1 = 0;
		this.attaqueSup2 = 0;
		this.addBonus2 = 0;		
	
		this._super();
		this.timeDel = 10000;		
	
	},
	
	bonusEffect: function(){
		this.attaqueSup1 = Math.floor(game.vehiculeJoueur.arme1.attaque*0.2);
		if (this.attaqueSup1==0)
			this.attaqueSup1=1;
		game.vehiculeJoueur.arme1.attaqueBonus+=this.attaqueSup1;
		
		this.attaqueSup2 = Math.floor(game.vehiculeJoueur.arme2.attaque*0.2);
		if (this.attaqueSup2==0)
			this.attaqueSup2=1;
		game.vehiculeJoueur.arme2.attaqueBonus+=this.attaqueSup2;
	},
	
	effaceBonusEffect: function(){
		game.vehiculeJoueur.arme1.attaqueBonus-=this.attaqueSup1;
		game.vehiculeJoueur.arme2.attaqueBonus-=this.attaqueSup2;
	},
});	


var BonusVitesseTire = BonusEffect.extend({
	init: function(){
		this.addBonus1 = 0;
		this.addBonus2 = 0;		
	
		this._super();
		this.timeDel = 10000;		
	
	},
	
	bonusEffect: function(){
		this.addBonus1 = Math.floor(game.vehiculeJoueur.arme1.tempsRecharge/2);
		game.vehiculeJoueur.arme1.tempsRechargeBonus-=this.addBonus1;
		
		this.addBonus2 = Math.floor(game.vehiculeJoueur.arme2.tempsRecharge/2);
		game.vehiculeJoueur.arme2.tempsRechargeBonus-=this.addBonus2;	
	},
	
	effaceBonusEffect: function(){
		game.vehiculeJoueur.arme1.tempsRechargeBonus+=this.addBonus1;
		game.vehiculeJoueur.arme2.tempsRechargeBonus+=this.addBonus2;
	},
});	
