var CV_KEYBOARD = 1;
var CV_MOUSE = 2;
var CV_TACTILE = 3;

var CONTROLE_VEHICULE = CV_KEYBOARD;
if (mobileAndTabletcheck())
	CONTROLE_VEHICULE = CV_TACTILE;



var Controle = Class.extend({
	init: function(){
		this.direction = new Vec();
		this.attaque = false;
		this.attaque2 = false;		
	},
});	

var controle = new Controle();
var toucheHitDown = 0;			// La touche qui est en train d'etre appuyer
var toucheHitUp = 0;			// La touche qu'on vien de relacher
var toucheLastHitDown = 0;		// Derniere touche appuyer

var tToucheActive = new Array();
var MaxtoucheActive = 230;
for (var i=0 ; i<MaxtoucheActive ; i++)
	tToucheActive[i]=false;



var CODE_TOUCHE_BAS = 40;
var CODE_TOUCHE_HAUT = 38;
var CODE_TOUCHE_GAUCHE = 37;
var CODE_TOUCHE_DROITE = 39;
var CODE_TOUCHE_ATTAQUE = 32;
var CODE_TOUCHE_ATTAQUE_Bis = 70;
var CODE_TOUCHE_ATTAQUE2 = 17;
var CODE_TOUCHE_PAUSE = 80;
var CODE_TOUCHE_PGUP = 33;
var CODE_TOUCHE_PGDOWN = 34;
var CODE_TOUCHE_RESTART = 82;

var CODE_TOUCHE_A = 65;
var CODE_TOUCHE_B = 66;
var CODE_TOUCHE_C = 67;
var CODE_TOUCHE_D = 68;
var CODE_TOUCHE_E = 69;
var CODE_TOUCHE_F = 70;
var CODE_TOUCHE_G = 71;
var CODE_TOUCHE_H = 72;
var CODE_TOUCHE_I = 73;
var CODE_TOUCHE_J = 74;
var CODE_TOUCHE_K = 75;
var CODE_TOUCHE_L = 76;
var CODE_TOUCHE_M = 77;
var CODE_TOUCHE_N = 78;
var CODE_TOUCHE_O = 79;
var CODE_TOUCHE_P = 80;
var CODE_TOUCHE_Q = 81;
var CODE_TOUCHE_R = 82;
var CODE_TOUCHE_S = 83;
var CODE_TOUCHE_T = 84;
var CODE_TOUCHE_U = 85;
var CODE_TOUCHE_V = 86;
var CODE_TOUCHE_W = 87;
var CODE_TOUCHE_X = 88;
var CODE_TOUCHE_Y = 89;
var CODE_TOUCHE_Z = 90;


var onKeyDownControleVehicule = function(keyCode) {
	if (keyCode == CODE_TOUCHE_BAS) {
		controle.direction.y = -1;
	}
	else if (keyCode == CODE_TOUCHE_HAUT) {
		controle.direction.y = 1;
	}
	else if (keyCode == CODE_TOUCHE_GAUCHE) {
		controle.direction.x = -1;
	}
	else if (keyCode == CODE_TOUCHE_DROITE) {
		controle.direction.x = 1;
	}
	
	if (keyCode == CODE_TOUCHE_ATTAQUE || keyCode == CODE_TOUCHE_ATTAQUE_Bis) {
		controle.attaque = true;
	}
	
	if (keyCode == CODE_TOUCHE_ATTAQUE2){
		controle.attaque2 = true;
	}	
}


var onKeyDown = function(event) {

	onKeyDownControleVehicule(event.keyCode);
	
	
		
	if (event.keyCode<MaxtoucheActive)
		tToucheActive[event.keyCode]=true;
	
	//alert(event.keyCode);
		
	toucheHitDown=event.keyCode;
	toucheLastHitDown=event.keyCode;
	
	return false;
}

var onKeyUp = function(event) {
	if (event.keyCode == CODE_TOUCHE_BAS) {
		controle.direction.y = 0;
	}
	else if (event.keyCode == CODE_TOUCHE_HAUT) {
		controle.direction.y = 0;
	}
	else if (event.keyCode == CODE_TOUCHE_GAUCHE) {
		controle.direction.x = 0;
	}
	else if (event.keyCode == CODE_TOUCHE_DROITE) {
		controle.direction.x = 0;
	}
	else if (event.keyCode == CODE_TOUCHE_ATTAQUE || event.keyCode == CODE_TOUCHE_ATTAQUE_Bis) {
		controle.attaque = false;
	}
	else if (event.keyCode == CODE_TOUCHE_ATTAQUE2){
		controle.attaque2 = false;
	}	
	
	if (event.keyCode<MaxtoucheActive)
		tToucheActive[event.keyCode]=false;
		
	for (var i=0 ; i<MaxtoucheActive ; i++){
		if (tToucheActive[i]){
			onKeyDownControleVehicule(i);
		}
	}
	
	
	toucheHitUp=event.keyCode;
	toucheHitDown=0;
	
	
	return false;
}

var resetKey = function(event) {
	toucheHitUp=0;
	toucheLastHitDown=0;
	
	controleMouse.hit=false;
	controleMouse.dblhit=false;
}


var initialisationKeybord = function() {
	window.onkeydown = onKeyDown;
	window.onkeyup = onKeyUp;
}


// ------------------------------------ Sourie 
var ControleMouse = Class.extend({
	init: function(){
		this.coord = new Vec();
		this.hit = false;
		this.dblhit = false;
		this.enfoncer = false;
	},
});	

var controleMouse = new ControleMouse();



function getMousePos(canvas, evt) {
	var rect = canvas.getBoundingClientRect();
	
	return new Vec(
	  (evt.clientX - rect.left)*(GAME_SIZE_WIDTH/canvas.width),
	  (evt.clientY - rect.top)*(GAME_SIZE_HEIGHT/canvas.height)
	);
}
	

var lastClicTime = 0;
	
var initialisationMouse = function(event) {
	canvas.addEventListener('mousemove', function(evt) {
			var mousePos = getMousePos(canvas, evt);
			controleMouse.coord=mousePos;
		}, false);
		
	canvas.addEventListener("mousedown", function(evt) {
			var mousePos = getMousePos(canvas, evt);
			controleMouse.coord=mousePos;
			controleMouse.hit=true;
			controleMouse.enfoncer = true;
			
			
			var now = Date.now();
			if (now-lastClicTime<300)
				controleMouse.dblhit=true;
			//else 
			//	this.dblhit=false;
			
			lastClicTime = now;
			
		}, false);
	

	canvas.addEventListener("mouseup", function(evt) {
			controleMouse.enfoncer = false;
		}, false);	
	canvas.addEventListener("mouseleave", function(evt) {
			controleMouse.enfoncer = false;
		}, false);
}



var touchStartMoveTime = 0;

var touchEndEvent = function(time) {	
		//controleMouse.coord=getMousePos(canvas, event);
		controleMouse.enfoncer = false;
DEBUG_TEXT_PRINT = +"t:"+(time-touchStartMoveTime);

		//if (time-touchStartMoveTime<300000)//pour PC
		if (time-touchStartMoveTime<300)//pour tablette iOS
			controleMouse.hit = true;
}

var initialisationTactile = function(event) {
	document.body.addEventListener('touchmove', function(event) {
	  event.preventDefault();
	}, false);
	
	
	
	canvas.addEventListener('touchstart', function(event) {
	  	controleMouse.coord=getMousePos(canvas, event.targetTouches[0]);
		controleMouse.enfoncer = true;
		
		//touchStartMoveTime = event.timeStamp;
		touchStartMoveTime = Date.now();
		
	}, false);	

	canvas.addEventListener('touchmove', function(event) {
/*	  // If there's exactly one finger inside this element
	  if (event.targetTouches.length == 1) {
			var touch = event.targetTouches[0];
	    	// Place element where the finger is
			
	  }*/
		controleMouse.coord=getMousePos(canvas, event.targetTouches[0]);
		messageLog("touchmove:"+event.targetTouches.length);
	  	
		event.preventDefault();
	  
	}, false);
	
	canvas.addEventListener('touchend', function(event) {
		//touchEndEvent(event.timeStamp);
		touchEndEvent(Date.now());
		
	}, false);
	
/*	canvas.addEventListener("mouseup", function(evt) {	
		touchEndEvent(event, 0);			
	}, false);	*/
	
	
	
}
