

var Ennemi = Vehicule.extend({
	init: function(){
		this._super();
		this.del = false;
		this.retablir_alpha = 0;	// temps en miliseconde Remettre l'alpha du vehicule a 1
		
		this.attaqueDegatSup = 0;
		
		this.terrainEnnemie = TE_CIEL;
		
		this.vitesseBalle = 0.3;
	},
	
	update: function(){
	},

	// le vehicule subit des degat (animation de degat)
	EvtVehiculeSubitDegat : function(){
		this.tile.setAlpha(0.5);
		this.retablir_alpha = 41;
	},	
	
	EvtExplosion : function(coord){
		game.tEntity.push(new ExplosionMoyen(coord));
		sonManager.play(SON_Explosion);
	},
	
	DoBonus : function(coord){

		if (randomTest(0.05)){
			if (this.tile != null)
				game.tBonus.push(new GraphBonusArgent(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2)));
			else
				game.tBonus.push(new GraphBonusArgent(new Vec(this.coord.x, this.coord.y)));
		}
	},	
	
	degat : function(pt){
		return this._super(pt);
	},		


	
	EvtVehiculeMort : function(){
		this._super();
		game.nbEnnemieDetruit++;
		this.DoBonus();
		this.EvtExplosion(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2));
	},
	
	drawVehicule: function(screenVec){
		if (this.retablir_alpha>0){
			this.retablir_alpha-=game.timeDelay;
			if (this.retablir_alpha<=0)
				this.tile.setAlpha(1);
		}

		this._super(screenVec);
	},
	draw: function(){
		this._super();
	},
	
	setLevel : function(lvl){
		this._super(lvl);
		this.attaqueDegatSup = (lvl-1)/2;
		this.vitesseBalle += (lvl-1)/30;
	}
	
});

//zigzagtir
var Ennemi1 = Ennemi.extend({
	init: function(lvl){
		this._super();
		
		this.vie = 1;
		this.gainScore = 3;		
		this.cadenceTir = 1500;
		this.vitesseDeplacement = 0.1;
		this.vitesseBalle = 0.3;
		this.setLevel(lvl);
		
		this.tile = new Tile(IMAGE_Aircraft_01);
		this.tile.setAnge(180);
		
		this.collision.setPosition(this.tile.coordBox);

		this.collision.addBox(new Box(4, 20, 102, 22));
		this.collision.addBox(new Box(48, 2, 12, 88));
	
		
		this.initCoord = new Vec();
		this.initCoord.setVec(this.coord);

		this.terrainEnnemie = TE_CIEL;

		
		this.direction = new VDep(this.vitesseDeplacement,game.vitesse_defilement/2);

		
		
		
		//messageLog("");
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
		this.initCoord.setVec(this.coord);
	},	
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
	
		if (this.coord.x-this.initCoord.x>128){
			this.coord.x=this.initCoord.x+128;
			this.direction.x*=-1;
		}
		else if (this.coord.x-this.initCoord.x<-128){
			this.coord.x=this.initCoord.x-128;
			this.direction.x*=-1;
		}
	
		this.coord.addVec(this.direction.getDeplacement());

		if (this.getScreenCoord().y>game.height)
			this.delme();		
		
		this.attaque();
	},
	
	attaque: function(){
		if (this.ctp_temps>this.cadenceTir){
			game.tballesEnnemi.push(new Balle1(new Vec(this.coord.x+12, this.coord.y-this.tile.coordBox.height+10), new VDep(0,-this.vitesseBalle), this.attaqueDegatSup));
			game.tballesEnnemi.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-this.tile.coordBox.height+10), new VDep(0,-this.vitesseBalle), this.attaqueDegatSup));
			this.ctp_temps=0;
		}
	},
	
	EvtVehiculeMort : function(){	
		this._super();
		game.nbEnnemieAvionDetruit++;
	},	
	
	// draw: function(){
	// }

	// EvtExplosion : function(coord){
		// //this._super(coord);
		// game.tBonus.push(new GraphBonusVitesseTire(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2)));
	// },		
});

var EnnemiChargeur = Ennemi.extend({
	init: function(lvl){
		this._super();
		this.tile = new Tile(IMAGE_Aircraft_01);
		this.tile.setAnge(180);
		this.setAngle(180);
		this.collision.setPosition(this.tile.coordBox);

		this.collision.addBox(new Box(4, 20, 102, 22));
		this.collision.addBox(new Box(48, 2, 12, 88));
		
		this.vie = 2;
		this.gainScore = 6;			
		this.vitesseDeplacement = 0.3;
		this.setLevel(lvl);
		
		this.direction = new VDep(0,-1);
		this.direction.unitaire();
		this.direction.multF(this.vitesseDeplacement);	
	
	
		//this.direction = new VDep(0,-0.3);
		this.initCoord = new Vec();
		this.initCoord.setVec(this.coord);
		
		this.etapeAnim = 0;
		this.etapeTemps = 0;
		
		this.terrainEnnemie = TE_CIEL;
	
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
		this.initCoord.setVec(this.coord);
	},	
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		this.etapeTemps+=game.timeDelay;	
				
			
		if (this.etapeAnim==3){
			// Fonce a toute vitesse vers le joueur
			var o = orient(this.coord, game.vehiculeJoueur.coord);
			
			this.angle=90-o;
			this.tile.setAnge(this.angle);
			this.direction.setVec(angleToVec(o));
			this.direction.x*=this.vitesseDeplacement*(5/3);
			this.direction.y*=this.vitesseDeplacement*(5/3);
			this.etapeAnim=4;
			this.etapeTemps=0;
		}
		else if (this.etapeAnim==2){
			
			// On garde l'orientation vers le joueur
			//this.angle = Math.floor(-90-orient(game.vehiculeJoueur.coord, this.coord));
			this.angle = Math.floor(90-orient(this.coord, game.vehiculeJoueur.coord));			
			this.tile.setAnge(this.angle);
			
			
			if (this.etapeTemps>1000){
				this.etapeAnim=3;
				this.etapeTemps=0;
			}
					
		}
		else if (this.etapeAnim==1){	
	
			// Stop l'avancement et Orient l'enemie vers le joueurs
			var angleVise = Math.floor(90-orient(this.coord, game.vehiculeJoueur.coord));
			angleVise=normaliseAngle(angleVise);		
			if (this.angle>angleVise)
				this.angle--;
			else if (this.angle<angleVise)
				this.angle++;
			else {
				this.etapeAnim=2;
				this.etapeTemps=0;
			}
			
			this.angle=normaliseAngle(this.angle);
			this.tile.setAnge(this.angle);
			this.direction.y=0;
		}
		
			
		
			
		this.coord.addVec(this.direction.getDeplacement());
		
		// On ralenti
		if (this.coord.y<game.origineY+game.height-50 && this.etapeAnim==0){
			this.direction.y=-this.vitesseDeplacement/60;	
			this.etapeAnim=1;
			this.etapeTemps=0;
		}			


		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	 //EvtExplosion : function(coord){
		//this._s	this.spriteBox = imageManager.getSpriteBox(this.imageItem, item);
		// game.tBonus.push(new GraphBonusVitesseTire(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2)));
	 //},	
	 
	EvtVehiculeMort : function(){	
		this._super();
		game.nbEnnemieAvionDetruit++;
	},	 
});



var EnnemiViseur = Ennemi.extend({
	init: function(lvl){
		this._super();

		
		this.tile = new Tile(IMAGE_aircrafts);
		this.tile.setSpriteItem(ITEM_aircrafts_Aircraft_01);	
		
		
		
		this.tile.setAnge(180);
		this.setAngle(180);
		this.collision.setPosition(this.tile.coordBox);

		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));
		
		this.cadenceTir = 1000;
		this.vie = 2;
		this.gainScore = 8;			
		this.vitesseDeplacement = 0.3;
		this.vitesseBalle = 0.3;
		this.setLevel(lvl);
		
		this.direction = new VDep(0,-1);
		this.direction.unitaire();
		this.direction.multF(this.vitesseDeplacement);	
	
	
		//this.direction = new VDep(0,-0.3);
		this.initCoord = new Vec();
		this.initCoord.setVec(this.coord);
		
		this.etapeAnim = 0;
		this.etapeTemps = 0;
		
		this.terrainEnnemie = TE_CIEL;		
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
		this.initCoord.setVec(this.coord);
	},	
	
	
	attaque: function(){
		if (this.ctp_temps>this.cadenceTir){
			var vecDir = angleToVec(-this.angle+90);
			vecDir.x*=this.vitesseBalle;
			vecDir.y*=this.vitesseBalle;
			
			var pos = this.coord.copy();
			//pos.x+=vecDir.x*20;
			//pos.y+=-vecDir.y*20;
			pos.x += this.tile.coordBox.width/2-15;
			pos.y -= this.tile.coordBox.height/2;
	
			game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
			this.ctp_temps=0;
		}
	},	
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		this.etapeTemps+=game.timeDelay;	
				
			

		if (this.etapeAnim==2){
			
			// On garde l'orientation vers le joueur
			//this.angle = Math.floor(-90-orient(game.vehiculeJoueur.coord, this.coord));
			this.angle = Math.floor(90-orient(this.coord, game.vehiculeJoueur.coord));			
			this.tile.setAnge(this.angle);
			
			this.attaque();
			
			// if (this.etapeTemps>1000){
				// this.etapeAnim=3;
				// this.etapeTemps=0;
			// }
					
		}
		else if (this.etapeAnim==1){	
	
			// Stop l'avancement et Orient l'enemie vers le joueurs
			var angleVise = Math.floor(90-orient(this.coord, game.vehiculeJoueur.coord));
			angleVise=normaliseAngle(angleVise);		
			if (this.angle>angleVise)
				this.angle--;
			else if (this.angle<angleVise)
				this.angle++;
			else {
				this.etapeAnim=2;
				this.etapeTemps=0;
			}
			
			this.angle=normaliseAngle(this.angle);
			this.tile.setAnge(this.angle);
			this.direction.y=0;
		}
		
			
		
			
		this.coord.addVec(this.direction.getDeplacement());
		
		// On ralenti
		if (this.coord.y<game.origineY+game.height-50 && this.etapeAnim==0){
			this.direction.y=-this.vitesseDeplacement/60;	
			this.etapeAnim=1;
			this.etapeTemps=0;
		}			


		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	EvtVehiculeMort : function(){	
		this._super();
		game.nbEnnemieAvionDetruit++;
	},	
});



var EnnemiBombardier = Ennemi.extend({
	init: function(lvl){
		this._super();

		this.tile = new Tile(IMAGE_aircrafts);
		this.tile.setSpriteItem(ITEM_aircrafts_Aircraft_02);	
	
		this.tile.setAnge(180);
		this.setAngle(180);
		this.collision.setPosition(this.tile.coordBox);

		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));
		
		this.cadenceTir = 1000;
		this.vie = 1;
		this.gainScore = 10;			
		this.vitesseDeplacement = 0.3;
		this.vitesseBalle = 0.3;
		this.setLevel(lvl);
		
		this.direction = new VDep(0,-1);
		this.direction.unitaire();
		this.direction.multF(this.vitesseDeplacement);	
	
		
		this.etapeAnim = 0;
		this.etapeTemps = 0;
		
		
		this.terrainEnnemie = TE_CIEL;		
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
	},	
	
	
	attaque: function(){

		var v = new Vec(this.coord.x+this.tile.coordBox.width/2 -11, this.coord.y-50);
		
		var vdir = new VDep(this.direction.x, this.direction.y);
		vdir.unitaire();
		vdir.multF(this.vitesseBalle);
	
		
		game.tballesEnnemi.push(new Missile(true, v, vdir, this.attaqueDegatSup, 150));
		
	},	
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		this.etapeTemps+=game.timeDelay;	
		
		if (this.etapeAnim==2){

		}
		else if (this.etapeAnim==1){
			this.angle-=this.vitesseDeplacement*game.get_mult_vitesse()*2;
			this.setAngle(this.angle);
			//messageLog(this.angle);
			
			if (this.angle<0){
				this.etapeAnim=2;

				this.setAngle(0);
				
				this.direction.x=0;
				this.direction.y=1;
				this.direction.unitaire();				
			}
		}
		else if (this.etapeAnim==0){	
			if (this.coord.y<game.origineY+game.height*0.8){
				this.etapeAnim=1;
				
				this.attaque();
						
				this.direction.x=1;
				this.direction.y=0;
				this.direction.unitaire();
				
				this.direction.multF(this.vitesseDeplacement);					
			}
		}
			
		this.coord.addVec(this.direction.getDeplacement());	

		if (this.getScreenCoord().y>game.height || (this.getScreenCoord().y<-this.tile.coordBox.height && this.etapeAnim>0))
			this.delme();	
	},
	
	EvtVehiculeMort : function(){	
		this._super();
		game.nbEnnemieAvionDetruit++;
	},
});



var EnnemiP38 = Ennemi.extend({
	init: function(lvl){
		this._super();
		this.tile = new Tile(IMAGE_avionP38);
		this.tile.setAnge(180);
		this.setAngle(180);	
		
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));		

		this.vie = 5;
		this.gainScore = 15;
		this.cadenceTir = 5000;		
		this.vitesseDeplacement = 0.1;
		this.vitesseBalle = 0.4;
		this.lvl=lvl;
		this.setLevel(lvl);
		
		this.direction = new VDep(0,-1);
		this.direction.unitaire();
		this.direction.multF(this.vitesseDeplacement);			
		
		
		
		this.initCoord = new Vec();
		this.initCoord.setVec(this.coord);
		

		
		this.etapeAnim = 0;
		this.etapeTemps = 0;
		
		this.terrainEnnemie = TE_CIEL;		
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.initCoord.setVec(this.coord);
	},
	
	attaque: function(){
		if (this.ctp_temps>this.cadenceTir){
			game.tballesEnnemi.push(new Balle1(new Vec(this.coord.x+12, this.coord.y-this.tile.coordBox.height+10), new VDep(0,-this.vitesseBalle), this.attaqueDegatSup));
			game.tballesEnnemi.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-this.tile.coordBox.height+10), new VDep(0,-this.vitesseBalle), this.attaqueDegatSup));
			this.ctp_temps=0;
		}
	},
	update: function(){
		this.ctp_temps+=game.timeDelay;
		this.etapeTemps+=game.timeDelay;	
		
			
		this.coord.addVec(this.direction.getDeplacement());
		
		this.attaque();
		

		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	EvtVehiculeMort : function(){	
		this._super();
		game.nbEnnemieAvionDetruit++;
	},
	
	EvtExplosion : function(coord){
		game.tEntity.push(new ExplosionBig(coord));
	},


});

var EnnemiP38ArmeLvlUp = EnnemiP38.extend({	
	DoBonus : function(coord){
		game.tBonus.push(new GraphBonusArmeLvlUp(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2)));
	},	
});

var EnnemiP38Argent = EnnemiP38.extend({
	DoBonus : function(coord){
		game.tBonus.push(new GraphBonusArgent(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2)));
	},	
});

var EnnemiP38Vie = EnnemiP38.extend({
	DoBonus : function(coord){
		game.tBonus.push(new GraphBonusVie(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2), this.lvl));
	},		
});


var BossAvion = Ennemi.extend({
	init: function(lvl){
		this._super();
		this.tile = new Tile(IMAGE_bossavion);
		this.tile.setAnge(180);
		this.setAngle(180);	
		
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));		
		
		this.vie = 3500;
		this.gainScore = 1000;
		this.cadenceTir = 100;
		this.vitesseDeplacement = 0.1;
		this.vitesseBalle = 0.4;
		this.setLevel(lvl);
		
		this.direction = new VDep(0,-1);
		this.direction.unitaire();
		this.direction.multF(this.vitesseDeplacement);		
		
		this.initCoord = new Vec();
		this.initCoord.setVec(this.coord);
		

		
		this.etapeAnim = 0;
		this.etapeTemps = 0;
		
		this.terrainEnnemie = TE_CIEL;	
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
		this.initCoord.setVec(this.coord);
	},
	
	attaque: function(){
		if (this.ctp_temps>this.cadenceTir){
			game.tballesEnnemi.push(new Balle1(new Vec(this.coord.x+this.tile.coordBox.width-73, this.coord.y-this.tile.coordBox.height+50), new VDep(0,-this.vitesseBalle), this.attaqueDegatSup));
			game.tballesEnnemi.push(new Balle1(new Vec(this.coord.x+73, this.coord.y-this.tile.coordBox.height+50), new VDep(0,-this.vitesseBalle), this.attaqueDegatSup));
			this.ctp_temps=0;
		}	
	},
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		this.etapeTemps+=game.timeDelay;	

		if (this.etapeAnim==0){
			if (this.getScreenCoord().y>50){
				this.direction.x=this.vitesseDeplacement;
				this.direction.y=game.vitesse_defilement;
				this.etapeAnim=1;
				this.etapeTemps=0;
			}
		}
		else if (this.etapeAnim>=1){
			if (this.coord.x-this.initCoord.x>150){
				this.coord.x=this.initCoord.x+150;
				this.direction.x*=-1;
			}
			else if (this.coord.x-this.initCoord.x<-150){
				this.coord.x=this.initCoord.x-150;
				this.direction.x*=-1;
			}	


			if (this.etapeAnim==3 && this.etapeTemps>3000){
				this.etapeAnim=1;
				this.etapeTemps=0;
			}
			else if (this.etapeAnim==2){
				this.attaque();
				if (this.etapeTemps>3000){
					this.etapeAnim=3;
					this.etapeTemps=0;
				}
			}
			else if (this.etapeAnim==1 && this.etapeTemps>5000){
				this.etapeAnim=2;
				this.etapeTemps=0;
				
			}
			
		}
		
			
		this.coord.addVec(this.direction.getDeplacement());
		

		

		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	EvtVehiculeMort : function(){	
		this._super();
		game.nbEnnemieAvionDetruit++;
	},
	

	
	EvtExplosion : function(coord){
		game.tEntity.push(new ExplosionBig(coord));
		sonManager.play(SON_Explosion);
		

		niveau.nextLevel();
	},
	
	DoBonus : function(coord){
		for (var i=0 ; i<10 ; i++){
			game.tBonus.push(new GraphBonusArgent(new Vec(this.coord.x+this.tile.coordBox.width*(i/10.), this.coord.y-this.tile.coordBox.height/2)));
		}
	},		

});

var Buildings = Ennemi.extend({
	init: function(buildingDef){
	
		this._super();
		this.tile = new Tile(IMAGE_buildings);
		this.tile.setSpriteItem(buildingDef.item);
		this.curItem=buildingDef.item;
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(imageManager.getCollisionBox(IMAGE_buildings, buildingDef.item));

	
		this.vie = buildingDef.vie;	
		
		this.direction = new VDep(0,0);
		this.initCoord = new Vec();
		this.initCoord.setVec(this.coord);
		
		this.buildingDef=buildingDef;

		
		
		

		this.timeHit = 0;;
		
		this.terrainEnnemie = TE_TERRE;	
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
		this.initCoord.setVec(this.coord);
	},
	
	setAngle: function(angle){
		this._super(angle);
		this.tile.setAnge(angle);
	},	
	
	update: function(){
		//this.coord.addVec(this.direction.getDeplacement());
	},
	
	draw: function(){
		
		if (this.timeHit>0){
			this.timeHit-=game.timeDelay;
			if (this.timeHit<=0){
				this.tile.setSpriteItem(this.curItem);
				this.timeHit=0;
			}
		}
		
		this._super();
	},	
	
	
	//EvtExplosion : function(coord){
	//	this._super(coord);
	//},
	
	DoBonus : function(){
		if (randomTest(this.buildingDef.frequenceBonus)){
			if (this.buildingDef.bonus=="argent")
				game.tBonus.push(new GraphBonusArgent(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2)));
		}
	},		
	
	EvtVehiculeMort : function(){
		game.nbBatimentDetruit++;
		this.EvtExplosion(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2));
		this.DoBonus();	
		
		if (this.buildingDef.itemDetruit){
			this.curItem=this.buildingDef.itemDetruit;
		}
		else
			this.delme();
	},
	
	EvtVehiculeSubitDegat : function(){
		if (this.buildingDef.itemHit){
			this.timeHit=30;
			this.tile.setSpriteItem(this.buildingDef.itemHit);
		}	
	},	
	
	// Retourne vrai si le vehicule a bien subit des degats
	degat : function(pt){
		
		
		if (this.buildingDef.indesctructible){
			return true;
		}	
	
		return this._super(pt);	
	},	
	
	// draw: function(){
	// }	
});



var Tank5 = Ennemi.extend({
	init: function(lvl){
	
		this._super();
		this.tile = new Tile(IMAGE_tank_5);
		this.tile.setSpriteItem(ITEM_tank_5_medium_tank);
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(imageManager.getCollisionBox(IMAGE_tank_5, ITEM_tank_5_medium_tank));


		this.etapeAnim = 0;
		this.etapeTemps = 0;
		
		
		this.angleTourelle = 315;
		
		this.vie = 10;	
		this.cadenceTir = 1000;
		this.vitesseDeplacement = 0.02;
		this.gainScore = 20;
		this.vitesseBalle = 0.3;
		this.setLevel(lvl);
		
		
		this.direction = new VDep(0,0);
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
	},
	
	setAngle: function(angle){
		this._super(angle);
		this.tile.setAnge(angle);
	},	
	
	attaque: function(){
		if (this.ctp_temps>this.cadenceTir){
			var vecDir = angleToVec(this.angleTourelle);
			vecDir.x*=this.vitesseBalle;
			vecDir.y*=this.vitesseBalle;
			
			var pos = this.coord.copy();
			pos.x+=26+vecDir.x*20;
			pos.y+=-20+vecDir.y*20;
	
			game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
			this.ctp_temps=0;
		}
	},	
	
	updateViseJoueur: function(){
		if (this.etapeAnim==0){
			this.direction = new VDep(0,1);
			this.direction.unitaire();
			this.direction.multF(this.vitesseDeplacement);				
			
			
			this.etapeAnim=1;
		}
		else if (this.etapeAnim==1){
			this.angleTourelle = Math.floor(orient(this.coord, game.vehiculeJoueur.coord));			
		}

		
		this.attaque();
	},
	
	
	updateVasEtViens: function(){
		if (this.etapeAnim==0){
			this.direction = new VDep(0,1);
			this.direction.unitaire();
			this.direction.multF(this.vitesseDeplacement);
			
			this.etapeAnim=1;
		}
		else if (this.etapeAnim==1){
			this.angleTourelle-=0.02*game.timeDelay;
			if (this.angleTourelle<225)
				this.etapeAnim=2;
		}
		else if (this.etapeAnim==2){
			this.angleTourelle+=0.02*game.timeDelay;
			if (this.angleTourelle>315)
				this.etapeAnim=1;		
		}	
		
		this.attaque();
	},	
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		
		
		//this.updateVasEtViens();
		this.updateViseJoueur();
		
		this.coord.addVec(this.direction.getDeplacement());
		
				
		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	drawVehicule: function(screenVec){
		this._super(screenVec);
	},
	
	draw: function(){
	
		this.tile.setSpriteItem(ITEM_tank_5_medium_tank);
		this.tile.setAnge(this.angle);
		this.drawVehicule(gameToScreenCoord(this.coord));
		
		var vecGun = this.coord.copy();
		vecGun.x+=12;
		vecGun.y+=4;
		this.tile.setSpriteItem(ITEM_tank_5_big_gun);
		this.tile.setAnge(-90-this.angleTourelle);
		this.drawVehicule(gameToScreenCoord(vecGun));		
	},
	
	EvtVehiculeMort : function(){
		this._super();
	},
	
	EvtVehiculeSubitDegat : function(){
		this._super();
	},	
	
	// Retourne vrai si le vehicule a bien subit des degats
	degat : function(pt){
		return this._super(pt);	
	},	
	
});



// Classe abstraite a ne pas utilisé telle quelle
// 
var Tourelle = Ennemi.extend({
	init: function(lvl){
	
		this.itemBase=0;
		this.itemArme=0;
		this.itemBaseDestruit=0;
		this.itemArmeDestruit=0;
		this.vecArme;
	
		this._super();
		
		this.initTourelle();
		
		
		this.tile = new Tile(IMAGE_buildings);
		this.tile.setSpriteItem(this.itemBase);
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(imageManager.getCollisionBox(IMAGE_buildings, this.itemBase));


		this.etapeAnim = 0;
		this.etapeTemps = 0;
		
		
		this.angleTourelle = 315;
		
		
		this.vitesseBalle = 0.3;
		this.setLevel(lvl);
		
		
		
		this.direction = new VDep(0,0);
		
		this.terrainEnnemie = TE_TERRE;	
		
	},
	
	// Fonction a redefinir.
	initTourelle: function(){
		/*
		this.itemBase=;
		this.itemArme=;
		this.itemBaseDestruit=;
		this.itemArmeDestruit=;	
		
		this.vecGun ;
		
		this.vie = ;
		this.cadenceTir = ;
		*/
	},	

	// Fonction a redefinir.
	tire: function(pos, vecDir){
		pos.x+=18+vecDir.x*56;
		pos.y+=-14+vecDir.y*56;
	
		game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));	
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
	},
	
	setAngle: function(angle){
		this._super(angle);
		this.tile.setAnge(angle);
	},	
	

	
	attaque: function(){
		if (this.ctp_temps>this.cadenceTir){
			var vecDir = angleToVec(this.angleTourelle);
			vecDir.x*=this.vitesseBalle;
			vecDir.y*=this.vitesseBalle;
				
			this.tire(this.coord.copy(), vecDir);

			this.ctp_temps=0;
		}
	},	
	
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		
		
		if (this.vie>0){	
			this.attaque();

			this.angleTourelle = Math.floor(orient(this.coord, game.vehiculeJoueur.coord));
			//this.coord.addVec(this.direction.getDeplacement());
		}
		
				
		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	drawVehicule: function(screenVec){
		this._super(screenVec);
	},
	
	draw: function(){
	
		this.tile.setSpriteItem(this.itemBase);
		this.tile.setAnge(this.angle);
		this.drawVehicule(gameToScreenCoord(this.coord));


		var vecGun = this.coord.copy();
		vecGun.x+=this.vecArme.x;
		vecGun.y+=this.vecArme.y;
		this.tile.setSpriteItem(this.itemArme);
		this.tile.setAnge(-90-this.angleTourelle);
		this.drawVehicule(gameToScreenCoord(vecGun));		
	},
	
	EvtVehiculeMort : function(){
		game.nbEnnemieDetruit++;
		game.nbEnnemieTourelleDetruit++;
		this.vie=0;
		this.itemBase=this.itemBaseDestruit;
		this.itemArme=this.itemArmeDestruit;
		this.EvtExplosion(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2));
		this.DoBonus();
	},
	
	EvtVehiculeSubitDegat : function(){
		this._super();
	},	
	
	// Retourne vrai si le vehicule a bien subit des degats
	degat : function(pt){
		return this._super(pt);
	},	
	
}); 

var TourelleGun = Tourelle.extend({
	// Fonction a redefinir.
	initTourelle: function(vec){
		this.itemBase=ITEM_buildings_platform_big_b;
		this.itemArme=ITEM_buildings_gun_big;
		this.itemBaseDestruit=ITEM_buildings_platform_big_b_destroyed;
		this.itemArmeDestruit=ITEM_buildings_gun_big_destroyed;
		this.distanceCentreArme=56;
		this.vecArme = new Vec(14,1);
		this.vie = 6;
		this.cadenceTir = 2000;
		this.gainScore = 5;
	},
	
	// Fonction a redefinir.
	tire: function(pos, vecDir){
		pos.x+=18+vecDir.x*56;
		pos.y+=-14+vecDir.y*56;
	
		game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));	
	},	
});


var TourelleGunDual = Tourelle.extend({
	// Fonction a redefinir.
	initTourelle: function(vec){
		this.itemBase=ITEM_buildings_platform_big_b;
		this.itemArme=ITEM_buildings_gun_big_dual;
		this.itemBaseDestruit=ITEM_buildings_platform_big_b_destroyed;
		this.itemArmeDestruit=ITEM_buildings_gun_big_dual_destroyed;
		this.distanceCentreArme=56;
		this.vecArme = new Vec(14,1);
		this.vie = 10;
		this.cadenceTir = 2000;
		this.gainScore = 6;
	},
	
	// Fonction a redefinir.
	tire: function(pos, vecDir){
		pos.x+=18+vecDir.x*110;
		pos.y+=-14+vecDir.y*110;		
	
		var a = vecToAngle(vecDir)+90;
		var va = angleToVec(a);


		var pos2=pos.copy();
		pos2.x+=va.x*6;
		pos2.y+=va.y*6;
		game.tballesEnnemi.push(new Balle1(pos2, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));	

		var pos3=pos.copy();
		pos3.x-=va.x*6;
		pos3.y-=va.y*6;
	
		game.tballesEnnemi.push(new Balle1(pos3, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));	
	},	
});



var TourelleTripple = Tourelle.extend({
	// Fonction a redefinir.
	initTourelle: function(vec){
		this.itemBase=ITEM_buildings_platform_big_b;
		this.itemArme=ITEM_buildings_gun_big_tripple_dark;
		this.itemBaseDestruit=ITEM_buildings_platform_big_b_destroyed;
		this.itemArmeDestruit=ITEM_buildings_gun_big_tripple_dark_destroyed;
		this.distanceCentreArme=56;
		this.vecArme = new Vec(14,1);
		this.vie = 20;
		this.cadenceTir = 2000;
		this.gainScore = 10;
	},
	
	// Fonction a redefinir.
	tire: function(pos, vecDir){

		var a = vecToAngle(vecDir)+90;
		var va = angleToVec(a);


		var pos2=pos.copy();
		pos2.x+=18+vecDir.x*100+va.x*10;
		pos2.y+=-14+vecDir.y*100+va.y*10;
		game.tballesEnnemi.push(new Balle1(pos2, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));	

		var pos3=pos.copy();
		pos3.x+=18+vecDir.x*100-va.x*10;
		pos3.y+=-14+vecDir.y*100-va.y*10;
	
		game.tballesEnnemi.push(new Balle1(pos3, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));	
		
		var pos1=pos.copy();
		pos1.x+=18+vecDir.x*110;
		pos1.y+=-14+vecDir.y*110;		
	
		game.tballesEnnemi.push(new Balle1(pos1, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
	},	
});



var TourelleMedium = Tourelle.extend({
	// Fonction a redefinir.
	initTourelle: function(vec){
		this.itemBase=ITEM_buildings_platform_medium_b;
		this.itemArme=ITEM_buildings_gun_medium_dark;
		this.itemBaseDestruit=ITEM_buildings_platform_medium_b_destroyed;
		this.itemArmeDestruit=ITEM_buildings_gun_medium_dark_destroyed;
		this.distanceCentreArme=56;
		this.vecArme = new Vec(14,1);
		this.vie = 4;
		this.cadenceTir = 3000;
		this.gainScore = 7;
	},
	
	// Fonction a redefinir.
	tire: function(pos, vecDir){

		pos.x+=10+vecDir.x*100;
		pos.y+=-11+vecDir.y*100;
	
		game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
	},	
});


var TourelleMediumRed = Tourelle.extend({
	init: function(lvl){
		this._super(lvl);
		
		this.tireCote = 0;
	},
	
	// Fonction a redefinir.
	initTourelle: function(vec){
		this.itemBase=ITEM_buildings_platform_medium_b;
		this.itemArme=ITEM_buildings_gun_medium_dual_dark;
		this.itemBaseDestruit=ITEM_buildings_platform_medium_b_destroyed;
		this.itemArmeDestruit=ITEM_buildings_gun_medium_dual_dark_destroyed;
		this.distanceCentreArme=56;
		this.vecArme = new Vec(2,1);
		this.vie = 4;
		this.cadenceTir = 1500;
		this.gainScore = 7;
	},
	
	// Fonction a redefinir.
	tire: function(pos, vecDir){

		pos.x+=14+vecDir.x*95;
		pos.y+=-14+vecDir.y*95;		
	
		var a = vecToAngle(vecDir)+90;
		var va = angleToVec(a);


		if (this.tireCote){
			pos.x+=va.x*15;
			pos.y+=va.y*15;
			this.tireCote=0;

		}else {
			pos.x-=va.x*15;
			pos.y-=va.y*15;
			this.tireCote=1;
		}
		game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
	},	
});




var Bateau = Ennemi.extend({
	init: function(lvl){
		this._super();
		
		this.initBateau();
		this.tile = new Tile(IMAGE_water_units);
		this.tile.setSpriteItem(this.itemBase);
		
		this.collision.setPosition(this.tile.coordBox);
		this.collision.addBox(imageManager.getCollisionBox(IMAGE_water_units, this.itemBase));
		
		this.TempsVie = 0;
		this.TimeMort = 0;
		this.DureeMort = 3000;
		this.angleTourelle = -90;
		this.vie = this.vieMax;
		//this.setLevel(lvl);
		
		
		this.direction = new VDep(0,0);
		
		this.direction = new VDep(0,1);
		this.direction.unitaire();
		this.direction.multF(this.vitesseDeplacement);			
		
		this.terrainEnnemie = TE_MER;
	},
	
	// A redefinir
	initBateau: function(lvl){
		this.itemBase=ITEM_water_units_ship_small_body;
		this.vieMax = 10;		
		this.cadenceTir = 1000;
		this.vitesseDeplacement = 0.001;
		this.vitesseBalle = 0.3;
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
	},
	
	setAngle: function(angle){
		this._super(angle);
		this.tile.setAnge(angle);
	},	
	
	
	// A redefinir
	attaque: function(){
	},	
	
	// A redefinir
	updateBateau: function(){	
	},
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		this.TempsVie+=game.timeDelay;
		
		
		if (this.vie>0){	
			this.updateBateau();
			this.coord.addVec(this.direction.getDeplacement());
		}
		else {
			this.TimeMort+=game.timeDelay;
			if (this.TimeMort>this.DureeMort)
				this.delme();
		}
				
		
					
		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	drawVehicule: function(screenVec){
		this._super(screenVec);
		
		// Effet de disparition pour mourrir
		this.tile.setAlpha(1-this.TimeMort/this.DureeMort);
	},
	
	// A redefinir
	draw: function(){		
	},
	
	EvtVehiculeMort : function(){
		game.nbEnnemieDetruit++;
		game.nbEnnemieBateauDetruit++;
		//this._super();
		this.vie=0;
		this.DoBonus();
	},
	
	EvtVehiculeSubitDegat : function(){
		this._super();
	},	
	
	// Retourne vrai si le vehicule a bien subit des degats
	degat : function(pt){
		return this._super(pt);	
	},	
	
});


var BateauPetit = Bateau.extend({
	init: function(lvl){
		this._super();
		this.armeDetruite=false;
		this.itemArme=ITEM_water_units_ship_big_gun;
	},

	// A redefinir
	initBateau: function(lvl){
		this.itemBase=ITEM_water_units_ship_small_body;
		this.vieMax = 10;	
		this.cadenceTir = 3000;
		this.vitesseDeplacement = 0.02;
		this.gainScore = 10;
		this.vitesseBalle = 0.3;
	},
	
	// A redefinir
	attaque: function(){	
		if (this.ctp_temps>this.cadenceTir){
			var vecDir = angleToVec(this.angleTourelle);
			vecDir.x*=this.vitesseBalle;
			vecDir.y*=this.vitesseBalle;
			
			var pos = this.coord.copy();
			pos.x+=15+vecDir.x*85;
			pos.y+=-70+vecDir.y*85;
	
			game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
			this.ctp_temps=0;
		}
	},	
	
	// A redefinir
	updateBateau: function(){
		
		if (!this.armeDetruite){
			this.attaque();
			this.angleTourelle = Math.floor(orient(this.coord, game.vehiculeJoueur.coord));
		}			
	},
	
	
	draw: function(){
		var vecTmp;
	
		var itemVague = Math.floor(this.TempsVie/250)%5;
		this.tile.setSpriteItem(ITEM_water_units_water_ripple_small_000+itemVague);
		vecTmp = this.coord.copy();
		vecTmp.x-=3;
		vecTmp.y+=15;		
		this.tile.setPosition(gameToScreenCoord(vecTmp));
		this.tile.setAnge(this.angle);
		this.tile.draw();	
	
	
		this.tile.setSpriteItem(this.itemBase);
		this.tile.setAnge(this.angle);
		this.drawVehicule(gameToScreenCoord(this.coord));
		
		vecTmp = this.coord.copy();
		vecTmp.x+=10;
		vecTmp.y-=48;
		this.tile.setSpriteItem(this.itemArme);
		this.tile.setAnge(-90-this.angleTourelle);
		this.drawVehicule(gameToScreenCoord(vecTmp));		
	},	
	
	
	EvtVehiculeMort : function(){
		this._super();
		this.EvtExplosion(new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2));
		this.DoBonus();
		this.itemBase=ITEM_water_units_ship_small_body_destroyed;
	},
	
	EvtVehiculeSubitDegat : function(){
		this._super();
		
		
		if (this.vie<this.vieMax/2){
			this.armeDetruite=true;
			this.itemArme=ITEM_water_units_ship_big_gun_destroyed;
		}
	},	
});




var BateauMoyen = Bateau.extend({
	init: function(lvl){
		this._super();
		this.armeDetruite1=false;
		this.armeDetruite2=false;
		this.itemArme1=ITEM_water_units_ship_gun_gray;
		this.itemArme2=ITEM_water_units_ship_gun_gray;
	},

	// A redefinir
	initBateau: function(lvl){
		this.itemBase=ITEM_water_units_ship_medium_body;
		this.vieMax = 10;	
		this.cadenceTir = 3000;
		this.vitesseDeplacement = 0.02;
		this.gainScore = 14;
		this.vitesseBalle = 0.3;
	},
	
	// A redefinir
	attaque: function(){	
		if (this.ctp_temps>this.cadenceTir){
			var vecDir = angleToVec(this.angleTourelle);
			vecDir.x*=this.vitesseBalle;
			vecDir.y*=this.vitesseBalle;
			
			var pos = this.coord.copy();
			pos.x+=20+vecDir.x*50;
			pos.y+=-55+vecDir.y*50;
	
			game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
			this.ctp_temps=0;
	
			var pos2 = this.coord.copy();
			pos2.x+=20+vecDir.x*60;
			pos2.y+=-135+vecDir.y*60;			
			game.tballesEnnemi.push(new Balle1(pos2, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
			this.ctp_temps=0;
						
		}
	},	
	
	// A redefinir
	updateBateau: function(){
		
		if (!this.armeDetruite1 || !this.armeDetruite2){
			this.attaque();
			this.angleTourelle = Math.floor(orient(this.coord, game.vehiculeJoueur.coord));
		}			
	},
	
	
	draw: function(){
		var vecTmp;
	
		var itemVague = Math.floor(this.TempsVie/250)%5;
		this.tile.setSpriteItem(ITEM_water_units_water_ripple_medium_000+itemVague);
		vecTmp = this.coord.copy();
		vecTmp.x-=10;
		vecTmp.y+=10;		
		this.tile.setPosition(gameToScreenCoord(vecTmp));
		this.tile.setAnge(this.angle);
		this.tile.draw();	
	
	
		this.tile.setSpriteItem(this.itemBase);
		this.tile.setAnge(this.angle);
		this.drawVehicule(gameToScreenCoord(this.coord));
		
		
		vecTmp = this.coord.copy();
		vecTmp.x+=24;
		vecTmp.y-=48;
		this.tile.setSpriteItem(this.itemArme1);
		this.tile.setAnge(-90-this.angleTourelle);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		
		
		vecTmp = this.coord.copy();
		vecTmp.x+=24;
		vecTmp.y-=125;
		this.tile.setSpriteItem(this.itemArme2);
		this.tile.setAnge(-90-this.angleTourelle);
		this.drawVehicule(gameToScreenCoord(vecTmp));					
	},	
	
	
	EvtVehiculeMort : function(){
		this._super();
		this.EvtExplosion(new Vec(this.coord.x+30-10+randomInt(20), this.coord.y- 58+20-randomInt(40)));
		this.EvtExplosion(new Vec(this.coord.x+30-10+randomInt(20), this.coord.y- 98+20-randomInt(40)));
		this.EvtExplosion(new Vec(this.coord.x+30-10+randomInt(20), this.coord.y-138+20-randomInt(40)));
		this.DoBonus();
		this.itemBase=ITEM_water_units_ship_medium_body_destroyed;
	},	
	
	EvtVehiculeSubitDegat : function(){
		this._super();
		
		
		if (!this.armeDetruite1 && this.vie<=this.vieMax*1/3){
			this.armeDetruite1=true;
			this.itemArme1=ITEM_water_units_ship_gun_gray_destroyed;
			
			this.EvtExplosion(new Vec(this.coord.x+30, this.coord.y-58));
		}
		else if (!this.armeDetruite2 && this.vie<=this.vieMax*2/3){
			this.armeDetruite2=true;
			this.itemArme2=ITEM_water_units_ship_gun_gray_destroyed;
			
			this.EvtExplosion(new Vec(this.coord.x+30, this.coord.y-138));
		}

			

	},	
});





var BateauBig = Bateau.extend({
	init: function(lvl){
		this._super();
		this.armeDetruite1=false;
		this.armeDetruite2=false;
		this.tItemArme = new Array();
		this.tItemArme[0]=ITEM_water_units_ship_gun_red;
		this.tItemArme[1]=ITEM_water_units_ship_gun_red;
		this.tItemArme[2]=ITEM_water_units_ship_big_gun;
		this.tItemArme[3]=ITEM_water_units_ship_big_gun_dual;
		this.tItemArme[4]=ITEM_water_units_ship_gun_huge;
		this.tItemArme[5]=ITEM_water_units_ship_big_gun_dual;
		this.tItemArme[6]=ITEM_water_units_ship_big_gun_dual;
		this.tItemArme[7]=ITEM_water_units_ship_big_gun;
		this.tItemArme[8]=ITEM_water_units_ship_gun_gray;
		
		this.tCollisionArme = new Array();
		this.tArmeDetruite = new Array();
		this.tAngleArme = new Array();
		this.tCadenceArme = new Array();
		this.tHeureTire = new Array();
		
		this.tVieArme = new Array();
		for (var i=0 ; i<this.tItemArme.length ; i++){
			this.tCollisionArme[i] = new Collisionneur();
			this.tCollisionArme[i].addBox(imageManager.getCollisionBox(IMAGE_water_units, this.tItemArme[i]));
			this.tArmeDetruite[i]=false;
			this.tAngleArme[i]=this.angleTourelle;
			this.tHeureTire[i]=0;
			
			if (i==4)
				this.tVieArme[i] = 20;
			else if (i>=2 && i<=7)
				this.tVieArme[i] = 8;
			else
				this.tVieArme[i] = 5;
			
			
			if (i==4)
				this.tCadenceArme[i] = 2000;
			else if (i>=2 && i<=7)
				this.tCadenceArme[i] = 1900;
			else
				this.tCadenceArme[i] = 1200;				
	
				
		}

	
	},

	// A redefinir
	initBateau: function(lvl){
		this.itemBase=ITEM_water_units_ship_large_body;
		this.vieMax = 30;	
		this.cadenceTir = 3000;
		this.vitesseDeplacement = 0.02;
		this.gainScore = 80;
		this.vitesseBalle = 0.3;
	},


	tire: function(vecDir, i){
	
		if (this.TempsVie-this.tHeureTire[i]<this.tCadenceArme[i])
			return;
			
		var pos = this.coord.copy();
		
		if (i==0){	// Gun 1 Red coté gauche
			pos.x+=6+vecDir.x*90;
			pos.y+=-244+vecDir.y*90;
		}
		else if (i==1){	// Gun 2 red	coté droite
			pos.x+=95+vecDir.x*90;
			pos.y+=-244+vecDir.y*90;	
		}
		else if (i==2){// Gun 3 big
			pos.x+=48+vecDir.x*100;
			pos.y+=-241+vecDir.y*100;
		}
		else if (i==3){// Gun 4 double
			pos.x+=48+vecDir.x*100;
			pos.y+=-215+vecDir.y*100;			

			//pos.x+=48+vecDir.x*90;
			//pos.y+=-215+vecDir.y*90;
		}
		else if (i==5){	// Gun 6 double coté gauche
			pos.x+=16+vecDir.x*100;
			pos.y+=-148+vecDir.y*100;			

			//pos.x+=16+vecDir.x*100;
			//pos.y+=-148+vecDir.y*100;		
		}
		else if (i==6){	// Gun 7 double coté droite
			pos.x+=80+vecDir.x*100;
			pos.y+=-148+vecDir.y*100;			

			//pos.x+=80+vecDir.x*100;
			//pos.y+=-148+vecDir.y*100;			
		}
		else if (i==7){	// Gun 8
			pos.x+=48+vecDir.x*90;
			pos.y+=-110+vecDir.y*90;
		}
		else if (i==8){	// Gun 9
			pos.x+=48+vecDir.x*80;
			pos.y+=-80+vecDir.y*80;
		}
		else if (i==4){	// Gun 5
			pos.x+=48+vecDir.x*130;
			pos.y+=-120+vecDir.y*130;	
		}	
		
		
		if (i==4)
			game.tballesEnnemi.push(new Missile(true, pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
		else
			game.tballesEnnemi.push(new Balle1(pos, new VDep(vecDir.x, vecDir.y), this.attaqueDegatSup));
		
			
					
		this.tHeureTire[i]=this.TempsVie;
	},
	
	// A redefinir
	attaque: function(){	

			var vecDir = angleToVec(this.angleTourelle);
			vecDir.x*=this.vitesseBalle;
			vecDir.y*=this.vitesseBalle;
			
			
			
			for (var i=0 ; i<this.tItemArme.length ; i++){
				if (this.tArmeDetruite[i])
					continue;				
				
				if (this.ctp_temps<1000 && (!this.tArmeDetruite[0] || !this.tArmeDetruite[1])){
					if (i==0 || i==1)
						this.tire(vecDir, i);
				}
				else if (this.ctp_temps<2000 && !this.tArmeDetruite[2]){
					if (i==2)
						this.tire(vecDir, i);
				}
				else if (this.ctp_temps<2500 && (!this.tArmeDetruite[3] || !this.tArmeDetruite[1] || !this.tArmeDetruite[0])){
					if (i==3 || i==0 || i==1)
						this.tire(vecDir, i);
				}					
				else if (this.ctp_temps<4000 && (!this.tArmeDetruite[5] || !this.tArmeDetruite[6] || !this.tArmeDetruite[3] || !this.tArmeDetruite[0] || !this.tArmeDetruite[1])){
					if (i==5 || i==6 || i==3 || i==0 || i==1)
						this.tire(vecDir, i);
				}
				else if (this.ctp_temps<5000 && (!this.tArmeDetruite[5] || !this.tArmeDetruite[6] || !this.tArmeDetruite[3])){
					if (i==5 || i==6 || i==3)
						this.tire(vecDir, i);
				}				
				else if (this.ctp_temps<5500 && !this.tArmeDetruite[4]){
					
				}	
				else if (this.ctp_temps<6000 && !this.tArmeDetruite[4]){
					if (i==4)
						this.tire(vecDir, i);
				}
				else if (this.ctp_temps<6500 && !this.tArmeDetruite[4]){

				}
				else if (this.ctp_temps<7000 && (!this.tArmeDetruite[7] || !this.tArmeDetruite[8])){
					if (i==7 || i==8)
						this.tire(vecDir, i);
				}
				else {
					this.tire(vecDir, i);
				}
				
							
				 if (this.ctp_temps>7000) 
					this.ctp_temps=0;
			}		

	},	
	
	// A redefinir
	updateBateau: function(){
		
		if (!this.armeDetruite1 || !this.armeDetruite2){
			
			this.angleTourelle = Math.floor(orient(new Vec(this.coord.x+48, this.coord.y-120), game.vehiculeJoueur.getCenter()));
			
			for (var i=0 ; i<this.tItemArme.length ; i++){
				if (!this.tArmeDetruite[i])
					this.tAngleArme[i]=this.angleTourelle;
			}
				
			this.attaque();
		}			
	},
	
	
	draw: function(){
		//	this.angleTourelle = Math.floor(orient(this.coord, game.vehiculeJoueur.coord));
		var vecTmp;
	
		var itemVague = Math.floor(this.TempsVie/250)%5;
		this.tile.setSpriteItem(ITEM_water_units_water_ripple_big_000+itemVague);
		vecTmp = this.coord.copy();
		vecTmp.x-=20;
		vecTmp.y+=10;		
		this.tile.setPosition(gameToScreenCoord(vecTmp));
		this.tile.setAnge(this.angle);
		this.tile.draw();	
	
	
		this.tile.setSpriteItem(this.itemBase);
		this.tile.setAnge(this.angle);
		this.drawVehicule(gameToScreenCoord(this.coord));
		
		// Gun 1 red
		vecTmp = this.coord.copy();
		vecTmp.x+=10;
		vecTmp.y-=232;
		this.tile.setSpriteItem(this.tItemArme[0]);
		this.tile.setAnge(-90-this.tAngleArme[0]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[0].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
		
		// Gun 2 red
		vecTmp = this.coord.copy();
		vecTmp.x+=98;
		vecTmp.y-=232;
		this.tile.setSpriteItem(this.tItemArme[1]);
		this.tile.setAnge(-90-this.tAngleArme[1]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[1].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
		
		// Gun 3
		vecTmp = this.coord.copy();
		vecTmp.x+=45;
		vecTmp.y-=225;
		this.tile.setSpriteItem(this.tItemArme[2]);
		this.tile.setAnge(-90-this.tAngleArme[2]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[2].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));

		// Gun 4 Dual
		vecTmp = this.coord.copy();
		vecTmp.x+=44;
		vecTmp.y-=190;
		this.tile.setSpriteItem(this.tItemArme[3]);
		this.tile.setAnge(-90-this.tAngleArme[3]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[3].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
					
					

				
		// Gun 6 double Coté gauche 
		vecTmp = this.coord.copy();
		vecTmp.x+=13;
		vecTmp.y-=125;
		this.tile.setSpriteItem(this.tItemArme[5]);
		this.tile.setAnge(-90-this.tAngleArme[5]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[5].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
		
		
		// Gun 7 double Coté droite
		vecTmp = this.coord.copy();
		vecTmp.x+=77;
		vecTmp.y-=125;
		this.tile.setSpriteItem(this.tItemArme[6]);
		this.tile.setAnge(-90-this.tAngleArme[6]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[6].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
		
		
		// Gun 8
		vecTmp = this.coord.copy();
		vecTmp.x+=45;
		vecTmp.y-=90;
		this.tile.setSpriteItem(this.tItemArme[7]);
		this.tile.setAnge(-90-this.tAngleArme[7]);
		this.drawVehicule(gameToScreenCoord(vecTmp));	
		this.tCollisionArme[7].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
		
		
		// Gun 9
		vecTmp = this.coord.copy();
		vecTmp.x+=53;
		vecTmp.y-=70;
		this.tile.setSpriteItem(this.tItemArme[8]);
		this.tile.setAnge(-90-this.tAngleArme[8]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[8].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
		
		// Gun 5 missile
		vecTmp = this.coord.copy();
		vecTmp.x+=44;
		vecTmp.y-=120;
		this.tile.setSpriteItem(this.tItemArme[4]);
		this.tile.setAnge(-90-this.tAngleArme[4]);
		this.drawVehicule(gameToScreenCoord(vecTmp));
		this.tCollisionArme[4].setPosition(new Vec(this.tile.coordBox.x,this.tile.coordBox.y));
		
		
		
		// Astuce pratique :  permet de reinitialisé la taille du sprite. Beaucoup plus pratique par la suite du code, on peut appelé tile.coordboxe pour avoir la taille du bateau		
		this.tile.setSpriteItem(this.itemBase);
		this.tile.setPosition(gameToScreenCoord(this.coord));
	},	
	
	
	EvtVehiculeMort : function(){
		this._super();
		
		this.EvtExplosion(new Vec(this.coord.x+30+randomInt(60), this.coord.y-50-randomInt(50)));
		this.EvtExplosion(new Vec(this.coord.x+30+randomInt(60), this.coord.y-100-randomInt(50)));
		this.EvtExplosion(new Vec(this.coord.x+30+randomInt(60), this.coord.y-150-randomInt(50)));	
		this.EvtExplosion(new Vec(this.coord.x+30+randomInt(60), this.coord.y-200-randomInt(50)));
		this.EvtExplosion(new Vec(this.coord.x+30+randomInt(60), this.coord.y-250-randomInt(50)));
		this.EvtExplosion(new Vec(this.coord.x+30+randomInt(60), this.coord.y-300-randomInt(50)));
		this.DoBonus();

		//this.EvtExplosion(new Vec(this.coord.x+30-10+randomInt(20), this.coord.y- 58+20-randomInt(40)));
		//this.EvtExplosion(new Vec(this.coord.x+30-10+randomInt(20), this.coord.y- 98+20-randomInt(40)));
		//this.EvtExplosion(new Vec(this.coord.x+30-10+randomInt(20), this.coord.y-138+20-randomInt(40)));
	
		this.itemBase=ITEM_water_units_ship_large_body_destroyed;
	},	
	
	EvtVehiculeSubitDegat : function(){
		this._super();
		
		
/*		if (!this.armeDetruite1 && this.vie<=this.vieMax*1/3){
			this.armeDetruite1=true;
			this.itemArme1=ITEM_water_units_ship_gun_gray_destroyed;
			
			this.EvtExplosion(new Vec(this.coord.x+30, this.coord.y-58));
		}
		else if (!this.armeDetruite2 && this.vie<=this.vieMax*2/3){
			this.armeDetruite2=true;
			this.itemArme2=ITEM_water_units_ship_gun_gray_destroyed;
			
			this.EvtExplosion(new Vec(this.coord.x+30, this.coord.y-138));
		}*/
	},
	
	degatBalle : function(balle){	
	

		var explosion=false;
		for (var i=0 ; i<this.tItemArme.length ; i++){
			if (this.tVieArme[i]>0 && this.tCollisionArme[i].testCollision(balle.collision)){
				this.tVieArme[i]-=balle.getAttaque();
				balle.EvtExplose();
				if (this.tVieArme[i]<=0)
				{
					this.tItemArme[i]++;
					this.tArmeDetruite[i]=true;
					game.tEntity.push(new ExplosionMoyen(balle.coord));
					explosion=true;
					break;
				}
			}
			
		}	
	
	
	
	
		if (balle.coord.y>this.coord.y-50)
			this._super(balle);
		
		//if (!explosion)
		//	this._super(balle);
	},	
	
		
});





var BossAvion2 = Ennemi.extend({
	init: function(lvl){
		this._super();
		this.tile = new Tile(IMAGE_bossavion);
		//this.tile.setAnge(180);
		//this.setAngle(180);	
		
		this.tileGun = new Tile(IMAGE_water_units);
		
		this.tItemArme = new Array();		
		//this.tCollisionArme = new Array();
		this.tArmeDetruite = new Array();
		this.tArmeActive = new Array();
		this.tAngleArme = new Array();
		this.tCadenceArme = new Array();
		this.tHeureTire = new Array();
		this.tVieArme = new Array();
		this.tCoordArme = new Array();
		this.tCoordArmeTire = new Array();
		this.tRayonArmeTire = new Array();
		this.tArmeTourne = new Array();		// Vrai/faux l'arme s'oriente vers le joueur
		

		this.tItemArme[0]=ITEM_water_units_ship_gun_gray;
		this.tCoordArme[0]= new Vec(125, -25);
		this.tCoordArmeTire[0]= new Vec(-4, -13);
		this.tRayonArmeTire[0]=15;
		this.tArmeTourne[0]=true;
		this.tCadenceArme[0]=1000;
		this.tItemArme[1]=ITEM_water_units_ship_gun_gray;
		this.tCoordArme[1]= new Vec(243, -25);
		this.tCoordArmeTire[1]= new Vec(-4, -13);
		this.tRayonArmeTire[1]=15;
		this.tArmeTourne[1]=true;
		this.tCadenceArme[1]=1000;
		this.tItemArme[2]=ITEM_water_units_ship_gun_gray;
		this.tCoordArme[2]= new Vec(186, -45);
		this.tCoordArmeTire[2]= new Vec(-4, -13);
		this.tRayonArmeTire[2]=15;
		this.tArmeTourne[2]=true;
		this.tCadenceArme[2]=1000;
		this.tItemArme[3]=ITEM_water_units_ship_gun_huge;
		this.tCoordArme[3]= new Vec(180,-100);
		this.tCoordArmeTire[3]= new Vec(3, -5);
		this.tRayonArmeTire[3]=60;
		this.tArmeTourne[3]=true;
		this.tCadenceArme[3]=900;
		this.tItemArme[4]=ITEM_water_units_ship_gun_red;
		this.tCoordArme[4]= new Vec(125,-120);
		this.tCoordArmeTire[4]= new Vec(-4, -13);
		this.tRayonArmeTire[4]=15;
		this.tArmeTourne[4]=true;
		this.tCadenceArme[4]=600;
		this.tItemArme[5]=ITEM_water_units_ship_gun_red;
		this.tCoordArme[5]= new Vec(245,-120);
		this.tCoordArmeTire[5]= new Vec(-4, -13);
		this.tRayonArmeTire[5]=15;
		this.tArmeTourne[5]=true;
		this.tCadenceArme[5]=600;
		this.tItemArme[6]=ITEM_water_units_ship_gun_gray;
		this.tCoordArme[6]= new Vec( 85,-130);
		this.tCoordArmeTire[6]= new Vec(-4, -13);
		this.tRayonArmeTire[6]=15;
		this.tArmeTourne[6]=true;
		this.tCadenceArme[6]=1000;
		this.tItemArme[7]=ITEM_water_units_ship_gun_gray;
		this.tCoordArme[7]= new Vec(285,-130);
		this.tCoordArmeTire[7]= new Vec(-4, -13);
		this.tRayonArmeTire[7]=15;
		this.tArmeTourne[7]=true;
		this.tCadenceArme[7]=1000;
		this.tItemArme[8]=ITEM_water_units_ship_gun_gray;
		this.tCoordArme[8]= new Vec( 35,-130);
		this.tCoordArmeTire[8]= new Vec(-4, -13);
		this.tRayonArmeTire[8]=15;
		this.tArmeTourne[8]=false;
		this.tCadenceArme[8]=100;
		this.tItemArme[9]=ITEM_water_units_ship_gun_gray;
		this.tCoordArme[9]= new Vec(335,-130);
		this.tCoordArmeTire[9]= new Vec(-4, -13);
		this.tRayonArmeTire[9]=15;	
		this.tArmeTourne[9]=false;
		this.tCadenceArme[9]=100;

		
		for (var i=0 ; i<this.tItemArme.length ; i++){
			//this.tCollisionArme[i] = new Collisionneur();
			//this.tCollisionArme[i].addBox(imageManager.getCollisionBox(IMAGE_water_units, this.tItemArme[i]));
			this.tArmeDetruite[i]=false;
			this.tArmeActive[i]=false;
			this.tAngleArme[i]=270;
			this.tHeureTire[i]=0;
			this.tVieArme[i] = 5;
			//this.tCadenceArme[i] = 1000;			
		}		
		
		this.collision.setPosition(this.tile.coordBox);
		//this.collision.addBox(new Box(0, 0, this.tile.coordBox.width, this.tile.coordBox.height));		
		this.collision.addBox(new Box(170, 26, 44, 253));
		this.collision.addBox(new Box(11, 139, 357, 36));
		this.collision.addBox(new Box(115, 32, 155, 29));
		
		this.vie = 3000;
		this.gainScore = 1000;
		this.cadenceTir = 100;
		this.vitesseDeplacement = 0.1;
		this.vitesseBalle = 0.4;
		this.setLevel(lvl);
		
		this.direction = new VDep(0,-1);
		this.direction.unitaire();
		this.direction.multF(this.vitesseDeplacement);		
		
		this.initCoord = new Vec();
		this.initCoord.setVec(this.coord);
		

		this.TempsVie = 0;
		this.etapeAnim = 0;
		this.etapeTemps = 0;
		this.zigzag=false;
		this.zigzagSense=1;
		
		this.terrainEnnemie = TE_CIEL;	
	},
	
	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
		this.initCoord.setVec(this.coord);
	},
	
	attaque: function(){
		//if (this.ctp_temps>this.cadenceTir){
			var vecTmp;		
			
			for (var i=0 ; i<this.tItemArme.length ; i++){
				
				if (!this.tArmeActive[i] || this.tArmeDetruite[i])
					continue;
			
				if (this.TempsVie-this.tHeureTire[i]<this.tCadenceArme[i])
					continue;		

				
				var vecAngle = angleToVec(this.tAngleArme[i]);
	
				vecTmp = this.coord.copy();	
				vecTmp.addVec(this.tCoordArme[i]);
				vecTmp.addVec(this.tCoordArmeTire[i])
				vecTmp.x+=vecAngle.x*this.tRayonArmeTire[i];
				vecTmp.y+=vecAngle.y*this.tRayonArmeTire[i];				
						
				if (i==3)
					game.tballesEnnemi.push(new Missile(true, vecTmp, new VDep(vecAngle.x, vecAngle.y, this.vitesseBalle), this.attaqueDegatSup));
				else
					game.tballesEnnemi.push(new Balle1(vecTmp, new VDep(vecAngle.x, vecAngle.y, this.vitesseBalle), this.attaqueDegatSup));

				this.tHeureTire[i]=this.TempsVie;
			}
			
			//this.ctp_temps=0;
		//}	
	},
	
	resetArmeActive: function(){
		for (var i=0 ; i<this.tItemArme.length ; i++)
			this.tArmeActive[i]=false;
	},
	
	update: function(){
		this.TempsVie+=game.timeDelay;
		//this.ctp_temps+=game.timeDelay;
		this.etapeTemps+=game.timeDelay;	
	

		for (var i=0 ; i<this.tItemArme.length ; i++){
			if (this.tArmeActive[i] && this.tArmeTourne[i] && !this.tArmeDetruite[i]){
				this.tAngleArme[i] = Math.floor(orient(new Vec(this.coord.x+this.tCoordArme[i].x, this.coord.y+this.tCoordArme[i].y), game.vehiculeJoueur.getCenter()));
			}
		}


		if (this.zigzag){
			if (this.coord.x-this.initCoord.x>130){
				this.coord.x=this.initCoord.x+130;
				this.zigzagSense*=-1;
			}
			else if (this.coord.x-this.initCoord.x<-130){
				this.coord.x=this.initCoord.x-130;
				this.zigzagSense*=-1;
			}
			this.direction.x=this.zigzagSense*this.vitesseDeplacement;
		}
		else
			this.direction.x=0;


		if (this.etapeAnim==0){
			if (this.getScreenCoord().y>50){
				//this.direction.x=this.vitesseDeplacement;
				this.zigzag=true;
				this.direction.y=game.vitesse_defilement;
				this.etapeAnim=1;
				this.etapeTemps=0;
			}
		}
		else if (this.etapeAnim>=1 && this.etapeAnim<5){

			if (this.etapeAnim==3 && this.etapeTemps>3000){
				this.etapeAnim=1;
				this.etapeTemps=0;
			}
			else if (this.etapeAnim==2){
				this.attaque();
				
				if (this.etapeTemps>15000){
					this.etapeAnim=5;
					this.etapeTemps=0;
					this.direction.x=0
					this.resetArmeActive();
				}
				else if (this.etapeTemps>2000){
					//this.direction.x=this.vitesseDeplacement;
					this.zigzag=true;
				}
			}
			else if (this.etapeAnim==1 && this.etapeTemps>3000){
				//this.etapeAnim=2;
				this.etapeAnim=2;
				this.etapeTemps=0;
				
				
				this.resetArmeActive();
				this.tArmeActive[8]=this.tArmeActive[9]=true;
				//this.direction.x=0;
				this.zigzag=false;
				
			}
			
		}
		else if (this.etapeAnim>=5){
			if (this.etapeAnim==5 && this.etapeTemps>1000){
				this.tArmeActive[6]=this.tArmeActive[7]=this.tArmeActive[2]=true;
				this.etapeAnim=6;
				this.etapeTemps=0;
			}
			else if (this.etapeAnim==6){
				this.attaque();
				if (this.etapeTemps>5000){
					this.etapeAnim=7;
					this.etapeTemps=0;
					this.zigzag=false;
					this.resetArmeActive();
					this.tArmeActive[3]=true;
					this.tArmeActive[0]=this.tArmeActive[1]=true;
				}
			}
			else if (this.etapeAnim==7){
				if (this.etapeTemps>3000){					
					this.attaque();
					
					if (this.etapeTemps>5000){	
						this.resetArmeActive();
						this.etapeAnim=8;
						this.etapeTemps=0;
					}
				}
			}
			else if (this.etapeAnim==8){
				this.zigzag=true;
				this.tArmeActive[4]=this.tArmeActive[5]=true;
				this.attaque();
				if (this.etapeTemps>5000){	
					this.etapeAnim=0;
					this.etapeTemps=0;			
				}
			}
		}
		
			
		this.coord.addVec(this.direction.getDeplacement());
		

		

		if (this.getScreenCoord().y>game.height)
			this.delme();
	},
	
	EvtVehiculeMort : function(){	
		this._super();
		game.nbEnnemieBossDetruit++;
	},	
	
	EvtExplosion : function(coord){
		game.tEntity.push(new ExplosionBig(coord));
		sonManager.play(SON_Explosion);
		

		niveau.nextLevel();
	},
	
	draw: function(){
		var vecTmp;


	
		this.tile.setSpriteImgFull();
		this.tile.setAnge(this.angle);
		this.drawVehicule(gameToScreenCoord(this.coord));
		
		for (var i=0 ; i<this.tItemArme.length ; i++){
			vecTmp = this.coord.copy();
			vecTmp.addVec(this.tCoordArme[i]);	
			
			this.tileGun.setSpriteItem(this.tItemArme[i]);
			this.tileGun.setAnge(-90-this.tAngleArme[i]);
			this.tileGun.setPosition(gameToScreenCoord(vecTmp));
			this.tileGun.draw();
			//this.tCollisionArme[i].setPosition(new Vec(this.tileGun.coordBox.x,this.tileGun.coordBox.y));	
			
		}
	
		
		

	},	
	
	degatBalle : function(balle){	
	

/*		var explosion=false;
		for (var i=0 ; i<this.tItemArme.length ; i++){
			if (this.tVieArme[i]>0 && this.tCollisionArme[i].testCollision(balle.collision)){
				this.tVieArme[i]-=balle.getAttaque();
				balle.EvtExplose();
				if (this.tVieArme[i]<=0)
				{
					this.tItemArme[i]++;
					this.tArmeDetruite[i]=true;
					game.tEntity.push(new ExplosionMoyen(balle.coord));
					explosion=true;
					break;
				}
			}
		}	*/
	
	
		//if (balle.coord.y>this.coord.y-50)
			this._super(balle);
		
		//if (!explosion)
		//	this._super(balle);
	},		
		
	DoBonus : function(coord){
		for (var i=0 ; i<10 ; i++){
			game.tBonus.push(new GraphBonusArgent(new Vec(this.coord.x+this.tile.coordBox.width*(i/10.), this.coord.y-this.tile.coordBox.height/2)));
		}
	},		

});

