var Explosion = Entity.extend({
	init: function(coord){
		this._super();
		this.tile = null;
		this.coord = coord;
		this.del = false;
		
		this.timeStart = game.gameTimeElapse;
	
		this.nbFrame = 0;
		this.frameDuree=41;				// en millisecond
	},

	drawSprite: function(num){
		this.tile.setPosition(this.getScreenCoord());
		this.tile.draw();
	},
	
	draw: function(){
		if (this.tile==null)
			return;
		
		var duree = game.gameTimeElapse-this.timeStart;
		var frame = Math.floor(duree/this.frameDuree);
		
		if (frame>=this.nbFrame || frame<0){
			this.delme();
			return;
		}

		
		this.drawSprite(frame);
	},
	
	getDuree: function(num){
		return this.frameDuree*this.nbFrame;
	},	
});


var ExplosionBig = Explosion.extend({
	init: function(coord){
		this._super(coord);
		this.tile = new Tile(IMAGE_explosionBig);
		this.tile.setMode(TILE_CENTER|TILE_MIDLE);
		this.tile.setSprite(0, 0, 90, 90);
		this.tile.setPosition(this.getScreenCoord());
		
		this.nbFrame = 10;

	},

	drawSprite: function(num){
	
		var px = (90+2)*(num%5);
		var py;
		if (num<5)
			py=0;
		else
			py=92;
			
		this.tile.setSprite(px, py, 90, 90);
		this.tile.setPosition(this.getScreenCoord());
		this.tile.draw();
	}	

});

var ExplosionMoyen = Explosion.extend({
	init: function(coord){
		this._super(coord);
		
		this.tile = new Tile(IMAGE_explosionBig);
		this.tile.setMode(TILE_CENTER|TILE_MIDLE);
		this.tile.setSprite(0, 0, 58, 58);
		this.tile.setPosition(this.getScreenCoord());
		
		this.nbFrame = 10;
	},

	drawSprite: function(num){
		var px = (58+2)*(num%5);
		var py;
		if (num<5)
			py=184;
		else
			py=244;
			
		this.tile.setSprite(px, py, 58, 58);
		this.tile.setPosition(this.getScreenCoord());
		this.tile.draw();
	}	

});