
var GraphiqueInterface = Class.extend({
	init: function(code){
		this.id = 0;
		if (code==undefined)
			this.code = "";
		else
			this.code = code;
		this.del = false;
		
		this.fenetreUnique = false;
		
		this.width = GAME_SIZE_WIDTH;
		this.height = GAME_SIZE_HEIGHT;
		
		this.tboutons = new Array();
		this.tEntity = new Array();
	},
	
	delme: function(){
		this.del = true;
	},
	
	pushBouton: function(bouton){
		this.tboutons.push(bouton);
	},
	
	pushEntity: function(e){
		this.tEntity.push(e);
	},	
	
	update: function(){
		for (var i=0, max=this.tboutons.length ; i<max ; i++){
			this.tboutons[i].update();		
		}
		
		if (controleMouse.hit){
			
			for (var i=0, max=this.tboutons.length ; i<max ; i++){
				if (this.tboutons[i].testCollision(controleMouse.coord)==1){
					this.tboutons[i].doHit();
					this.eventBouton(this.tboutons[i]);
					
					controleMouse.hit=false;
				}		
			}	
		}
		
		for (var i=0, max=this.tEntity.length ; i<max ; i++){
			this.tEntity[i].update();		
		}
	},
	
	draw: function(){
		for (var i=0, max=this.tboutons.length ; i<max ; i++){
			this.tboutons[i].draw();		
		}
		
		for (var i=0, max=this.tEntity.length ; i<max ; i++){
			this.tEntity[i].draw();		
		}
	},
	
	eventBouton: function(bouton){
	},
	
	drawLogo: function(){
		this.pushEntity(new Text("SHOOT", new Vec((this.width)/2-40-31,70), 80, TM_CENTER|TM_BOTTOM));
		this.pushEntity(new Text("in", new Vec((this.width)/2+30-25,60), 30, TM_LEFT|TM_BOTTOM));
		this.pushEntity(new Text("LOOP", new Vec((this.width)/2+160+2,70), 80, TM_RIGHT|TM_BOTTOM));
		this.pushEntity(new Text("BETA", new Vec((this.width)/2+110,60), 30, TM_CENTER));	
	},	
			
});


var InterfaceManager = Class.extend({
	init: function(){
		this.tinterfaces = new Array();
		
		this.idInterface = 1;
		
		this.addInterface(new GraphPermanent());
		//this.addInterface(new GameAccueil());
			
	},	
	
	loop: function(){
		this.update();
		this.draw();
	},
	
	addInterface: function(interf){
		interf.id = this.idInterface;
		this.tinterfaces.push(interf);
		this.idInterface++;
	},
	
	delInterface: function(id){
		for (var i=0 ; i<this.tinterfaces.length ; i++){
			if (this.tinterfaces[i].id==id)
				this.tinterfaces[i].del=true;
		}
	},
	
	delInterfaceCode: function(code){
		for (var i=0 ; i<this.tinterfaces.length ; i++){
			if (this.tinterfaces[i].code==code)
				this.tinterfaces[i].del=true;
		}
	},	
	
	existFenetreUnique: function(code){
		for (var i=this.tinterfaces.length-1 ; i>=0 ; i--){
			if (!this.tinterfaces[i].del){
				if (this.tinterfaces[i].fenetreUnique)
					return true;
			}
		}
		return false;
	},		
	
	update: function(){
		for (var i=this.tinterfaces.length-1 ; i>=0 ; i--){
			if (!this.tinterfaces[i].del){
				this.tinterfaces[i].update();
				if (this.tinterfaces[i].fenetreUnique)
					break;
			}
		}
		
		for (var i=0, max=this.tinterfaces.length ; i<max ; i++){
			if (this.tinterfaces[i].del){
				this.tinterfaces.splice(i, 1);
				i--;
				max--;
			}			
		}
	},
	
	draw: function(){
		for (var i=0, max=this.tinterfaces.length ; i<max ; i++){
			this.tinterfaces[i].draw();
		}	
	},
	
	reset: function(){
		//this.tinterfaces.splice(0, this.tinterfaces.length);
		for (var i=0, max=this.tinterfaces.length ; i<max ; i++)
			this.tinterfaces[i].delme();
	},
});


var GraphPermanent = GraphiqueInterface.extend({
	init: function(){
		this._super();
		
		//var boutonSon = new BoutonText(new Vec(this.width-38,10), "Sound", 35, 25);
		var boutonSon = new BoutonText(new Vec(10,10), "Sound", 35, 30);
		boutonSon.doHit = function(){
			if (sonManager.playAudio)
				sonManager.stopSon();
			else
				sonManager.playSon();
		}
		this.pushBouton(boutonSon);	
	
	
		this.pushEntity(new Text("Best score", new Vec(this.width-60,5), 30, TM_CENTER));
		this.pushEntity(new Text(""+game.joueur.bestScore, new Vec(this.width-60,35), 30, TM_CENTER));
		
		// Compteur Fps
		if (DRAW_DEBUG_PRINT){
			this.fpsStart = new Date();
			this.lastdate = new Date();
			this.nbFrameTotale = 0;
			this.textFpsS = new Text("", new Vec(0,0), 20, TM_LEFT);
			this.pushEntity(this.textFpsS);	
			this.textFpsM = new Text("", new Vec(0,20), 20, TM_LEFT);
			this.pushEntity(this.textFpsM);
			this.textControleMouse = new Text("", new Vec(0,40), 20, TM_LEFT);
			this.pushEntity(this.textControleMouse);		
			this.textDebugTextPrint = new Text("", new Vec(0,60), 100, TM_LEFT);
			this.pushEntity(this.textDebugTextPrint);
		}

	},
	
	update: function(){
		this._super();
		
		// Mise a jour compteur Fps
		if (DRAW_DEBUG_PRINT){
			var date = new Date();
			
			var nbFrameS = 1000/(date.getTime()-this.lastdate.getTime());
			var nbFrameM = 1000*this.nbFrameTotale/(date.getTime()-this.fpsStart.getTime());
			this.nbFrameTotale++;
			this.lastdate=date;
			
			this.textFpsS.setText("FrameS:"+Math.round(nbFrameS*100)/100);	//*100 /100 pour arrondi 2 chiffre apres virgule
			this.textFpsM.setText("FrameM:"+Math.round(nbFrameM*100)/100);
			
			this.textControleMouse.setText("coordMouse:"+Math.floor(controleMouse.coord.x)+ ";" + Math.floor(controleMouse.coord.y));
				
			this.textDebugTextPrint.setText(DEBUG_TEXT_PRINT);
		}
		
	}
	
});



var GameIdentification = GraphiqueInterface.extend({
	init: function(){
		this._super();
		
		
		this.drawLogo();

		show_div('identificationDiv');	
		
	},
	
	
	eventBouton: function(bouton){
		this.delme();
	},
});


var GameAccueil = GraphiqueInterface.extend({
	
	drawTextControle: function(){
		if (CONTROLE_VEHICULE == CV_KEYBOARD){
			this.boutonControle.txt.setText("Keyboard");
			this.txtMove.setText("Move : ←↑→↓");
			this.txtFire.setText("Fire : space");
			this.txtBomb.setText("Bomb : Ctrl");
		}
		else {
			this.boutonControle.txt.setText("Mouse");
			this.txtMove.setText("Move : cursor");
			this.txtFire.setText("Fire : mouse left");
			this.txtBomb.setText("Bomb : double click");		
		}
	},
	
	init: function(){
		this._super();
		
		this.drawLogo();
		

		

		
			
		
		
		this.boutonControle=null;
		
		if (!mobileAndTabletcheck()){
			
			var boutonBoutique = new BoutonText(new Vec((this.width-200)/2,350), "Start", 200, 50);
			boutonBoutique.doHit = function(){
				closePubMini();
				gameInterface.addInterface(new Boutique());	
			}
			this.pushBouton(boutonBoutique);				
			
			
			this.pushEntity(new Text("Controle :", new Vec((this.width)/2-50,550), 30, TM_CENTER));
			this.boutonControle = new BoutonText(new Vec(this.width/2+5,550), "Keyboard", 150, 30);
			this.boutonControle.doHit = function(){

			}
			this.pushBouton(this.boutonControle);		
			
			this.txtMove = new Text("Move : ←↑→↓", new Vec((this.width)/2,600), 25, TM_CENTER);
			this.txtFire = new Text("Fire : space", new Vec((this.width)/2,625), 25, TM_CENTER);
			this.txtBomb = new Text("Bomb : Ctrl", new Vec((this.width)/2,650), 25, TM_CENTER);			
			this.pushEntity(this.txtMove);
			this.pushEntity(this.txtFire);
			this.pushEntity(this.txtBomb);
			this.drawTextControle();
		}
		else {
			
			//var textStart = new Text("Touch to start", new Vec(this.width/2,250), 60, TM_CENTER);
			var textStart = new Text("Touch to start", new Vec(this.width/2,850), 60, TM_CENTER);
			textStart.startClignote();
			this.pushEntity(textStart);
			
			
			
			var boutonBoutique = new HitPage();
			boutonBoutique.doHit = function(){
				closePubMini();
				gameInterface.addInterface(new Boutique());	
			}
			this.pushBouton(boutonBoutique);	
			
			
		
			this.pushEntity(new Text("Controle :", new Vec((this.width)/2,500), 42, TM_CENTER));
			this.pushEntity(new Text("Move and fire: touch sceen", new Vec((this.width)/2,525), 40, TM_CENTER));
			this.pushEntity(new Text("Bomb : double touch", new Vec((this.width)/2,550), 40, TM_CENTER));				
						
		}
		
		
		
		if (DRAW_DEBUG_PRINT)
		{
			var boutonStart = new BoutonText(new Vec((this.width-200)/2-200,450), "Start no boutique", 200, 30);
			boutonStart.doHit = function(){
				game.nouvellePartie();
				gameInterface.addInterface(new GameUI());
			}
			this.pushBouton(boutonStart);
			
			var razJoueur = new BoutonText(new Vec((this.width-200)/2-200,550), "raz Joueur", 200, 30);
			razJoueur.doHit = function(){
				game.vehiculeJoueur.reset();
				game.joueur.argent = 0;
				game.joueur.lvlMission = 0;
				game.joueur.bestScore = 0;				
				game.joueur.tproduitsCodes = new Array();
				game.joueur.tproduitsCodesActif = new Array();
				save();
				gameInterface.addInterface(new GameAccueil());
			}
			this.pushBouton(razJoueur);
		}
		
		//show_div('bannierePub');
		closePubMini();
		drawPubMini();
	},
	
	eventBouton: function(bouton){
		
		if (bouton==this.boutonControle)
		{
			if (CONTROLE_VEHICULE == CV_KEYBOARD){
				CONTROLE_VEHICULE = CV_MOUSE;
			}
			else {
				CONTROLE_VEHICULE = CV_KEYBOARD;
			}
			this.drawTextControle();
		}
		else {
			
			this.delme();
		}
	},
});


var Boutique = GraphiqueInterface.extend({
	init: function(){
		this._super("BOUTIQUE");

		drawPubMini();
		
		this.drawLogo();		
		
		
		this.pushEntity(new Text("Store", new Vec((this.width)/2,90), 100, TM_CENTER));
		
		//this.pushEntity(new Text("Money:", new Vec((this.width)/2-1+15,165), 50, TM_RIGHT));
		this.argent = new Text("Money:"+game.joueur.argent+"Cr", new Vec((this.width)/2,170), 65, TM_LEFT|TM_CENTER);		
		this.pushEntity(this.argent);	
		
		
		this.boutonStart = new BoutonText(new Vec((this.width-250)/2,this.height-150), "Start shooting", 250, 70);
		/*this.boutonStart.doHit = function(){
			if (game.joueur.argent>0){
				gameInterface.addInterface(new ConfirmeStartGame());
				gameInterface.existFenetreUnique
			}
			else{
				gameInterface.delInterfaceCode("BOUTIQUE");
				game.nouvellePartie();
				gameInterface.addInterface(new GameUI());	
			}

		}*/
		this.boutonStart.txt.startClignote();
		this.pushBouton(this.boutonStart);		
		
		

		var y=250;
		var sizeBt=170;
		
	
		this.btVehicule = new BoutonText(new Vec(this.width/2-sizeBt-20,y), "Upgrade\nPlane", sizeBt, sizeBt, 50);
		this.btCapaArme = new BoutonText(new Vec(this.width/2+20,y), "Upgrade\nWeapon", sizeBt, sizeBt, 50);
		this.btArme1 = new BoutonText(new Vec(this.width/2-sizeBt-20,y+220), "Change\nWeapon", sizeBt, sizeBt, 50);
		this.btArme2 = new BoutonText(new Vec(this.width/2+20,y+220), "Change\nBomb", sizeBt, sizeBt, 50);
	
		this.pushBouton(this.btVehicule);
		this.pushBouton(this.btCapaArme);
		this.pushBouton(this.btArme1);
		this.pushBouton(this.btArme2);
	},


	
	update: function(){
		this._super();
		this.argent.setText("Money:"+game.joueur.argent+"Cr");
		
		if (!this.boutonStart.txt.clignote && !gameInterface.existFenetreUnique())
			this.boutonStart.txt.startClignote();
	},	
	
	draw: function(){
		this._super();
	},
	
	eventBouton: function(bouton){	
	
		if (bouton==this.btVehicule){
			gameInterface.addInterface(new BoutiqueDetail(PT_UPGRADEVEHICULE));
			this.delme();
		}
		else if (bouton==this.btCapaArme){
			gameInterface.addInterface(new BoutiqueDetail(PT_UPGRADEARME1));
			this.delme();
		}
		else if (bouton==this.btArme1){
			gameInterface.addInterface(new BoutiqueDetail(PT_ARME1));
			this.delme();
		}
		else if (bouton==this.btArme2	){
			gameInterface.addInterface(new BoutiqueDetail(PT_ARME2));
			this.delme();
		}	
		else if (bouton==this.boutonStart){
			if (game.joueur.argent>0){
				gameInterface.addInterface(new ConfirmeStartGame());
				this.boutonStart.txt.stopClignote();
			}
			else{
				gameInterface.delInterfaceCode("BOUTIQUE");
				game.nouvellePartie();
				gameInterface.addInterface(new GameUI());	
			}			
		}
		
			
	},	
});

var BoutiqueDetail = GraphiqueInterface.extend({
	init: function(typeProduit){
		this._super("BOUTDET");

		this.typeProduit = typeProduit;
		closePubMini();
		this.drawLogo();		
		
		
	
		var titre;	
		if (typeProduit==PT_UPGRADEVEHICULE)
			titre = "Upgrade plane";
		else if (typeProduit==PT_UPGRADEARME1)
			titre = "Upgrade weapon";
		else if (typeProduit==PT_ARME1)
			titre = "Change weapon";
		else if (typeProduit==PT_ARME2)
			titre = "Change bomb";
		this.pushEntity(new Text(titre, new Vec((this.width)/2,90), 100, TM_CENTER));
		

		
		//this.pushEntity(new Text("Money:", new Vec((this.width)/2-1+15,165), 50, TM_RIGHT));
		this.argent = new Text("Money:"+game.joueur.argent+"Cr", new Vec((this.width)/2,170), 65, TM_LEFT|TM_CENTER);		
		this.pushEntity(this.argent);	
		

		
		
		//this.boutonStart = new BoutonText(new Vec((this.width-220)/2+150,this.height-150), "Start shooting", 220, 70);
		this.boutonStart = new BoutonText(new Vec((this.width-250)/2+150,this.height-150), "Start shooting", 250, 70);
		/*this.boutonStart.doHit = function(){
			//game.nouvellePartie();
			//gameInterface.addInterface(new GameUI());
			
			if (game.joueur.argent>0){
				gameInterface.addInterface(new ConfirmeStartGame());
				this.boutonStart.txt.stopClignote();
				this.boutonBoutique.txt.stopClignote();
			}
			else{
				gameInterface.delInterfaceCode("BOUTIQUE");
				gameInterface.delInterfaceCode("BOUTDET");
				game.nouvellePartie();
				gameInterface.addInterface(new GameUI());	
			}

		}*/
		this.boutonStart.txt.startClignote();
		this.pushBouton(this.boutonStart);	
		
		
		
		this.boutonBoutique = new BoutonText(new Vec((this.width-250)/2-150,this.height-150), "Store", 250, 70);
		this.boutonBoutique.doHit = function(){
			gameInterface.addInterface(new Boutique());
		}
		this.boutonBoutique.txt.startClignote();
		this.pushBouton(this.boutonBoutique);				
		


		this.tboutonsProduit = new Array();
		this.tboutonsProduitCode = new Array();
		this.nbBoutonProduit = 0;
		


		var x=40;
		var y=200;
	
		var nbProdGroupeLigne=0;	
		var lastProdType=0;	

		for (var i=0, nb=0, max=tProduitDef.length ; i<max ;  nb++, i++){

			if (tProduitDef[i][0].prodType!=this.typeProduit)
				continue;
			
			if (tProduitDef[i][0].affichage==PTA_UNIQUE){
				nbProdGroupeLigne = 0;					
				lastProdType=0;
				
				y+=100;
				x=40;			
				
				for (var j=0, max2=tProduitDef[i].length ; j<max2 ; j++){
					
					if (game.joueur.haveProduit(tProduitDef[i][j]))
						this.drawBouton(x,y,tProduitDef[i][j], -1, false);
					else 
						this.drawBouton(x,y,tProduitDef[i][j], tProduitDef[i][j].prix);
					x+=200;
					if (this.nbBoutonProduit%3==0){
						x=40;
						y+=240;
					}
				}

			
			}
			else if (tProduitDef[i][0].affichage==PTA_GROUPE) {
			
				
				var prodPossedePas=-1;
				var peutAcheter=false;
				for (var j=0, max2=tProduitDef[i].length ; j<max2 ; j++){
					if (!game.joueur.haveProduit(tProduitDef[i][j])){
						prodPossedePas=j;
						break;
					}
				}
					
				nbProdGroupeLigne++;
				if (lastProdType!=tProduitDef[i][0].prodType || nbProdGroupeLigne>=6){
					nbProdGroupeLigne=0;
					y+=100;
					x=40;
				}			
					
				if (prodPossedePas!=-1)
					this.drawBouton(x,y,tProduitDef[i][0], tProduitDef[i][prodPossedePas].prix);	
				else
					this.drawBouton(x,y,tProduitDef[i][0], -1);
				
				lastProdType=tProduitDef[i][0].prodType;
				
				x+=200;

				if (this.nbBoutonProduit%3==0){
					x=40;
					y+=240;
				}

				
			}
		}
		

	},

	drawBouton: function(x,y, prodDef, prix){
		this.tboutonsProduit[this.nbBoutonProduit] = new BoutonBoutique(new Vec(x,y), prodDef, 170, 170, 10);
		this.pushBouton(this.tboutonsProduit[this.nbBoutonProduit]);
		
		this.tboutonsProduitCode[this.nbBoutonProduit] = prodDef.code;
		
		this.nbBoutonProduit++;	

		if (prix!=-1){
			var t=new Text(""+prix+"Cr", new Vec(x+170/2,y+170), 40, TM_CENTER);
			this.pushEntity(t);		
			
			
			if ((prix!=-1 && game.joueur.argent>=prix) || CHEATGRATUIT)
				t.setColor("#FFFF00");
		}			

	},
	
	
	update: function(){
		this._super();
		this.argent.setText("Money:"+game.joueur.argent+"Cr");
		
		if (!this.boutonStart.txt.clignote && !gameInterface.existFenetreUnique()){
			this.boutonStart.txt.startClignote();
			this.boutonBoutique.txt.startClignote();
		}
	},	
	
	draw: function(){
		this._super();
	},
	
	eventBouton: function(bouton){	
	
		if (bouton==this.boutonStart){
			if (game.joueur.argent>0){
				gameInterface.addInterface(new ConfirmeStartGame());
				this.boutonStart.txt.stopClignote();
				this.boutonBoutique.txt.stopClignote();
			}
			else{
				this.delme();
				gameInterface.delInterfaceCode("BOUTIQUE");
				//gameInterface.delInterfaceCode("BOUTDET");
				game.nouvellePartie();
				gameInterface.addInterface(new GameUI());	
			}
					
		}
		else if (bouton==this.boutonBoutique)
			this.delme();
		else{
			for (var i=0 ; i<this.nbBoutonProduit ; i++){
				if (bouton===this.tboutonsProduit[i]){
					gameInterface.addInterface(new ConfirmeAchat(this.tboutonsProduitCode[i]));
				}
			}
		}
			
	},	
});

/*
var Boutique = GraphiqueInterface.extend({
	init: function(){
		this._super("BOUTIQUE");

		drawPubMini();
		
		this.drawLogo();		
		
		
		this.pushEntity(new Text("Store", new Vec((this.width)/2,90), 90, TM_CENTER));
		
		//this.pushEntity(new Text("Money:", new Vec((this.width)/2-1+15,165), 50, TM_RIGHT));
		this.argent = new Text("Money:"+game.joueur.argent, new Vec((this.width)/2,165), 50, TM_LEFT|TM_CENTER);		
		this.pushEntity(this.argent);	
		
		
		//this.boutonAccueil = new BoutonText(new Vec((this.width-220)/2-150,this.height-150), "Home page", 220, 70);
		//this.boutonAccueil.doHit = function(){
		//	gameInterface.addInterface(new GameAccueil());
		//}
		//this.pushBouton(this.boutonAccueil);
		
		
		//this.boutonStart = new BoutonText(new Vec((this.width-220)/2+150,this.height-150), "Start shooting", 220, 70);
		this.boutonStart = new BoutonText(new Vec((this.width-250)/2,this.height-150), "Start shooting", 250, 70);
		this.boutonStart.doHit = function(){
			//game.nouvellePartie();
			//gameInterface.addInterface(new GameUI());
			
			if (game.joueur.argent>0)
				gameInterface.addInterface(new ConfirmeStartGame());
			else{
				gameInterface.delInterfaceCode("BOUTIQUE");
				game.nouvellePartie();
				gameInterface.addInterface(new GameUI());	
			}

		}
		this.boutonStart.txt.startClignote();
		this.pushBouton(this.boutonStart);		
		


		this.tboutonsProduit = new Array();
		this.tboutonsProduitCode = new Array();
		this.nbBoutonProduit = 0;
		


		var x=40;
		var y=130;
	
		var nbProdGroupeLigne=0;	
		var lastProdType=0;	

		for (var i=0, nb=0, max=tProduitDef.length ; i<max ;  nb++, i++){

			
			
			if (tProduitDef[i][0].affichage==PTA_UNIQUE){
				nbProdGroupeLigne = 0;					
				lastProdType=0;
				
				y+=100;
				x=40;			
				
				for (var j=0, max2=tProduitDef[i].length ; j<max2 ; j++){
					
					if (game.joueur.haveProduit(tProduitDef[i][j]))
						this.drawBouton(x,y,tProduitDef[i][j], -1, false);
					else 
						this.drawBouton(x,y,tProduitDef[i][j], tProduitDef[i][j].prix);
					x+=100;
				}

			
			}
			else if (tProduitDef[i][0].affichage==PTA_GROUPE) {
			
				
				var prodPossedePas=-1;
				var peutAcheter=false;
				for (var j=0, max2=tProduitDef[i].length ; j<max2 ; j++){
					if (!game.joueur.haveProduit(tProduitDef[i][j])){
						prodPossedePas=j;
						break;
					}
				}
					
				nbProdGroupeLigne++;
				if (lastProdType!=tProduitDef[i][0].prodType || nbProdGroupeLigne>=6){
					nbProdGroupeLigne=0;
					y+=100;
					x=40;
				}			
					
				if (prodPossedePas!=-1)
					this.drawBouton(x,y,tProduitDef[i][0], tProduitDef[i][prodPossedePas].prix);	
				else
					this.drawBouton(x,y,tProduitDef[i][0], -1);
				
				lastProdType=tProduitDef[i][0].prodType;
				
				x+=100;
				
			}
		}
		
		this.majBoutonProduit();

	},

	drawBouton: function(x,y, prodDef, prix){
		this.tboutonsProduit[this.nbBoutonProduit] = new BoutonBoutique(new Vec(x,y), prodDef, 70, 70, 10);
		this.pushBouton(this.tboutonsProduit[this.nbBoutonProduit]);
		
		this.tboutonsProduitCode[this.nbBoutonProduit] = prodDef.code;
		
		this.nbBoutonProduit++;	

		if (prix!=-1){
			var t=new Text(""+prix, new Vec(x+65,y+70), 30, TM_RIGHT);
			this.pushEntity(t);		
			
			
			if ((prix!=-1 && game.joueur.argent>=prix) || CHEATGRATUIT)
				t.setColor("#FFFF00");
		}			

	},

	majBoutonProduit: function(){
	},
	
	update: function(){
		this._super();
		this.argent.setText("Money:"+game.joueur.argent);
		this.majBoutonProduit();
	},	
	
	draw: function(){
		this._super();
	},
	
	eventBouton: function(bouton){	
	
		if (bouton==this.boutonAccueil)
			this.delme();
		else{
			for (var i=0, max=tProduitDef.length ; i<this.nbBoutonProduit ; i++){

				if (bouton===this.tboutonsProduit[i]){
					gameInterface.addInterface(new ConfirmeAchat(this.tboutonsProduitCode[i]));
				}
			}
		}
			
	},	
});
*/



var ConfirmeAchat = GraphiqueInterface.extend({
	init: function(code){
		this._super();
		this.fenetreUnique = true;
		
		

		this.ligneDef=0;
		for (var i=0, max=tProduitDef.length ; i<max ; i++){
			for (var j=0, max2=tProduitDef[i].length ; j<max2 ; j++){
				if (tProduitDef[i][j].code==code){
					this.ligneDef=i;
					this.produitDef=tProduitDef[i][j];
					break;
				}
			}	
		}
		
		
		var tileImg = new Tile(IMAGE_boutiqueitem);
		tileImg.setSpriteItem(this.produitDef.item);	
		tileImg.setPosition(new Vec(20, 400));
		this.pushEntity(tileImg);
	
		if (this.produitDef.affichage==PTA_UNIQUE){
	
			var titre = new Text(this.produitDef.nom, new Vec((this.width)/2,370), 50, TM_CENTER|TM_MIDDLE);
			this.pushEntity(titre);
		
			this.pushEntity(new Text(this.produitDef.desc, new Vec((this.width)/2+40,430), 40, TM_CENTER|TM_MIDDLE));
		
			if (game.joueur.isProduitActif(this.produitDef)){
				//this.pushEntity(new Text("Use Weapon ?", new Vec((this.width)/2,560), 40, TM_CENTER|TM_MIDDLE));	
			}
			else if (game.joueur.haveProduit(this.produitDef))
				this.pushEntity(new Text("Use weapon ?", new Vec((this.width)/2,560), 40, TM_CENTER|TM_MIDDLE));
			else
				this.pushEntity(new Text("Cost :"+this.produitDef.prix+"Cr", new Vec((this.width)/2,560), 40, TM_CENTER|TM_MIDDLE));

		
			if (game.joueur.isProduitActif(this.produitDef) || (!game.joueur.haveProduit(this.produitDef) && (game.joueur.argent<this.produitDef.prix && !CHEATGRATUIT))){
				this.boutonFermer = new BoutonText(new Vec(this.width/2-50,610), "Close", 100, 40);
				this.pushBouton(this.boutonFermer);	
			}
			else {
		
				
				this.boutonOui = new BoutonText(new Vec(this.width/2+50,610), "Yes", 100, 40);
				this.pushBouton(this.boutonOui);
	
				this.boutonNon = new BoutonText(new Vec(this.width/2-150,610), "No", 100, 40);
				this.pushBouton(this.boutonNon);
			}		
		
	
		
		}
		else {
			
			this.prodActif=-1;
			this.prodPossedePas=-1;
			var peutAcheter=false;
			var possedeProdMax=-1;
			for (var j=0, max2=tProduitDef[this.ligneDef].length ; j<max2 ; j++){
				
				if (game.joueur.isProduitActif(tProduitDef[this.ligneDef][j]))
					this.prodActif=j;
				if (!game.joueur.haveProduit(tProduitDef[this.ligneDef][j])){
					this.prodPossedePas=j;
					break;
				}
				else 
					possedeProdMax=j;
			}
			
			if ((this.prodPossedePas!=-1 && game.joueur.argent>=tProduitDef[this.ligneDef][this.prodPossedePas].prix) || CHEATGRATUIT)
				peutAcheter=true;
							
			
			
			
			
			//this.produitDef = tProduitDef[this.ligneDef][0];
			
			var t = this.produitDef.nom;
			if (this.prodActif!=-1)
				t+=" "+(this.prodActif+1);
			
			var titre = new Text(t, new Vec((this.width)/2,370), 50, TM_CENTER|TM_MIDDLE);
			this.pushEntity(titre);
		
			this.pushEntity(new Text(this.produitDef.desc, new Vec((this.width)/2+40,440), 40, TM_CENTER|TM_MIDDLE));
		
			if (this.prodActif!=-1){
				this.boutonlvlm = new BoutonText(new Vec(this.width/2-160,520), "Level down", 170, 60);
				this.pushBouton(this.boutonlvlm);	
			}
			
			if (possedeProdMax!=-1 && this.prodActif<possedeProdMax){
				this.boutonlvlp = new BoutonText(new Vec(this.width/2+60,520), "Level up", 170, 60);
				this.pushBouton(this.boutonlvlp);	
			}		
			else if (this.prodPossedePas!=-1){
				this.boutonAcheter = new BoutonText(new Vec(this.width/2+60,520), "level up:"+tProduitDef[this.ligneDef][this.prodPossedePas].prix+"Cr", 230, 60);
				this.pushBouton(this.boutonAcheter);
				
				if (game.joueur.argent<tProduitDef[this.ligneDef][this.prodPossedePas].prix && !CHEATGRATUIT)
					this.boutonAcheter.disable();
			}
			
			
			this.boutonFermer = new BoutonText(new Vec(this.width/2-50,610), "Close", 150, 60);
			this.pushBouton(this.boutonFermer);
		}	
		
	},
	
	draw: function(){
		canvas2DContext.fillStyle = "#808080";
		canvas2DContext.fillRect(0,350,this.width,350);
	
	
		this._super();
	},	
	
	eventBouton: function(bouton){	

		if (bouton==this.boutonlvlm){
			if (this.prodActif>0)
				game.joueur.addProduitActif(tProduitDef[this.ligneDef][this.prodActif-1], false);
			else 
				game.joueur.delProduitActif(tProduitDef[this.ligneDef][this.prodActif]);
			save();
			
			if (this.prodActif>0)			
				gameInterface.addInterface(new ConfirmeAchat(tProduitDef[this.ligneDef][this.prodActif-1].code));
			else
				gameInterface.addInterface(new ConfirmeAchat(tProduitDef[this.ligneDef][this.prodActif].code));
			this.delme();
		}
		else if (bouton==this.boutonlvlp){
			game.joueur.addProduitActif(tProduitDef[this.ligneDef][this.prodActif+1], false);
			save();
			gameInterface.addInterface(new ConfirmeAchat(tProduitDef[this.ligneDef][this.prodActif+1].code));
			this.delme();
		}
		else if (bouton==this.boutonAcheter){
			// Achete le produit		
			if (game.joueur.argent>=tProduitDef[this.ligneDef][this.prodPossedePas].prix || CHEATGRATUIT)
			{
				game.joueur.argent-=tProduitDef[this.ligneDef][this.prodPossedePas].prix;
				game.joueur.addProduit(tProduitDef[this.ligneDef][this.prodPossedePas]);
				save();
				
				gameInterface.delInterfaceCode("BOUTDET");
				gameInterface.addInterface(new BoutiqueDetail(tProduitDef[this.ligneDef][this.prodPossedePas].prodType));				
				gameInterface.addInterface(new ConfirmeAchat(tProduitDef[this.ligneDef][this.prodPossedePas].code));
				this.delme();
			}
		}
		else if (bouton==this.boutonFermer){
			this.delme();
		}		
		
	
	
		else if (bouton==this.boutonOui){
			if(game.joueur.haveProduit(this.produitDef))
				// Rend le produit actif
				game.joueur.addProduitActif(this.produitDef, false);
			else {
				// Achete le produit
				game.joueur.argent-=this.produitDef.prix;
				game.joueur.addProduit(this.produitDef);
			}
			save();
			gameInterface.delInterfaceCode("BOUTDET");
			gameInterface.addInterface(new BoutiqueDetail(this.produitDef.prodType));
			gameInterface.addInterface(new ConfirmeAchat(this.produitDef.code));
			this.delme();
		}	
		else if (bouton==this.boutonNon){
			this.delme();
		}
	}
});




var ConfirmeStartGame = GraphiqueInterface.extend({
	init: function(){
		this._super();
		this.fenetreUnique = true;


		var titre = new Text("Start", new Vec((this.width)/2,370), 50, TM_CENTER|TM_MIDDLE);
		this.pushEntity(titre);

		var titre = new Text("Warning : you are going to lose all you money", new Vec((this.width)/2,430), 30, TM_CENTER|TM_MIDDLE);
		this.pushEntity(titre);


		//var boutonQuitter = new BoutonText(new Vec((this.width-200)/2-130,450), "Close", 200, 40);
		var boutonQuitter = new BoutonText(new Vec((this.width-200)/2-130,550), "Close", 200, 40);
		//boutonQuitter.doHit = function(){
		//	game.nouvellePartie();
		//	gameInterface.addInterface(new GameUI());
		//}
		this.pushBouton(boutonQuitter);	

		
		var boutonStart = new BoutonText(new Vec((this.width-200)/2+130,550), "Start", 200, 40);
		boutonStart.doHit = function(){
			gameInterface.delInterfaceCode("BOUTIQUE");
			gameInterface.delInterfaceCode("BOUTDET");
			game.nouvellePartie();
			gameInterface.addInterface(new GameUI());
		}
		boutonStart.txt.startClignote();
		this.pushBouton(boutonStart);		
		
	},
	
	draw: function(){
		canvas2DContext.fillStyle = "#808080";
		canvas2DContext.fillRect(0,350,this.width,280);
	
	
		this._super();
	},	
	
	eventBouton: function(bouton){	
 		//if (bouton==this.boutonQuitter){
			this.delme();
		//}
	}
});



var GameUI = GraphiqueInterface.extend({
	init: function(){
		this._super();
	
		this.text = new Text("", new Vec((this.width-16*8)/2,5), 50);
		
		//this.textArgent = new Text("", new Vec(5,5));
if (DRAW_DEBUG_PRINT)	
		this.textDebugDegatSubit = new Text("", new Vec(5,500));
		
		this.jauveVie = new JaugeVie(new Vec(20,this.height-20));
		
		this.tileMissile = undefined;
		if (game.vehiculeJoueur.arme2!=undefined){
			this.tileMissile = new Tile(IMAGE_missile);
			this.tileMissile.coordBox.width=8;
			this.tileMissile.coordBox.height=24;
			this.tileMissile.setPosition(new Vec(60,this.height-44));
			if (game.vehiculeJoueur.arme2.nbMunition==-1)
				this.textNbMissile = new Text("∞", new Vec(70,this.height-36));
			else 
				this.textNbMissile = new Text("", new Vec(70,this.height-36));
		}


		
//		var boutonQuitter = new BoutonText(new Vec(this.width-75,10), "Quit", 30, 25);
		var boutonQuitter = new BoutonText(new Vec(50,10), "Quit", 35, 30);
		boutonQuitter.doHit = function(){
			gameInterface.addInterface(new ConfirmeQuitter());
		}
		this.pushBouton(boutonQuitter);	


//		var boutonQuitter = new BoutonText(new Vec(5,10), "Pause", 30, 25);
		var boutonQuitter = new BoutonText(new Vec(90,10), "Pause", 35, 30);
		boutonQuitter.doHit = function(){
			gameInterface.addInterface(new FenetrePause());
		}
		this.pushBouton(boutonQuitter);
		
		gameInterface.addInterface(new Mission());	
		
	},

	draw: function(){
		this._super();
	
		var t = ""+(game.score+game.argent);
		while (t.length<8)
			t = "0"+t;
	
		this.text.setText(t);
		this.text.draw();
		
/*		t = ":"+game.argent;
		this.textArgent.setText(t);
		this.textArgent.draw();	*/

		if (game.vehiculeJoueur.arme2!=undefined && this.tileMissile!=undefined){
			this.tileMissile.draw();
			
			if (game.vehiculeJoueur.arme2.nbMunition>=0)
				this.textNbMissile.setText("x"+game.vehiculeJoueur.arme2.nbMunition);
			this.textNbMissile.draw();
		}

if (DRAW_DEBUG_PRINT){
		t = ""+game.vehiculeJoueur.degatSubit;
		this.textDebugDegatSubit.setText(t);
		this.textDebugDegatSubit.draw();	
}	
		
		this.jauveVie.draw();
	},
	
});



var FenetrePause = GraphiqueInterface.extend({
	init: function(){
		this._super();
		this.fenetreUnique=true;
		
		var titre = new Text("Pause", new Vec((this.width)/2,270), 50, TM_CENTER|TM_MIDDLE);
		this.pushEntity(titre);

		this.boutonOk = new BoutonText(new Vec(this.width/2-50,450), "Resume", 100, 40);
		this.pushBouton(this.boutonOk);

	
		game.pause=true;
		
	},
	
	draw: function(){
		canvas2DContext.fillStyle = "#808080";
		canvas2DContext.fillRect(0,250,this.width,250);
	
	
		this._super();
	},	
	
	eventBouton: function(bouton){	
	
		if (bouton==this.boutonOk){
			game.pause=false;
			this.delme();
		}	

	}
});

var ConfirmeQuitter = GraphiqueInterface.extend({
	init: function(){
		this._super();
		this.fenetreUnique=true;
		
		var titre = new Text("Quit ?", new Vec((this.width)/2,270), 50, TM_CENTER|TM_MIDDLE);
		this.pushEntity(titre);

		this.boutonOui = new BoutonText(new Vec(this.width/2+50,450), "Yes", 100, 40);
		this.pushBouton(this.boutonOui);

		this.boutonNon = new BoutonText(new Vec(this.width/2-150,450), "No", 100, 40);
		this.pushBouton(this.boutonNon);
	
		game.pause=true;
		
	},
	
	draw: function(){
		canvas2DContext.fillStyle = "#808080";
		canvas2DContext.fillRect(0,250,this.width,250);
	
	
		this._super();
	},	
	
	eventBouton: function(bouton){	
	
		if (bouton==this.boutonOui){
			game.TerminerPartie(false);
			this.delme();
		}	
		else if (bouton==this.boutonNon){
			game.pause=false;
			this.delme();
		}
	}
});




var FinPartie = GraphiqueInterface.extend({
	init: function(){
		this._super();
		this.fenetreUnique=true;

		this.pushEntity(new Text("Game Over", new Vec((this.width)/2,100), 90, TM_CENTER));
		
		var y=270;
		var textX=(this.width)/2-250;
		var ScoreX=(this.width)/2+20;
		var ArgentX=(this.width)/2+180;
		
		this.pushEntity(new Text("Money", new Vec(ArgentX,y), 45, TM_CENTER));
		y+=45;
		
		this.pushEntity(new Text("kill", new Vec(textX,y), 45, TM_LEFT));
		this.pushEntity(new Text(""+game.nbEnnemieDetruit, new Vec(ScoreX,y), 45, TM_CENTER));
		this.pushEntity(new Text(""+game.score, new Vec(ArgentX,y), 45, TM_CENTER));
		y+=50;
		
		this.pushEntity(new Text("Bonus", new Vec(textX,y), 45, TM_LEFT));
		this.pushEntity(new Text(""+game.nbBonusArgent, new Vec(ScoreX,y), 45, TM_CENTER));
		this.pushEntity(new Text(""+game.argent, new Vec(ArgentX,y), 45, TM_CENTER));
		y+=50;
	
		this.pushEntity(new Text("Distance", new Vec(textX,y), 45, TM_LEFT));
		this.pushEntity(new Text(""+(game.origineY-game.origineYStartGame), new Vec(ScoreX,y), 45, TM_CENTER));
		this.pushEntity(new Text(""+game.getArgentDistance(), new Vec(ArgentX,y), 45, TM_CENTER));
		y+=50;
		
		var precision = 0;
		if ((game.nbTireArme1+game.nbTireArme2)>0)
			precision = Math.round(100*(game.nbEnnemieDetruit+game.nbBatimentDetruit)/(game.nbTireArme1+game.nbTireArme2));
		this.pushEntity(new Text("Precision", new Vec(textX,y), 45, TM_LEFT));
		this.pushEntity(new Text(""+precision+"%", new Vec(ScoreX,y), 45, TM_CENTER));
		this.pushEntity(new Text(""+game.getArgentTirRatio(), new Vec(ArgentX,y), 45, TM_CENTER));
		y+=50;
	
	
		this.pushEntity(new Text("Mission", new Vec(textX,y), 45, TM_LEFT));
		if (game.missionReussi)
			this.pushEntity(new Text("Succes", new Vec(ScoreX,y), 45, TM_CENTER));
		else
			this.pushEntity(new Text("Echec", new Vec(ScoreX,y), 45, TM_CENTER));
		this.pushEntity(new Text(""+game.getArgentMission(), new Vec(ArgentX,y), 45, TM_CENTER));
			
		y+=50;		
		
		//this.pushEntity(new Text("Ennemie kill :"+game.nbEnnemieDetruit, new Vec((this.width)/2,420), 45, TM_CENTER));
		//this.pushEntity(new Text("Shoot :"+(game.nbTireArme1+game.nbTireArme2), new Vec((this.width)/2,470), 45, TM_CENTER));
		//this.pushEntity(new Text("Precision :"+(game.nbEnnemieDetruit/(game.nbTireArme1+game.nbTireArme2)), new Vec((this.width)/2,520), 45, TM_CENTER));
		
		//this.pushEntity(new Text("Distance :"+(game.origineY-game.origineYStartGame), new Vec((this.width)/2,590), 45, TM_CENTER));		
		
		y+=30;
		this.pushEntity(new Text("Saving of money :"+game.joueur.argent+"Cr", new Vec((this.width)/2,y), 50, TM_CENTER));
		
		//var gameDuree = game.time-game.gameTimeStart;
		//var bonusScore = Math.floor(gameDuree/100); 
		//game.score+=bonusScore;
		//var argent = Math.floor(game.score/50);
		//game.joueur.argent += argent+game.argent;
		
		
		
		
		//this.pushEntity(new Text("duree :"+Math.floor(gameDuree/60000)+" min "+Math.floor((gameDuree%60000)/1000)+"sec", new Vec((this.width)/2,300), 40, TM_CENTER));
		//this.pushEntity(new Text("Bonus score :"+bonusScore, new Vec((this.width)/2,350), 40, TM_CENTER));
		
		
		//this.pushEntity(new Text("Gain argent :"+argent, new Vec((this.width)/2,450), 40, TM_CENTER));

		if (mobileAndTabletcheck()){
			this.boutonAccueil = new HitPage();
			var textTouch = new Text("Touch to continue", new Vec(this.width/2,655), 45, TM_CENTER)
			textTouch.startClignote();
			this.pushEntity(textTouch);
		}
		else {
			
			this.boutonAccueil = new BoutonText(new Vec((this.width-200)/2,655), "Home page", 200, 40);
		}
		this.boutonAccueil.doHit = function(){
			game.TerminerPartie(true);
		}
		this.pushBouton(this.boutonAccueil);		
	},
	
	eventBouton: function(bouton){
		this.delme();
	},	
	
	draw: function(){
		canvas2DContext.fillStyle = "#808080";
		canvas2DContext.fillRect(0,275,this.width,370);
	
	
		this._super();
	},		
});



/*
var FullPub = GraphiqueInterface.extend({
	init: function(){
		this._super();
		this.fenetreUnique = true;
		

		
		var boutonFermer = new BoutonText(new Vec((this.width-100),0), "Fermer", 100, 30);
		boutonFermer.doHit = function(){
			hide_div('fullPub');
		}
		this.pushBouton(boutonFermer);	
		

		
		show_div('fullPub');	
	},
	
	eventBouton: function(bouton){
			
		this.delme();
	},
});
*/



var Mission = GraphiqueInterface.extend({
	
	updatePosition: function(bouton){

		this.boutonDeployer.setPosition(new Vec(this.coord.x+0,this.coord.y+0));		
		this.txtMission.setPosition(new Vec(this.coord.x+this.width/2,this.coord.y+-5));
		this.txtTexte.setPosition(new Vec(this.coord.x+this.width/2,this.coord.y+65));
		this.txtValue.setPosition(new Vec(this.coord.x+this.width/2,this.coord.y+110));
		
	},
	
	updateTexte: function(bouton){
		if (isMissionReussi(this.mission)){
			this.txtValue.setColor("#00CC00");
		}
		this.txtValue.setText(""+getMissionValue(this.mission)+"/"+getMissionValueNeed(this.mission));
	},	
	
	
	
	init: function(){
		this._super();
		
		this.coord = new Vec(50,705);
		this.dest = new Vec(50,705);
		this.deployer = true;
		this.lastUpdate = game.time;
		this.timeCreer = game.time;
		this.clicBouton = false;


		this.vecBtDeployer = new Vec(0,0);
		this.vecTxtMission = new Vec(500,-5);


		this.boutonDeployer = new BoutonText(new Vec(0,0), ">>", 30, 50);
		this.boutonDeployer.doHit = function(){

		}
		this.pushBouton(this.boutonDeployer);	
		
		this.mission = game.joueur.lvlMission;
		


		this.txtMission=new Text("Mission", new Vec(0,0), 70, TM_CENTER|TM_TOP);
		this.pushEntity(this.txtMission);
		
		this.txtTexte=new Text(tMissionsDef[getMissionIndice(this.mission)].texte, new Vec(0,0), 45, TM_CENTER|TM_TOP);
		this.pushEntity(this.txtTexte);		
		this.txtValue=new Text("", new Vec(0,0), 45, TM_CENTER|TM_TOP);
		this.pushEntity(this.txtValue);

		this.updatePosition();
		this.updateTexte();
	
	},
	
	eventBouton: function(bouton){
		
		if (bouton==this.boutonDeployer){
			this.deployer=!this.deployer;
			if (this.deployer){
				this.boutonDeployer.txt.setText(">>");
				this.dest.x=50;
			}
			else {
				this.boutonDeployer.txt.setText("<<");
				this.dest.x=this.width-30;
			}
		}
		
		this.clicBouton=true;
	},
		
	update: function(){
		this._super();
		
		if (this.dest.x!=this.coord.x){
			var avance = (game.time-this.lastUpdate)*1400/1000;
			
			if (this.dest.x>this.coord.x){
				this.coord.x+=avance;
				this.coord.x=clampu(this.coord.x, this.dest.x);
			}
			else {
				this.coord.x-=avance;
				this.coord.x=clampl(this.coord.x, this.dest.x);
			}
			this.updatePosition();
		}
		
		
		if (!this.clicBouton && this.timeCreer && game.time-this.timeCreer>3000){
			this.eventBouton(this.boutonDeployer);
			this.timeCreer=0;
		}
		
		if (this.deployer)
			this.updateTexte();
			
		this.lastUpdate=game.time;
	},
	
	draw: function(){
		canvas2DContext.fillStyle = "#808080";
		canvas2DContext.fillRect(this.coord.x+30,this.coord.y,this.width,200);
	
	
		this._super();
	},	
});

