
var Joueur = Class.extend({
	init: function(){

		this.pseudo = "Srane";
		this.argent = 0;
		this.lvlMission = 0;
		this.bestScore = 0;
		
		this.tproduitsCodes = new Array();
		this.tproduitsCodesActif = new Array();
		
		//this.http;

	},

	serialise: function(){
		var serialisation="";
		serialisation+=this.pseudo+";";
		serialisation+=this.argent+";";
		for (var i=0, max=this.tproduitsCodes.length ; i<max ; i++){
			serialisation+=this.tproduitsCodes[i]+";";
		}
		serialisation+="STOP;";
		for (var i=0, max=this.tproduitsCodesActif.length ; i<max ; i++){
			serialisation+=this.tproduitsCodesActif[i]+";";
		}
		serialisation+="STOP;";
		serialisation+=this.lvlMission+";";
		serialisation+="STOP;";
		serialisation+=this.bestScore+";";
		serialisation+="STOP;";	
		
		return serialisation;
	},

	unserialise: function(s){
		var t = s.split(";");
		
		this.pseudo=t[0];
		this.argent=parseInt(t[1]);
		var i;
		for (i=2 ; i<t.length ; i++){
			if (t[i]=="STOP")
				break;
			else if (t[i]!="")
				this.tproduitsCodes.push(t[i]);
		}
		i++;	// Passe le STOP
		for ( ; i<t.length ; i++){
			if (t[i]=="STOP")
				break;
			else if (t[i]!=""){
				pdef = findProduitDefFromCode(t[i]);
				if (pdef!=PROD_NULL)
					this.addProduitActif(pdef);
			}
		}	
		i++;	// Passe le STOP
		if (i<t.length && t[i]!="" && t[i]!="STOP")
			this.lvlMission=parseInt(t[i++]);
		
		i++;	// Passe le STOP
		if (i<t.length && t[i]!="" && t[i]!="STOP")
			this.bestScore=parseInt(t[i++]);
		i++;
	},
	
	
	appliqueProduitEffect: function(produitDef){
		makeEffect(produitDef.code);
		
		//var s = produitDef.effect;
		
		//while (s.indexOf("#") > -1){
		//	s = s.replace("#arme2", "game.vehiculeJoueur.arme2");
		//	s = s.replace("#arme", "game.vehiculeJoueur.arme1");			
		//	s = s.replace("#joueurCoord", "game.vehiculeJoueur.coord");
		//	s = s.replace("#vehicule", "game.vehiculeJoueur");
		//}
				
		//eval(s);
	},
	
	addProduit: function(produitDef){
		this.tproduitsCodes.push(produitDef.code);
		this.addProduitActif(produitDef);
	},
	
	haveProduit: function(produitDef){
		for (var i=0, max=this.tproduitsCodes.length ; i<max ; i++){
			if (this.tproduitsCodes[i]==produitDef.code)
				return true;
		}
		return false;
	},
	
	addProduitActif: function(produitDef, appliqueEffet){
		if (this.isProduitActif(produitDef))
			return;
			
		if (appliqueEffet==undefined)
			appliqueEffet=true;
		
		
		// Supprime les produits actif de la meme famille (ex PROD_ARME_RECHARGE1 sera d'esactiver si on active PROD_ARME_RECHARGE2)
		for (var i=0, max=tProduitDef.length ; i<max ; i++){
			for (var j=0, max2=tProduitDef[i].length ; j<max2 ; j++){
				if (produitDef.code==tProduitDef[i][j].code){
					
					for (var j2=0 ; j2<max2 ; j2++){
						if (this.isProduitActif(tProduitDef[i][j2]))
						{
							this.delProduitActif(tProduitDef[i][j2]);
							j2--;
							max2--;
						}
					}				

					break;
				}
			}
		}
		
		// Si on ajoute une arme, Supprime les produits actif de type arme
		if (produitDef.prodType==PT_ARME1 || produitDef.prodType==PT_ARME2){
			var def;
			for (var i=0 ; i<this.tproduitsCodesActif.length ; i++){
				def=findProduitDefFromCode(this.tproduitsCodesActif[i]);
				if (def.prodType==produitDef.prodType){
					this.delProduitActif(def);
					i--;
				}
			} 
		}
			
			
			
		if (produitDef.prodType==PT_ARME1 || produitDef.prodType==PT_ARME2)
			this.tproduitsCodesActif.unshift(produitDef.code);	// Ajoute au debut du tableau
		else
			this.tproduitsCodesActif.push(produitDef.code);
			
		if (appliqueEffet)
			this.appliqueProduitEffect(produitDef);
	},
	
	isProduitActif: function(produitDef){
		for (var i=0, max=this.tproduitsCodesActif.length ; i<max ; i++){
			if (this.tproduitsCodesActif[i]==produitDef.code)
				return true;
		}
		return false;
	},	
	
	delProduitActif: function(produitDef){
		for (var i=0, max=this.tproduitsCodesActif.length ; i<max ; i++){
			if (this.tproduitsCodesActif[i]==produitDef.code){
				this.tproduitsCodesActif.splice(i, 1);
				return;
			}
		}
	},

	AppliqueProduitActif: function(){
	
		var pdef;
		for (var i=0, max=this.tproduitsCodesActif.length ; i<max ; i++){
			pdef = findProduitDefFromCode(this.tproduitsCodesActif[i]);
			this.appliqueProduitEffect(pdef);
		}
	
	}	
});